/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.tool.DefaultToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.support.ToolUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public interface ToolCallingChatOptions
extends ChatOptions {
    public static final boolean DEFAULT_TOOL_EXECUTION_ENABLED = true;

    public List<ToolCallback> getToolCallbacks();

    public void setToolCallbacks(List<ToolCallback> var1);

    public Set<String> getToolNames();

    public void setToolNames(Set<String> var1);

    @Nullable
    public Boolean getInternalToolExecutionEnabled();

    public void setInternalToolExecutionEnabled(@Nullable Boolean var1);

    public Map<String, Object> getToolContext();

    public void setToolContext(Map<String, Object> var1);

    public static Builder builder() {
        return new DefaultToolCallingChatOptions.Builder();
    }

    public static boolean isInternalToolExecutionEnabled(ChatOptions chatOptions) {
        ToolCallingChatOptions toolCallingChatOptions;
        Assert.notNull((Object)chatOptions, (String)"chatOptions cannot be null");
        boolean internalToolExecutionEnabled = chatOptions instanceof ToolCallingChatOptions && (toolCallingChatOptions = (ToolCallingChatOptions)chatOptions).getInternalToolExecutionEnabled() != null ? Boolean.TRUE.equals(toolCallingChatOptions.getInternalToolExecutionEnabled()) : true;
        return internalToolExecutionEnabled;
    }

    public static Set<String> mergeToolNames(Set<String> runtimeToolNames, Set<String> defaultToolNames) {
        Assert.notNull(runtimeToolNames, (String)"runtimeToolNames cannot be null");
        Assert.notNull(defaultToolNames, (String)"defaultToolNames cannot be null");
        if (CollectionUtils.isEmpty(runtimeToolNames)) {
            return new HashSet<String>(defaultToolNames);
        }
        return new HashSet<String>(runtimeToolNames);
    }

    public static List<ToolCallback> mergeToolCallbacks(List<ToolCallback> runtimeToolCallbacks, List<ToolCallback> defaultToolCallbacks) {
        Assert.notNull(runtimeToolCallbacks, (String)"runtimeToolCallbacks cannot be null");
        Assert.notNull(defaultToolCallbacks, (String)"defaultToolCallbacks cannot be null");
        if (CollectionUtils.isEmpty(runtimeToolCallbacks)) {
            return new ArrayList<ToolCallback>(defaultToolCallbacks);
        }
        return new ArrayList<ToolCallback>(runtimeToolCallbacks);
    }

    public static Map<String, Object> mergeToolContext(Map<String, Object> runtimeToolContext, Map<String, Object> defaultToolContext) {
        Assert.notNull(runtimeToolContext, (String)"runtimeToolContext cannot be null");
        Assert.noNullElements(runtimeToolContext.keySet(), (String)"runtimeToolContext keys cannot be null");
        Assert.notNull(defaultToolContext, (String)"defaultToolContext cannot be null");
        Assert.noNullElements(defaultToolContext.keySet(), (String)"defaultToolContext keys cannot be null");
        HashMap<String, Object> mergedToolContext = new HashMap<String, Object>(defaultToolContext);
        mergedToolContext.putAll(runtimeToolContext);
        return mergedToolContext;
    }

    public static void validateToolCallbacks(List<ToolCallback> toolCallbacks) {
        List<String> duplicateToolNames = ToolUtils.getDuplicateToolNames(toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s) found in ToolCallingChatOptions".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }

    public static interface Builder
    extends ChatOptions.Builder {
        public Builder toolCallbacks(List<ToolCallback> var1);

        public Builder toolCallbacks(ToolCallback ... var1);

        public Builder toolNames(Set<String> var1);

        public Builder toolNames(String ... var1);

        public Builder internalToolExecutionEnabled(@Nullable Boolean var1);

        public Builder toolContext(Map<String, Object> var1);

        public Builder toolContext(String var1, Object var2);

        @Override
        public Builder model(@Nullable String var1);

        @Override
        public Builder frequencyPenalty(@Nullable Double var1);

        @Override
        public Builder maxTokens(@Nullable Integer var1);

        @Override
        public Builder presencePenalty(@Nullable Double var1);

        @Override
        public Builder stopSequences(@Nullable List<String> var1);

        @Override
        public Builder temperature(@Nullable Double var1);

        @Override
        public Builder topK(@Nullable Integer var1);

        @Override
        public Builder topP(@Nullable Double var1);

        @Override
        public ToolCallingChatOptions build();
    }
}

