/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock.converse;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionConfiguration;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionProperties;
import org.springframework.ai.autoconfigure.bedrock.converse.BedrockConverseProxyChatProperties;
import org.springframework.ai.autoconfigure.chat.model.ToolCallingAutoConfiguration;
import org.springframework.ai.bedrock.converse.BedrockProxyChatModel;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.model.function.DefaultFunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;

@AutoConfiguration(after={ToolCallingAutoConfiguration.class})
@EnableConfigurationProperties(value={BedrockConverseProxyChatProperties.class, BedrockAwsConnectionConfiguration.class})
@ConditionalOnClass(value={BedrockProxyChatModel.class, BedrockRuntimeClient.class, BedrockRuntimeAsyncClient.class})
@ConditionalOnProperty(prefix="spring.ai.bedrock.converse.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={BedrockAwsConnectionConfiguration.class})
@ImportAutoConfiguration(value={ToolCallingAutoConfiguration.class})
public class BedrockConverseProxyChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AwsCredentialsProvider.class, AwsRegionProvider.class})
    public BedrockProxyChatModel bedrockProxyChatModel(AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider, BedrockAwsConnectionProperties connectionProperties, BedrockConverseProxyChatProperties chatProperties, ToolCallingManager toolCallingManager, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention, ObjectProvider<BedrockRuntimeClient> bedrockRuntimeClient, ObjectProvider<BedrockRuntimeAsyncClient> bedrockRuntimeAsyncClient) {
        BedrockProxyChatModel chatModel = BedrockProxyChatModel.builder().credentialsProvider(credentialsProvider).region(regionProvider.getRegion()).timeout(connectionProperties.getTimeout()).defaultOptions(chatProperties.getOptions()).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).toolCallingManager(toolCallingManager).bedrockRuntimeClient((BedrockRuntimeClient)bedrockRuntimeClient.getIfAvailable()).bedrockRuntimeAsyncClient((BedrockRuntimeAsyncClient)bedrockRuntimeAsyncClient.getIfAvailable()).build();
        observationConvention.ifAvailable(arg_0 -> ((BedrockProxyChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackResolver springAiFunctionManager(ApplicationContext context) {
        DefaultFunctionCallbackResolver manager = new DefaultFunctionCallbackResolver();
        manager.setApplicationContext(context);
        return manager;
    }
}

