/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.wps.service;

import cn.afterturn.easypoi.wps.service.EasyPoiWpsUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public interface IEasyPoiWpsConvertService {
    public static final String CONVERT_API = "https://dhs.open.wps.cn/pre/v1/convert";
    public static final String QUERY_API = "https://dhs.open.wps.cn/pre/v1/query";

    default public boolean fileConvert(String taskId, String srcUri, String fileName, String exportType, String callback) throws Exception {
        String headerDate = EasyPoiWpsUtil.getGMTDate();
        LinkedHashMap param = Maps.newLinkedHashMap();
        param.put("SrcUri", srcUri);
        param.put("FileName", fileName);
        param.put("ExportType", exportType);
        if (callback == null || !callback.startsWith("http")) {
            callback = "http://www.wupaas.com";
        }
        param.put("CallBack", callback);
        param.put("TaskId", taskId);
        String contentMd5 = EasyPoiWpsUtil.getMD5(param);
        String signature = EasyPoiWpsUtil.getSignature("POST", CONVERT_API, contentMd5, headerDate, "application/json", this.getAppSecret());
        String authorization = "WPS " + this.getAppId() + ":" + signature;
        LinkedHashMap headers = Maps.newLinkedHashMap();
        headers.put("Content-Type", "application/json");
        headers.put("Date", headerDate);
        headers.put("Content-MD5", contentMd5);
        headers.put("Authorization", authorization);
        String parsStr = JSONUtil.toJsonStr((Object)param);
        String result = ((HttpRequest)HttpUtil.createPost((String)CONVERT_API).addHeaders((Map)headers)).body(parsStr).execute().body();
        return "OK".equalsIgnoreCase(JSONUtil.parseObj((String)result).get((Object)"Code").toString()) || "AlreadyExists".equalsIgnoreCase(JSONUtil.parseObj((String)result).get((Object)"Code").toString());
    }

    default public byte[] getConvertFile(String taskId) throws Exception {
        String headerDate = EasyPoiWpsUtil.getGMTDate();
        String downUrl = "";
        String contentMd5 = EasyPoiWpsUtil.getMD5(null);
        String url = "https://dhs.open.wps.cn/pre/v1/query?TaskId=" + taskId + "&AppId=" + this.getAppId();
        String signature = EasyPoiWpsUtil.getSignature("GET", url, contentMd5, headerDate, "application/json", this.getAppSecret());
        String authorization = "WPS " + this.getAppId() + ":" + signature;
        LinkedHashMap headers = Maps.newLinkedHashMap();
        headers.put("Content-Type", "application/json");
        headers.put("Date", headerDate);
        headers.put("Content-MD5", contentMd5);
        headers.put("Authorization", authorization);
        String result = ((HttpRequest)HttpUtil.createGet((String)url).addHeaders((Map)headers)).execute().body();
        JSONObject jsonObject = JSONUtil.parseObj((String)result);
        String code = jsonObject.get((Object)"Code").toString();
        if (code.equals("OK")) {
            if (jsonObject.get((Object)"Urls") != null) {
                downUrl = jsonObject.getJSONArray((Object)"Urls").getStr((Object)0).toString();
            } else if (jsonObject.get((Object)"Url") != null) {
                downUrl = jsonObject.get((Object)"Url").toString();
            } else {
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u4e0b\u8f7d\u6587\u4ef6\u5730\u5740");
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HttpUtil.download((String)downUrl, (OutputStream)bos, (boolean)true);
        return bos.toByteArray();
    }

    public String getAppSecret();

    public String getAppId();
}

