/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v2;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.v2.WechatV2Client;
import cn.felord.payment.wechat.v2.model.GroupRedpackModel;
import cn.felord.payment.wechat.v2.model.RedpackInfoModel;
import cn.felord.payment.wechat.v2.model.RedpackModel;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.http.HttpMethod;

public class WechatPayRedpackApi {
    private final WechatV2Client wechatV2Client;

    public WechatPayRedpackApi(WechatV2Client wechatV2Client) {
        this.wechatV2Client = wechatV2Client;
    }

    public JsonNode sendRedpack(RedpackModel redpackModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        redpackModel.setWxappid(v3.getAppId());
        redpackModel.setMchId(v3.getMchId());
        return this.wechatV2Client.wechatPayRequest(redpackModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack");
    }

    public JsonNode sendRedpack(GroupRedpackModel groupRedpackModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        groupRedpackModel.setWxappid(v3.getAppId());
        groupRedpackModel.setMchId(v3.getMchId());
        return this.wechatV2Client.wechatPayRequest(groupRedpackModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendgroupredpack");
    }

    public JsonNode redpackInfo(RedpackInfoModel redpackInfoModel) {
        WechatPayProperties.V3 v3 = this.wechatV2Client.getWechatMetaBean().getV3();
        redpackInfoModel.setAppid(v3.getAppId());
        redpackInfoModel.setMchId(v3.getMchId());
        return this.wechatV2Client.wechatPayRequest(redpackInfoModel, HttpMethod.POST, "https://api.mch.weixin.qq.com/mmpaymkttransfers/gethbinfo");
    }
}

