/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.model.payscore.CancelServiceOrderParams;
import cn.felord.payment.wechat.v3.model.payscore.CompleteServiceOrderParams;
import cn.felord.payment.wechat.v3.model.payscore.DirectCompleteServiceOrderParams;
import cn.felord.payment.wechat.v3.model.payscore.ModifyServiceOrderParams;
import cn.felord.payment.wechat.v3.model.payscore.PayServiceOrderParams;
import cn.felord.payment.wechat.v3.model.payscore.PermissionsAuthCodeParams;
import cn.felord.payment.wechat.v3.model.payscore.PermissionsOpenIdParams;
import cn.felord.payment.wechat.v3.model.payscore.QueryServiceOrderParams;
import cn.felord.payment.wechat.v3.model.payscore.ServiceOrderPermissionParams;
import cn.felord.payment.wechat.v3.model.payscore.SyncServiceOrderParams;
import cn.felord.payment.wechat.v3.model.payscore.UserServiceOrderParams;
import cn.felord.payment.wechat.v3.model.payscore.UserServiceStateParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.HashMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatPayScoreApi
extends AbstractApi {
    public WechatPayScoreApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> userServiceState(UserServiceStateParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_USER_SERVICE_STATE, params).function((wechatPayV3Type, userServiceStateParams) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            HashMap<String, String> pathParams = new HashMap<String, String>(3);
            pathParams.put("appid", v3.getAppId());
            pathParams.put("service_id", params.getServiceId());
            pathParams.put("openid", params.getOpenId());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(pathParams).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> createServiceOrder(UserServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_CREATE_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setNotifyUrl(v3.getDomain().concat(orderParams.getNotifyUrl()));
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryServiceOrder(QueryServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_QUERY_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            String queryId;
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            String outOrderNo = orderParams.getOutOrderNo();
            if (StringUtils.hasText((String)outOrderNo)) {
                queryParams.add((Object)"out_order_no", (Object)outOrderNo);
            }
            if (StringUtils.hasText((String)(queryId = orderParams.getQueryId()))) {
                queryParams.add((Object)"query_id", (Object)queryId);
            }
            queryParams.add((Object)"service_id", (Object)orderParams.getServiceId());
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            queryParams.add((Object)"appid", (Object)v3.getAppId());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParams((MultiValueMap)queryParams).build().toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> cancelServiceOrder(CancelServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_CANCEL_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> modifyServiceOrder(ModifyServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_MODIFY_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> completeServiceOrder(CompleteServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_COMPLETE_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> payServiceOrder(PayServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PAY_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> syncServiceOrder(SyncServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_SYNC_USER_SERVICE_ORDER, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOutOrderNo()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOutOrderNo(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> directCompleteServiceOrder(DirectCompleteServiceOrderParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_DIRECT_COMPLETE, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            String notifyUrl = orderParams.getNotifyUrl();
            if (StringUtils.hasText((String)notifyUrl)) {
                orderParams.setNotifyUrl(v3.getDomain().concat(notifyUrl));
            }
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> permissions(ServiceOrderPermissionParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PERMISSIONS, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            String notifyUrl = orderParams.getNotifyUrl();
            orderParams.setAppid(v3.getAppId());
            if (StringUtils.hasText((String)notifyUrl)) {
                orderParams.setNotifyUrl(v3.getDomain().concat(notifyUrl));
            }
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryPermissionsByAuthCode(PermissionsAuthCodeParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PERMISSIONS_AUTH_CODE, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParam("service_id", new Object[]{orderParams.getServiceId()}).build().expand(new Object[]{orderParams.getAuthorizationCode()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> terminatePermissionsByAuthCode(PermissionsAuthCodeParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_TERMINATE_PERMISSIONS_AUTH_CODE, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getAuthorizationCode()}).toUri();
            orderParams.setAuthorizationCode(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryPermissionsByOpenId(PermissionsOpenIdParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_PERMISSIONS_OPENID, params).function((wechatPayV3Type, orderParams) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParam("appid", new Object[]{v3.getAppId()}).queryParam("service_id", new Object[]{orderParams.getServiceId()}).build().expand(new Object[]{orderParams.getOpenid()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> terminatePermissionsByOpenId(PermissionsOpenIdParams params) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PAY_SCORE_TERMINATE_PERMISSIONS_OPENID, params).function((wechatPayV3Type, orderParams) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{orderParams.getOpenid()}).toUri();
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            orderParams.setAppid(v3.getAppId());
            orderParams.setOpenid(null);
            return this.Post(uri, orderParams);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

