/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3;

import cn.felord.payment.wechat.WechatPayProperties;
import cn.felord.payment.wechat.enumeration.WeChatServer;
import cn.felord.payment.wechat.enumeration.WechatPayV3Type;
import cn.felord.payment.wechat.v3.AbstractApi;
import cn.felord.payment.wechat.v3.SignatureProvider;
import cn.felord.payment.wechat.v3.WechatPayClient;
import cn.felord.payment.wechat.v3.WechatResponseEntity;
import cn.felord.payment.wechat.v3.X509WechatCertificateInfo;
import cn.felord.payment.wechat.v3.model.profitsharing.AddReceiversParams;
import cn.felord.payment.wechat.v3.model.profitsharing.DelReceiversParams;
import cn.felord.payment.wechat.v3.model.profitsharing.ProfitSharingOrder;
import cn.felord.payment.wechat.v3.model.profitsharing.QueryOrderParams;
import cn.felord.payment.wechat.v3.model.profitsharing.QueryReturnOrderParams;
import cn.felord.payment.wechat.v3.model.profitsharing.Receiver;
import cn.felord.payment.wechat.v3.model.profitsharing.ReturnOrdersParams;
import cn.felord.payment.wechat.v3.model.profitsharing.UnfreezeParams;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class WechatProfitsharingApi
extends AbstractApi {
    public WechatProfitsharingApi(WechatPayClient wechatPayClient, String tenantId) {
        super(wechatPayClient, tenantId);
    }

    public WechatResponseEntity<ObjectNode> profitsharingOrders(ProfitSharingOrder profitSharingOrder) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_ORDERS, profitSharingOrder).function((wechatPayV3Type, params) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            params.setAppid(v3.getAppId());
            List<Receiver> receivers = params.getReceivers();
            if (!CollectionUtils.isEmpty(receivers)) {
                List<Receiver> encrypted = receivers.stream().peek(receiversItem -> {
                    String name = receiversItem.getName();
                    if (StringUtils.hasText((String)name)) {
                        String encryptedName = signatureProvider.encryptRequestMessage(name, x509Certificate);
                        receiversItem.setName(encryptedName);
                    }
                }).collect(Collectors.toList());
                params.setReceivers(encrypted);
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, params, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryProfitsharingOrder(QueryOrderParams queryOrderParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_ORDERS_RESULT, queryOrderParams).function((wechatPayV3Type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParam("transaction_id", new Object[]{params.getTransactionId()}).build().expand(new Object[]{params.getOutOrderNo()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> returnOrders(ReturnOrdersParams returnOrdersParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_RETURN_ORDERS, returnOrdersParams).function((wechatPayV3Type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryReturnOrders(QueryReturnOrderParams queryReturnOrderParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_RETURN_ORDERS_RESULT, queryReturnOrderParams).function((wechatPayV3Type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).queryParam("out_order_no", new Object[]{params.getOutOrderNo()}).build().expand(new Object[]{params.getOutReturnNo()}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> unfreeze(UnfreezeParams unfreezeParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_ORDERS_UNFREEZE, unfreezeParams).function((wechatPayV3Type, params) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> queryAmounts(String transactionId) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_AMOUNTS, transactionId).function((wechatPayV3Type, id) -> {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().expand(new Object[]{id}).toUri();
            return this.Get(uri);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> addReceivers(AddReceiversParams addReceiversParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_RECEIVERS_ADD, addReceiversParams).function((wechatPayV3Type, params) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            SignatureProvider signatureProvider = this.client().signatureProvider();
            X509WechatCertificateInfo certificate = signatureProvider.getCertificate(this.wechatMetaBean().getTenantId());
            X509Certificate x509Certificate = certificate.getX509Certificate();
            params.setAppid(v3.getAppId());
            String name = params.getName();
            if (StringUtils.hasText((String)name)) {
                String encryptedName = signatureProvider.encryptRequestMessage(name, x509Certificate);
                params.setName(encryptedName);
            }
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Wechatpay-Serial", certificate.getWechatPaySerial());
            return this.Post(uri, params, httpHeaders);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }

    public WechatResponseEntity<ObjectNode> deleteReceivers(DelReceiversParams delReceiversParams) {
        WechatResponseEntity<ObjectNode> wechatResponseEntity = new WechatResponseEntity<ObjectNode>();
        this.client().withType(WechatPayV3Type.PROFITSHARING_RECEIVERS_DELETE, delReceiversParams).function((wechatPayV3Type, params) -> {
            WechatPayProperties.V3 v3 = this.wechatMetaBean().getV3();
            params.setAppid(v3.getAppId());
            URI uri = UriComponentsBuilder.fromHttpUrl((String)wechatPayV3Type.uri(WeChatServer.CHINA)).build().toUri();
            return this.Post(uri, params);
        }).consumer(wechatResponseEntity::convert).request();
        return wechatResponseEntity;
    }
}

