/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.auth;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.TempSecretApi;
import cn.stylefeng.roses.kernel.auth.api.TenantCodeGetApi;
import cn.stylefeng.roses.kernel.auth.api.context.AuthJwtContext;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.expander.LoginConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordTransferEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginResponse;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.payload.DefaultJwtPayload;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.demo.expander.DemoConfigExpander;
import cn.stylefeng.roses.kernel.log.api.LoginLogServiceApi;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.scanner.api.exception.ScannerException;
import cn.stylefeng.roses.kernel.scanner.api.exception.enums.ScannerExceptionEnum;
import cn.stylefeng.roses.kernel.scanner.api.holder.InitScanFlagHolder;
import cn.stylefeng.roses.kernel.security.api.DragCaptchaApi;
import cn.stylefeng.roses.kernel.security.api.ImageCaptchaApi;
import cn.stylefeng.roses.kernel.security.api.expander.SecurityConfigExpander;
import cn.stylefeng.roses.kernel.sys.api.SysUserServiceApi;
import cn.stylefeng.roses.kernel.sys.api.enums.user.UserStatusEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.UserValidateDTO;
import cn.stylefeng.roses.kernel.validator.api.exception.enums.ValidatorExceptionEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    @Resource
    private SysUserServiceApi sysUserServiceApi;
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private PasswordTransferEncryptApi passwordTransferEncryptApi;
    @Resource
    private ImageCaptchaApi captchaApi;
    @Resource
    private DragCaptchaApi dragCaptchaApi;
    @Resource
    private LoginLogServiceApi loginLogServiceApi;
    @Resource(name="loginErrorCountCacheApi")
    private CacheOperatorApi<Integer> loginErrorCountCacheApi;
    @Resource
    private PasswordStoredEncryptApi passwordStoredEncryptApi;
    @Resource
    private TenantCodeGetApi tenantCodeGetApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginResponse loginAction(LoginRequest loginRequest, Boolean validatePassword, String caToken) {
        if (!InitScanFlagHolder.getFlag().booleanValue()) {
            throw new ScannerException((AbstractExceptionEnum)ScannerExceptionEnum.SYSTEM_RESOURCE_URL_NOT_INIT);
        }
        LoginService.validateEmptyParams(loginRequest, validatePassword);
        Integer loginErrorCount = this.validatePasswordRetryTimes(loginRequest);
        this.validateCaptcha(loginRequest);
        this.decryptRequestPassword(loginRequest);
        String tenantCode = loginRequest.getTenantCode();
        Long tenantId = this.tenantCodeGetApi.getTenantIdByCode(tenantCode);
        UserValidateDTO userValidateInfo = this.sysUserServiceApi.getUserLoginValidateDTO(tenantId, loginRequest.getAccount());
        this.validateUserPassword(validatePassword, loginErrorCount, loginRequest, userValidateInfo);
        if (!UserStatusEnum.ENABLE.getCode().equals(userValidateInfo.getUserStatus())) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.USER_STATUS_ERROR, new Object[]{UserStatusEnum.getCodeMessage((Integer)userValidateInfo.getUserStatus())});
        }
        DefaultJwtPayload defaultJwtPayload = new DefaultJwtPayload(userValidateInfo.getUserId(), loginRequest.getAccount(), loginRequest.getRememberMe().booleanValue(), caToken);
        String userLoginToken = AuthJwtContext.me().generateTokenDefaultPayload(defaultJwtPayload);
        LoginUser loginUser = new LoginUser(userValidateInfo.getUserId(), loginRequest.getAccount(), userLoginToken, tenantId);
        String ip = HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest());
        loginUser.setLoginIp(ip);
        loginUser.setLoginTime(new Date());
        String string = loginRequest.getAccount().intern();
        synchronized (string) {
            this.sessionManagerApi.createSession(userLoginToken, loginUser);
            if (LoginConfigExpander.getSingleAccountLoginFlag()) {
                this.sessionManagerApi.removeSessionExcludeToken(userLoginToken);
            }
        }
        if (!DemoConfigExpander.getDemoEnvFlag().booleanValue()) {
            this.sysUserServiceApi.updateUserLoginInfo(loginUser.getUserId(), ip);
            this.loginLogServiceApi.loginSuccess(loginUser.getUserId());
        }
        this.loginErrorCountCacheApi.remove(new String[]{loginRequest.getAccount()});
        return new LoginResponse(loginUser.getUserId(), userLoginToken);
    }

    private void decryptRequestPassword(LoginRequest loginRequest) {
        if (loginRequest.getPassword() != null && LoginConfigExpander.getPasswordRsaValidateFlag().booleanValue()) {
            String decryptPassword = this.passwordTransferEncryptApi.decrypt(loginRequest.getPassword());
            loginRequest.setPassword(decryptPassword);
        }
    }

    private void validateCaptcha(LoginRequest loginRequest) {
        String verKey;
        if (SecurityConfigExpander.getCaptchaOpen().booleanValue()) {
            verKey = loginRequest.getVerKey();
            String verCode = loginRequest.getVerCode();
            if (StrUtil.isEmpty((CharSequence)verKey) || StrUtil.isEmpty((CharSequence)verCode)) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_EMPTY);
            }
            if (!this.captchaApi.validateCaptcha(verKey, verCode)) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_ERROR);
            }
        }
        if (SecurityConfigExpander.getDragCaptchaOpen().booleanValue()) {
            verKey = loginRequest.getVerKey();
            String verXLocationValue = loginRequest.getVerCode();
            if (StrUtil.isEmpty((CharSequence)verKey) || StrUtil.isEmpty((CharSequence)verXLocationValue)) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_EMPTY);
            }
            if (!this.dragCaptchaApi.validateCaptcha(verKey, Convert.toInt((Object)verXLocationValue))) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.DRAG_CAPTCHA_ERROR);
            }
        }
    }

    private Integer validatePasswordRetryTimes(LoginRequest loginRequest) {
        Integer loginErrorCount = (Integer)this.loginErrorCountCacheApi.get(loginRequest.getAccount());
        if (loginErrorCount != null && loginErrorCount >= LoginConfigExpander.getMaxErrorLoginCount()) {
            this.sysUserServiceApi.lockUserStatus(loginRequest.getTenantCode(), loginRequest.getAccount());
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.LOGIN_LOCKED);
        }
        return loginErrorCount;
    }

    private static void validateEmptyParams(LoginRequest loginRequest, Boolean validatePassword) {
        if (validatePassword.booleanValue()) {
            if (loginRequest == null || StrUtil.hasBlank((CharSequence[])new CharSequence[]{loginRequest.getAccount(), loginRequest.getPassword()})) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.PARAM_EMPTY);
            }
        } else if (loginRequest == null || StrUtil.hasBlank((CharSequence[])new CharSequence[]{loginRequest.getAccount()})) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.ACCOUNT_IS_BLANK);
        }
    }

    private String getRemoteLoginCode(LoginRequest loginRequest) {
        String ssoUrl = AuthConfigExpander.getSsoUrl();
        HttpRequest httpRequest = HttpRequest.post((String)(ssoUrl + "/sso/getLoginCode"));
        httpRequest.body(JSON.toJSONString((Object)loginRequest));
        HttpResponse httpResponse = httpRequest.execute();
        String body = httpResponse.body();
        JSONObject jsonObject = new JSONObject();
        if (StrUtil.isNotBlank((CharSequence)body)) {
            jsonObject = JSON.parseObject((String)body);
        }
        if (httpResponse.getStatus() != 200) {
            String message = jsonObject.getString("message");
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_LOGIN_CODE_GET_ERROR, new Object[]{message});
        }
        String loginCode = jsonObject.getString("data");
        if (loginCode == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_LOGIN_CODE_GET_ERROR, new Object[]{"loginCode\u4e3a\u7a7a"});
        }
        return loginCode;
    }

    private void validateUserPassword(Boolean validatePassword, Integer loginErrorCount, LoginRequest loginRequest, UserValidateDTO userValidateInfo) {
        if (!validatePassword.booleanValue()) {
            return;
        }
        Boolean checkResult = this.passwordStoredEncryptApi.checkPasswordWithSalt(loginRequest.getPassword(), userValidateInfo.getUserPasswordSalt(), userValidateInfo.getUserPasswordHexed());
        if (checkResult.booleanValue()) {
            return;
        }
        TempSecretApi tempSecretApi = null;
        try {
            boolean validateResult;
            tempSecretApi = (TempSecretApi)SpringUtil.getBean(TempSecretApi.class);
            if (tempSecretApi != null && (validateResult = tempSecretApi.validateUserTempSecretKey(userValidateInfo.getUserId(), loginRequest.getPassword()))) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loginErrorCount == null) {
            loginErrorCount = 0;
        }
        if (!DemoConfigExpander.getDemoEnvFlag().booleanValue()) {
            this.loginErrorCountCacheApi.put(loginRequest.getAccount(), (Object)(loginErrorCount + 1));
        }
        throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.USERNAME_PASSWORD_ERROR);
    }
}

