/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.mp.datascope;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.mp.datascope.config.DataScopeConfig;
import cn.stylefeng.roses.kernel.db.mp.datascope.holder.DataScopeHolder;
import cn.stylefeng.roses.kernel.rule.enums.permission.DataScopeTypeEnum;
import com.baomidou.mybatisplus.extension.plugins.handler.MultiDataPermissionHandler;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;

public class ProjectDataScopeHandler
implements MultiDataPermissionHandler {
    public static final Long NONE_ID_VALUE = -1L;
    public static final String DEFAULT_USER_ID_FIELD_NAME = "user_id";
    public static final String DEFAULT_ORG_ID_FIELD_NAME = "org_id";

    public Expression getSqlSegment(Table table, Expression where, String mappedStatementId) {
        DataScopeConfig dataScopeConfig = DataScopeHolder.get();
        if (ObjectUtil.isEmpty((Object)dataScopeConfig)) {
            return null;
        }
        if ((dataScopeConfig = this.validateDataScopeConfig(dataScopeConfig)) == null) {
            return null;
        }
        DataScopeTypeEnum dataScopeTypeEnum = dataScopeConfig.getDataScopeType();
        switch (dataScopeTypeEnum) {
            case ALL: {
                return null;
            }
            case DEPT: {
                return ProjectDataScopeHandler.getEqualsTo(dataScopeConfig.getOrgIdFieldName(), dataScopeConfig.getUserDeptId());
            }
            case DEPT_WITH_CHILD: {
                return ProjectDataScopeHandler.deptWithChildScope(dataScopeConfig, dataScopeConfig.getUserDeptId());
            }
            case COMPANY_WITH_CHILD: {
                return ProjectDataScopeHandler.deptWithChildScope(dataScopeConfig, dataScopeConfig.getUserCompanyId());
            }
            case DEFINE: {
                return ProjectDataScopeHandler.getInExpression(dataScopeConfig);
            }
            case SELF: {
                return ProjectDataScopeHandler.getEqualsTo(dataScopeConfig.getUserIdFieldName(), dataScopeConfig.getUserId());
            }
        }
        return null;
    }

    private DataScopeConfig validateDataScopeConfig(DataScopeConfig dataScopeConfig) {
        if (dataScopeConfig == null) {
            return null;
        }
        DataScopeTypeEnum dataScopeType = dataScopeConfig.getDataScopeType();
        if (dataScopeType == null) {
            return null;
        }
        if (DataScopeTypeEnum.ALL.equals((Object)dataScopeType)) {
            return null;
        }
        if (DataScopeTypeEnum.SELF.equals((Object)dataScopeType)) {
            if (ObjectUtil.isEmpty((Object)dataScopeConfig.getUserId())) {
                dataScopeConfig.setUserId(NONE_ID_VALUE);
            }
            if (ObjectUtil.isEmpty((Object)dataScopeConfig.getUserIdFieldName())) {
                dataScopeConfig.setUserIdFieldName(DEFAULT_USER_ID_FIELD_NAME);
            }
        } else if (DataScopeTypeEnum.COMPANY_WITH_CHILD.equals((Object)dataScopeType)) {
            if (ObjectUtil.isEmpty((Object)dataScopeConfig.getUserCompanyId())) {
                dataScopeConfig.setUserCompanyId(NONE_ID_VALUE);
            }
            if (ObjectUtil.isEmpty((Object)dataScopeConfig.getOrgIdFieldName())) {
                dataScopeConfig.setOrgIdFieldName(DEFAULT_ORG_ID_FIELD_NAME);
            }
        } else if (DataScopeTypeEnum.DEPT_WITH_CHILD.equals((Object)dataScopeType)) {
            if (ObjectUtil.isEmpty((Object)dataScopeConfig.getUserDeptId())) {
                dataScopeConfig.setUserDeptId(NONE_ID_VALUE);
            }
            if (ObjectUtil.isEmpty((Object)dataScopeConfig.getOrgIdFieldName())) {
                dataScopeConfig.setOrgIdFieldName(DEFAULT_ORG_ID_FIELD_NAME);
            }
        } else if (DataScopeTypeEnum.DEPT.equals((Object)dataScopeType)) {
            if (ObjectUtil.isEmpty((Object)dataScopeConfig.getUserDeptId())) {
                dataScopeConfig.setUserDeptId(NONE_ID_VALUE);
            }
            if (ObjectUtil.isEmpty((Object)dataScopeConfig.getOrgIdFieldName())) {
                dataScopeConfig.setOrgIdFieldName(DEFAULT_ORG_ID_FIELD_NAME);
            }
        } else if (DataScopeTypeEnum.DEFINE.equals((Object)dataScopeType)) {
            if (ObjectUtil.isEmpty(dataScopeConfig.getSpecificOrgIds())) {
                dataScopeConfig.setSpecificOrgIds(ListUtil.list((boolean)true, (Object[])new Long[]{NONE_ID_VALUE}));
            }
            if (ObjectUtil.isEmpty((Object)dataScopeConfig.getOrgIdFieldName())) {
                dataScopeConfig.setOrgIdFieldName(DEFAULT_ORG_ID_FIELD_NAME);
            }
        }
        return dataScopeConfig;
    }

    private static EqualsTo getEqualsTo(String fieldName, Long value) {
        Column orgIdColumn = new Column(fieldName);
        LongValue longValue = new LongValue(value.longValue());
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)orgIdColumn);
        equalsTo.setRightExpression((Expression)longValue);
        return equalsTo;
    }

    private static InExpression getInExpression(DataScopeConfig dataScopeConfig) {
        Column orgIdColumn = new Column(dataScopeConfig.getOrgIdFieldName());
        ExpressionList expressionList = new ExpressionList();
        expressionList.setExpressions(dataScopeConfig.getSpecificOrgIds().stream().map(LongValue::new).collect(Collectors.toList()));
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)orgIdColumn);
        inExpression.setRightItemsList((ItemsList)expressionList);
        return inExpression;
    }

    private static Expression deptWithChildScope(DataScopeConfig dataScopeConfig, Long deptOrCompanyId) {
        Column orgIdColumn = new Column(dataScopeConfig.getOrgIdFieldName());
        SubSelect subSelect = new SubSelect();
        PlainSelect selectBody = new PlainSelect();
        selectBody.setSelectItems(ListUtil.of((Object[])new SelectItem[]{new SelectExpressionItem((Expression)orgIdColumn)}));
        selectBody.setFromItem((FromItem)new Table("sys_hr_organization"));
        LikeExpression likeExpression = new LikeExpression();
        likeExpression.setLeftExpression((Expression)new Column("org_pids"));
        likeExpression.setRightExpression((Expression)new StringValue("%[" + deptOrCompanyId + "]%"));
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)orgIdColumn);
        equalsTo.setRightExpression((Expression)new LongValue(deptOrCompanyId.longValue()));
        OrExpression orExpression = new OrExpression((Expression)likeExpression, (Expression)equalsTo);
        selectBody.setWhere((Expression)orExpression);
        subSelect.setSelectBody((SelectBody)selectBody);
        return new InExpression((Expression)orgIdColumn, (ItemsList)subSelect);
    }
}

