/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.mp.fieldfill;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.util.EntityFieldUtil;
import cn.stylefeng.roses.kernel.db.mp.tenant.holder.TenantIdHolder;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.lang.reflect.Field;
import java.util.Date;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomMetaObjectHandler.class);

    public void insertFill(MetaObject metaObject) {
        try {
            this.setValue(metaObject, "createUser", this.getUserUniqueId());
            this.setValue(metaObject, "createTime", new Date());
            this.setDelFlagDefaultValue(metaObject);
            this.setStatusDefaultValue(metaObject);
            this.setValue(metaObject, "versionFlag", 0L);
            this.setValue(metaObject, "orgId", this.getUserOrgId());
            this.setValue(metaObject, "tenantId", this.getTenantId());
        }
        catch (ReflectionException e) {
            log.warn("CustomMetaObjectHandler\u5904\u7406\u8fc7\u7a0b\u4e2d\u65e0\u76f8\u5173\u5b57\u6bb5\uff0c\u4e0d\u505a\u5904\u7406");
        }
    }

    public void updateFill(MetaObject metaObject) {
        try {
            if (metaObject.hasSetter("updateUser")) {
                metaObject.setValue("updateUser", (Object)this.getUserUniqueId());
            }
            if (metaObject.hasSetter("updateTime")) {
                metaObject.setValue("updateTime", (Object)new Date());
            }
        }
        catch (ReflectionException e) {
            log.warn("CustomMetaObjectHandler\u5904\u7406\u8fc7\u7a0b\u4e2d\u65e0\u76f8\u5173\u5b57\u6bb5\uff0c\u4e0d\u505a\u5904\u7406");
        }
    }

    protected Long getUserUniqueId() {
        try {
            return LoginContext.me().getLoginUser().getUserId();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    protected void setValue(MetaObject metaObject, String fieldName, Object value) {
        Object originalAttr = this.getFieldValByName(fieldName, metaObject);
        if (ObjectUtil.isEmpty((Object)originalAttr)) {
            this.setFieldValByName(fieldName, value, metaObject);
        }
    }

    protected Long getUserOrgId() {
        try {
            return LoginContext.me().getLoginUser().getCurrentOrgId();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    protected Long getTenantId() {
        try {
            Long tenantId = TenantIdHolder.get();
            if (ObjectUtil.isNotEmpty((Object)tenantId)) {
                return tenantId;
            }
            return LoginContext.me().getLoginUser().getTenantId();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    protected void setDelFlagDefaultValue(MetaObject metaObject) {
        Object originalAttr = this.getFieldValByName("delFlag", metaObject);
        if (ObjectUtil.isNotEmpty((Object)originalAttr)) {
            return;
        }
        Object originalObject = metaObject.getOriginalObject();
        try {
            Field declaredField = EntityFieldUtil.getDeclaredField((Object)originalObject, (String)"delFlag");
            if (ClassUtil.isEnum(declaredField.getType())) {
                this.setFieldValByName("delFlag", YesOrNotEnum.N, metaObject);
            } else {
                this.setFieldValByName("delFlag", YesOrNotEnum.N.getCode(), metaObject);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    protected void setStatusDefaultValue(MetaObject metaObject) {
        Object originalAttr = this.getFieldValByName("statusFlag", metaObject);
        if (ObjectUtil.isNotEmpty((Object)originalAttr)) {
            return;
        }
        Object originalObject = metaObject.getOriginalObject();
        try {
            Field declaredField = EntityFieldUtil.getDeclaredField((Object)originalObject, (String)"statusFlag");
            if (ClassUtil.isEnum(declaredField.getType())) {
                this.setFieldValByName("statusFlag", StatusEnum.ENABLE, metaObject);
            } else {
                this.setFieldValByName("statusFlag", StatusEnum.ENABLE.getCode(), metaObject);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

