/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.mp.tenant;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.db.api.pojo.tenant.TenantTableProperties;
import cn.stylefeng.roses.kernel.db.mp.tenant.holder.TenantIdHolder;
import cn.stylefeng.roses.kernel.db.mp.tenant.holder.TenantSwitchHolder;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.schema.Column;

public class ProjectTenantInterceptor
implements TenantLineHandler {
    private TenantTableProperties tenantTableProperties;

    public ProjectTenantInterceptor(TenantTableProperties tenantTableProperties) {
        this.tenantTableProperties = tenantTableProperties;
    }

    public Expression getTenantId() {
        Long tenantId = TenantIdHolder.get();
        if (ObjectUtil.isNotEmpty((Object)tenantId)) {
            return new LongValue(tenantId.longValue());
        }
        LoginUser loginUserNullable = LoginContext.me().getLoginUserNullable();
        if (loginUserNullable == null) {
            return null;
        }
        if (ObjectUtil.isEmpty((Object)loginUserNullable.getTenantId())) {
            return null;
        }
        return new LongValue(loginUserNullable.getTenantId().longValue());
    }

    public boolean ignoreTable(String tableName) {
        Boolean openFlag = TenantSwitchHolder.get();
        if (openFlag != null && !openFlag.booleanValue()) {
            return true;
        }
        if (this.tenantTableProperties == null) {
            return true;
        }
        List businessTableList = this.tenantTableProperties.getBusinessTableList();
        if (ObjectUtil.isEmpty((Object)businessTableList)) {
            return true;
        }
        for (String tenantTable : businessTableList) {
            if (!tenantTable.equalsIgnoreCase(tableName)) continue;
            return false;
        }
        return true;
    }

    public boolean ignoreInsert(List<Column> columns, String tenantIdColumn) {
        return super.ignoreInsert(columns, tenantIdColumn);
    }
}

