/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DashScopeAiStreamFunctionCallingHelper {
    private Boolean incrementalOutput = false;

    public DashScopeAiStreamFunctionCallingHelper() {
    }

    public DashScopeAiStreamFunctionCallingHelper(Boolean incrementalOutput) {
        this.incrementalOutput = incrementalOutput;
    }

    public DashScopeApi.ChatCompletionChunk merge(DashScopeApi.ChatCompletionChunk previous, DashScopeApi.ChatCompletionChunk current) {
        DashScopeApi.ChatCompletionOutput.Choice currentChoice0;
        DashScopeApi.ChatCompletionOutput.Choice previousChoice0;
        DashScopeApi.TokenUsage usage;
        if (previous == null) {
            return current;
        }
        String id = current.requestId() != null ? current.requestId() : previous.requestId();
        DashScopeApi.TokenUsage tokenUsage = usage = current.usage() != null ? current.usage() : previous.usage();
        DashScopeApi.ChatCompletionOutput.Choice choice = previous.output() == null ? null : (previousChoice0 = CollectionUtils.isEmpty(previous.output().choices()) ? null : previous.output().choices().get(0));
        DashScopeApi.ChatCompletionOutput.Choice choice2 = current.output() == null ? null : (currentChoice0 = CollectionUtils.isEmpty(current.output().choices()) ? null : current.output().choices().get(0));
        if (!this.incrementalOutput.booleanValue() && this.isStreamingToolFunctionCall(current)) {
            if (!this.isStreamingToolFunctionCallFinish(current)) {
                return new DashScopeApi.ChatCompletionChunk(id, new DashScopeApi.ChatCompletionOutput(null, List.of(), null), usage);
            }
            return new DashScopeApi.ChatCompletionChunk(id, new DashScopeApi.ChatCompletionOutput(null, List.of(currentChoice0), null), usage);
        }
        DashScopeApi.ChatCompletionOutput.Choice choice3 = this.merge(previousChoice0, currentChoice0);
        List<DashScopeApi.ChatCompletionOutput.Choice> chunkChoices = choice3 == null ? List.of() : List.of(choice3);
        return new DashScopeApi.ChatCompletionChunk(id, new DashScopeApi.ChatCompletionOutput(null, chunkChoices, null), usage);
    }

    private DashScopeApi.ChatCompletionOutput.Choice merge(DashScopeApi.ChatCompletionOutput.Choice previous, DashScopeApi.ChatCompletionOutput.Choice current) {
        if (previous == null) {
            return current;
        }
        DashScopeApi.ChatCompletionFinishReason finishReason = current.finishReason() != null ? current.finishReason() : previous.finishReason();
        DashScopeApi.ChatCompletionMessage message = this.merge(previous.message(), current.message());
        DashScopeApi.ChatCompletionLogprobs logprobs = current.logprobs() != null ? current.logprobs() : previous.logprobs();
        return new DashScopeApi.ChatCompletionOutput.Choice(finishReason, message, logprobs);
    }

    private DashScopeApi.ChatCompletionMessage merge(DashScopeApi.ChatCompletionMessage previous, DashScopeApi.ChatCompletionMessage current) {
        String content = current.content() != null ? current.content() : (previous.content() != null ? previous.content() : "");
        DashScopeApi.ChatCompletionMessage.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : DashScopeApi.ChatCompletionMessage.Role.ASSISTANT;
        String name = StringUtils.hasText((String)current.name()) ? current.name() : previous.name();
        String toolCallId = StringUtils.hasText((String)current.toolCallId()) ? current.toolCallId() : previous.toolCallId();
        String reasoningContent = current.reasoningContent() != null ? current.reasoningContent() : previous.reasoningContent();
        ArrayList<DashScopeApi.ChatCompletionMessage.ToolCall> toolCalls = new ArrayList<DashScopeApi.ChatCompletionMessage.ToolCall>();
        DashScopeApi.ChatCompletionMessage.ToolCall lastPreviousTooCall = null;
        if (previous.toolCalls() != null) {
            lastPreviousTooCall = previous.toolCalls().get(previous.toolCalls().size() - 1);
            if (previous.toolCalls().size() > 1) {
                toolCalls.addAll(previous.toolCalls().subList(0, previous.toolCalls().size() - 1));
            }
        }
        if (!CollectionUtils.isEmpty(current.toolCalls())) {
            if (current.toolCalls().size() > 1) {
                throw new IllegalStateException("Currently only one tool call is supported per message!");
            }
            DashScopeApi.ChatCompletionMessage.ToolCall currentToolCall = current.toolCalls().iterator().next();
            if (StringUtils.hasText((String)currentToolCall.id())) {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(currentToolCall);
            } else {
                toolCalls.add(this.merge(lastPreviousTooCall, currentToolCall));
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return new DashScopeApi.ChatCompletionMessage(content, role, name, toolCallId, toolCalls, reasoningContent);
    }

    private DashScopeApi.ChatCompletionMessage.ToolCall merge(DashScopeApi.ChatCompletionMessage.ToolCall previous, DashScopeApi.ChatCompletionMessage.ToolCall current) {
        if (previous == null) {
            return current;
        }
        String id = StringUtils.hasText((String)current.id()) ? current.id() : previous.id();
        String type = StringUtils.hasText((String)current.type()) ? current.type() : previous.type();
        DashScopeApi.ChatCompletionMessage.ChatCompletionFunction function = this.merge(previous.function(), current.function());
        return new DashScopeApi.ChatCompletionMessage.ToolCall(id, type, function);
    }

    private DashScopeApi.ChatCompletionMessage.ChatCompletionFunction merge(DashScopeApi.ChatCompletionMessage.ChatCompletionFunction previous, DashScopeApi.ChatCompletionMessage.ChatCompletionFunction current) {
        if (previous == null) {
            return current;
        }
        String name = StringUtils.hasText((String)current.name()) ? current.name() : previous.name();
        StringBuilder arguments = new StringBuilder();
        if (previous.arguments() != null) {
            arguments.append(previous.arguments());
        }
        if (current.arguments() != null) {
            arguments.append(current.arguments());
        }
        return new DashScopeApi.ChatCompletionMessage.ChatCompletionFunction(name, arguments.toString());
    }

    public boolean isStreamingToolFunctionCall(DashScopeApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || chatCompletion.output() == null || CollectionUtils.isEmpty(chatCompletion.output().choices())) {
            return false;
        }
        DashScopeApi.ChatCompletionOutput.Choice choice = chatCompletion.output().choices().get(0);
        if (choice == null || choice.message() == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(choice.message().toolCalls());
    }

    public boolean isStreamingToolFunctionCallFinish(DashScopeApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.output().choices())) {
            return false;
        }
        DashScopeApi.ChatCompletionOutput.Choice choice = chatCompletion.output().choices().get(0);
        if (choice == null || choice.message() == null) {
            return false;
        }
        return choice.finishReason() == DashScopeApi.ChatCompletionFinishReason.TOOL_CALLS;
    }

    public DashScopeApi.ChatCompletion chunkToChatCompletion(DashScopeApi.ChatCompletionChunk chunk) {
        return new DashScopeApi.ChatCompletion(chunk.requestId(), chunk.output(), chunk.usage());
    }
}

