/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.ModelDescription;
import org.springframework.ai.model.ModelResult;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.ResultMetadata;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class DashScopeVideoApi {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeVideoApi.class);
    public static final String DEFAULT_VIDEO_MODEL = VideoModel.WANX2_1_T2V_TURBO.getValue();
    private final String baseUrl;
    private final ApiKey apiKey;
    private final RestClient restClient;
    private final ResponseErrorHandler responseErrorHandler;

    public Builder mutate() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public DashScopeVideoApi(String baseUrl, ApiKey apiKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.responseErrorHandler = responseErrorHandler;
        Consumer<HttpHeaders> finalHeaders = h -> {
            if (!(apiKey instanceof NoopApiKey)) {
                h.setBearerAuth(apiKey.getValue());
            }
            h.setContentType(MediaType.APPLICATION_JSON);
        };
        this.restClient = restClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(finalHeaders).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<VideoGenerationResponse> submitVideoGenTask(VideoGenerationRequest request) {
        logger.debug("Submitting video generation task with options: {}", (Object)request);
        Object baseUrl = "/api/v1/services/aigc";
        String firstAndLAst = "/image2video/video-synthesis";
        String normal = "/video-generation/video-synthesis";
        baseUrl = request.input.getFirstFrameUrl() != null || request.input.getLastFrameUrl() != null ? (String)baseUrl + firstAndLAst : (String)baseUrl + normal;
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri((String)baseUrl, new Object[0])).body((Object)request).header("X-DashScope-Async", new String[]{"enable"})).retrieve().toEntity(VideoGenerationResponse.class);
    }

    public ResponseEntity<VideoGenerationResponse> queryVideoGenTask(String taskId) {
        return this.restClient.get().uri("/api/v1/tasks/{taskId}", new Object[]{taskId}).retrieve().toEntity(VideoGenerationResponse.class);
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    ApiKey getApiKey() {
        return this.apiKey;
    }

    RestClient getRestClient() {
        return this.restClient;
    }

    ResponseErrorHandler getResponseErrorHandler() {
        return this.responseErrorHandler;
    }

    public static class Builder {
        private String baseUrl = "https://dashscope.aliyuncs.com";
        private ApiKey apiKey;
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder() {
        }

        public Builder(DashScopeVideoApi api) {
            this.baseUrl = api.getBaseUrl();
            this.apiKey = api.getApiKey();
            this.restClientBuilder = api.restClient != null ? api.restClient.mutate() : RestClient.builder();
            this.responseErrorHandler = api.getResponseErrorHandler();
        }

        public Builder baseUrl(String baseUrl) {
            Assert.notNull((Object)baseUrl, (String)"Base URL cannot be null");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"Simple api key cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"Rest client builder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"Response error handler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public DashScopeVideoApi build() {
            Assert.notNull((Object)this.apiKey, (String)"API key cannot be null");
            return new DashScopeVideoApi(this.baseUrl, this.apiKey, this.restClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class VideoGenerationRequest {
        @JsonProperty(value="model")
        private String model;
        @JsonProperty(value="input")
        private VideoInput input;
        @JsonProperty(value="parameters")
        private VideoParameters parameters;

        public VideoGenerationRequest(String model, VideoInput input, VideoParameters parameters) {
            this.model = model;
            this.input = input;
            this.parameters = parameters;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public VideoInput getInput() {
            return this.input;
        }

        public void setInput(VideoInput input) {
            this.input = input;
        }

        public VideoParameters getParameters() {
            return this.parameters;
        }

        public void setParameters(VideoParameters parameters) {
            this.parameters = parameters;
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class VideoInput {
            @JsonProperty(value="prompt")
            private String prompt;
            @JsonProperty(value="negative_prompt")
            private String negativePrompt;
            @JsonProperty(value="img_url")
            private String imageUrl;
            @JsonProperty(value="template")
            private String template;
            @JsonProperty(value="first_frame_url")
            private String firstFrameUrl;
            @JsonProperty(value="last_frame_url")
            private String lastFrameUrl;

            public VideoInput(String prompt) {
                this.prompt = prompt;
            }

            public VideoInput(String prompt, String negativePrompt) {
                this.prompt = prompt;
                this.negativePrompt = negativePrompt;
            }

            public VideoInput(String prompt, String negativePrompt, String imageUrl, String template) {
                this.prompt = prompt;
                this.negativePrompt = negativePrompt;
                this.imageUrl = imageUrl;
                this.template = template;
            }

            public VideoInput(String prompt, String negativePrompt, String imageUrl, String template, String firstFrameUrl, String lastFrameUrl) {
                this.prompt = prompt;
                this.negativePrompt = negativePrompt;
                this.imageUrl = imageUrl;
                this.template = template;
                this.firstFrameUrl = firstFrameUrl;
                this.lastFrameUrl = lastFrameUrl;
            }

            public String getFirstFrameUrl() {
                return this.firstFrameUrl;
            }

            public void setFirstFrameUrl(String firstFrameUrl) {
                this.firstFrameUrl = firstFrameUrl;
            }

            public String getLastFrameUrl() {
                return this.lastFrameUrl;
            }

            public void setLastFrameUrl(String lastFrameUrl) {
                this.lastFrameUrl = lastFrameUrl;
            }

            public String getNegativePrompt() {
                return this.negativePrompt;
            }

            public void setNegativePrompt(String negativePrompt) {
                this.negativePrompt = negativePrompt;
            }

            public String getImageUrl() {
                return this.imageUrl;
            }

            public void setImageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
            }

            public String getTemplate() {
                return this.template;
            }

            public void setTemplate(String template) {
                this.template = template;
            }

            public String getPrompt() {
                return this.prompt;
            }

            public void setPrompt(String prompt) {
                this.prompt = prompt;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String prompt;
                private String negativePrompt;
                private String imageUrl;
                private String template;
                private String firstFrameUrl;
                private String lastFrameUrl;

                public Builder prompt(String prompt) {
                    this.prompt = prompt;
                    return this;
                }

                public Builder negativePrompt(String negativePrompt) {
                    this.negativePrompt = negativePrompt;
                    return this;
                }

                public Builder imageUrl(String imageUrl) {
                    this.imageUrl = imageUrl;
                    return this;
                }

                public Builder template(VideoTemplate template) {
                    this.template = Objects.nonNull((Object)template) ? template.getValue() : "";
                    return this;
                }

                public Builder firstFrameUrl(String firstFrameUrl) {
                    this.firstFrameUrl = firstFrameUrl;
                    return this;
                }

                public Builder lastFrameUrl(String lastFrameUrl) {
                    this.lastFrameUrl = lastFrameUrl;
                    return this;
                }

                public VideoInput build() {
                    return new VideoInput(this.prompt, this.negativePrompt, this.imageUrl, this.template, this.firstFrameUrl, this.lastFrameUrl);
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class VideoParameters {
            @JsonProperty(value="resolution")
            private String resolution;
            @JsonProperty(value="size")
            private String size;
            @JsonProperty(value="duration")
            private Integer duration;
            @JsonProperty(value="seed")
            private Long seed;
            @JsonProperty(value="prompt_extend")
            private Boolean promptExtend;

            public VideoParameters(String size, Integer duration, Long seed, String resolution, Boolean promptExtend) {
                this.promptExtend = promptExtend;
                this.resolution = resolution;
                this.size = size;
                this.seed = seed;
                this.duration = duration;
            }

            public String getResolution() {
                return this.resolution;
            }

            public void setResolution(String resolution) {
                this.resolution = resolution;
            }

            public Integer getDuration() {
                return this.duration;
            }

            public void setDuration(Integer duration) {
                this.duration = duration;
            }

            public Long getSeed() {
                return this.seed;
            }

            public void setSeed(Long seed) {
                this.seed = seed;
            }

            public Boolean getPromptExtend() {
                return this.promptExtend;
            }

            public void setPromptExtend(Boolean promptExtend) {
                this.promptExtend = promptExtend;
            }

            public String getSize() {
                return this.size;
            }

            public void setSize(String size) {
                this.size = size;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String size;
                private Integer duration;
                private Long seed;
                private Boolean promptExtend;
                private String resolution;

                public Builder size(String size) {
                    this.size = size;
                    return this;
                }

                public Builder duration(Integer duration) {
                    this.duration = duration;
                    return this;
                }

                public Builder seed(Long seed) {
                    this.seed = seed;
                    return this;
                }

                public Builder promptExtend(Boolean promptExtend) {
                    this.promptExtend = promptExtend;
                    return this;
                }

                public Builder resolution(String resolution) {
                    this.resolution = resolution;
                    return this;
                }

                public VideoParameters build() {
                    return new VideoParameters(this.size, this.duration, this.seed, this.resolution, this.promptExtend);
                }
            }
        }

        public static final class Builder {
            private String model;
            private VideoInput input;
            private VideoParameters parameters;

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder input(VideoInput input) {
                this.input = input;
                return this;
            }

            public Builder parameters(VideoParameters parameters) {
                this.parameters = parameters;
                return this;
            }

            public VideoGenerationRequest build() {
                return new VideoGenerationRequest(this.model, this.input, this.parameters);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class VideoGenerationResponse
    implements ModelResult<VideoOutput> {
        @JsonProperty(value="request_id")
        private String requestId;
        @JsonProperty(value="output")
        private VideoOutput output;
        @JsonProperty(value="usage")
        private VideoUsage usage;

        public VideoUsage getUsage() {
            return this.usage;
        }

        public void setUsage(VideoUsage usage) {
            this.usage = usage;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public VideoOutput getOutput() {
            return this.output;
        }

        public ResultMetadata getMetadata() {
            return null;
        }

        public void setOutput(VideoOutput output) {
            this.output = output;
        }

        public String toString() {
            return "VideoGenerationResponse{requestId='" + this.requestId + "', output=" + this.output + ", usage=" + this.usage + "}";
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class VideoUsage {
            @JsonProperty(value="video_duration")
            private Integer videoDuration;
            @JsonProperty(value="video_ratio")
            private String videoRatio;
            @JsonProperty(value="video_count")
            private Integer videoCount;

            public Integer getVideoDuration() {
                return this.videoDuration;
            }

            public void setVideoDuration(Integer videoDuration) {
                this.videoDuration = videoDuration;
            }

            public String getVideoRatio() {
                return this.videoRatio;
            }

            public void setVideoRatio(String videoRatio) {
                this.videoRatio = videoRatio;
            }

            public Integer getVideoCount() {
                return this.videoCount;
            }

            public void setVideoCount(Integer videoCount) {
                this.videoCount = videoCount;
            }

            public String toString() {
                return "VideoUsage{videoDuration=" + this.videoDuration + ", videoRatio='" + this.videoRatio + "', videoCount=" + this.videoCount + "}";
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class VideoOutput {
            @JsonProperty(value="task_id")
            private String taskId;
            @JsonProperty(value="task_status")
            private String taskStatus;
            @JsonProperty(value="submit_time")
            private String submitTimes;
            @JsonProperty(value="end_time")
            private String endTime;
            @JsonProperty(value="scheduled_time")
            private String scheduledTime;
            @JsonProperty(value="video_url")
            private String videoUrl;
            @JsonProperty(value="orig_prompt")
            private String origPrompt;
            @JsonProperty(value="actual_prompt")
            private String actualPrompt;
            @JsonProperty(value="code")
            private String code;
            @JsonProperty(value="message")
            private String message;

            public String getTaskId() {
                return this.taskId;
            }

            public void setTaskId(String taskId) {
                this.taskId = taskId;
            }

            public String getTaskStatus() {
                return this.taskStatus;
            }

            public void setTaskStatus(String taskStatus) {
                this.taskStatus = taskStatus;
            }

            public String getSubmitTimes() {
                return this.submitTimes;
            }

            public void setSubmitTimes(String submitTimes) {
                this.submitTimes = submitTimes;
            }

            public String getEndTime() {
                return this.endTime;
            }

            public void setEndTime(String endTime) {
                this.endTime = endTime;
            }

            public String getScheduledTime() {
                return this.scheduledTime;
            }

            public void setScheduledTime(String scheduledTime) {
                this.scheduledTime = scheduledTime;
            }

            public String getVideoUrl() {
                return this.videoUrl;
            }

            public void setVideoUrl(String videoUrl) {
                this.videoUrl = videoUrl;
            }

            public String getOrigPrompt() {
                return this.origPrompt;
            }

            public void setOrigPrompt(String origPrompt) {
                this.origPrompt = origPrompt;
            }

            public String getActualPrompt() {
                return this.actualPrompt;
            }

            public void setActualPrompt(String actualPrompt) {
                this.actualPrompt = actualPrompt;
            }

            public String getCode() {
                return this.code;
            }

            public void setCode(String code) {
                this.code = code;
            }

            public String getMessage() {
                return this.message;
            }

            public void setMessage(String message) {
                this.message = message;
            }

            public String toString() {
                return "VideoOutput{taskId='" + this.taskId + "', taskStatus='" + this.taskStatus + "', submitTimes='" + this.submitTimes + "', endTime='" + this.endTime + "', scheduledTime='" + this.scheduledTime + "', videoUrl='" + this.videoUrl + "', origPrompt='" + this.origPrompt + "', actualPrompt='" + this.actualPrompt + "', code='" + this.code + "', message='" + this.message + "'}";
            }
        }
    }

    public static enum VideoModel implements ModelDescription
    {
        WANX2_1_T2V_TURBO("wanx2.1-t2v-turbo"),
        WANX2_1_T2V_PLUS("wanx2.1-t2v-plus"),
        WANX2_1_I2V_TURBO("wanx2.1-i2v-turbo"),
        WANX2_1_I2V_PLUS("wanx2.1-i2v-plus"),
        WANX2_1_KF2V_PLUS("wanx2.1-kf2v-plus");

        public final String value;

        private VideoModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }

    public static enum VideoTemplate {
        SQUISH("squish"),
        POKE("poke"),
        ROTATION("rotation"),
        INFLATE("inflate"),
        DISSOLVE("dissolve"),
        CAROUSEL("carousel"),
        SINGLEHEART("singleheart"),
        DANCE1("dance1"),
        DANCE2("dance2"),
        DANCE3("dance3"),
        MERMAID("mermaid"),
        GRADUATION("graduation"),
        DEAGON("dragon"),
        MONEY("money"),
        FLYING("flying"),
        ROSE("rose"),
        CRYSTALROSE("crystalrose"),
        HUG("hug"),
        FRENCHKISS("frenchkiss"),
        COUPLEHEART("coupleheart");

        private final String value;

        private VideoTemplate(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

