/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.chat;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeResponseFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashScopeChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonIgnore
    private Boolean stream;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="stop")
    private List<Object> stop;
    @JsonProperty(value="enable_search")
    private Boolean enableSearch = false;
    @JsonProperty(value="response_format")
    private DashScopeResponseFormat responseFormat;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="incremental_output")
    private Boolean incrementalOutput = true;
    @JsonProperty(value="repetition_penalty")
    private Double repetitionPenalty;
    @JsonProperty(value="tools")
    private List<DashScopeApi.FunctionTool> tools;
    @JsonProperty(value="search_options")
    private DashScopeApi.SearchOptions searchOptions;
    @JsonProperty(value="parallel_tool_calls")
    private Boolean parallelToolCalls;
    @JsonIgnore
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    @JsonProperty(value="tool_choice")
    private Object toolChoice;
    @JsonProperty(value="vl_high_resolution_images")
    private Boolean vlHighResolutionImages;
    @JsonProperty(value="enable_thinking")
    private Boolean enableThinking = false;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonProperty(value="multi_model")
    private Boolean multiModel = false;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();

    public String getModel() {
        return this.model;
    }

    public Double getFrequencyPenalty() {
        return null;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Double getPresencePenalty() {
        return null;
    }

    public List<String> getStopSequences() {
        return null;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public void setSearchOptions(DashScopeApi.SearchOptions searchOptions) {
        this.searchOptions = searchOptions;
    }

    public DashScopeApi.SearchOptions getSearchOptions() {
        return this.searchOptions;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public Double getTopP() {
        return this.topP;
    }

    public ChatOptions copy() {
        return DashScopeChatOptions.fromOptions(this);
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public List<Object> getStop() {
        return this.stop;
    }

    public void setStop(List<Object> stop) {
        this.stop = stop;
    }

    public DashScopeResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(DashScopeResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Boolean getEnableSearch() {
        return this.enableSearch;
    }

    public void setEnableSearch(Boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public Double getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public void setRepetitionPenalty(Double repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    public List<DashScopeApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<DashScopeApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public Boolean getIncrementalOutput() {
        return this.incrementalOutput;
    }

    public void setIncrementalOutput(Boolean incrementalOutput) {
        this.incrementalOutput = incrementalOutput;
    }

    public Boolean getVlHighResolutionImages() {
        return this.vlHighResolutionImages;
    }

    public void setVlHighResolutionImages(Boolean vlHighResolutionImages) {
        this.vlHighResolutionImages = vlHighResolutionImages;
    }

    public Boolean getEnableThinking() {
        return this.enableThinking;
    }

    public void setEnableThinking(Boolean enableThinking) {
        this.enableThinking = enableThinking;
    }

    public Boolean getMultiModel() {
        return this.multiModel;
    }

    public void setMultiModel(Boolean multiModel) {
        this.multiModel = multiModel;
    }

    public static DashscopeChatOptionsBuilder builder() {
        return new DashscopeChatOptionsBuilder();
    }

    public static DashScopeChatOptions fromOptions(DashScopeChatOptions fromOptions) {
        return DashScopeChatOptions.builder().withModel(fromOptions.getModel()).withTemperature(fromOptions.getTemperature()).withMaxToken(fromOptions.getMaxTokens()).withTopP(fromOptions.getTopP()).withTopK(fromOptions.getTopK()).withSeed(fromOptions.getSeed()).withStop(fromOptions.getStop()).withResponseFormat(fromOptions.getResponseFormat()).withStream(fromOptions.getStream()).withEnableSearch(fromOptions.enableSearch).withIncrementalOutput(fromOptions.getIncrementalOutput()).withToolCallbacks(fromOptions.getToolCallbacks()).withToolNames(fromOptions.getToolNames()).withInternalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).withRepetitionPenalty(fromOptions.getRepetitionPenalty()).withTools(fromOptions.getTools()).withToolContext(fromOptions.getToolContext()).withMultiModel(fromOptions.getMultiModel()).withVlHighResolutionImages(fromOptions.getVlHighResolutionImages()).withEnableThinking(fromOptions.getEnableThinking()).withParallelToolCalls(fromOptions.getParallelToolCalls()).withSearchOptions(fromOptions.getSearchOptions()).withHttpHeaders(fromOptions.getHttpHeaders()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashScopeChatOptions that = (DashScopeChatOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.stream, that.stream) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.seed, that.seed) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.stop, that.stop) && Objects.equals(this.enableSearch, that.enableSearch) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.incrementalOutput, that.incrementalOutput) && Objects.equals(this.repetitionPenalty, that.repetitionPenalty) && Objects.equals(this.tools, that.tools) && Objects.equals(this.toolChoice, that.toolChoice) && Objects.equals(this.vlHighResolutionImages, that.vlHighResolutionImages) && Objects.equals(this.enableThinking, that.enableThinking) && Objects.equals(this.toolCallbacks, that.toolCallbacks) && Objects.equals(this.toolNames, that.toolNames) && Objects.equals(this.internalToolExecutionEnabled, that.internalToolExecutionEnabled) && Objects.equals(this.multiModel, that.multiModel) && Objects.equals(this.searchOptions, that.searchOptions) && Objects.equals(this.parallelToolCalls, that.parallelToolCalls) && Objects.equals(this.httpHeaders, that.httpHeaders) && Objects.equals(this.toolContext, that.toolContext);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.stream, this.temperature, this.seed, this.topP, this.topK, this.stop, this.enableSearch, this.responseFormat, this.incrementalOutput, this.repetitionPenalty, this.tools, this.toolChoice, this.vlHighResolutionImages, this.enableThinking, this.toolCallbacks, this.toolNames, this.internalToolExecutionEnabled, this.multiModel, this.searchOptions, this.parallelToolCalls, this.httpHeaders, this.toolContext);
    }

    public String toString() {
        return "DashScopeChatOptions: " + ModelOptionsUtils.toJsonString((Object)this);
    }

    public static class DashscopeChatOptionsBuilder {
        private DashScopeChatOptions options = new DashScopeChatOptions();

        public DashscopeChatOptionsBuilder withModel(String model) {
            this.options.model = model;
            return this;
        }

        public DashscopeChatOptionsBuilder withSearchOptions(DashScopeApi.SearchOptions searchOptions) {
            this.options.searchOptions = searchOptions;
            return this;
        }

        public DashscopeChatOptionsBuilder withParallelToolCalls(Boolean parallelToolCalls) {
            this.options.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public DashscopeChatOptionsBuilder withHttpHeaders(Map<String, String> httpHeaders) {
            this.options.httpHeaders = httpHeaders;
            return this;
        }

        public DashscopeChatOptionsBuilder withMaxToken(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public DashscopeChatOptionsBuilder withTemperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public DashscopeChatOptionsBuilder withTopP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public DashscopeChatOptionsBuilder withTopK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public DashscopeChatOptionsBuilder withStop(List<Object> stop) {
            this.options.stop = stop;
            return this;
        }

        public DashscopeChatOptionsBuilder withResponseFormat(DashScopeResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public DashscopeChatOptionsBuilder withEnableSearch(Boolean enableSearch) {
            this.options.enableSearch = enableSearch;
            return this;
        }

        public DashscopeChatOptionsBuilder withRepetitionPenalty(Double repetitionPenalty) {
            this.options.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public DashscopeChatOptionsBuilder withTools(List<DashScopeApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public DashscopeChatOptionsBuilder withToolChoice(Object toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public DashscopeChatOptionsBuilder withStream(Boolean stream) {
            this.options.stream = stream;
            return this;
        }

        public DashscopeChatOptionsBuilder withToolCallbacks(List<ToolCallback> toolCallbacks) {
            Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
            this.options.toolCallbacks = toolCallbacks;
            return this;
        }

        public DashscopeChatOptionsBuilder withToolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
            toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
            this.options.toolNames = toolNames;
            return this;
        }

        public DashscopeChatOptionsBuilder withToolName(String toolName) {
            Assert.hasText((String)toolName, (String)"Tool name must not be empty");
            this.options.toolNames.add(toolName);
            return this;
        }

        public DashscopeChatOptionsBuilder withInternalToolExecutionEnabled(Boolean internalToolExecutionEnabled) {
            this.options.internalToolExecutionEnabled = internalToolExecutionEnabled;
            return this;
        }

        public DashscopeChatOptionsBuilder withSeed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        public DashscopeChatOptionsBuilder withIncrementalOutput(Boolean incrementalOutput) {
            this.options.incrementalOutput = incrementalOutput;
            return this;
        }

        public DashscopeChatOptionsBuilder withToolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public DashscopeChatOptionsBuilder withVlHighResolutionImages(Boolean vlHighResolutionImages) {
            this.options.vlHighResolutionImages = vlHighResolutionImages;
            return this;
        }

        public DashscopeChatOptionsBuilder withEnableThinking(Boolean enableThinking) {
            this.options.enableThinking = enableThinking;
            return this;
        }

        public DashscopeChatOptionsBuilder withMultiModel(Boolean multiModel) {
            this.options.multiModel = multiModel;
            return this;
        }

        public DashScopeChatOptions build() {
            return this.options;
        }
    }
}

