/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent;

import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import java.util.UUID;

public class TokenCacheNode {
    private Long tokenId;
    private Long clientTimeout;
    private Long resourceTimeout;
    private Long flowId;
    private int acquireCount;
    private String clientAddress;

    public static TokenCacheNode generateTokenCacheNode(FlowRule rule, int acquireCount, String clientAddress) {
        TokenCacheNode node = new TokenCacheNode();
        node.setTokenId(UUID.randomUUID().getMostSignificantBits());
        node.setFlowId(rule.getClusterConfig().getFlowId());
        node.setClientTimeout(rule.getClusterConfig().getClientOfflineTime());
        node.setResourceTimeout(rule.getClusterConfig().getResourceTimeout());
        node.setAcquireCount(acquireCount);
        node.setClientAddress(clientAddress);
        return node;
    }

    public Long getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(Long tokenId) {
        this.tokenId = tokenId;
    }

    public Long getClientTimeout() {
        return this.clientTimeout;
    }

    public void setClientTimeout(Long clientTimeout) {
        this.clientTimeout = clientTimeout + System.currentTimeMillis();
    }

    public Long getResourceTimeout() {
        return this.resourceTimeout;
    }

    public void setResourceTimeout(Long resourceTimeout) {
        this.resourceTimeout = resourceTimeout + System.currentTimeMillis();
    }

    public Long getFlowId() {
        return this.flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public int getAcquireCount() {
        return this.acquireCount;
    }

    public void setAcquireCount(int acquireCount) {
        this.acquireCount = acquireCount;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public String toString() {
        return "TokenCacheNode{tokenId=" + this.tokenId + ", clientTimeout=" + this.clientTimeout + ", resourceTimeout=" + this.resourceTimeout + ", flowId=" + this.flowId + ", acquireCount=" + this.acquireCount + ", clientAddress='" + this.clientAddress + '\'' + '}';
    }
}

