/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.metric.extension.MetricExtension;
import com.alibaba.csp.sentinel.metric.extension.MetricExtensionProvider;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.AssertUtil;

public class Tracer {
    protected static Class<? extends Throwable>[] traceClasses;
    protected static Class<? extends Throwable>[] ignoreClasses;

    protected Tracer() {
    }

    public static void trace(Throwable e) {
        Tracer.trace(e, 1);
    }

    public static void trace(Throwable e, int count) {
        if (!Tracer.shouldTrace(e)) {
            return;
        }
        Context context = ContextUtil.getContext();
        if (context == null) {
            return;
        }
        DefaultNode curNode = (DefaultNode)context.getCurNode();
        Tracer.traceExceptionToNode(e, count, context.getCurEntry(), curNode);
    }

    public static void traceContext(Throwable e, int count, Context context) {
        if (!Tracer.shouldTrace(e)) {
            return;
        }
        if (context == null) {
            return;
        }
        DefaultNode curNode = (DefaultNode)context.getCurNode();
        Tracer.traceExceptionToNode(e, count, context.getCurEntry(), curNode);
    }

    public static void traceEntry(Throwable e, Entry entry) {
        Tracer.traceEntry(e, 1, entry);
    }

    public static void traceEntry(Throwable e, int count, Entry entry) {
        if (!Tracer.shouldTrace(e)) {
            return;
        }
        if (entry == null || entry.getCurNode() == null) {
            return;
        }
        DefaultNode curNode = (DefaultNode)entry.getCurNode();
        Tracer.traceExceptionToNode(e, count, entry, curNode);
    }

    private static void traceExceptionToNode(Throwable t, int count, Entry entry, DefaultNode curNode) {
        if (curNode == null) {
            return;
        }
        for (MetricExtension m : MetricExtensionProvider.getMetricExtensions()) {
            m.addException(entry.getResourceWrapper().getName(), count, t);
        }
        ClusterNode clusterNode = curNode.getClusterNode();
        if (clusterNode == null) {
            return;
        }
        clusterNode.trace(t, count);
    }

    @SafeVarargs
    public static void setExceptionsToTrace(Class<? extends Throwable> ... traceClasses) {
        Tracer.checkNotNull(traceClasses);
        Tracer.traceClasses = traceClasses;
    }

    public static Class<? extends Throwable>[] getExceptionsToTrace() {
        return traceClasses;
    }

    @SafeVarargs
    public static void setExceptionsToIgnore(Class<? extends Throwable> ... ignoreClasses) {
        Tracer.checkNotNull(ignoreClasses);
        Tracer.ignoreClasses = ignoreClasses;
    }

    public static Class<? extends Throwable>[] getExceptionsToIgnore() {
        return ignoreClasses;
    }

    private static void checkNotNull(Class<? extends Throwable>[] classes) {
        AssertUtil.notNull(classes, "trace or ignore classes must not be null");
        for (Class<? extends Throwable> clazz : classes) {
            AssertUtil.notNull(clazz, "trace or ignore classes must not be null");
        }
    }

    protected static boolean shouldTrace(Throwable t) {
        if (t == null || t instanceof BlockException) {
            return false;
        }
        if (ignoreClasses != null) {
            for (Class<? extends Throwable> clazz : ignoreClasses) {
                if (clazz == null || !clazz.isAssignableFrom(t.getClass())) continue;
                return false;
            }
        }
        if (traceClasses != null) {
            for (Class<? extends Throwable> clazz : traceClasses) {
                if (clazz == null || !clazz.isAssignableFrom(t.getClass())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

