/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandHandlerInterceptor;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandRequestExecution;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class InterceptingCommandHandler<R>
implements CommandHandler<R> {
    private final CommandHandler<R> delegate;
    private final List<CommandHandlerInterceptor<R>> commandHandlerInterceptors;

    public InterceptingCommandHandler(CommandHandler<R> delegate, List<CommandHandlerInterceptor<R>> commandHandlerInterceptors) {
        AssertUtil.notNull(delegate, (String)"delegate cannot be null");
        AssertUtil.notNull(commandHandlerInterceptors, (String)"commandHandlerInterceptors cannot be null");
        this.delegate = delegate;
        this.commandHandlerInterceptors = commandHandlerInterceptors;
    }

    @Override
    public CommandResponse<R> handle(CommandRequest request) {
        return new InterceptingRequestExecution<R>(this.commandHandlerInterceptors.iterator(), this.delegate::handle).execute(request);
    }

    private static class InterceptingRequestExecution<R>
    implements CommandRequestExecution<R> {
        private final Iterator<CommandHandlerInterceptor<R>> iterator;
        private final Function<CommandRequest, CommandResponse<R>> commandResponseFunction;

        public InterceptingRequestExecution(Iterator<CommandHandlerInterceptor<R>> iterator, Function<CommandRequest, CommandResponse<R>> commandResponseFunction) {
            this.iterator = iterator;
            this.commandResponseFunction = commandResponseFunction;
        }

        @Override
        public CommandResponse<R> execute(CommandRequest request) {
            if (this.iterator.hasNext()) {
                CommandHandlerInterceptor<R> nextInterceptor = this.iterator.next();
                return nextInterceptor.intercept(request, this);
            }
            return this.commandResponseFunction.apply(request);
        }
    }
}

