package com.alibaba.fastjson2;

import com.alibaba.fastjson2.util.JDKUtils;

import static com.alibaba.fastjson2.JSONWriter.Feature.*;
import static com.alibaba.fastjson2.util.JDKUtils.UNSAFE;

public final class JSONWriterUTF16JDK8UF
        extends JSONWriterUTF16 {
    JSONWriterUTF16JDK8UF(Context ctx) {
        super(ctx);
    }

    @Override
    public void writeString(String str) {
        if (str == null) {
            writeStringNull();
            return;
        }

        boolean browserSecure = (context.features & BrowserSecure.mask) != 0;
        boolean escapeNoneAscii = (context.features & EscapeNoneAscii.mask) != 0;
        char[] value = (char[]) UNSAFE.getObject(str, JDKUtils.FIELD_STRING_VALUE_OFFSET);
        final int strlen = value.length;

        boolean escape = false;
        for (int i = 0; i < value.length; i++) {
            char ch = value[i];
            if (ch == quote || ch == '\\' || ch < ' '
                    || (browserSecure && (ch == '<' || ch == '>' || ch == '(' || ch == ')'))
                    || (escapeNoneAscii && ch > 0x007F)
            ) {
                escape = true;
                break;
            }
        }

        if (!escape) {
            int off = this.off;
            // inline ensureCapacity(off + strlen + 2);
            int minCapacity = off + strlen + 2;
            if (minCapacity >= chars.length) {
                ensureCapacity(minCapacity);
            }

            final char[] chars = this.chars;
            chars[off++] = quote;
            System.arraycopy(value, 0, chars, off, value.length);
            off += strlen;
            chars[off] = quote;
            this.off = off + 1;
            return;
        }

        writeStringEscape(str);
    }
}
