/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplList;
import com.alibaba.fastjson2.writer.ObjectWriterImplListEnum;
import com.alibaba.fastjson2.writer.ObjectWriterImplListStr;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class FieldWriterList<T>
extends FieldWriter<T> {
    private static final Class<?> EMPTY_LIST_CLASS = Collections.emptyList().getClass();
    private static final Class<?> EMPTY_SET_CLASS = Collections.emptySet().getClass();
    final Type itemType;
    final Class itemClass;
    final boolean itemClassNotReferenceDetect;
    ObjectWriter listWriter;
    ObjectWriter itemObjectWriter;
    final boolean writeAsString;
    final Class<?> contentAs;

    FieldWriterList(String name, Type itemType, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field, Method method, Class<?> contentAs) {
        super(name, ordinal, features, format, null, label, fieldType, fieldClass, field, method);
        this.contentAs = contentAs;
        this.writeAsString = (features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        Object object = this.itemType = itemType == null ? Object.class : itemType;
        if (this.itemType instanceof Class) {
            this.itemClass = (Class)itemType;
            if (this.itemClass != null) {
                this.listWriter = Enum.class.isAssignableFrom(this.itemClass) ? new ObjectWriterImplListEnum(fieldClass, this.itemClass, features) : (this.itemClass == String.class ? ObjectWriterImplListStr.INSTANCE : new ObjectWriterImplList(fieldClass, fieldType, this.itemClass, itemType, features));
            }
        } else {
            this.itemClass = TypeUtils.getMapping(itemType);
        }
        boolean bl = this.itemClassNotReferenceDetect = this.itemClass != null && ObjectWriterProvider.isNotReferenceDetect(this.itemClass);
        if (format != null && this.itemClass == Date.class) {
            this.itemObjectWriter = new ObjectWriterImplDate(format, null);
        }
    }

    @Override
    public final Type getItemType() {
        return this.itemType;
    }

    @Override
    public final Class getItemClass() {
        return this.itemClass;
    }

    @Override
    public final ObjectWriter getItemWriter(JSONWriter jsonWriter, Type itemType) {
        if (this.contentAs != null) {
            ObjectWriter itemObjectWriter = this.itemObjectWriter;
            if (itemObjectWriter != null) {
                return itemObjectWriter;
            }
            this.itemObjectWriter = jsonWriter.getObjectWriter(this.contentAs, this.contentAs);
            return this.itemObjectWriter;
        }
        if (itemType == null || itemType == this.itemType) {
            if (this.itemObjectWriter != null) {
                return this.itemObjectWriter;
            }
            if (this.format != null) {
                return jsonWriter.getContext().getProvider().getObjectWriter(itemType, this.format, null);
            }
            this.itemObjectWriter = jsonWriter.getObjectWriter(this.itemType, this.itemClass);
            return this.itemObjectWriter;
        }
        return jsonWriter.getObjectWriter(itemType, TypeUtils.getClass(itemType));
    }

    @Override
    public final ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        ObjectWriter listWriter = this.listWriter;
        if (listWriter != null && this.fieldClass.isAssignableFrom(valueClass)) {
            return listWriter;
        }
        if (listWriter == null && valueClass == this.fieldClass) {
            this.listWriter = jsonWriter.getObjectWriter(valueClass);
            return this.listWriter;
        }
        return jsonWriter.getObjectWriter(valueClass);
    }

    @Override
    public void writeListValueJSONB(JSONWriter jsonWriter, List list) {
        boolean refDetect;
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        long features = jsonWriter.getFeatures(this.features);
        boolean beanToArray = (features & JSONWriter.Feature.BeanToArray.mask) != 0L;
        int size = list.size();
        boolean bl = refDetect = (features & JSONWriter.Feature.ReferenceDetection.mask) != 0L;
        if (jsonWriter.isWriteTypeInfo((Object)list, this.fieldClass)) {
            jsonWriter.writeTypeName(TypeUtils.getTypeName(list.getClass()));
        }
        jsonWriter.startArray(size);
        for (int i = 0; i < size; ++i) {
            Object item = list.get(i);
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass != previousClass) {
                refDetect = jsonWriter.isRefDetect();
                previousObjectWriter = itemClass == this.itemType && this.itemObjectWriter != null ? this.itemObjectWriter : this.getItemWriter(jsonWriter, itemClass);
                previousClass = itemClass;
                if (refDetect) {
                    refDetect = itemClass == this.itemClass ? !this.itemClassNotReferenceDetect : !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                }
            }
            ObjectWriter itemObjectWriter = previousObjectWriter;
            if (refDetect && jsonWriter.writeReference(i, item)) continue;
            if (beanToArray) {
                itemObjectWriter.writeArrayMappingJSONB(jsonWriter, item, i, this.itemType, features);
            } else {
                itemObjectWriter.writeJSONB(jsonWriter, item, i, this.itemType, features);
            }
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
    }

    @Override
    public final void writeListValue(JSONWriter jsonWriter, List list) {
        if (jsonWriter.jsonb) {
            this.writeListValueJSONB(jsonWriter, list);
            return;
        }
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        long features = jsonWriter.getFeatures(this.features);
        boolean previousItemRefDetect = (features & JSONWriter.Feature.ReferenceDetection.mask) != 0L;
        jsonWriter.startArray();
        for (int i = 0; i < list.size(); ++i) {
            boolean itemRefDetect;
            ObjectWriter itemObjectWriter;
            Object item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = list.get(i)) == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == String.class) {
                jsonWriter.writeString((String)item);
                continue;
            }
            if (this.writeAsString) {
                jsonWriter.writeString(item.toString());
                continue;
            }
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
                itemRefDetect = previousItemRefDetect;
            } else {
                itemRefDetect = (features & JSONWriter.Feature.ReferenceDetection.mask) != 0L;
                itemObjectWriter = this.getItemWriter(jsonWriter, itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
                if (itemRefDetect) {
                    itemRefDetect = !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                }
                previousItemRefDetect = itemRefDetect;
            }
            if (itemRefDetect && jsonWriter.writeReference(i, item)) continue;
            if (this.managedReference) {
                jsonWriter.addManagerReference(item);
            }
            itemObjectWriter.write(jsonWriter, item, null, this.itemType, features);
            if (!itemRefDetect) continue;
            jsonWriter.popPath(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public final void writeListJSONB(JSONWriter jsonWriter, List list) {
        boolean refDetect;
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        long features = jsonWriter.getFeatures(this.features);
        boolean beanToArray = (features & JSONWriter.Feature.BeanToArray.mask) != 0L;
        int size = list.size();
        if ((features & JSONWriter.Feature.NotWriteEmptyArray.mask) != 0L && size == 0) {
            return;
        }
        this.writeFieldName(jsonWriter);
        boolean bl = refDetect = (features & JSONWriter.Feature.ReferenceDetection.mask) != 0L;
        if (jsonWriter.isWriteTypeInfo((Object)list, this.fieldClass)) {
            jsonWriter.writeTypeName(TypeUtils.getTypeName(list.getClass()));
        }
        jsonWriter.startArray(size);
        for (int i = 0; i < size; ++i) {
            Object item = list.get(i);
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass != previousClass) {
                refDetect = jsonWriter.isRefDetect();
                previousObjectWriter = itemClass == this.itemType && this.itemObjectWriter != null ? this.itemObjectWriter : this.getItemWriter(jsonWriter, itemClass);
                previousClass = itemClass;
                if (refDetect) {
                    refDetect = itemClass == this.itemClass ? !this.itemClassNotReferenceDetect : !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                }
            }
            ObjectWriter itemObjectWriter = previousObjectWriter;
            if (refDetect && jsonWriter.writeReference(i, item)) continue;
            if (beanToArray) {
                itemObjectWriter.writeArrayMappingJSONB(jsonWriter, item, i, this.itemType, features);
            } else {
                itemObjectWriter.writeJSONB(jsonWriter, item, i, this.itemType, features);
            }
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
    }

    @Override
    public final void writeList(JSONWriter jsonWriter, List list) {
        if (jsonWriter.jsonb) {
            this.writeListJSONB(jsonWriter, list);
            return;
        }
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        long features = jsonWriter.getFeatures(this.features);
        if ((features & JSONWriter.Feature.NotWriteEmptyArray.mask) != 0L && list.isEmpty()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        boolean previousItemRefDetect = (features & JSONWriter.Feature.ReferenceDetection.mask) != 0L;
        jsonWriter.startArray();
        for (int i = 0; i < list.size(); ++i) {
            boolean itemRefDetect;
            ObjectWriter itemObjectWriter;
            Object item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = list.get(i)) == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == String.class) {
                jsonWriter.writeString((String)item);
                continue;
            }
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
                itemRefDetect = previousItemRefDetect;
            } else {
                itemRefDetect = jsonWriter.isRefDetect();
                itemObjectWriter = this.getItemWriter(jsonWriter, itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
                if (itemRefDetect) {
                    itemRefDetect = !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                }
                previousItemRefDetect = itemRefDetect;
            }
            if (itemRefDetect) {
                if (jsonWriter.writeReference(i, item)) {
                    continue;
                }
            } else if (this.managedReference) {
                jsonWriter.addManagerReference(item);
            }
            itemObjectWriter.write(jsonWriter, item, null, this.itemType, features);
            if (!itemRefDetect) continue;
            jsonWriter.popPath(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public final void writeListStr(JSONWriter jsonWriter, boolean writeFieldName, List<String> list) {
        if (writeFieldName) {
            this.writeFieldName(jsonWriter);
        }
        if (jsonWriter.jsonb && jsonWriter.isWriteTypeInfo(list, this.fieldClass)) {
            jsonWriter.writeTypeName(TypeUtils.getTypeName(list.getClass()));
        }
        jsonWriter.writeString(list);
    }

    @Override
    public final boolean isRefDetect(Object object, long features) {
        Class<?> objectClass;
        return ((features |= this.features) & JSONWriter.Feature.ReferenceDetection.mask) != 0L && (features & 0x200000000000000L) == 0L && object != null && (objectClass = object.getClass()) != EMPTY_LIST_CLASS && objectClass != EMPTY_SET_CLASS;
    }
}

