/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/monitored_resource.proto

package com.aliyun.openservices.ons.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * An object that describes the schema of a [MonitoredResource][google.api.MonitoredResource] object using a
 * type name and a set of labels.  For example, the monitored resource
 * descriptor for Google Compute Engine VM instances has a type of
 * `"gce_instance"` and specifies the use of the labels `"instance_id"` and
 * `"zone"` to identify particular VM instances.
 * Different services can support different monitored resource types.
 * The following are specific rules to service defined monitored resources for
 * Monitoring and Logging:
 * * The `type`, `display_name`, `description`, `labels` and `launch_stage`
 *   fields are all required.
 * * The first label of the monitored resource descriptor must be
 *   `resource_container`. There are legacy monitored resource descritptors
 *   start with `project_id`.
 * * It must include a `location` label.
 * * Maximum of default 5 service defined monitored resource descriptors
 *   is allowed per service.
 * * Maximum of default 10 labels per monitored resource is allowed.
 * The default maximum limit can be overridden. Please follow
 * https://cloud.google.com/monitoring/quotas
 * </pre>
 *
 * Protobuf type {@code google.api.MonitoredResourceDescriptor}
 */
public final class MonitoredResourceDescriptor extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.MonitoredResourceDescriptor)
    MonitoredResourceDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MonitoredResourceDescriptor.newBuilder() to construct.
  private MonitoredResourceDescriptor(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MonitoredResourceDescriptor() {
    name_ = "";
    type_ = "";
    displayName_ = "";
    description_ = "";
    labels_ = java.util.Collections.emptyList();
    launchStage_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MonitoredResourceDescriptor();
  }

  @java.lang.Override
  public final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private MonitoredResourceDescriptor(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              type_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor>();
                mutable_bitField0_ |= 0x00000001;
              }
              labels_.add(
                  input.readMessage(com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.parser(), extensionRegistry));
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              launchStage_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        labels_ = java.util.Collections.unmodifiableList(labels_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceProto
        .internal_static_google_api_MonitoredResourceDescriptor_descriptor;
  }

  @java.lang.Override
  protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceProto
        .internal_static_google_api_MonitoredResourceDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor.class,
            com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 5;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the monitored resource descriptor:
   * `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
   * {type} is the value of the `type` field in this object and
   * {project_id} is a project ID that provides API-specific context for
   * accessing the type.  APIs that do not use project information can use the
   * resource name format `"monitoredResourceDescriptors/{type}"`.
   * </pre>
   *
   * <code>string name = 5;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the monitored resource descriptor:
   * `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
   * {type} is the value of the `type` field in this object and
   * {project_id} is a project ID that provides API-specific context for
   * accessing the type.  APIs that do not use project information can use the
   * resource name format `"monitoredResourceDescriptors/{type}"`.
   * </pre>
   *
   * <code>string name = 5;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object type_;
  /**
   *
   *
   * <pre>
   * Required. The monitored resource type. For example, the type
   * `cloudsql_database` represents databases in Google Cloud SQL.
   * All service defined monitored resource types must be prefixed with the
   * service name, in the format of `{service name}/{relative resource name}`.
   * The relative resource name must follow:
   * * Only upper and lower-case letters and digits are allowed.
   * * It must start with upper case character and is recommended to use Upper
   *   Camel Case style.
   * * The maximum number of characters allowed for the relative_resource_name
   *   is 100.
   * Note there are legacy service monitored resources not following this rule.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The monitored resource type. For example, the type
   * `cloudsql_database` represents databases in Google Cloud SQL.
   * All service defined monitored resource types must be prefixed with the
   * service name, in the format of `{service name}/{relative resource name}`.
   * The relative resource name must follow:
   * * Only upper and lower-case letters and digits are allowed.
   * * It must start with upper case character and is recommended to use Upper
   *   Camel Case style.
   * * The maximum number of characters allowed for the relative_resource_name
   *   is 100.
   * Note there are legacy service monitored resources not following this rule.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Optional. A concise name for the monitored resource type that might be
   * displayed in user interfaces. It should be a Title Cased Noun Phrase,
   * without any article or other determiners. For example,
   * `"Google Cloud SQL Database"`.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A concise name for the monitored resource type that might be
   * displayed in user interfaces. It should be a Title Cased Noun Phrase,
   * without any article or other determiners. For example,
   * `"Google Cloud SQL Database"`.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Optional. A detailed description of the monitored resource type that might
   * be used in documentation.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A detailed description of the monitored resource type that might
   * be used in documentation.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
          com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 4;
  private java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> labels_;
  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> getLabelsList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>
      getLabelsOrBuilderList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public int getLabelsCount() {
    return labels_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor getLabels(int index) {
    return labels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. A set of labels used to describe instances of this monitored
   * resource type.
   * The label key name must follow:
   * * Only upper and lower-case letters, digits and underscores (_) are
   *   allowed.
   * * Label name must start with a letter or digit.
   * * The maximum length of a label name is 100 characters.
   * For example, an individual Google Cloud SQL database is
   * identified by values for the labels `database_id` and `location`.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
    return labels_.get(index);
  }

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 7;
  private int launchStage_;
  /**
   *
   *
   * <pre>
   * Optional. The launch stage of the monitored resource definition.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 7;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The launch stage of the monitored resource definition.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 7;</code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage getLaunchStage() {
    @SuppressWarnings("deprecation")
    com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage result = com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage.valueOf(launchStage_);
    return result == null ? com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getTypeBytes().isEmpty()) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      output.writeMessage(4, labels_.get(i));
    }
    if (!getNameBytes().isEmpty()) {
      com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 5, name_);
    }
    if (launchStage_ != com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, launchStage_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getTypeBytes().isEmpty()) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels_.get(i));
    }
    if (!getNameBytes().isEmpty()) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(5, name_);
    }
    if (launchStage_ != com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      size += com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedOutputStream.computeEnumSize(7, launchStage_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor)) {
      return super.equals(obj);
    }
    com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor other =
        (com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getLabelsList().equals(other.getLabelsList())) return false;
    if (launchStage_ != other.launchStage_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getLabelsCount() > 0) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelsList().hashCode();
    }
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(java.nio.ByteBuffer data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(
      java.nio.ByteBuffer data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString data,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(byte[] data)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(
      byte[] data, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseDelimitedFrom(
      java.io.InputStream input, com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parseFrom(
      com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
      com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An object that describes the schema of a [MonitoredResource][google.api.MonitoredResource] object using a
   * type name and a set of labels.  For example, the monitored resource
   * descriptor for Google Compute Engine VM instances has a type of
   * `"gce_instance"` and specifies the use of the labels `"instance_id"` and
   * `"zone"` to identify particular VM instances.
   * Different services can support different monitored resource types.
   * The following are specific rules to service defined monitored resources for
   * Monitoring and Logging:
   * * The `type`, `display_name`, `description`, `labels` and `launch_stage`
   *   fields are all required.
   * * The first label of the monitored resource descriptor must be
   *   `resource_container`. There are legacy monitored resource descritptors
   *   start with `project_id`.
   * * It must include a `location` label.
   * * Maximum of default 5 service defined monitored resource descriptors
   *   is allowed per service.
   * * Maximum of default 10 labels per monitored resource is allowed.
   * The default maximum limit can be overridden. Please follow
   * https://cloud.google.com/monitoring/quotas
   * </pre>
   *
   * Protobuf type {@code google.api.MonitoredResourceDescriptor}
   */
  public static final class Builder extends com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.MonitoredResourceDescriptor)
      com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptorOrBuilder {
    public static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceProto
          .internal_static_google_api_MonitoredResourceDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceProto
          .internal_static_google_api_MonitoredResourceDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor.class,
              com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor.Builder.class);
    }

    // Construct using com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLabelsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      type_ = "";

      displayName_ = "";

      description_ = "";

      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        labelsBuilder_.clear();
      }
      launchStage_ = 0;

      return this;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceProto
          .internal_static_google_api_MonitoredResourceDescriptor_descriptor;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor getDefaultInstanceForType() {
      return com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor build() {
      com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor buildPartial() {
      com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor result =
          new com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.type_ = type_;
      result.displayName_ = displayName_;
      result.description_ = description_;
      if (labelsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          labels_ = java.util.Collections.unmodifiableList(labels_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.labels_ = labels_;
      } else {
        result.labels_ = labelsBuilder_.build();
      }
      result.launchStage_ = launchStage_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.protobuf.Message other) {
      if (other instanceof com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor) {
        return mergeFrom((com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor other) {
      if (other == com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (labelsBuilder_ == null) {
        if (!other.labels_.isEmpty()) {
          if (labels_.isEmpty()) {
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLabelsIsMutable();
            labels_.addAll(other.labels_);
          }
          onChanged();
        }
      } else {
        if (!other.labels_.isEmpty()) {
          if (labelsBuilder_.isEmpty()) {
            labelsBuilder_.dispose();
            labelsBuilder_ = null;
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000001);
            labelsBuilder_ =
                com.aliyun.openservices.ons.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelsFieldBuilder()
                    : null;
          } else {
            labelsBuilder_.addAllMessages(other.labels_);
          }
        }
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the monitored resource descriptor:
     * `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
     * {type} is the value of the `type` field in this object and
     * {project_id} is a project ID that provides API-specific context for
     * accessing the type.  APIs that do not use project information can use the
     * resource name format `"monitoredResourceDescriptors/{type}"`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the monitored resource descriptor:
     * `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
     * {type} is the value of the `type` field in this object and
     * {project_id} is a project ID that provides API-specific context for
     * accessing the type.  APIs that do not use project information can use the
     * resource name format `"monitoredResourceDescriptors/{type}"`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @return The bytes for name.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the monitored resource descriptor:
     * `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
     * {type} is the value of the `type` field in this object and
     * {project_id} is a project ID that provides API-specific context for
     * accessing the type.  APIs that do not use project information can use the
     * resource name format `"monitoredResourceDescriptors/{type}"`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the monitored resource descriptor:
     * `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
     * {type} is the value of the `type` field in this object and
     * {project_id} is a project ID that provides API-specific context for
     * accessing the type.  APIs that do not use project information can use the
     * resource name format `"monitoredResourceDescriptors/{type}"`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the monitored resource descriptor:
     * `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
     * {type} is the value of the `type` field in this object and
     * {project_id} is a project ID that provides API-specific context for
     * accessing the type.  APIs that do not use project information can use the
     * resource name format `"monitoredResourceDescriptors/{type}"`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Required. The monitored resource type. For example, the type
     * `cloudsql_database` represents databases in Google Cloud SQL.
     * All service defined monitored resource types must be prefixed with the
     * service name, in the format of `{service name}/{relative resource name}`.
     * The relative resource name must follow:
     * * Only upper and lower-case letters and digits are allowed.
     * * It must start with upper case character and is recommended to use Upper
     *   Camel Case style.
     * * The maximum number of characters allowed for the relative_resource_name
     *   is 100.
     * Note there are legacy service monitored resources not following this rule.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource type. For example, the type
     * `cloudsql_database` represents databases in Google Cloud SQL.
     * All service defined monitored resource types must be prefixed with the
     * service name, in the format of `{service name}/{relative resource name}`.
     * The relative resource name must follow:
     * * Only upper and lower-case letters and digits are allowed.
     * * It must start with upper case character and is recommended to use Upper
     *   Camel Case style.
     * * The maximum number of characters allowed for the relative_resource_name
     *   is 100.
     * Note there are legacy service monitored resources not following this rule.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource type. For example, the type
     * `cloudsql_database` represents databases in Google Cloud SQL.
     * All service defined monitored resource types must be prefixed with the
     * service name, in the format of `{service name}/{relative resource name}`.
     * The relative resource name must follow:
     * * Only upper and lower-case letters and digits are allowed.
     * * It must start with upper case character and is recommended to use Upper
     *   Camel Case style.
     * * The maximum number of characters allowed for the relative_resource_name
     *   is 100.
     * Note there are legacy service monitored resources not following this rule.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource type. For example, the type
     * `cloudsql_database` represents databases in Google Cloud SQL.
     * All service defined monitored resource types must be prefixed with the
     * service name, in the format of `{service name}/{relative resource name}`.
     * The relative resource name must follow:
     * * Only upper and lower-case letters and digits are allowed.
     * * It must start with upper case character and is recommended to use Upper
     *   Camel Case style.
     * * The maximum number of characters allowed for the relative_resource_name
     *   is 100.
     * Note there are legacy service monitored resources not following this rule.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {

      type_ = getDefaultInstance().getType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource type. For example, the type
     * `cloudsql_database` represents databases in Google Cloud SQL.
     * All service defined monitored resource types must be prefixed with the
     * service name, in the format of `{service name}/{relative resource name}`.
     * The relative resource name must follow:
     * * Only upper and lower-case letters and digits are allowed.
     * * It must start with upper case character and is recommended to use Upper
     *   Camel Case style.
     * * The maximum number of characters allowed for the relative_resource_name
     *   is 100.
     * Note there are legacy service monitored resources not following this rule.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      type_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A concise name for the monitored resource type that might be
     * displayed in user interfaces. It should be a Title Cased Noun Phrase,
     * without any article or other determiners. For example,
     * `"Google Cloud SQL Database"`.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A concise name for the monitored resource type that might be
     * displayed in user interfaces. It should be a Title Cased Noun Phrase,
     * without any article or other determiners. For example,
     * `"Google Cloud SQL Database"`.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A concise name for the monitored resource type that might be
     * displayed in user interfaces. It should be a Title Cased Noun Phrase,
     * without any article or other determiners. For example,
     * `"Google Cloud SQL Database"`.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A concise name for the monitored resource type that might be
     * displayed in user interfaces. It should be a Title Cased Noun Phrase,
     * without any article or other determiners. For example,
     * `"Google Cloud SQL Database"`.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A concise name for the monitored resource type that might be
     * displayed in user interfaces. It should be a Title Cased Noun Phrase,
     * without any article or other determiners. For example,
     * `"Google Cloud SQL Database"`.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A detailed description of the monitored resource type that might
     * be used in documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString bs = (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A detailed description of the monitored resource type that might
     * be used in documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString b =
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A detailed description of the monitored resource type that might
     * be used in documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A detailed description of the monitored resource type that might
     * be used in documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A detailed description of the monitored resource type that might
     * be used in documentation.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.aliyun.openservices.ons.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> labels_ =
        java.util.Collections.emptyList();

    private void ensureLabelsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        labels_ = new java.util.ArrayList<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor>(labels_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor,
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>
        labelsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> getLabelsList() {
      if (labelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labels_);
      } else {
        return labelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public int getLabelsCount() {
      if (labelsBuilder_ == null) {
        return labels_.size();
      } else {
        return labelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor getLabels(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder setLabels(int index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.set(index, value);
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder setLabels(int index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addLabels(com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addLabels(int index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(index, value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addLabels(com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addLabels(int index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder addAllLabels(
        java.lang.Iterable<? extends com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor> values) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labels_);
        onChanged();
      } else {
        labelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder clearLabels() {
      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        labelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public Builder removeLabels(int index) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.remove(index);
        onChanged();
      } else {
        labelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder getLabelsBuilder(int index) {
      return getLabelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public java.util.List<? extends com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>
        getLabelsOrBuilderList() {
      if (labelsBuilder_ != null) {
        return labelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labels_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder addLabelsBuilder() {
      return getLabelsFieldBuilder()
          .addBuilder(com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder addLabelsBuilder(int index) {
      return getLabelsFieldBuilder()
          .addBuilder(index, com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. A set of labels used to describe instances of this monitored
     * resource type.
     * The label key name must follow:
     * * Only upper and lower-case letters, digits and underscores (_) are
     *   allowed.
     * * Label name must start with a letter or digit.
     * * The maximum length of a label name is 100 characters.
     * For example, an individual Google Cloud SQL database is
     * identified by values for the labels `database_id` and `location`.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 4;</code>
     */
    public java.util.List<com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder> getLabelsBuilderList() {
      return getLabelsFieldBuilder().getBuilderList();
    }

    private com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor,
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder,
            com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>
        getLabelsFieldBuilder() {
      if (labelsBuilder_ == null) {
        labelsBuilder_ =
            new com.aliyun.openservices.ons.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
                com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor,
                com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptor.Builder,
                com.aliyun.openservices.ons.shaded.com.google.api.LabelDescriptorOrBuilder>(
                labels_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        labels_ = null;
      }
      return labelsBuilder_;
    }

    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the monitored resource definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the monitored resource definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {

      launchStage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the monitored resource definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage getLaunchStage() {
      @SuppressWarnings("deprecation")
      com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage result = com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage.valueOf(launchStage_);
      return result == null ? com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the monitored resource definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(com.aliyun.openservices.ons.shaded.com.google.api.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }

      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the monitored resource definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {

      launchStage_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.aliyun.openservices.ons.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.MonitoredResourceDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.api.MonitoredResourceDescriptor)
  private static final com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor();
  }

  public static com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<MonitoredResourceDescriptor> PARSER =
      new com.aliyun.openservices.ons.shaded.com.google.protobuf.AbstractParser<MonitoredResourceDescriptor>() {
        @java.lang.Override
        public MonitoredResourceDescriptor parsePartialFrom(
            com.aliyun.openservices.ons.shaded.com.google.protobuf.CodedInputStream input,
            com.aliyun.openservices.ons.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.aliyun.openservices.ons.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new MonitoredResourceDescriptor(input, extensionRegistry);
        }
      };

  public static com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<MonitoredResourceDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.protobuf.Parser<MonitoredResourceDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.aliyun.openservices.ons.shaded.com.google.api.MonitoredResourceDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
