/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Consumer;

/** Builder class for {@link LongValueObserver}. */
public interface LongValueObserverBuilder
    extends AsynchronousInstrumentBuilder<AsynchronousInstrument.LongResult> {
  @Override
  LongValueObserverBuilder setDescription(String description);

  @Override
  LongValueObserverBuilder setUnit(String unit);

  @Override
  LongValueObserverBuilder setUpdater(Consumer<AsynchronousInstrument.LongResult> updater);

  @Override
  LongValueObserver build();
}
