/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.internal;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.AttributeKey;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.BiConsumer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.resource.v1.Resource;

final class ResourceAdapter {
  static Resource toProtoResource(com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource resource) {
    final Resource.Builder builder = Resource.newBuilder();
    resource
        .getAttributes().forEach(new BiConsumer<AttributeKey<?>, Object>() {
      @Override
      public void accept(AttributeKey<?> key, Object value) {
        builder.addAttributes(CommonAdapter.toProtoAttribute(key, value));
      }
    });
    return builder.build();
  }

  private ResourceAdapter() {}
}
