/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;

abstract class AbstractAsynchronousInstrument extends AbstractInstrument {
  private final AsynchronousInstrumentAccumulator accumulator;

  AbstractAsynchronousInstrument(
      InstrumentDescriptor descriptor, AsynchronousInstrumentAccumulator accumulator) {
    super(descriptor);
    this.accumulator = accumulator;
  }

  @Override
  final List<MetricData> collectAll(long epochNanos) {
    return accumulator.collectAll(epochNanos);
  }
}
