/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongValueObserver;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongValueObserverBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.BiFunction;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentType;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongValueObserverSdk extends AbstractAsynchronousInstrument
    implements LongValueObserver {

  LongValueObserverSdk(
      InstrumentDescriptor descriptor, AsynchronousInstrumentAccumulator accumulator) {
    super(descriptor, accumulator);
  }

  static final class Builder
      extends AbstractLongAsynchronousInstrumentBuilder<LongValueObserverSdk.Builder>
      implements LongValueObserverBuilder {

    Builder(
        String name,
        MeterProviderSharedState meterProviderSharedState,
        MeterSharedState meterSharedState) {
      super(
          name,
          InstrumentType.VALUE_OBSERVER,
          InstrumentValueType.LONG,
          meterProviderSharedState,
          meterSharedState);
    }

    @Override
    Builder getThis() {
      return this;
    }

    @Override
    public LongValueObserverSdk build() {
      return buildInstrument(
          new BiFunction<InstrumentDescriptor, AsynchronousInstrumentAccumulator, LongValueObserverSdk>() {
            @Override
            public LongValueObserverSdk apply(InstrumentDescriptor instrumentDescriptor,
                AsynchronousInstrumentAccumulator asynchronousInstrumentAccumulator) {
              return new LongValueObserverSdk(instrumentDescriptor, asynchronousInstrumentAccumulator);
            }
          });
    }
  }
}
