/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Collection;

final class NoopSpanExporter extends SpanExporter {

  private static final SpanExporter INSTANCE = new NoopSpanExporter();

  static SpanExporter getInstance() {
    return INSTANCE;
  }

  @Override
  public CompletableResultCode export(Collection<SpanData> spans) {
    return CompletableResultCode.ofSuccess();
  }

  @Override
  public CompletableResultCode flush() {
    return CompletableResultCode.ofSuccess();
  }

  @Override
  public CompletableResultCode shutdown() {
    return CompletableResultCode.ofSuccess();
  }
}
