/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.injector.methods;

import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;

public class DeleteByIds
extends AbstractMethod {
    public DeleteByIds() {
        this(SqlMethod.DELETE_BY_IDS.getMethod());
    }

    public DeleteByIds(String name) {
        super(name);
    }

    @Override
    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        SqlMethod sqlMethod = SqlMethod.LOGIC_DELETE_BY_IDS;
        if (tableInfo.isWithLogicDelete()) {
            String sql = this.logicDeleteScript(tableInfo, sqlMethod);
            SqlSource sqlSource = super.createSqlSource(this.configuration, sql, Object.class);
            return this.addUpdateMappedStatement(mapperClass, modelClass, this.methodName, sqlSource);
        }
        sqlMethod = SqlMethod.DELETE_BY_IDS;
        String sql = String.format(sqlMethod.getSql(), tableInfo.getTableName(), tableInfo.getKeyColumn(), SqlScriptUtils.convertForeach(SqlScriptUtils.convertChoose("@org.apache.ibatis.type.SimpleTypeRegistry@isSimpleType(item.getClass())", "#{item}", "#{item." + tableInfo.getKeyProperty() + "}"), "coll", null, "item", ","));
        SqlSource sqlSource = super.createSqlSource(this.configuration, sql, Object.class);
        return this.addDeleteMappedStatement(mapperClass, this.methodName, sqlSource);
    }

    public String logicDeleteScript(TableInfo tableInfo, SqlMethod sqlMethod) {
        List fieldInfos = tableInfo.getFieldList().stream().filter(TableFieldInfo::isWithUpdateFill).filter(f -> !f.isLogicDelete()).collect(Collectors.toList());
        String sqlSet = "SET ";
        if (CollectionUtils.isNotEmpty(fieldInfos)) {
            sqlSet = sqlSet + SqlScriptUtils.convertIf(fieldInfos.stream().map(i -> i.getSqlSet("mpFillEt.")).collect(Collectors.joining("")), String.format("%s != null", "mpFillEt"), true);
        }
        sqlSet = sqlSet + "" + tableInfo.getLogicDeleteSql(false, false);
        return String.format(sqlMethod.getSql(), tableInfo.getTableName(), sqlSet, tableInfo.getKeyColumn(), SqlScriptUtils.convertForeach(SqlScriptUtils.convertChoose("@org.apache.ibatis.type.SimpleTypeRegistry@isSimpleType(item.getClass())", "#{item}", "#{item." + tableInfo.getKeyProperty() + "}"), "coll", null, "item", ","), tableInfo.getLogicDeleteSql(true, true));
    }
}

