/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.websocket.audio.transcriptions;

import com.coze.openapi.client.websocket.event.downstream.ErrorEvent;
import com.coze.openapi.client.websocket.event.downstream.InputAudioBufferClearedEvent;
import com.coze.openapi.client.websocket.event.downstream.InputAudioBufferCompletedEvent;
import com.coze.openapi.client.websocket.event.downstream.TranscriptionsCreatedEvent;
import com.coze.openapi.client.websocket.event.downstream.TranscriptionsMessageCompletedEvent;
import com.coze.openapi.client.websocket.event.downstream.TranscriptionsMessageUpdateEvent;
import com.coze.openapi.client.websocket.event.downstream.TranscriptionsUpdatedEvent;
import com.coze.openapi.client.websocket.event.model.TranscriptionsUpdateEventData;
import com.coze.openapi.client.websocket.event.upstream.InputAudioBufferAppendEvent;
import com.coze.openapi.client.websocket.event.upstream.InputAudioBufferClearEvent;
import com.coze.openapi.client.websocket.event.upstream.InputAudioBufferCompleteEvent;
import com.coze.openapi.client.websocket.event.upstream.TranscriptionsUpdateEvent;
import com.coze.openapi.service.service.websocket.audio.transcriptions.WebsocketsAudioTranscriptionsCallbackHandler;
import com.coze.openapi.service.service.websocket.audio.transcriptions.WebsocketsAudioTranscriptionsCreateReq;
import com.coze.openapi.service.service.websocket.common.BaseCallbackHandler;
import com.coze.openapi.service.service.websocket.common.BaseWebsocketsClient;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;

public class WebsocketsAudioTranscriptionsClient
extends BaseWebsocketsClient {
    private final WebsocketsAudioTranscriptionsCallbackHandler handler;
    private static final String uri = "/v1/audio/transcriptions";

    protected WebsocketsAudioTranscriptionsClient(OkHttpClient client, String wsHost, WebsocketsAudioTranscriptionsCreateReq req) {
        super(client, WebsocketsAudioTranscriptionsClient.buildUrl(wsHost), req.getCallbackHandler(), req);
        this.handler = req.getCallbackHandler();
    }

    protected static String buildUrl(String wsHost) {
        return String.format("%s%s", wsHost, uri);
    }

    public void transcriptionsUpdate(TranscriptionsUpdateEventData data) {
        this.sendEvent(((TranscriptionsUpdateEvent.TranscriptionsUpdateEventBuilder)TranscriptionsUpdateEvent.builder().data(data)).build());
    }

    public void inputAudioBufferAppend(String data) {
        this.inputAudioBufferAppend(data.getBytes(StandardCharsets.UTF_8));
    }

    public void inputAudioBufferAppend(byte[] data) {
        String base64Data = Base64.getEncoder().encodeToString(data);
        this.sendEvent(InputAudioBufferAppendEvent.of(base64Data));
    }

    public void inputAudioBufferClear() {
        this.sendEvent(new InputAudioBufferClearEvent());
    }

    public void inputAudioBufferComplete() {
        this.sendEvent(new InputAudioBufferCompleteEvent());
    }

    @Override
    protected BaseCallbackHandler getCallbackHandler() {
        return this.handler;
    }

    @Override
    protected void handleEvent(WebSocket ws, String text) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(text);
            String eventType = this.parseEventType(jsonNode, text);
            if (eventType == null) {
                return;
            }
            switch (eventType) {
                case "transcriptions.created": {
                    TranscriptionsCreatedEvent createdEvent = (TranscriptionsCreatedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, TranscriptionsCreatedEvent.class);
                    this.handler.onTranscriptionsCreated(this, createdEvent);
                    break;
                }
                case "transcriptions.updated": {
                    TranscriptionsUpdatedEvent updatedEvent = (TranscriptionsUpdatedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, TranscriptionsUpdatedEvent.class);
                    this.handler.onTranscriptionsUpdated(this, updatedEvent);
                    break;
                }
                case "transcriptions.message.update": {
                    TranscriptionsMessageUpdateEvent messageUpdateEvent = (TranscriptionsMessageUpdateEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, TranscriptionsMessageUpdateEvent.class);
                    this.handler.onTranscriptionsMessageUpdate(this, messageUpdateEvent);
                    break;
                }
                case "transcriptions.message.completed": {
                    TranscriptionsMessageCompletedEvent messageCompletedEvent = (TranscriptionsMessageCompletedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, TranscriptionsMessageCompletedEvent.class);
                    this.handler.onTranscriptionsMessageCompleted(this, messageCompletedEvent);
                    break;
                }
                case "input_audio_buffer.cleared": {
                    InputAudioBufferClearedEvent bufferClearedEvent = (InputAudioBufferClearedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, InputAudioBufferClearedEvent.class);
                    this.handler.onInputAudioBufferCleared(this, bufferClearedEvent);
                    break;
                }
                case "input_audio_buffer.completed": {
                    InputAudioBufferCompletedEvent bufferCompletedEvent = (InputAudioBufferCompletedEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, InputAudioBufferCompletedEvent.class);
                    this.handler.onInputAudioBufferCompleted(this, bufferCompletedEvent);
                    break;
                }
                case "error": {
                    ErrorEvent errorEvent = (ErrorEvent)this.objectMapper.treeToValue((TreeNode)jsonNode, ErrorEvent.class);
                    this.handler.onError(this, errorEvent);
                    break;
                }
                default: {
                    logger.error("unknown event type: {}, event string: {}", (Object)eventType, (Object)text);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handler.onClientException(this, new RuntimeException(e));
        }
    }
}

