/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.foundation.internals.provider;

import com.ctrip.framework.foundation.internals.Utils;
import com.ctrip.framework.foundation.internals.io.BOMInputStream;
import com.ctrip.framework.foundation.spi.provider.ApplicationProvider;
import com.ctrip.framework.foundation.spi.provider.Provider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationProvider
implements ApplicationProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultApplicationProvider.class);
    public static final String APP_PROPERTIES_CLASSPATH = "/META-INF/app.properties";
    private Properties m_appProperties = new Properties();
    private String m_appId;

    @Override
    public void initialize() {
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(APP_PROPERTIES_CLASSPATH);
            if (in == null) {
                in = DefaultApplicationProvider.class.getResourceAsStream(APP_PROPERTIES_CLASSPATH);
            }
            this.initialize(in);
        }
        catch (Throwable ex) {
            logger.error("Initialize DefaultApplicationProvider failed.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(InputStream in) {
        try {
            if (in != null) {
                try {
                    this.m_appProperties.load(new InputStreamReader((InputStream)new BOMInputStream(in), StandardCharsets.UTF_8));
                }
                finally {
                    in.close();
                }
            }
            this.initAppId();
        }
        catch (Throwable ex) {
            logger.error("Initialize DefaultApplicationProvider failed.", ex);
        }
    }

    @Override
    public String getAppId() {
        return this.m_appId;
    }

    @Override
    public boolean isAppIdSet() {
        return !Utils.isBlank(this.m_appId);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        if ("app.id".equals(name)) {
            String val = this.getAppId();
            return val == null ? defaultValue : val;
        }
        String val = this.m_appProperties.getProperty(name, defaultValue);
        return val == null ? defaultValue : val;
    }

    @Override
    public Class<? extends Provider> getType() {
        return ApplicationProvider.class;
    }

    private void initAppId() {
        this.m_appId = System.getProperty("app.id");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            logger.info("App ID is set to {} by app.id property from System Property", (Object)this.m_appId);
            return;
        }
        this.m_appId = this.m_appProperties.getProperty("app.id");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            logger.info("App ID is set to {} by app.id property from {}", (Object)this.m_appId, (Object)APP_PROPERTIES_CLASSPATH);
            return;
        }
        this.m_appId = null;
        logger.warn("app.id is not available from System Property and {}. It is set to null", (Object)APP_PROPERTIES_CLASSPATH);
    }

    public String toString() {
        return "appId [" + this.getAppId() + "] properties: " + this.m_appProperties + " (DefaultApplicationProvider)";
    }
}

