/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.rw;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.filter.rw.RWCounter;
import dm.jdbc.filter.rw.RWUtil;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.EP;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class RWUtil2
extends RWUtil {
    public static final String SQL_SELECT_STANDBY = "select distinct mailIni.inst_name, mailIni.INST_IP, mailIni.INST_PORT, archIni.arch_status from  v$arch_status archIni left join (select * from V$DM_MAL_INI) mailIni on archIni.arch_dest = mailIni.inst_name left join V$MAL_LINK_STATUS on CTL_LINK_STATUS  = 'CONNECTED' AND DATA_LINK_STATUS = 'CONNECTED' where archIni.arch_type in ('TIMELY', 'REALTIME') AND  archIni.arch_status = 'VALID'";
    public static final String SQL_SELECT_STANDBY2 = "select distinct mailIni.mal_inst_name, mailIni.mal_INST_HOST, mailIni.mal_INST_PORT, archIni.arch_status from v$arch_status archIni left join (select * from V$DM_MAL_INI) mailIni on archIni.arch_dest = mailIni.mal_inst_name left join V$MAL_LINK_STATUS on CTL_LINK_STATUS  = 'CONNECTED' AND DATA_LINK_STATUS = 'CONNECTED' where archIni.arch_type in ('TIMELY', 'REALTIME') AND  archIni.arch_status = 'VALID'";

    @Override
    protected void connectStandby(DmdbConnection connection) throws SQLException {
        EP db = this.chooseValidStandby(connection);
        if (db == null) {
            this.log.warn(connection, "connStandby", "no valid standby");
            return;
        }
        try {
            DmProperties standbyProps = (DmProperties)connection.props.clone();
            standbyProps.setProperty(Configuration.host.getName(), db.host);
            standbyProps.setProperty(Configuration.port.getName(), String.valueOf(db.port));
            standbyProps.setProperty(Configuration.rwStandby.getName(), String.valueOf(true));
            standbyProps.setProperty(Configuration.epGroup.getName(), null);
            standbyProps.setProperty(Configuration.loginMode.getName(), String.valueOf(2));
            standbyProps.setProperty(Configuration.switchTimes.getName(), "0");
            connection.rwInfo.connStandby = DmDriver.driver.do_connect(standbyProps);
            if (connection.rwInfo.connStandby.svrMode != 2 || connection.rwInfo.connStandby.svrStat != 4) {
                this.removeStandby(connection);
            }
        }
        catch (Throwable ignore) {
            this.log.warn(connection, "connStandby", ignore.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EP chooseValidStandby(DmdbConnection connection) throws SQLException {
        EP eP;
        DmdbResultSet rs;
        block20: {
            Throwable exception;
            block21: {
                block19: {
                    int i2;
                    rs = null;
                    exception = null;
                    String filter = "";
                    String filter2 = "";
                    try {
                        if (connection.rwSeparate == 2) {
                            String epStr = "";
                            if (connection.epGroup != null) {
                                i2 = 0;
                                for (EP ep : connection.epGroup.epList) {
                                    if (i2 != 0) {
                                        epStr = String.valueOf(epStr) + ",";
                                    }
                                    epStr = String.valueOf(epStr) + "'" + ep.host + ":" + ep.port + "'";
                                    ++i2;
                                }
                            }
                            if (StringUtil.isNotEmpty(epStr)) {
                                filter = " and (mailIni.INST_IP || ':'|| mailIni.INST_PORT) in (" + epStr + ")";
                                filter2 = " and (mailIni.mal_INST_HOST || ':'|| mailIni.mal_INST_PORT) in (" + epStr + ")";
                            }
                        }
                        rs = DriverUtil.executeQuery(connection, connection.malini2 ? SQL_SELECT_STANDBY2 + filter2 : SQL_SELECT_STANDBY + filter);
                    }
                    catch (SQLException sQLException) {
                        MiscUtil.close(rs);
                        try {
                            rs = DriverUtil.executeQuery(connection, connection.malini2 ? SQL_SELECT_STANDBY + filter : SQL_SELECT_STANDBY2 + filter2);
                        }
                        catch (Throwable ignore) {
                            exception = ignore;
                        }
                    }
                    catch (Throwable ignore) {
                        exception = ignore;
                    }
                    try {
                        int count;
                        int n2 = count = rs == null ? 0 : (int)rs.getRowCount();
                        if (count <= 0) break block19;
                        connection.rwInfo.rwCounter = RWCounter.getInstance(connection, count);
                        i2 = 0;
                        int rowIndex = connection.rwInfo.rwCounter.chooseStandbyIndex(count);
                        while (rs.do_next()) {
                            if (i2 == rowIndex) {
                                eP = new EP(rs.do_getString(2), rs.do_getInt(3));
                                break block20;
                            }
                            ++i2;
                        }
                    }
                    catch (Throwable throwable) {
                        MiscUtil.close(rs);
                        throw throwable;
                    }
                    {
                        catch (Throwable ignore) {
                            exception = ignore;
                            MiscUtil.close(rs);
                            break block21;
                            break;
                        }
                    }
                }
                MiscUtil.close(rs);
            }
            if (exception != null) {
                if (exception instanceof SQLException && ((SQLException)exception).getErrorCode() == DBError.ECJDBC_COMMUNITION_ERROR.errCode) {
                    throw (SQLException)exception;
                }
                DBError.throwRuntimeException("choose valid standby error!", exception);
            }
            return null;
        }
        MiscUtil.close(rs);
        return eP;
    }
}

