/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.convert;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.internal.convert.OffRowData;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.ConvertUtil;
import java.sql.Blob;
import java.sql.SQLException;

public class OffRowBlobData
extends OffRowData {
    public OffRowBlobData(Blob obj, DmdbConnection conn) throws SQLException {
        super(obj, conn, -1L);
        this.init();
    }

    @Override
    public void read(ByteArrayQueue byteArray) throws SQLException {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(byteArray);
        } else if (!this.readOver) {
            Blob blob = (Blob)this.obj;
            long totalLen = blob.length();
            long leaveLen = totalLen - this.position;
            int readLen = (int)(leaveLen > (long)this.READ_LEN ? (long)this.READ_LEN : leaveLen);
            byte[] bytes = blob.getBytes(this.position + 1L, readLen);
            this.position += (long)readLen;
            if (this.position == totalLen) {
                this.readOver = true;
            }
            byteArray.putBytes(bytes, 0, bytes.length);
        }
    }

    @Override
    public byte[] readAll() throws SQLException {
        Blob blob = (Blob)this.obj;
        return ConvertUtil.getBlobData(blob);
    }
}

