/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.core.framework.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public final class DateUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String MONTH_DATE_FORMAT = "MM-dd";
    public static final String YEAR_WEEK_FORMAT = "yyyy-ww";
    public static final String YEAR_MONTH_FORMAT = "yyyy-MM";
    public static final String YEAR_WEEK_FORMAT_SHORT = "yy-ww";
    public static final String YEAR_MONTH_FORMAT_SHORT = "yy-MM";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String FULL_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_FORMAT = "HH:mm";
    public static final String MONTH_DAY_HOUR_MINUTE_FORMAT = "MM-dd HH:mm";
    public static final String LOCATE_DATE_FORMAT = "yyyyMMddHHmmss";
    private static final int DAYS_OF_A_WEEK = 7;

    private DateUtil() {
    }

    public static Date parseDate(String date) throws ParseException {
        return DateUtil.parseDate(date, DATE_FORMAT);
    }

    public static Date parseDate(String date, String pattern) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.parse(date);
    }

    public static Date addHour(Date date, int v) {
        Calendar calendar = DateUtil.getDefaultCalendar();
        calendar.setTime(date);
        calendar.add(10, v);
        return calendar.getTime();
    }

    public static String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(date);
    }

    public static String formatTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
        return format.format(date);
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String getCurrentDateFormat() {
        return DateUtil.formatDate(new Date());
    }

    public static String getCurrentTimeFormat() {
        return DateUtil.formatTime(new Date());
    }

    public static int getDateNum(Date fromDate, Date endDate) {
        long days = (endDate.getTime() - fromDate.getTime()) / 86400000L;
        return (int)days;
    }

    public static Date addDate(Date date, int number) {
        Calendar calendar = DateUtil.getDefaultCalendar();
        calendar.setTime(date);
        calendar.add(5, number);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int number) {
        Calendar calendar = DateUtil.getDefaultCalendar();
        calendar.setTime(date);
        calendar.add(2, number);
        return calendar.getTime();
    }

    public static Date addYear(Date date, int number) {
        Calendar calendar = DateUtil.getDefaultCalendar();
        calendar.setTime(date);
        calendar.add(1, number);
        return calendar.getTime();
    }

    public static Calendar getDefaultCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        return calendar;
    }

    public static String getStringDate(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return year + "-" + DateUtil.getNiceString(month) + "-" + DateUtil.getNiceString(day);
    }

    public static String getNiceString(int value) {
        String str = "00" + value;
        return str.substring(str.length() - 2, str.length());
    }

    public static Calendar getCalendarFromDate(Date date) {
        Calendar calendar = DateUtil.getDefaultCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public static String getInterval(Date startDate, Date endDate) {
        long intervalTime = endDate.getTime() - startDate.getTime();
        return DateUtil.getInterval(intervalTime);
    }

    public static int getIntervalMinute(Date startDate, Date endDate) {
        long intervalTime = endDate.getTime() - startDate.getTime();
        return (int)(intervalTime / 60000L);
    }

    public static String getInterval(long intervalTime) {
        int hour = (int)(intervalTime / 3600000L);
        int minute = (int)(intervalTime / 60000L - (long)(hour * 60));
        int second = (int)(intervalTime / 1000L - (long)(hour * 60 * 60) - (long)(minute * 60));
        if (hour > 0) {
            return hour + "\u5c0f\u65f6 " + minute + "\u5206 " + second + "\u79d2";
        }
        if (minute > 0) {
            return minute + "\u5206\u949f " + second + "\u79d2";
        }
        return second + "\u79d2";
    }

    public static int getYear(Date date) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        return calendar.get(2) + 1;
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        return calendar.get(5);
    }

    public static int getHour(Date now) {
        Calendar calendar = DateUtil.getCalendarFromDate(now);
        return calendar.get(11);
    }

    public static int getWeekOfYear(Date date) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        calendar.setFirstDayOfWeek(2);
        return calendar.get(3) - 1;
    }

    public static Date getCurrentDate() {
        Calendar calendar = DateUtil.getCalendarFromDate(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static String getCurrentDateStr() {
        return DateUtil.formatDate(new Date());
    }

    public static Date getNextDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.getCurrentDate());
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static List<Date> getWeekDayOfYear(Date date) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(7);
        int week = calendar.get(3);
        int year = calendar.get(1);
        ArrayList<Date> result = new ArrayList<Date>();
        result.add(DateUtil.getDateOfYearWeek(year, week, 2));
        result.add(DateUtil.getDateOfYearWeek(year, week, 3));
        result.add(DateUtil.getDateOfYearWeek(year, week, 4));
        result.add(DateUtil.getDateOfYearWeek(year, week, 5));
        result.add(DateUtil.getDateOfYearWeek(year, week, 6));
        result.add(DateUtil.getDateOfYearWeek(year, week, 7));
        result.add(DateUtil.getDateOfYearWeek(year, week, 1));
        return result;
    }

    private static Date getDateOfYearWeek(int yearNum, int weekNum, int dayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.set(7, dayOfWeek);
        cal.setMinimalDaysInFirstWeek(7);
        cal.set(1, yearNum);
        cal.set(3, weekNum);
        return cal.getTime();
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        calendar.setMinimalDaysInFirstWeek(7);
        return calendar.get(7) - 1;
    }

    public static Date getDefaultDate() {
        Calendar calendar = DateUtil.getCalendarFromDate(new Date());
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date addSecond(Date date, int number) {
        Calendar calendar = DateUtil.getDefaultCalendar();
        calendar.setTime(date);
        calendar.add(13, number);
        return calendar.getTime();
    }

    public static Date addMinutes(Date date, int number) {
        Calendar calendar = DateUtil.getDefaultCalendar();
        calendar.setTime(date);
        calendar.add(12, number);
        return calendar.getTime();
    }

    public static Date clearTime(Date date) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static boolean betweenHour(Date date, int hour) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        calendar.add(10, hour);
        Calendar now = DateUtil.getDefaultCalendar();
        return calendar.after(now);
    }

    public static boolean betweenMinute(Date date, int minute) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        calendar.add(12, minute);
        Calendar now = DateUtil.getDefaultCalendar();
        return calendar.after(now);
    }

    public static boolean betweenSecond(Date date, int second) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        calendar.add(13, second);
        Calendar now = DateUtil.getDefaultCalendar();
        return calendar.after(now);
    }

    public static Date addWeek(Date date, int v) {
        Calendar calendar = DateUtil.getDefaultCalendar();
        calendar.setTime(date);
        calendar.add(3, v);
        return calendar.getTime();
    }

    public static String getCurrentWeekDay(Date date, int day) {
        Calendar calendar = DateUtil.getCalendarFromDate(date);
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(7);
        int week = calendar.get(3);
        int year = calendar.get(1);
        return DateUtil.formatDate(DateUtil.getDateOfYearWeek(year, week, day));
    }

    public static List<String> getYearRange(int fromYear, int toYear) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i <= toYear - fromYear; ++i) {
            result.add(String.format("%d", toYear - i));
        }
        return result;
    }

    public static List<String> getMonthRange(int year, int month) {
        Calendar calendar = DateUtil.getDefaultCalendar();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, 1);
        ArrayList<String> result = new ArrayList<String>();
        Date date = calendar.getTime();
        while (month - 1 == calendar.get(2)) {
            result.add(DateUtil.formatDate(date));
            date = DateUtil.addDate(date, 1);
        }
        return result;
    }

    public static List<String> getDateRange(String strBeginDate, String strEndDate, String pattern) throws ParseException {
        ArrayList<String> ret = new ArrayList<String>();
        Date beginDate = DateUtil.parseDate(strBeginDate);
        Date endDate = DateUtil.parseDate(strEndDate);
        ret.add(DateUtil.formatDate(beginDate, pattern));
        while (!beginDate.equals(endDate)) {
            beginDate = DateUtil.addDate(beginDate, 1);
            ret.add(DateUtil.formatDate(beginDate, pattern));
        }
        return ret;
    }

    public static boolean before(Date beginDate, Date endDate) {
        return beginDate.compareTo(endDate) <= 0;
    }

    public static List<String> getWeekRange(String strBeginDate, String strEndDate, String pattern) throws ParseException {
        ArrayList<String> ret = new ArrayList<String>();
        Date beginDate = DateUtil.parseDate(strBeginDate);
        Date endDate = DateUtil.parseDate(strEndDate);
        String beginFormat = DateUtil.formatDate(beginDate, pattern);
        String endFormat = DateUtil.formatDate(endDate, pattern);
        ret.add(beginFormat);
        while (!beginFormat.equals(endFormat)) {
            beginDate = DateUtil.addWeek(beginDate, 1);
            beginFormat = DateUtil.formatDate(beginDate, pattern);
            ret.add(beginFormat);
        }
        return ret;
    }

    public static List<String> getMonthRange(String strBeginDate, String strEndDate, String pattern) throws ParseException {
        ArrayList<String> ret = new ArrayList<String>();
        Date beginDate = DateUtil.parseDate(strBeginDate, pattern);
        Date endDate = DateUtil.parseDate(strEndDate, pattern);
        String beginFormat = DateUtil.formatDate(beginDate, pattern);
        String endFormat = DateUtil.formatDate(endDate, pattern);
        ret.add(beginFormat);
        while (!beginFormat.equals(endFormat)) {
            beginDate = DateUtil.addMonth(beginDate, 1);
            beginFormat = DateUtil.formatDate(beginDate, pattern);
            ret.add(beginFormat);
        }
        return ret;
    }

    public static float getIntervalHour(Date startDate, Date endDate) {
        long intervalTime = endDate.getTime() - startDate.getTime();
        return (float)intervalTime * 1.0f / 3600000.0f;
    }

    public static String getCurrentDateTime() {
        return DateUtil.formatDate(new Date(), LOCATE_DATE_FORMAT);
    }

    public static String getWeek(Date date) {
        String[] weeks = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week_index = cal.get(7) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        return weeks[week_index];
    }

    public static List<String> getFullYear() {
        ArrayList<String> list = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        int year = calendar.get(1) + 1900;
        for (int i = 0; i < 12; ++i) {
            if (month == 0) {
                month = 12;
                --year;
            }
            String temp = month < 10 ? "0" + month : month + "";
            list.add(year + "-" + temp);
            --month;
        }
        return list;
    }
}

