/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.core.framework.utils;

import com.lorne.core.framework.utils.DateUtil;
import java.util.UUID;

public class KidUtils {
    private static String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static String getKid() {
        String kid = KidUtils.generateShortUuid();
        kid = DateUtil.getCurrentDateTime() + kid;
        return kid;
    }

    public static String getKKid() {
        String kid = KidUtils.generateShortUuid();
        kid = "k" + DateUtil.getCurrentDateTime() + kid;
        return kid;
    }

    public static String getUUID() {
        String kid = KidUtils.generateShortUuid();
        kid = DateUtil.getCurrentDateTime() + "ud" + kid;
        return kid;
    }

    public static boolean isUUID(String uuid) {
        if (uuid != null && uuid.length() == 24) {
            String time = uuid.substring(0, 14);
            try {
                DateUtil.parseDate(time, "yyyyMMddHHmmss");
                if ("ud".equals(uuid.substring(14, 16))) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String generateShortUuid() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }
}

