/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.core.framework.utils.http;

import com.lorne.core.framework.exception.HttpException;
import com.lorne.core.framework.utils.http.CookieContext;
import com.lorne.core.framework.utils.http.HttpClientFactory;
import com.lorne.core.framework.utils.http.IOUtils;
import com.lorne.core.framework.utils.http.PostFileParam;
import com.lorne.core.framework.utils.http.PostParam;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execute(CloseableHttpClient httpClient, HttpRequestBase request) {
        String res = null;
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request, (HttpContext)CookieContext.createHttpClientContext());
            if (response.getStatusLine().getStatusCode() == 302) {
                String location = response.getFirstHeader("Location").getValue();
                String string = HttpUtils.get(location);
                return string;
            }
            res = IOUtils.getStringFromInputStream(response);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return res;
    }

    public static String get(String url) {
        CloseableHttpClient httpClient = HttpClientFactory.createHttpClient();
        HttpGet request = new HttpGet(url);
        return HttpUtils.execute(httpClient, (HttpRequestBase)request);
    }

    public static String post(String url) {
        List<PostParam> params = null;
        return HttpUtils.post(url, params);
    }

    public static String post(String url, List<PostParam> params) {
        CloseableHttpClient httpClient = HttpClientFactory.createHttpClient();
        HttpPost request = new HttpPost(url);
        if (params != null) {
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (PostParam param : params) {
                BasicNameValuePair pair = new BasicNameValuePair(param.getName(), param.getValue());
                pairList.add(pair);
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        }
        return HttpUtils.execute(httpClient, (HttpRequestBase)request);
    }

    public static String post(String url, PostParam ... params) {
        CloseableHttpClient httpClient = HttpClientFactory.createHttpClient();
        HttpPost request = new HttpPost(url);
        if (params != null) {
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.length);
            for (PostParam param : params) {
                BasicNameValuePair pair = new BasicNameValuePair(param.getName(), param.getValue());
                pairList.add(pair);
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        }
        return HttpUtils.execute(httpClient, (HttpRequestBase)request);
    }

    public static String post(String url, String postParams) {
        UrlEncodedFormEntity postEntity = null;
        if (StringUtils.isNotEmpty((String)postParams)) {
            String[] params = postParams.split("&");
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            if (params != null && params.length > 0) {
                for (String param : params) {
                    try {
                        param = URLDecoder.decode(param, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    String[] nv = param.split("=");
                    if (nv.length == 1) {
                        formParams.add(new BasicNameValuePair(nv[0], ""));
                        continue;
                    }
                    formParams.add(new BasicNameValuePair(param.substring(0, param.indexOf("=")), param.substring(param.indexOf("=") + 1)));
                }
            }
            try {
                postEntity = new UrlEncodedFormEntity(formParams, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        CloseableHttpClient httpClient = HttpClientFactory.createHttpClient();
        HttpPost request = new HttpPost(url);
        if (postEntity != null) {
            request.setEntity(postEntity);
        }
        return HttpUtils.execute(httpClient, (HttpRequestBase)request);
    }

    public static String postString(String url, String str) throws HttpException {
        try {
            StringEntity postEntity = new StringEntity(str);
            CloseableHttpClient httpClient = HttpClientFactory.createHttpClient();
            HttpPost request = new HttpPost(url);
            if (postEntity != null) {
                request.setEntity((HttpEntity)postEntity);
            }
            return HttpUtils.execute(httpClient, (HttpRequestBase)request);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new HttpException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean download(String url, String path) {
        CloseableHttpClient httpClient = HttpClientFactory.createHttpClient();
        HttpGet request = new HttpGet(url);
        boolean res = false;
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request, (HttpContext)CookieContext.createHttpClientContext());
            if (200 == response.getStatusLine().getStatusCode()) {
                HttpEntity httpEntity = response.getEntity();
                InputStream is = httpEntity.getContent();
                if (!new File(path).exists()) {
                    new File(path).getParentFile().mkdirs();
                    new File(path).createNewFile();
                }
                FileUtils.copyInputStreamToFile((InputStream)is, (File)new File(path));
                if (httpEntity != null) {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                res = true;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return res;
    }

    public static String postFile(String url, PostFileParam ... fileParams) {
        if (fileParams == null) {
            return null;
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(Charset.forName("UTF-8"));
        for (PostFileParam fileParam : fileParams) {
            InputStream inputStream;
            FileBody fileBody;
            if (fileParam.getValue() instanceof File) {
                File file;
                if (fileParam.getContentType() != null) {
                    file = (File)fileParam.getValue();
                    fileBody = new FileBody(file, fileParam.getContentType());
                    builder.addPart(fileParam.getName(), (ContentBody)fileBody);
                    continue;
                }
                file = (File)fileParam.getValue();
                fileBody = new FileBody(file);
                builder.addPart(fileParam.getName(), (ContentBody)fileBody);
                continue;
            }
            if (fileParam.getValue() instanceof String) {
                StringBody stringBody;
                String str;
                if (fileParam.getContentType() != null) {
                    str = (String)fileParam.getValue();
                    stringBody = new StringBody(str, fileParam.getContentType());
                    builder.addPart(fileParam.getName(), (ContentBody)stringBody);
                    continue;
                }
                str = (String)fileParam.getValue();
                stringBody = new StringBody(str, ContentType.MULTIPART_FORM_DATA);
                builder.addPart(fileParam.getName(), (ContentBody)stringBody);
                continue;
            }
            if (!(fileParam.getValue() instanceof InputStream)) continue;
            if (fileParam.getContentType() != null) {
                inputStream = (InputStream)fileParam.getValue();
                fileBody = new InputStreamBody(inputStream, fileParam.getContentType());
                builder.addPart(fileParam.getName(), (ContentBody)fileBody);
                continue;
            }
            inputStream = (InputStream)fileParam.getValue();
            fileBody = new InputStreamBody(inputStream, ContentType.APPLICATION_OCTET_STREAM);
            builder.addPart(fileParam.getName(), (ContentBody)fileBody);
        }
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        CloseableHttpClient httpClient = HttpClientFactory.createHttpClient();
        HttpPost request = new HttpPost(url);
        request.setEntity(builder.build());
        return HttpUtils.execute(httpClient, (HttpRequestBase)request);
    }

    public static String postJson(String url, String json) {
        return HttpUtils.postString(url, json, "application/json");
    }

    public static String postString(String url, String data, String type) {
        CloseableHttpClient httpClient = HttpClientFactory.createHttpClient();
        HttpPost request = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(data, "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType(type);
        request.setEntity((HttpEntity)stringEntity);
        return HttpUtils.execute(httpClient, (HttpRequestBase)request);
    }

    public static String postXml(String url, String xml) {
        return HttpUtils.postString(url, xml, "text/xml");
    }
}

