/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.core.framework.utils.math;

import java.math.BigDecimal;

public class MathUtils {
    private static final int DEF_DIV_SCALE = 10;

    public static double add(double ... ds) {
        BigDecimal count = new BigDecimal("0");
        if (ds != null && ds.length > 0) {
            for (double d : ds) {
                BigDecimal val = new BigDecimal(Double.toString(d));
                count = count.add(val);
            }
        }
        return count.doubleValue();
    }

    public static double sub(double ... ds) {
        if (ds == null) {
            return 0.0;
        }
        BigDecimal count = new BigDecimal(String.valueOf(ds[0]));
        if (ds != null && ds.length > 0) {
            int i = 0;
            for (double d : ds) {
                if (++i == 1) continue;
                BigDecimal val = new BigDecimal(Double.toString(d));
                count = count.subtract(val);
            }
        }
        return count.doubleValue();
    }

    public static double mul(double ... ds) {
        if (ds == null) {
            return 0.0;
        }
        BigDecimal count = new BigDecimal(String.valueOf(ds[0]));
        if (ds != null && ds.length > 0) {
            int i = 0;
            for (double d : ds) {
                if (++i == 1) continue;
                BigDecimal val = new BigDecimal(Double.toString(d));
                count = count.multiply(val);
            }
        }
        return count.doubleValue();
    }

    public static double div(double ... ds) {
        return MathUtils.div(10, ds);
    }

    private static double div(int scale, double ... ds) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        if (ds.length < 0) {
            throw new RuntimeException("\u53c2\u6570\u65e0\u6548");
        }
        BigDecimal count = new BigDecimal(String.valueOf(ds[0]));
        if (ds != null && ds.length > 0) {
            for (int i = 1; i < ds.length; ++i) {
                double d = ds[i];
                BigDecimal val = new BigDecimal(Double.toString(d));
                count = count.divide(val, scale, 4);
            }
        }
        return count.doubleValue();
    }
}

