/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.core.framework.utils.task;

import com.lorne.core.framework.utils.task.ConditionUtils;
import com.lorne.core.framework.utils.task.IBack;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Task {
    private Lock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private volatile IBack back;
    private Object obj;
    private volatile IBack execute;
    private volatile boolean hasExecute = false;
    private volatile boolean isNotify = false;
    private volatile boolean isAwait = false;
    private String key;
    private volatile int state = 0;

    public boolean isNotify() {
        return this.isNotify;
    }

    public boolean isRemove() {
        return !ConditionUtils.getInstance().hasKey(this.getKey());
    }

    public boolean isAwait() {
        return this.isAwait;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public IBack getBack() {
        return this.back;
    }

    public void setBack(IBack back) {
        this.back = back;
    }

    protected Task() {
    }

    public synchronized Object execute(IBack back) {
        try {
            this.execute = back;
            this.hasExecute = true;
            this.executeSignalTask();
            while (this.execute != null) {
                Thread.currentThread();
                if (Thread.interrupted()) break;
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Object object = this.obj;
            return object;
        }
        finally {
            this.obj = null;
        }
    }

    public void remove() {
        ConditionUtils.getInstance().removeKey(this.getKey());
    }

    private void executeSignalTask() {
        while (!this.isAwait) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            this.lock.lock();
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signalTask() {
        while (this.hasExecute) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        while (!this.isAwait) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            this.lock.lock();
            this.isNotify = true;
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signalTask(IBack back) {
        while (this.hasExecute) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        while (!this.isAwait) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            this.lock.lock();
            this.isNotify = true;
            try {
                back.doing(new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitTask() throws Throwable {
        this.condition.await();
        if (this.hasExecute) {
            try {
                this.obj = this.execute.doing(new Object[0]);
            }
            catch (Throwable e) {
                this.obj = e;
            }
            this.hasExecute = false;
            this.execute = null;
            this.waitTask();
        }
    }

    public void awaitTask() {
        try {
            this.lock.lock();
            this.isAwait = true;
            this.waitTask();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.lock.unlock();
        }
    }

    public void awaitTask(IBack back) {
        try {
            this.lock.lock();
            try {
                back.doing(new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.isAwait = true;
            this.waitTask();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.lock.unlock();
        }
    }
}

