/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.core.framework.utils.thread;

import com.lorne.core.framework.utils.thread.CountDownThread;
import com.lorne.core.framework.utils.thread.IExecute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CountDownLatchHelper<T> {
    private boolean isExecute = false;
    private int count;
    private List<T> data;
    private List<CountDownThread<T>> list;
    private CountDownLatch end;
    private ExecutorService threadPool = Executors.newFixedThreadPool(10);
    private List<IExecute<T>> executes = new ArrayList<IExecute<T>>();

    public CountDownLatchHelper() {
        this.data = Collections.synchronizedList(new ArrayList());
        this.list = new ArrayList<CountDownThread<T>>();
    }

    public CountDownLatchHelper<T> addExecute(IExecute<T> execute) {
        this.executes.add(execute);
        return this;
    }

    public CountDownLatchHelper<T> execute() {
        this.count = this.executes.size();
        if (this.count > 0) {
            this.end = new CountDownLatch(this.count);
            for (IExecute<T> countDown : this.executes) {
                CountDownThread<T> countDownThread = new CountDownThread<T>(this.threadPool, this.data, countDown, this.end);
                countDownThread.execute();
            }
            try {
                this.end.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.threadPool.shutdown();
        this.isExecute = true;
        return this;
    }

    public List<T> getData() {
        if (!this.isExecute) {
            throw new RuntimeException("no execute !");
        }
        return this.data;
    }
}

