/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorProperties;
import com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool.FlexyPoolConfigurationBuilderCustomizer;
import com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool.FlexyPoolDataSourceDecorator;
import com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool.FlexyPoolProperties;
import com.vladmihalcea.flexypool.FlexyPoolDataSource;
import com.vladmihalcea.flexypool.adaptor.DBCP2PoolAdapter;
import com.vladmihalcea.flexypool.adaptor.HikariCPPoolAdapter;
import com.vladmihalcea.flexypool.adaptor.TomcatCPPoolAdapter;
import com.vladmihalcea.flexypool.connection.ConnectionProxyFactory;
import com.vladmihalcea.flexypool.event.Event;
import com.vladmihalcea.flexypool.event.EventListener;
import com.vladmihalcea.flexypool.metric.MetricsFactory;
import com.vladmihalcea.flexypool.metric.micrometer.MicrometerMetrics;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquisitionStrategyFactory;
import com.vladmihalcea.flexypool.strategy.IncrementPoolOnTimeoutConnectionAcquisitionStrategy;
import com.vladmihalcea.flexypool.strategy.RetryConnectionAcquisitionStrategy;
import com.vladmihalcea.flexypool.util.ClassLoaderUtils;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class FlexyPoolConfiguration {
    static <T extends javax.sql.DataSource> List<ConnectionAcquisitionStrategyFactory<?, T>> mergeFactories(List<ConnectionAcquisitionStrategyFactory<?, T>> factories, FlexyPoolProperties flexyPool) {
        List factoryClasses;
        ArrayList newFactories = new ArrayList();
        if (factories != null) {
            factoryClasses = factories.stream().map(Object::getClass).collect(Collectors.toList());
            newFactories.addAll(factories);
        } else {
            factoryClasses = Collections.emptyList();
        }
        if (!factoryClasses.contains(IncrementPoolOnTimeoutConnectionAcquisitionStrategy.Factory.class) && flexyPool.getAcquisitionStrategy().getIncrementPool().getMaxOvergrowPoolSize() > 0) {
            newFactories.add((ConnectionAcquisitionStrategyFactory<?, T>)new IncrementPoolOnTimeoutConnectionAcquisitionStrategy.Factory(flexyPool.getAcquisitionStrategy().getIncrementPool().getMaxOvergrowPoolSize(), flexyPool.getAcquisitionStrategy().getIncrementPool().getTimeoutMillis()));
        }
        if (!factoryClasses.contains(RetryConnectionAcquisitionStrategy.Factory.class) && flexyPool.getAcquisitionStrategy().getRetry().getAttempts() > 0) {
            newFactories.add((ConnectionAcquisitionStrategyFactory<?, T>)new RetryConnectionAcquisitionStrategy.Factory(flexyPool.getAcquisitionStrategy().getRetry().getAttempts()));
        }
        return newFactories;
    }

    private static class FlexyPoolConfigurationAvailableCondition
    extends SpringBootCondition {
        private FlexyPoolConfigurationAvailableCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"FlexyPoolConfigurationAvailable", (Object[])new Object[0]);
            String propertiesFilePath = System.getProperty("flexy.pool.properties.path");
            if (propertiesFilePath != null && ClassLoaderUtils.getResource((String)propertiesFilePath) != null) {
                return ConditionOutcome.match((ConditionMessage)message.found("FlexyPool configuration file").items(new Object[]{propertiesFilePath}));
            }
            if (ClassLoaderUtils.getResource((String)"flexy-pool.properties") != null) {
                return ConditionOutcome.match((ConditionMessage)message.found("FlexyPool configuration file").items(new Object[]{"flexy-pool.properties"}));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("FlexyPool configuration file").atAll());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MicrometerMetrics.class})
    static class MicrometerConfiguration {
        MicrometerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MetricsFactory metricsFactory() {
            return MicrometerMetrics.FACTORY;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={FlexyPoolDataSourceDecorator.class})
    @Conditional(value={FlexyPoolConfigurationAvailableCondition.class})
    static class PropertyFlexyConfiguration {
        private static final Logger log = LoggerFactory.getLogger(PropertyFlexyConfiguration.class);
        @Autowired(required=false)
        private List<ConnectionAcquisitionStrategyFactory<?, javax.sql.DataSource>> connectionAcquisitionStrategyFactories;

        PropertyFlexyConfiguration() {
        }

        @PostConstruct
        public void warnIfAnyStrategyFound() {
            if (this.connectionAcquisitionStrategyFactories != null) {
                log.warn("ConnectionAcquisitionStrategyFactory beans found in the context will not be applied to FlexyDataSource due to property based configuration of FlexyPool");
            }
        }

        @Bean
        public FlexyPoolDataSourceDecorator flexyPoolDataSourceDecorator() {
            return new FlexyPoolDataSourceDecorator();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={FlexyPoolDataSourceDecorator.class})
    @ConditionalOnClass(value={DBCP2PoolAdapter.class})
    @ConditionalOnBean(value={BasicDataSource.class})
    static class Dbcp2FlexyConfiguration {
        @Autowired(required=false)
        private List<ConnectionAcquisitionStrategyFactory<?, BasicDataSource>> connectionAcquisitionStrategyFactories;
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;

        Dbcp2FlexyConfiguration() {
        }

        @Bean
        public FlexyPoolDataSourceDecorator flexyPoolDataSourceDecorator() {
            return new FlexyPoolDataSourceDecorator(FlexyPoolConfiguration.mergeFactories(this.connectionAcquisitionStrategyFactories, this.dataSourceDecoratorProperties.getFlexyPool()), DBCP2PoolAdapter.FACTORY, BasicDataSource.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={FlexyPoolDataSourceDecorator.class})
    @ConditionalOnClass(value={TomcatCPPoolAdapter.class})
    @ConditionalOnBean(value={DataSource.class})
    static class TomcatFlexyConfiguration {
        @Autowired(required=false)
        private List<ConnectionAcquisitionStrategyFactory<?, DataSource>> connectionAcquisitionStrategyFactories;
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;

        TomcatFlexyConfiguration() {
        }

        @Bean
        public FlexyPoolDataSourceDecorator flexyPoolDataSourceDecorator() {
            return new FlexyPoolDataSourceDecorator(FlexyPoolConfiguration.mergeFactories(this.connectionAcquisitionStrategyFactories, this.dataSourceDecoratorProperties.getFlexyPool()), TomcatCPPoolAdapter.FACTORY, DataSource.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={FlexyPoolDataSourceDecorator.class})
    @ConditionalOnClass(value={HikariCPPoolAdapter.class})
    @ConditionalOnBean(value={HikariDataSource.class})
    static class HikariFlexyConfiguration {
        @Autowired(required=false)
        private List<ConnectionAcquisitionStrategyFactory<?, HikariDataSource>> connectionAcquisitionStrategyFactories;
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;

        HikariFlexyConfiguration() {
        }

        @Bean
        public FlexyPoolDataSourceDecorator flexyPoolDataSourceDecorator() {
            return new FlexyPoolDataSourceDecorator(FlexyPoolConfiguration.mergeFactories(this.connectionAcquisitionStrategyFactories, this.dataSourceDecoratorProperties.getFlexyPool()), HikariCPPoolAdapter.FACTORY, HikariDataSource.class);
        }
    }

    @ConditionalOnMissingBean(value={PropertyFlexyConfiguration.class})
    static class FlexyPoolCustomizerConfiguration {
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;
        @Autowired(required=false)
        private MetricsFactory metricsFactory;
        @Autowired(required=false)
        private ConnectionProxyFactory connectionProxyFactory;
        @Autowired(required=false)
        private List<EventListener<? extends Event>> eventListeners;

        FlexyPoolCustomizerConfiguration() {
        }

        @Bean
        public FlexyPoolConfigurationBuilderCustomizer flexyPoolConfigurationBuilderCustomizer() {
            return (beanName, builder, dataSourceClass) -> {
                FlexyPoolProperties flexyPool = this.dataSourceDecoratorProperties.getFlexyPool();
                builder.setMetricLogReporterMillis(flexyPool.getMetrics().getReporter().getLog().getMillis());
                builder.setJmxEnabled(flexyPool.getMetrics().getReporter().getJmx().isEnabled());
                builder.setJmxAutoStart(flexyPool.getMetrics().getReporter().getJmx().isAutoStart());
                builder.setConnectionAcquisitionTimeThresholdMillis(Long.valueOf(flexyPool.getThreshold().getConnection().getAcquisition()));
                builder.setConnectionLeaseTimeThresholdMillis(Long.valueOf(flexyPool.getThreshold().getConnection().getLease()));
                if (this.metricsFactory != null) {
                    builder.setMetricsFactory(this.metricsFactory);
                }
                if (this.connectionProxyFactory != null) {
                    builder.setConnectionProxyFactory(this.connectionProxyFactory);
                }
                if (this.eventListeners != null) {
                    builder.setEventListenerResolver(() -> this.eventListeners);
                }
            };
        }
    }

    @ConditionalOnClass(value={FlexyPoolDataSource.class})
    @Import(value={MicrometerConfiguration.class, PropertyFlexyConfiguration.class, HikariFlexyConfiguration.class, TomcatFlexyConfiguration.class, Dbcp2FlexyConfiguration.class, FlexyPoolCustomizerConfiguration.class})
    public static class Ordered {
    }
}

