/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.lang.reflect.InvocationTargetException;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.Block;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.CreateFunctionalStatement;
import net.sf.jsqlparser.statement.DeclareStatement;
import net.sf.jsqlparser.statement.DescribeStatement;
import net.sf.jsqlparser.statement.ExplainStatement;
import net.sf.jsqlparser.statement.IfElseStatement;
import net.sf.jsqlparser.statement.PurgeStatement;
import net.sf.jsqlparser.statement.ResetStatement;
import net.sf.jsqlparser.statement.RollbackStatement;
import net.sf.jsqlparser.statement.SavepointStatement;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.ShowColumnsStatement;
import net.sf.jsqlparser.statement.ShowStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.UnsupportedStatement;
import net.sf.jsqlparser.statement.UseStatement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterSession;
import net.sf.jsqlparser.statement.alter.AlterSystemStatement;
import net.sf.jsqlparser.statement.alter.RenameTableStatement;
import net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import net.sf.jsqlparser.statement.analyze.Analyze;
import net.sf.jsqlparser.statement.comment.Comment;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.schema.CreateSchema;
import net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import net.sf.jsqlparser.statement.create.synonym.CreateSynonym;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.grant.Grant;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.refresh.RefreshMaterializedViewStatement;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.show.ShowIndexStatement;
import net.sf.jsqlparser.statement.show.ShowTablesStatement;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.AlterDeParser;
import net.sf.jsqlparser.util.deparser.AlterSequenceDeParser;
import net.sf.jsqlparser.util.deparser.AlterSessionDeParser;
import net.sf.jsqlparser.util.deparser.AlterViewDeParser;
import net.sf.jsqlparser.util.deparser.CreateIndexDeParser;
import net.sf.jsqlparser.util.deparser.CreateSequenceDeParser;
import net.sf.jsqlparser.util.deparser.CreateSynonymDeparser;
import net.sf.jsqlparser.util.deparser.CreateTableDeParser;
import net.sf.jsqlparser.util.deparser.CreateViewDeParser;
import net.sf.jsqlparser.util.deparser.DeclareStatementDeParser;
import net.sf.jsqlparser.util.deparser.DeleteDeParser;
import net.sf.jsqlparser.util.deparser.DropDeParser;
import net.sf.jsqlparser.util.deparser.ExecuteDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.GrantDeParser;
import net.sf.jsqlparser.util.deparser.InsertDeParser;
import net.sf.jsqlparser.util.deparser.MergeDeParser;
import net.sf.jsqlparser.util.deparser.RefreshMaterializedViewStatementDeParser;
import net.sf.jsqlparser.util.deparser.ResetStatementDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;
import net.sf.jsqlparser.util.deparser.SetStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowColumnsStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowIndexStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowTablesStatementDeparser;
import net.sf.jsqlparser.util.deparser.UpdateDeParser;
import net.sf.jsqlparser.util.deparser.UpsertDeParser;
import net.sf.jsqlparser.util.deparser.UseStatementDeParser;

public class StatementDeParser
extends AbstractDeParser<Statement>
implements StatementVisitor<StringBuilder> {
    private final ExpressionDeParser expressionDeParser;
    private final SelectDeParser selectDeParser;

    public StatementDeParser(Class<? extends ExpressionDeParser> expressionDeparserClass, Class<? extends SelectDeParser> selectDeparserClass, StringBuilder builder) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        super(builder);
        this.selectDeParser = selectDeparserClass.getConstructor(Class.class, StringBuilder.class).newInstance(expressionDeparserClass, builder);
        this.expressionDeParser = expressionDeparserClass.cast(this.selectDeParser.getExpressionVisitor());
    }

    public StatementDeParser(Class<? extends ExpressionDeParser> expressionDeparserClass, Class<? extends SelectDeParser> selectDeparserClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this(expressionDeparserClass, selectDeparserClass, new StringBuilder());
    }

    public StatementDeParser(StringBuilder buffer) {
        this(new ExpressionDeParser(), new SelectDeParser(), buffer);
    }

    public StatementDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder buffer) {
        super(buffer);
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
        this.selectDeParser.setBuffer(buffer);
        this.selectDeParser.setExpressionVisitor(expressionDeParser);
        this.expressionDeParser.setSelectVisitor(selectDeParser);
        this.expressionDeParser.setBuffer(buffer);
    }

    @Override
    public <S> StringBuilder visit(CreateIndex createIndex, S context) {
        CreateIndexDeParser createIndexDeParser = new CreateIndexDeParser(this.buffer);
        createIndexDeParser.deParse(createIndex);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(CreateTable createTable, S context) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this, this.buffer);
        createTableDeParser.deParse(createTable);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(CreateView createView, S context) {
        CreateViewDeParser createViewDeParser = new CreateViewDeParser(this.buffer);
        createViewDeParser.deParse(createView);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(RefreshMaterializedViewStatement materializedViewStatement, S context) {
        new RefreshMaterializedViewStatementDeParser(this.buffer).deParse(materializedViewStatement);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(AlterView alterView, S context) {
        AlterViewDeParser alterViewDeParser = new AlterViewDeParser(this.buffer);
        alterViewDeParser.deParse(alterView);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Delete delete, S context) {
        DeleteDeParser deleteDeParser = new DeleteDeParser(this.expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Drop drop, S context) {
        DropDeParser dropDeParser = new DropDeParser(this.buffer);
        dropDeParser.deParse(drop);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Insert insert, S context) {
        InsertDeParser insertDeParser = new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Select select, S context) {
        select.accept(this.selectDeParser, context);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Truncate truncate, S context) {
        this.buffer.append("TRUNCATE");
        if (truncate.isTableToken()) {
            this.buffer.append(" TABLE");
        }
        if (truncate.isOnly()) {
            this.buffer.append(" ONLY");
        }
        this.buffer.append(" ");
        this.buffer.append(truncate.getTable());
        if (truncate.getCascade()) {
            this.buffer.append(" CASCADE");
        }
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Update update, S context) {
        UpdateDeParser updateDeParser = new UpdateDeParser(this.expressionDeParser, this.buffer);
        updateDeParser.deParse(update);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Analyze analyzer, S context) {
        this.buffer.append("ANALYZE ");
        this.buffer.append(analyzer.getTable());
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Alter alter, S context) {
        AlterDeParser alterDeParser = new AlterDeParser(this.buffer);
        alterDeParser.deParse(alter);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Statements statements, S context) {
        statements.accept(this, context);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Execute execute, S context) {
        ExecuteDeParser executeDeParser = new ExecuteDeParser(this.expressionDeParser, this.buffer);
        executeDeParser.deParse(execute);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(SetStatement set, S context) {
        SetStatementDeParser setStatementDeparser = new SetStatementDeParser(this.expressionDeParser, this.buffer);
        setStatementDeparser.deParse(set);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(ResetStatement reset, S context) {
        ResetStatementDeParser setStatementDeparser = new ResetStatementDeParser(this.expressionDeParser, this.buffer);
        setStatementDeparser.deParse(reset);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Merge merge, S context) {
        new MergeDeParser(this.expressionDeParser, this.selectDeParser, this.buffer).deParse(merge);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(SavepointStatement savepointStatement, S context) {
        this.buffer.append(savepointStatement.toString());
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(RollbackStatement rollbackStatement, S context) {
        this.buffer.append(rollbackStatement.toString());
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Commit commit, S context) {
        this.buffer.append(commit.toString());
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Upsert upsert, S context) {
        UpsertDeParser upsertDeParser = new UpsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        upsertDeParser.deParse(upsert);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(UseStatement use, S context) {
        new UseStatementDeParser(this.buffer).deParse(use);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(ShowColumnsStatement show, S context) {
        new ShowColumnsStatementDeParser(this.buffer).deParse(show);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(ShowIndexStatement showIndexes, S context) {
        new ShowIndexStatementDeParser(this.buffer).deParse(showIndexes);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(ShowTablesStatement showTables, S context) {
        new ShowTablesStatementDeparser(this.buffer).deParse(showTables);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Block block, S context) {
        this.buffer.append("BEGIN\n");
        if (block.getStatements() != null) {
            for (Statement stmt : block.getStatements().getStatements()) {
                stmt.accept(this, context);
                this.buffer.append(";\n");
            }
        }
        this.buffer.append("END");
        if (block.hasSemicolonAfterEnd()) {
            this.buffer.append(";");
        }
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Comment comment, S context) {
        this.buffer.append(comment.toString());
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(DescribeStatement describe, S context) {
        this.buffer.append(describe.getDescribeType());
        this.buffer.append(" ");
        this.buffer.append(describe.getTable());
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(ExplainStatement explainStatement, S context) {
        this.buffer.append("EXPLAIN ");
        if (explainStatement.getTable() != null) {
            this.buffer.append(explainStatement.getTable());
        } else if (explainStatement.getOptions() != null) {
            this.buffer.append(explainStatement.getOptions().values().stream().map(ExplainStatement.Option::formatOption).collect(Collectors.joining(" ")));
            this.buffer.append(" ");
        }
        if (explainStatement.getStatement() != null) {
            explainStatement.getStatement().accept(this, context);
        }
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(ShowStatement showStatement, S context) {
        new ShowStatementDeParser(this.buffer).deParse(showStatement);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(DeclareStatement declareStatement, S context) {
        new DeclareStatementDeParser(this.expressionDeParser, this.buffer).deParse(declareStatement);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Grant grant, S context) {
        GrantDeParser grantDeParser = new GrantDeParser(this.buffer);
        grantDeParser.deParse(grant);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(CreateSchema aThis, S context) {
        this.buffer.append(aThis.toString());
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(CreateSequence createSequence, S context) {
        new CreateSequenceDeParser(this.buffer).deParse(createSequence);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(AlterSequence alterSequence, S context) {
        new AlterSequenceDeParser(this.buffer).deParse(alterSequence);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(CreateFunctionalStatement createFunctionalStatement, S context) {
        this.buffer.append(createFunctionalStatement.toString());
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(CreateSynonym createSynonym, S context) {
        new CreateSynonymDeparser(this.buffer).deParse(createSynonym);
        return this.buffer;
    }

    @Override
    void deParse(Statement statement) {
        statement.accept(this, null);
    }

    @Override
    public <S> StringBuilder visit(AlterSession alterSession, S context) {
        new AlterSessionDeParser(this.buffer).deParse(alterSession);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(IfElseStatement ifElseStatement, S context) {
        ifElseStatement.appendTo(this.buffer);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(RenameTableStatement renameTableStatement, S context) {
        renameTableStatement.appendTo(this.buffer);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(PurgeStatement purgeStatement, S context) {
        purgeStatement.appendTo(this.buffer);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(AlterSystemStatement alterSystemStatement, S context) {
        alterSystemStatement.appendTo(this.buffer);
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(UnsupportedStatement unsupportedStatement, S context) {
        unsupportedStatement.appendTo(this.buffer);
        return this.buffer;
    }

    public ExpressionDeParser getExpressionDeParser() {
        return this.expressionDeParser;
    }

    public SelectDeParser getSelectDeParser() {
        return this.selectDeParser;
    }
}

