/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.page;

import com.github.pagehelper.AutoDialect;
import com.github.pagehelper.Dialect;
import com.github.pagehelper.PageException;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.dialect.auto.C3P0AutoDialect;
import com.github.pagehelper.dialect.auto.DataSourceNegotiationAutoDialect;
import com.github.pagehelper.dialect.auto.DbcpAutoDialect;
import com.github.pagehelper.dialect.auto.DefaultAutoDialect;
import com.github.pagehelper.dialect.auto.DruidAutoDialect;
import com.github.pagehelper.dialect.auto.HikariAutoDialect;
import com.github.pagehelper.dialect.auto.TomcatAutoDialect;
import com.github.pagehelper.dialect.helper.AS400Dialect;
import com.github.pagehelper.dialect.helper.CirroDataDialect;
import com.github.pagehelper.dialect.helper.Db2Dialect;
import com.github.pagehelper.dialect.helper.FirebirdDialect;
import com.github.pagehelper.dialect.helper.HerdDBDialect;
import com.github.pagehelper.dialect.helper.HsqldbDialect;
import com.github.pagehelper.dialect.helper.InformixDialect;
import com.github.pagehelper.dialect.helper.MySqlDialect;
import com.github.pagehelper.dialect.helper.Oracle9iDialect;
import com.github.pagehelper.dialect.helper.OracleDialect;
import com.github.pagehelper.dialect.helper.OscarDialect;
import com.github.pagehelper.dialect.helper.PostgreSqlDialect;
import com.github.pagehelper.dialect.helper.SqlServer2012Dialect;
import com.github.pagehelper.dialect.helper.SqlServerDialect;
import com.github.pagehelper.util.ClassUtil;
import com.github.pagehelper.util.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;

public class PageAutoDialect {
    private static Map<String, Class<? extends Dialect>> dialectAliasMap = new LinkedHashMap<String, Class<? extends Dialect>>();
    private static Map<String, Class<? extends AutoDialect>> autoDialectMap = new LinkedHashMap<String, Class<? extends AutoDialect>>();
    private boolean autoDialect = true;
    private Properties properties;
    private Map<Object, AbstractHelperDialect> urlDialectMap = new ConcurrentHashMap<Object, AbstractHelperDialect>();
    private ReentrantLock lock = new ReentrantLock();
    private AbstractHelperDialect delegate;
    private ThreadLocal<AbstractHelperDialect> dialectThreadLocal = new ThreadLocal();
    private AutoDialect autoDialectDelegate;

    public static void registerDialectAlias(String alias, Class<? extends Dialect> dialectClass) {
        dialectAliasMap.put(alias, dialectClass);
    }

    public static void registerAutoDialectAlias(String alias, Class<? extends AutoDialect> autoDialectClass) {
        autoDialectMap.put(alias, autoDialectClass);
    }

    public static String fromJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.toLowerCase();
        for (String dialect : dialectAliasMap.keySet()) {
            if (!url.contains(":" + dialect.toLowerCase() + ":")) continue;
            return dialect;
        }
        return null;
    }

    public AbstractHelperDialect getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.dialectThreadLocal.get();
    }

    public void clearDelegate() {
        this.dialectThreadLocal.remove();
    }

    public AbstractHelperDialect getDialectThreadLocal() {
        return this.dialectThreadLocal.get();
    }

    public void setDialectThreadLocal(AbstractHelperDialect delegate) {
        this.dialectThreadLocal.set(delegate);
    }

    public static Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    public static AbstractHelperDialect instanceDialect(String dialectClass, Properties properties) {
        AbstractHelperDialect dialect;
        if (StringUtil.isEmpty(dialectClass)) {
            throw new PageException("When you use the PageHelper pagination plugin, you must set the helper property");
        }
        try {
            Class sqlDialectClass = PageAutoDialect.resloveDialectClass(dialectClass);
            if (!AbstractHelperDialect.class.isAssignableFrom(sqlDialectClass)) {
                throw new PageException("When using PageHelper, the dialect must be an implementation class that implements the " + AbstractHelperDialect.class.getCanonicalName() + " interface!");
            }
            dialect = (AbstractHelperDialect)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException("error initializing helper dialectclass[" + dialectClass + "]" + e.getMessage(), e);
        }
        dialect.setProperties(properties);
        return dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDelegateDialect(MappedStatement ms, String dialectClass) {
        if (StringUtil.isNotEmpty(dialectClass)) {
            AbstractHelperDialect dialect = this.urlDialectMap.get(dialectClass);
            if (dialect == null) {
                this.lock.lock();
                try {
                    dialect = this.urlDialectMap.get(dialectClass);
                    if (dialect == null) {
                        dialect = PageAutoDialect.instanceDialect(dialectClass, this.properties);
                        this.urlDialectMap.put(dialectClass, dialect);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.dialectThreadLocal.set(dialect);
        } else if (this.delegate == null) {
            if (this.autoDialect) {
                this.delegate = this.autoGetDialect(ms);
            } else {
                this.dialectThreadLocal.set(this.autoGetDialect(ms));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractHelperDialect autoGetDialect(MappedStatement ms) {
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        Object dialectKey = this.autoDialectDelegate.extractDialectKey(ms, dataSource, this.properties);
        if (dialectKey == null) {
            return this.autoDialectDelegate.extractDialect(dialectKey, ms, dataSource, this.properties);
        }
        if (!this.urlDialectMap.containsKey(dialectKey)) {
            this.lock.lock();
            try {
                if (!this.urlDialectMap.containsKey(dialectKey)) {
                    this.urlDialectMap.put(dialectKey, this.autoDialectDelegate.extractDialect(dialectKey, ms, dataSource, this.properties));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.urlDialectMap.get(dialectKey);
    }

    private void initAutoDialectClass(Properties properties) {
        String autoDialectClassStr = properties.getProperty("autoDialectClass");
        if (StringUtil.isNotEmpty(autoDialectClassStr)) {
            try {
                Class<Object> autoDialectClass = autoDialectMap.containsKey(autoDialectClassStr) ? autoDialectMap.get(autoDialectClassStr) : Class.forName(autoDialectClassStr);
                this.autoDialectDelegate = (AutoDialect)ClassUtil.newInstance(autoDialectClass, properties);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Make sure that the AutoDialect implementation class (" + autoDialectClassStr + ") for the autoDialectClass configuration exists!", e);
            }
            catch (Exception e) {
                throw new RuntimeException(autoDialectClassStr + "Class must provide a constructor without parameters", e);
            }
        } else {
            this.autoDialectDelegate = new DataSourceNegotiationAutoDialect();
        }
    }

    private void initDialectAlias(Properties properties) {
        String dialectAlias = properties.getProperty("dialectAlias");
        if (StringUtil.isNotEmpty(dialectAlias)) {
            String[] alias = dialectAlias.split(";");
            for (int i = 0; i < alias.length; ++i) {
                String[] kv = alias[i].split("=");
                if (kv.length != 2) {
                    throw new IllegalArgumentException("dialectAlias parameter misconfigured,Please follow alias1=xx.dialectClass; alias2=dialectClass2!");
                }
                for (int j = 0; j < kv.length; ++j) {
                    try {
                        if (dialectAliasMap.containsKey(kv[1])) {
                            PageAutoDialect.registerDialectAlias(kv[0], dialectAliasMap.get(kv[1]));
                            continue;
                        }
                        Class<?> diallectClass = Class.forName(kv[1]);
                        PageAutoDialect.registerDialectAlias(kv[0], diallectClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Make sure the Dialect implementation class configured by dialectAlias exists!", e);
                    }
                }
            }
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.initAutoDialectClass(properties);
        String useSqlserver2012 = properties.getProperty("useSqlserver2012");
        if (StringUtil.isNotEmpty(useSqlserver2012) && Boolean.parseBoolean(useSqlserver2012)) {
            PageAutoDialect.registerDialectAlias("sqlserver", SqlServer2012Dialect.class);
            PageAutoDialect.registerDialectAlias("sqlserver2008", SqlServerDialect.class);
        }
        this.initDialectAlias(properties);
        String dialect = properties.getProperty("helperDialect");
        String runtimeDialect = properties.getProperty("autoRuntimeDialect");
        if (StringUtil.isNotEmpty(runtimeDialect) && "TRUE".equalsIgnoreCase(runtimeDialect)) {
            this.autoDialect = false;
        } else if (StringUtil.isEmpty(dialect)) {
            this.autoDialect = true;
        } else {
            this.autoDialect = false;
            this.delegate = PageAutoDialect.instanceDialect(dialect, properties);
        }
    }

    static {
        PageAutoDialect.registerDialectAlias("hsqldb", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("h2", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("phoenix", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("postgresql", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias("mysql", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("mariadb", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("sqlite", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("herddb", HerdDBDialect.class);
        PageAutoDialect.registerDialectAlias("oracle", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("oracle9i", Oracle9iDialect.class);
        PageAutoDialect.registerDialectAlias("db2", Db2Dialect.class);
        PageAutoDialect.registerDialectAlias("as400", AS400Dialect.class);
        PageAutoDialect.registerDialectAlias("informix", InformixDialect.class);
        PageAutoDialect.registerDialectAlias("informix-sqli", InformixDialect.class);
        PageAutoDialect.registerDialectAlias("sqlserver", SqlServerDialect.class);
        PageAutoDialect.registerDialectAlias("sqlserver2012", SqlServer2012Dialect.class);
        PageAutoDialect.registerDialectAlias("derby", SqlServer2012Dialect.class);
        PageAutoDialect.registerDialectAlias("dm", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("edb", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("oscar", OscarDialect.class);
        PageAutoDialect.registerDialectAlias("clickhouse", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("highgo", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("xugu", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("impala", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("firebirdsql", FirebirdDialect.class);
        PageAutoDialect.registerDialectAlias("kingbase", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias("kingbase8", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias("xcloud", CirroDataDialect.class);
        PageAutoDialect.registerDialectAlias("opengauss", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias("sundb", OracleDialect.class);
        PageAutoDialect.registerAutoDialectAlias("old", DefaultAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("hikari", HikariAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("druid", DruidAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("tomcat-jdbc", TomcatAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("dbcp", DbcpAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("c3p0", C3P0AutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("default", DataSourceNegotiationAutoDialect.class);
    }
}

