/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type.seq;

import com.googlecode.aviator.runtime.type.Collector;
import com.googlecode.aviator.runtime.type.seq.AbstractSequence;
import com.googlecode.aviator.runtime.type.seq.ArrayCollector;
import com.googlecode.aviator.runtime.type.seq.ListCollector;
import java.lang.reflect.Array;
import java.util.Iterator;

public class ArraySequence
extends AbstractSequence<Object> {
    private final Object a;
    private final int len;

    @Override
    public int hintSize() {
        return this.len;
    }

    @Override
    public Collector newCollector(int size) {
        if (size <= 0) {
            return new ListCollector(true);
        }
        return new ArrayCollector(size);
    }

    public ArraySequence(Object a) {
        this.a = a;
        this.len = Array.getLength(a);
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ArraySequence.this.len;
            }

            @Override
            public Object next() {
                return Array.get(ArraySequence.this.a, this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

