/*
 * <summary></summary>
 * <author>He Han</author>
 * <email>hankcs.cn@gmail.com</email>
 * <create-date>2014/9/10 14:47</create-date>
 *
 * <copyright file="PersonDictionary.java" company="上海林原信息科技有限公司">
 * Copyright (c) 2003-2014, 上海林原信息科技有限公司. All Right Reserved, http://www.linrunsoft.com/
 * This source is subject to the LinrunSpace License. Please contact 上海林原信息科技有限公司 to get more information.
 * </copyright>
 */
package com.hankcs.hanlp.dictionary.nt;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.NT;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.TransformMatrixDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import com.hankcs.hanlp.utility.Predefine;

import java.util.List;
import java.util.TreeMap;

import static com.hankcs.hanlp.utility.Predefine.logger;

/**
 * 机构名识别用的词典，实际上是对两个词典的包装
 *
 * @author hankcs
 */
public class OrganizationDictionary
{
    /**
     * 机构名词典
     */
    public static NTDictionary dictionary;
    /**
     * 转移矩阵词典
     */
    public static TransformMatrixDictionary<NT> transformMatrixDictionary;
    /**
     * AC算法用到的Trie树
     */
    public static AhoCorasickDoubleArrayTrie<String> trie;
    /**
     * 本词典专注的词的ID
     */
    static final int WORD_ID = CoreDictionary.getWordID(Predefine.TAG_GROUP);
    /**
     * 本词典专注的词的属性
     */
    static final CoreDictionary.Attribute ATTRIBUTE = CoreDictionary.get(WORD_ID);

    private static void addKeyword(TreeMap<String, String> patternMap, String keyword)
    {
        patternMap.put(keyword, keyword);
    }
    static
    {
        long start = System.currentTimeMillis();
        dictionary = new NTDictionary();
        dictionary.load(HanLP.Config.OrganizationDictionaryPath);
        logger.info(HanLP.Config.OrganizationDictionaryPath + "加载成功，耗时" + (System.currentTimeMillis() - start) + "ms");
        transformMatrixDictionary = new TransformMatrixDictionary<NT>(NT.class);
        transformMatrixDictionary.load(HanLP.Config.OrganizationDictionaryTrPath);
        trie = new AhoCorasickDoubleArrayTrie<String>();
        TreeMap<String, String> patternMap = new TreeMap<String, String>();
        addKeyword(patternMap, "CCCCCCCCD");
        addKeyword(patternMap, "CCCCCCCD");
        addKeyword(patternMap, "CCCCCCD");
        addKeyword(patternMap, "CCCCCCGD");
        addKeyword(patternMap, "CCCCCCICCCCD");
        addKeyword(patternMap, "CCCCCCPD");
        addKeyword(patternMap, "CCCCCD");
        addKeyword(patternMap, "CCCCCDD");
        addKeyword(patternMap, "CCCCCGCCD");
        addKeyword(patternMap, "CCCCCICCCCCD");
        addKeyword(patternMap, "CCCCCPCCD");
        addKeyword(patternMap, "CCCCCWDWD");
        addKeyword(patternMap, "CCCCD");
        addKeyword(patternMap, "CCCCDCCD");
        addKeyword(patternMap, "CCCCDCD");
        addKeyword(patternMap, "CCCCDD");
        addKeyword(patternMap, "CCCCID");
        addKeyword(patternMap, "CCCCPCD");
        addKeyword(patternMap, "CCCD");
        addKeyword(patternMap, "CCCDCCCD");
        addKeyword(patternMap, "CCCDCCD");
        addKeyword(patternMap, "CCCDCD");
        addKeyword(patternMap, "CCCDD");
        addKeyword(patternMap, "CCCDICFPD");
        addKeyword(patternMap, "CCCFCFFCD");
        addKeyword(patternMap, "CCCGD");
        addKeyword(patternMap, "CCCGID");
        addKeyword(patternMap, "CCCGJCD");
        addKeyword(patternMap, "CCCID");
        addKeyword(patternMap, "CCCJCCD");
        addKeyword(patternMap, "CCCJD");
        addKeyword(patternMap, "CCCLGCD");
        addKeyword(patternMap, "CCCMD");
        addKeyword(patternMap, "CCCPCCCD");
        addKeyword(patternMap, "CCCPCCD");
        addKeyword(patternMap, "CCCPCD");
        addKeyword(patternMap, "CCCPD");
        addKeyword(patternMap, "CCD");
        addKeyword(patternMap, "CCDCCCCCCD");
        addKeyword(patternMap, "CCDCCCCD");
        addKeyword(patternMap, "CCDCCCD");
        addKeyword(patternMap, "CCDCCCDD");
        addKeyword(patternMap, "CCDCCD");
        addKeyword(patternMap, "CCDCD");
        addKeyword(patternMap, "CCDCDD");
        addKeyword(patternMap, "CCDCGCD");
        addKeyword(patternMap, "CCDCGCDID");
        addKeyword(patternMap, "CCDCGCDPD");
        addKeyword(patternMap, "CCDCGGDD");
        addKeyword(patternMap, "CCDCID");
        addKeyword(patternMap, "CCDCJCCD");
        addKeyword(patternMap, "CCDCJCCDD");
        addKeyword(patternMap, "CCDD");
        addKeyword(patternMap, "CCDDD");
        addKeyword(patternMap, "CCDFIDGD");
        addKeyword(patternMap, "CCDGCCD");
        addKeyword(patternMap, "CCDICD");
        addKeyword(patternMap, "CCDID");
        addKeyword(patternMap, "CCDJCD");
        addKeyword(patternMap, "CCDPCD");
        addKeyword(patternMap, "CCDPJD");
        addKeyword(patternMap, "CCFCCD");
        addKeyword(patternMap, "CCFD");
        addKeyword(patternMap, "CCGCCCD");
        addKeyword(patternMap, "CCGCCD");
        addKeyword(patternMap, "CCGCD");
        addKeyword(patternMap, "CCGCDCD");
        addKeyword(patternMap, "CCGCDCMD");
        addKeyword(patternMap, "CCGD");
        addKeyword(patternMap, "CCGGCD");
        addKeyword(patternMap, "CCGID");
        addKeyword(patternMap, "CCGIDD");
        addKeyword(patternMap, "CCGJD");
        addKeyword(patternMap, "CCGWGWD");
        addKeyword(patternMap, "CCICCD");
        addKeyword(patternMap, "CCICD");
        addKeyword(patternMap, "CCICIFD");
        addKeyword(patternMap, "CCICJPD");
        addKeyword(patternMap, "CCID");
        addKeyword(patternMap, "CCIDCD");
        addKeyword(patternMap, "CCIDD");
        addKeyword(patternMap, "CCIID");
        addKeyword(patternMap, "CCJCCCD");
        addKeyword(patternMap, "CCJCCD");
        addKeyword(patternMap, "CCJCD");
        addKeyword(patternMap, "CCJCFD");
        addKeyword(patternMap, "CCJD");
        addKeyword(patternMap, "CCJID");
        addKeyword(patternMap, "CCJJMJD");
        addKeyword(patternMap, "CCKID");
        addKeyword(patternMap, "CCLD");
        addKeyword(patternMap, "CCMD");
        addKeyword(patternMap, "CCMMPDCD");
        addKeyword(patternMap, "CCPCCD");
        addKeyword(patternMap, "CCPCD");
        addKeyword(patternMap, "CCPD");
        addKeyword(patternMap, "CCPDCD");
        addKeyword(patternMap, "CCPPD");
        addKeyword(patternMap, "CCWCWD");
        addKeyword(patternMap, "CCWGWCCD");
        addKeyword(patternMap, "CCWGWD");
        addKeyword(patternMap, "CD");
        addKeyword(patternMap, "CDCCCCCCD");
        addKeyword(patternMap, "CDCCCCD");
        addKeyword(patternMap, "CDCCCD");
        addKeyword(patternMap, "CDCCD");
        addKeyword(patternMap, "CDCCDD");
        addKeyword(patternMap, "CDCCJD");
        addKeyword(patternMap, "CDCD");
        addKeyword(patternMap, "CDCDD");
        addKeyword(patternMap, "CDCGD");
        addKeyword(patternMap, "CDCGPCCD");
        addKeyword(patternMap, "CDCJD");
        addKeyword(patternMap, "CDCLD");
        addKeyword(patternMap, "CDCWIWD");
        addKeyword(patternMap, "CDD");
        addKeyword(patternMap, "CDDCCD");
        addKeyword(patternMap, "CDDCCDD");
        addKeyword(patternMap, "CDDCD");
        addKeyword(patternMap, "CDDD");
        addKeyword(patternMap, "CDFD");
        addKeyword(patternMap, "CDFPCCD");
        addKeyword(patternMap, "CDGCD");
        addKeyword(patternMap, "CDGCICD");
        addKeyword(patternMap, "CDGD");
        addKeyword(patternMap, "CDICD");
        addKeyword(patternMap, "CDID");
        addKeyword(patternMap, "CDILLCCD");
        addKeyword(patternMap, "CDJCCD");
        addKeyword(patternMap, "CDJCD");
        addKeyword(patternMap, "CDJD");
        addKeyword(patternMap, "CDJLD");
        addKeyword(patternMap, "CDLGCD");
        addKeyword(patternMap, "CDLJD");
        addKeyword(patternMap, "CDMCD");
        addKeyword(patternMap, "CDPCCCCD");
        addKeyword(patternMap, "CDPCCD");
        addKeyword(patternMap, "CDPD");
        addKeyword(patternMap, "CDPPD");
        addKeyword(patternMap, "CFCCD");
        addKeyword(patternMap, "CFCPD");
        addKeyword(patternMap, "CFD");
        addKeyword(patternMap, "CFPD");
        addKeyword(patternMap, "CGCCCD");
        addKeyword(patternMap, "CGCCD");
        addKeyword(patternMap, "CGCD");
        addKeyword(patternMap, "CGCDCD");
        addKeyword(patternMap, "CGCDD");
        addKeyword(patternMap, "CGD");
        addKeyword(patternMap, "CGDCD");
        addKeyword(patternMap, "CGDD");
        addKeyword(patternMap, "CGDDCCD");
        addKeyword(patternMap, "CGDDD");
        addKeyword(patternMap, "CGDDID");
        addKeyword(patternMap, "CGDJD");
        addKeyword(patternMap, "CGDMD");
        addKeyword(patternMap, "CGFD");
        addKeyword(patternMap, "CGGCCCD");
        addKeyword(patternMap, "CGGCCD");
        addKeyword(patternMap, "CGGCD");
        addKeyword(patternMap, "CGGD");
        addKeyword(patternMap, "CGGGD");
        addKeyword(patternMap, "CGGGDD");
        addKeyword(patternMap, "CGGICD");
        addKeyword(patternMap, "CGGJD");
        addKeyword(patternMap, "CGICD");
        addKeyword(patternMap, "CGID");
        addKeyword(patternMap, "CGIJD");
        addKeyword(patternMap, "CGJD");
        addKeyword(patternMap, "CGMD");
        addKeyword(patternMap, "CGPJD");
        addKeyword(patternMap, "CICCCCD");
        addKeyword(patternMap, "CICCD");
        addKeyword(patternMap, "CICD");
        addKeyword(patternMap, "CICDCD");
        addKeyword(patternMap, "CICDD");
        addKeyword(patternMap, "CICWGWD");
        addKeyword(patternMap, "CID");
        addKeyword(patternMap, "CIDD");
        addKeyword(patternMap, "CIGCD");
        addKeyword(patternMap, "CIGD");
        addKeyword(patternMap, "CIID");
        addKeyword(patternMap, "CILCD");
        addKeyword(patternMap, "CIMD");
        addKeyword(patternMap, "CJCCCCCD");
        addKeyword(patternMap, "CJCCCD");
        addKeyword(patternMap, "CJCCCDD");
        addKeyword(patternMap, "CJCCD");
        addKeyword(patternMap, "CJCCMD");
        addKeyword(patternMap, "CJCD");
        addKeyword(patternMap, "CJCDD");
        addKeyword(patternMap, "CJCGCCD");
        addKeyword(patternMap, "CJCGPJD");
        addKeyword(patternMap, "CJCMD");
        addKeyword(patternMap, "CJCPCCCD");
        addKeyword(patternMap, "CJCPD");
        addKeyword(patternMap, "CJD");
        addKeyword(patternMap, "CJDCCCCD");
        addKeyword(patternMap, "CJDCCJD");
        addKeyword(patternMap, "CJDCD");
        addKeyword(patternMap, "CJDD");
        addKeyword(patternMap, "CJDFD");
        addKeyword(patternMap, "CJDPD");
        addKeyword(patternMap, "CJFCD");
        addKeyword(patternMap, "CJFD");
        addKeyword(patternMap, "CJGD");
        addKeyword(patternMap, "CJGLD");
        addKeyword(patternMap, "CJGPCJD");
        addKeyword(patternMap, "CJID");
        addKeyword(patternMap, "CJJCCD");
        addKeyword(patternMap, "CJJD");
        addKeyword(patternMap, "CJJJD");
        addKeyword(patternMap, "CJJLD");
        addKeyword(patternMap, "CJKD");
        addKeyword(patternMap, "CJLCCD");
        addKeyword(patternMap, "CJMCD");
        addKeyword(patternMap, "CJMD");
        addKeyword(patternMap, "CJPD");
        addKeyword(patternMap, "CJWCCWCGJD");
        addKeyword(patternMap, "CJWD");
        addKeyword(patternMap, "CJWPMWCGD");
        addKeyword(patternMap, "CKCD");
        addKeyword(patternMap, "CKD");
        addKeyword(patternMap, "CKJCDCD");
        addKeyword(patternMap, "CKJPD");
        addKeyword(patternMap, "CLCCCD");
        addKeyword(patternMap, "CLCCD");
        addKeyword(patternMap, "CLCCGCD");
        addKeyword(patternMap, "CLCD");
        addKeyword(patternMap, "CLD");
        addKeyword(patternMap, "CLDFD");
        addKeyword(patternMap, "CLID");
        addKeyword(patternMap, "CLPCD");
        addKeyword(patternMap, "CMCD");
        addKeyword(patternMap, "CMCDD");
        addKeyword(patternMap, "CMCGD");
        addKeyword(patternMap, "CMD");
        addKeyword(patternMap, "CMDCD");
        addKeyword(patternMap, "CMDD");
        addKeyword(patternMap, "CMMD");
        addKeyword(patternMap, "CMMDCCD");
        addKeyword(patternMap, "CMPD");
        addKeyword(patternMap, "CPCCCCCCCD");
        addKeyword(patternMap, "CPCCCCD");
        addKeyword(patternMap, "CPCCCD");
        addKeyword(patternMap, "CPCCD");
        addKeyword(patternMap, "CPCD");
        addKeyword(patternMap, "CPCDD");
        addKeyword(patternMap, "CPCPD");
        addKeyword(patternMap, "CPD");
        addKeyword(patternMap, "CPDCCD");
        addKeyword(patternMap, "CPDCD");
        addKeyword(patternMap, "CPDD");
        addKeyword(patternMap, "CPDGD");
        addKeyword(patternMap, "CPDWGWD");
        addKeyword(patternMap, "CPGCD");
        addKeyword(patternMap, "CPGD");
        addKeyword(patternMap, "CPID");
        addKeyword(patternMap, "CPJCD");
        addKeyword(patternMap, "CPJD");
        addKeyword(patternMap, "CPJPD");
        addKeyword(patternMap, "CPMD");
        addKeyword(patternMap, "CPPD");
        addKeyword(patternMap, "CWCD");
        addKeyword(patternMap, "CWCGWCCD");
        addKeyword(patternMap, "CWCWD");
        addKeyword(patternMap, "CWDWDD");
        addKeyword(patternMap, "CWGWCCD");
        addKeyword(patternMap, "CWGWCD");
        addKeyword(patternMap, "CWPWD");
        addKeyword(patternMap, "DCCCCCD");
        addKeyword(patternMap, "DCCCCD");
        addKeyword(patternMap, "DCCCCDCCD");
        addKeyword(patternMap, "DCCCD");
        addKeyword(patternMap, "DCCD");
        addKeyword(patternMap, "DCD");
        addKeyword(patternMap, "DCDD");
        addKeyword(patternMap, "DCGCD");
        addKeyword(patternMap, "DCJD");
        addKeyword(patternMap, "DCPD");
        addKeyword(patternMap, "DD");
        addKeyword(patternMap, "DDCCD");
        addKeyword(patternMap, "DDCD");
        addKeyword(patternMap, "DDD");
        addKeyword(patternMap, "DDICCD");
        addKeyword(patternMap, "DFD");
        addKeyword(patternMap, "DGCCD");
        addKeyword(patternMap, "DGCD");
//        addKeyword(patternMap, "DGD");
        addKeyword(patternMap, "DGDCD");
        addKeyword(patternMap, "DGDD");
        addKeyword(patternMap, "DGDPD");
        addKeyword(patternMap, "DGGD");
        addKeyword(patternMap, "DICCCD");
        addKeyword(patternMap, "DICD");
        addKeyword(patternMap, "DID");
        addKeyword(patternMap, "DIICD");
        addKeyword(patternMap, "DJCCD");
        addKeyword(patternMap, "DJCD");
        addKeyword(patternMap, "DJD");
        addKeyword(patternMap, "DLCCD");
        addKeyword(patternMap, "DLCD");
        addKeyword(patternMap, "DLD");
        addKeyword(patternMap, "DMCD");
        addKeyword(patternMap, "DMD");
        addKeyword(patternMap, "DMMCD");
        addKeyword(patternMap, "DPD");
        addKeyword(patternMap, "DPMMCCD");
        addKeyword(patternMap, "FCCCCCD");
        addKeyword(patternMap, "FCCCCD");
        addKeyword(patternMap, "FCCCD");
        addKeyword(patternMap, "FCCCPCD");
        addKeyword(patternMap, "FCCD");
        addKeyword(patternMap, "FCCGD");
        addKeyword(patternMap, "FCCID");
        addKeyword(patternMap, "FCCPD");
        addKeyword(patternMap, "FCCWGWD");
        addKeyword(patternMap, "FCD");
        addKeyword(patternMap, "FCDCD");
        addKeyword(patternMap, "FCDD");
        addKeyword(patternMap, "FCDFD");
        addKeyword(patternMap, "FCFCD");
        addKeyword(patternMap, "FCFPD");
        addKeyword(patternMap, "FCGCCD");
        addKeyword(patternMap, "FCGCD");
        addKeyword(patternMap, "FCGD");
        addKeyword(patternMap, "FCID");
        addKeyword(patternMap, "FCIJJD");
        addKeyword(patternMap, "FCJCD");
        addKeyword(patternMap, "FCJD");
        addKeyword(patternMap, "FCPD");
        addKeyword(patternMap, "FCPGCD");
        addKeyword(patternMap, "FCWGWD");
        addKeyword(patternMap, "FD");
        addKeyword(patternMap, "FDCD");
        addKeyword(patternMap, "FDD");
        addKeyword(patternMap, "FDFD");
        addKeyword(patternMap, "FDGCCD");
        addKeyword(patternMap, "FDID");
        addKeyword(patternMap, "FDLCD");
        addKeyword(patternMap, "FFCCD");
        addKeyword(patternMap, "FFCD");
        addKeyword(patternMap, "FFCKFCCD");
        addKeyword(patternMap, "FFCLLD");
        addKeyword(patternMap, "FFD");
        addKeyword(patternMap, "FFFD");
        addKeyword(patternMap, "FFGCCD");
        addKeyword(patternMap, "FFGD");
        addKeyword(patternMap, "FFJCD");
        addKeyword(patternMap, "FFJD");
        addKeyword(patternMap, "FFJPCD");
        addKeyword(patternMap, "FFPD");
        addKeyword(patternMap, "FGCCD");
        addKeyword(patternMap, "FGCD");
        addKeyword(patternMap, "FGCGCGCJCD");
        addKeyword(patternMap, "FGD");
        addKeyword(patternMap, "FGDD");
        addKeyword(patternMap, "FGFD");
        addKeyword(patternMap, "FGJCCD");
        addKeyword(patternMap, "FICCD");
        addKeyword(patternMap, "FICD");
        addKeyword(patternMap, "FICDD");
        addKeyword(patternMap, "FICGD");
        addKeyword(patternMap, "FICID");
        addKeyword(patternMap, "FID");
        addKeyword(patternMap, "FIDCD");
        addKeyword(patternMap, "FIDD");
        addKeyword(patternMap, "FIFPD");
        addKeyword(patternMap, "FIID");
        addKeyword(patternMap, "FIJCD");
        addKeyword(patternMap, "FIJD");
        addKeyword(patternMap, "FJCCD");
        addKeyword(patternMap, "FJCD");
        addKeyword(patternMap, "FJCDD");
        addKeyword(patternMap, "FJD");
        addKeyword(patternMap, "FJDCD");
        addKeyword(patternMap, "FJDD");
        addKeyword(patternMap, "FJGD");
        addKeyword(patternMap, "FJJCCD");
        addKeyword(patternMap, "FJJCD");
        addKeyword(patternMap, "FJJCLCD");
        addKeyword(patternMap, "FJJD");
        addKeyword(patternMap, "FJJJCCD");
        addKeyword(patternMap, "FJJJD");
        addKeyword(patternMap, "FJJJICCD");
        addKeyword(patternMap, "FJJLJLCD");
        addKeyword(patternMap, "FJPJD");
        addKeyword(patternMap, "FKCD");
        addKeyword(patternMap, "FKCJD");
        addKeyword(patternMap, "FLD");
        addKeyword(patternMap, "FLPCD");
        addKeyword(patternMap, "FPCCCD");
        addKeyword(patternMap, "FPCD");
        addKeyword(patternMap, "FPD");
        addKeyword(patternMap, "FPFD");
        addKeyword(patternMap, "FPFDD");
        addKeyword(patternMap, "FPID");
        addKeyword(patternMap, "FPJCCD");
        addKeyword(patternMap, "FPJCD");
        addKeyword(patternMap, "FPPCD");
        addKeyword(patternMap, "FPPD");
        addKeyword(patternMap, "FPPDLD");
        addKeyword(patternMap, "FWCCCWCD");
        addKeyword(patternMap, "FWCCCWD");
        addKeyword(patternMap, "FWDWD");
        addKeyword(patternMap, "FWFD");
        addKeyword(patternMap, "FWFWCCCWD");
        addKeyword(patternMap, "FWGJCD");
        addKeyword(patternMap, "FWGWCD");
        addKeyword(patternMap, "GCCCCCCCD");
        addKeyword(patternMap, "GCCCCCCD");
        addKeyword(patternMap, "GCCCCCD");
        addKeyword(patternMap, "GCCCCCDCD");
        addKeyword(patternMap, "GCCCCCDD");
        addKeyword(patternMap, "GCCCCD");
        addKeyword(patternMap, "GCCCCDCCD");
        addKeyword(patternMap, "GCCCCDD");
        addKeyword(patternMap, "GCCCCGD");
        addKeyword(patternMap, "GCCCCJD");
        addKeyword(patternMap, "GCCCCPD");
        addKeyword(patternMap, "GCCCCWDWD");
        addKeyword(patternMap, "GCCCD");
        addKeyword(patternMap, "GCCCDCCCD");
        addKeyword(patternMap, "GCCCDCCCDD");
        addKeyword(patternMap, "GCCCDCCD");
        addKeyword(patternMap, "GCCCDCD");
        addKeyword(patternMap, "GCCCDD");
        addKeyword(patternMap, "GCCCDDJD");
        addKeyword(patternMap, "GCCCDID");
        addKeyword(patternMap, "GCCCDMCD");
        addKeyword(patternMap, "GCCCDPD");
        addKeyword(patternMap, "GCCCDWGCDWD");
        addKeyword(patternMap, "GCCCFCD");
        addKeyword(patternMap, "GCCCGD");
        addKeyword(patternMap, "GCCCICD");
        addKeyword(patternMap, "GCCCID");
        addKeyword(patternMap, "GCCCJCD");
        addKeyword(patternMap, "GCCCJD");
        addKeyword(patternMap, "GCCCJGD");
        addKeyword(patternMap, "GCCCLD");
        addKeyword(patternMap, "GCCCMD");
        addKeyword(patternMap, "GCCCPCCD");
        addKeyword(patternMap, "GCCCWDWD");
        addKeyword(patternMap, "GCCD");
        addKeyword(patternMap, "GCCDCCCCD");
        addKeyword(patternMap, "GCCDCCCD");
        addKeyword(patternMap, "GCCDCCCDCD");
        addKeyword(patternMap, "GCCDCCD");
        addKeyword(patternMap, "GCCDCD");
        addKeyword(patternMap, "GCCDCID");
        addKeyword(patternMap, "GCCDCJCD");
        addKeyword(patternMap, "GCCDCPCD");
        addKeyword(patternMap, "GCCDD");
        addKeyword(patternMap, "GCCDDCCCD");
        addKeyword(patternMap, "GCCDDCCD");
        addKeyword(patternMap, "GCCDDD");
        addKeyword(patternMap, "GCCDFD");
        addKeyword(patternMap, "GCCDGCCD");
        addKeyword(patternMap, "GCCDGD");
        addKeyword(patternMap, "GCCDGGDCD");
        addKeyword(patternMap, "GCCDID");
        addKeyword(patternMap, "GCCDJCD");
        addKeyword(patternMap, "GCCDJD");
        addKeyword(patternMap, "GCCDLDD");
        addKeyword(patternMap, "GCCDLJCD");
        addKeyword(patternMap, "GCCDMJD");
        addKeyword(patternMap, "GCCDMJMMCD");
        addKeyword(patternMap, "GCCDMJMMD");
        addKeyword(patternMap, "GCCDMMD");
        addKeyword(patternMap, "GCCDPD");
        addKeyword(patternMap, "GCCFCD");
        addKeyword(patternMap, "GCCFDD");
        addKeyword(patternMap, "GCCFJPD");
        addKeyword(patternMap, "GCCFPD");
        addKeyword(patternMap, "GCCGCCCD");
        addKeyword(patternMap, "GCCGCCD");
        addKeyword(patternMap, "GCCGCD");
        addKeyword(patternMap, "GCCGCDD");
        addKeyword(patternMap, "GCCGD");
        addKeyword(patternMap, "GCCGGCGD");
        addKeyword(patternMap, "GCCGGDD");
        addKeyword(patternMap, "GCCICCDCCD");
        addKeyword(patternMap, "GCCICD");
        addKeyword(patternMap, "GCCID");
        addKeyword(patternMap, "GCCIDD");
        addKeyword(patternMap, "GCCJCCCD");
        addKeyword(patternMap, "GCCJCCCID");
        addKeyword(patternMap, "GCCJCCD");
        addKeyword(patternMap, "GCCJCD");
        addKeyword(patternMap, "GCCJCJD");
        addKeyword(patternMap, "GCCJD");
        addKeyword(patternMap, "GCCJICD");
        addKeyword(patternMap, "GCCJID");
        addKeyword(patternMap, "GCCJPCD");
        addKeyword(patternMap, "GCCJPD");
        addKeyword(patternMap, "GCCKD");
        addKeyword(patternMap, "GCCLCCD");
        addKeyword(patternMap, "GCCLCD");
        addKeyword(patternMap, "GCCLCGCD");
        addKeyword(patternMap, "GCCLD");
        addKeyword(patternMap, "GCCMCD");
        addKeyword(patternMap, "GCCMD");
        addKeyword(patternMap, "GCCMPD");
        addKeyword(patternMap, "GCCPCCCCD");
        addKeyword(patternMap, "GCCPCCCID");
        addKeyword(patternMap, "GCCPCCD");
        addKeyword(patternMap, "GCCPCD");
        addKeyword(patternMap, "GCCPD");
        addKeyword(patternMap, "GCCPDD");
        addKeyword(patternMap, "GCCPFWCJD");
        addKeyword(patternMap, "GCCPJD");
        addKeyword(patternMap, "GCCWCCWCD");
        addKeyword(patternMap, "GCCWCDWCD");
        addKeyword(patternMap, "GCCWDWCCD");
        addKeyword(patternMap, "GCCWDWD");
        addKeyword(patternMap, "GCD");
        addKeyword(patternMap, "GCDCCCCD");
        addKeyword(patternMap, "GCDCCCCPD");
        addKeyword(patternMap, "GCDCCCD");
        addKeyword(patternMap, "GCDCCD");
        addKeyword(patternMap, "GCDCCDCD");
        addKeyword(patternMap, "GCDCCDD");
        addKeyword(patternMap, "GCDCCDID");
        addKeyword(patternMap, "GCDCCJCD");
        addKeyword(patternMap, "GCDCCJD");
        addKeyword(patternMap, "GCDCD");
        addKeyword(patternMap, "GCDCDD");
        addKeyword(patternMap, "GCDCDICD");
        addKeyword(patternMap, "GCDCGCD");
        addKeyword(patternMap, "GCDCGD");
        addKeyword(patternMap, "GCDCGMCD");
        addKeyword(patternMap, "GCDCID");
        addKeyword(patternMap, "GCDCJCD");
        addKeyword(patternMap, "GCDCJD");
        addKeyword(patternMap, "GCDCLDD");
        addKeyword(patternMap, "GCDCMCD");
        addKeyword(patternMap, "GCDCMD");
        addKeyword(patternMap, "GCDCMDCD");
        addKeyword(patternMap, "GCDCMDD");
        addKeyword(patternMap, "GCDCMDID");
        addKeyword(patternMap, "GCDCPD");
        addKeyword(patternMap, "GCDD");
        addKeyword(patternMap, "GCDDCD");
        addKeyword(patternMap, "GCDDD");
        addKeyword(patternMap, "GCDDMCD");
        addKeyword(patternMap, "GCDFD");
        addKeyword(patternMap, "GCDFGCD");
        addKeyword(patternMap, "GCDFWFD");
        addKeyword(patternMap, "GCDGCCCCCD");
        addKeyword(patternMap, "GCDGCCD");
        addKeyword(patternMap, "GCDGCD");
        addKeyword(patternMap, "GCDGD");
        addKeyword(patternMap, "GCDGDD");
        addKeyword(patternMap, "GCDGGD");
        addKeyword(patternMap, "GCDGLCCD");
        addKeyword(patternMap, "GCDGLJPCD");
        addKeyword(patternMap, "GCDICCCCD");
        addKeyword(patternMap, "GCDICCD");
        addKeyword(patternMap, "GCDICD");
        addKeyword(patternMap, "GCDID");
        addKeyword(patternMap, "GCDIDD");
        addKeyword(patternMap, "GCDJCCD");
        addKeyword(patternMap, "GCDJCD");
        addKeyword(patternMap, "GCDJCDGPD");
        addKeyword(patternMap, "GCDJD");
        addKeyword(patternMap, "GCDJJD");
        addKeyword(patternMap, "GCDKCDCD");
        addKeyword(patternMap, "GCDLCCCD");
        addKeyword(patternMap, "GCDLD");
        addKeyword(patternMap, "GCDLGCCCCD");
        addKeyword(patternMap, "GCDLGCD");
        addKeyword(patternMap, "GCDLPD");
        addKeyword(patternMap, "GCDMCD");
        addKeyword(patternMap, "GCDMCDD");
        addKeyword(patternMap, "GCDMD");
        addKeyword(patternMap, "GCDMDD");
        addKeyword(patternMap, "GCDMJD");
        addKeyword(patternMap, "GCDPCD");
        addKeyword(patternMap, "GCDPD");
        addKeyword(patternMap, "GCDWFWD");
        addKeyword(patternMap, "GCDWGWCD");
        addKeyword(patternMap, "GCDWGWD");
        addKeyword(patternMap, "GCFCCD");
        addKeyword(patternMap, "GCFCCJFGDD");
        addKeyword(patternMap, "GCFCD");
        addKeyword(patternMap, "GCFD");
        addKeyword(patternMap, "GCFDD");
        addKeyword(patternMap, "GCFFD");
        addKeyword(patternMap, "GCFID");
        addKeyword(patternMap, "GCFJCCD");
        addKeyword(patternMap, "GCFPCD");
        addKeyword(patternMap, "GCFPD");
        addKeyword(patternMap, "GCFWGCCD");
        addKeyword(patternMap, "GCFWGCCDD");
        addKeyword(patternMap, "GCFWGJCD");
        addKeyword(patternMap, "GCGCCCD");
        addKeyword(patternMap, "GCGCCD");
        addKeyword(patternMap, "GCGCD");
        addKeyword(patternMap, "GCGCID");
        addKeyword(patternMap, "GCGCLD");
        addKeyword(patternMap, "GCGCPPCCD");
        addKeyword(patternMap, "GCGD");
        addKeyword(patternMap, "GCGDD");
        addKeyword(patternMap, "GCGGCD");
        addKeyword(patternMap, "GCGGCGD");
        addKeyword(patternMap, "GCGGD");
        addKeyword(patternMap, "GCGICD");
        addKeyword(patternMap, "GCGID");
        addKeyword(patternMap, "GCGJCCD");
        addKeyword(patternMap, "GCGPCCD");
        addKeyword(patternMap, "GCICCCCD");
        addKeyword(patternMap, "GCICCCD");
        addKeyword(patternMap, "GCICCD");
        addKeyword(patternMap, "GCICD");
        addKeyword(patternMap, "GCICDD");
        addKeyword(patternMap, "GCID");
        addKeyword(patternMap, "GCIDD");
        addKeyword(patternMap, "GCIDID");
        addKeyword(patternMap, "GCIFCCD");
        addKeyword(patternMap, "GCIID");
        addKeyword(patternMap, "GCIJCD");
        addKeyword(patternMap, "GCIJD");
        addKeyword(patternMap, "GCIJICD");
        addKeyword(patternMap, "GCIPCD");
        addKeyword(patternMap, "GCIPD");
        addKeyword(patternMap, "GCIWGIIWD");
        addKeyword(patternMap, "GCJCCCCD");
        addKeyword(patternMap, "GCJCCCD");
        addKeyword(patternMap, "GCJCCD");
        addKeyword(patternMap, "GCJCD");
        addKeyword(patternMap, "GCJCGD");
        addKeyword(patternMap, "GCJCID");
        addKeyword(patternMap, "GCJCIID");
        addKeyword(patternMap, "GCJCPD");
        addKeyword(patternMap, "GCJD");
        addKeyword(patternMap, "GCJDCCD");
        addKeyword(patternMap, "GCJDCD");
        addKeyword(patternMap, "GCJDD");
        addKeyword(patternMap, "GCJDID");
        addKeyword(patternMap, "GCJFD");
        addKeyword(patternMap, "GCJGD");
        addKeyword(patternMap, "GCJICD");
        addKeyword(patternMap, "GCJID");
        addKeyword(patternMap, "GCJJCCD");
        addKeyword(patternMap, "GCJJCD");
        addKeyword(patternMap, "GCJJD");
        addKeyword(patternMap, "GCJJGD");
        addKeyword(patternMap, "GCJKCD");
        addKeyword(patternMap, "GCJLCCD");
        addKeyword(patternMap, "GCJMD");
        addKeyword(patternMap, "GCJPCCGJLFD");
        addKeyword(patternMap, "GCJPD");
        addKeyword(patternMap, "GCJWCCJCD");
        addKeyword(patternMap, "GCKCCD");
        addKeyword(patternMap, "GCKD");
        addKeyword(patternMap, "GCLCCCD");
        addKeyword(patternMap, "GCLCCD");
        addKeyword(patternMap, "GCLCD");
        addKeyword(patternMap, "GCLD");
        addKeyword(patternMap, "GCLDD");
        addKeyword(patternMap, "GCLGGCD");
        addKeyword(patternMap, "GCMCCD");
        addKeyword(patternMap, "GCMCD");
        addKeyword(patternMap, "GCMD");
        addKeyword(patternMap, "GCMDD");
        addKeyword(patternMap, "GCMPCD");
        addKeyword(patternMap, "GCMPMD");
        addKeyword(patternMap, "GCPCCCCD");
        addKeyword(patternMap, "GCPCCCD");
        addKeyword(patternMap, "GCPCCD");
        addKeyword(patternMap, "GCPCCDD");
        addKeyword(patternMap, "GCPCD");
        addKeyword(patternMap, "GCPCDD");
        addKeyword(patternMap, "GCPCKCD");
        addKeyword(patternMap, "GCPD");
        addKeyword(patternMap, "GCPDCCD");
        addKeyword(patternMap, "GCPDD");
        addKeyword(patternMap, "GCPFD");
        addKeyword(patternMap, "GCPICCCD");
        addKeyword(patternMap, "GCPJCCD");
        addKeyword(patternMap, "GCPJCD");
        addKeyword(patternMap, "GCPJD");
        addKeyword(patternMap, "GCPJDCD");
        addKeyword(patternMap, "GCPJJCD");
        addKeyword(patternMap, "GCPJJDD");
        addKeyword(patternMap, "GCPJPD");
        addKeyword(patternMap, "GCPPCCD");
        addKeyword(patternMap, "GCPPD");
        addKeyword(patternMap, "GCPPPD");
        addKeyword(patternMap, "GCWCWCJD");
        addKeyword(patternMap, "GCWCWD");
        addKeyword(patternMap, "GCWDWCDD");
        addKeyword(patternMap, "GCWDWD");
        addKeyword(patternMap, "GCWGWDD");
        addKeyword(patternMap, "GD");
        addKeyword(patternMap, "GDCCCCCCD");
        addKeyword(patternMap, "GDCCCCCD");
        addKeyword(patternMap, "GDCCCCD");
        addKeyword(patternMap, "GDCCCCPD");
        addKeyword(patternMap, "GDCCCD");
        addKeyword(patternMap, "GDCCCDD");
        addKeyword(patternMap, "GDCCCGCCD");
        addKeyword(patternMap, "GDCCCJCD");
        addKeyword(patternMap, "GDCCCJD");
        addKeyword(patternMap, "GDCCCJDCD");
        addKeyword(patternMap, "GDCCD");
        addKeyword(patternMap, "GDCCDCD");
        addKeyword(patternMap, "GDCCDCDD");
        addKeyword(patternMap, "GDCCDD");
        addKeyword(patternMap, "GDCCID");
        addKeyword(patternMap, "GDCCJD");
        addKeyword(patternMap, "GDCCPCD");
        addKeyword(patternMap, "GDCD");
        addKeyword(patternMap, "GDCDCCD");
        addKeyword(patternMap, "GDCDCD");
        addKeyword(patternMap, "GDCDD");
        addKeyword(patternMap, "GDCDICD");
        addKeyword(patternMap, "GDCDPD");
        addKeyword(patternMap, "GDCFD");
        addKeyword(patternMap, "GDCGCCD");
        addKeyword(patternMap, "GDCGD");
        addKeyword(patternMap, "GDCGPPCCD");
        addKeyword(patternMap, "GDCID");
        addKeyword(patternMap, "GDCIDD");
        addKeyword(patternMap, "GDCJCCD");
        addKeyword(patternMap, "GDCJD");
        addKeyword(patternMap, "GDCLD");
        addKeyword(patternMap, "GDCMD");
        addKeyword(patternMap, "GDCPD");
        addKeyword(patternMap, "GDCPID");
        addKeyword(patternMap, "GDCPJD");
        addKeyword(patternMap, "GDD");
        addKeyword(patternMap, "GDDCCCCD");
        addKeyword(patternMap, "GDDCCCD");
        addKeyword(patternMap, "GDDCCD");
        addKeyword(patternMap, "GDDCD");
        addKeyword(patternMap, "GDDCDD");
        addKeyword(patternMap, "GDDCFD");
        addKeyword(patternMap, "GDDCFDCD");
        addKeyword(patternMap, "GDDCMD");
        addKeyword(patternMap, "GDDD");
        addKeyword(patternMap, "GDDDCD");
        addKeyword(patternMap, "GDDID");
        addKeyword(patternMap, "GDDPPD");
        addKeyword(patternMap, "GDDPPLD");
        addKeyword(patternMap, "GDFCCD");
        addKeyword(patternMap, "GDFCD");
        addKeyword(patternMap, "GDFD");
        addKeyword(patternMap, "GDFFD");
        addKeyword(patternMap, "GDFGD");
        addKeyword(patternMap, "GDGCCCD");
        addKeyword(patternMap, "GDGCCD");
        addKeyword(patternMap, "GDGCD");
        addKeyword(patternMap, "GDGD");
        addKeyword(patternMap, "GDGDCD");
        addKeyword(patternMap, "GDGDD");
        addKeyword(patternMap, "GDGDFID");
        addKeyword(patternMap, "GDGJCCD");
        addKeyword(patternMap, "GDGMD");
        addKeyword(patternMap, "GDICCD");
        addKeyword(patternMap, "GDICD");
        addKeyword(patternMap, "GDID");
        addKeyword(patternMap, "GDIDCD");
        addKeyword(patternMap, "GDIDD");
        addKeyword(patternMap, "GDIGCD");
        addKeyword(patternMap, "GDIID");
        addKeyword(patternMap, "GDIPCD");
        addKeyword(patternMap, "GDJCCCD");
        addKeyword(patternMap, "GDJCCD");
        addKeyword(patternMap, "GDJCD");
        addKeyword(patternMap, "GDJD");
        addKeyword(patternMap, "GDJICD");
        addKeyword(patternMap, "GDJJD");
        addKeyword(patternMap, "GDJJJD");
        addKeyword(patternMap, "GDJPCD");
        addKeyword(patternMap, "GDJPDD");
        addKeyword(patternMap, "GDLCCCCCD");
        addKeyword(patternMap, "GDLCID");
        addKeyword(patternMap, "GDLD");
        addKeyword(patternMap, "GDLJD");
        addKeyword(patternMap, "GDLJDD");
        addKeyword(patternMap, "GDMCD");
        addKeyword(patternMap, "GDMD");
        addKeyword(patternMap, "GDMDCD");
        addKeyword(patternMap, "GDMDD");
        addKeyword(patternMap, "GDMJD");
        addKeyword(patternMap, "GDMJMMD");
        addKeyword(patternMap, "GDMPD");
        addKeyword(patternMap, "GDPCCCCCD");
        addKeyword(patternMap, "GDPCCD");
        addKeyword(patternMap, "GDPCD");
        addKeyword(patternMap, "GDPD");
        addKeyword(patternMap, "GDPGCD");
        addKeyword(patternMap, "GDPID");
        addKeyword(patternMap, "GDPJCD");
        addKeyword(patternMap, "GDPJD");
        addKeyword(patternMap, "GDPPD");
        addKeyword(patternMap, "GDPPJD");
        addKeyword(patternMap, "GDWDWCCD");
        addKeyword(patternMap, "GDWDWCCDD");
        addKeyword(patternMap, "GDWDWD");
        addKeyword(patternMap, "GDWFWD");
        addKeyword(patternMap, "GDWGWD");
        addKeyword(patternMap, "GFCCCCCD");
        addKeyword(patternMap, "GFCCCCD");
        addKeyword(patternMap, "GFCCCCJD");
        addKeyword(patternMap, "GFCCCD");
        addKeyword(patternMap, "GFCCCID");
        addKeyword(patternMap, "GFCCD");
        addKeyword(patternMap, "GFCCDD");
        addKeyword(patternMap, "GFCCFCD");
        addKeyword(patternMap, "GFCCPD");
        addKeyword(patternMap, "GFCCPGD");
        addKeyword(patternMap, "GFCD");
        addKeyword(patternMap, "GFCDCD");
        addKeyword(patternMap, "GFCDD");
        addKeyword(patternMap, "GFCID");
        addKeyword(patternMap, "GFCJCD");
        addKeyword(patternMap, "GFCJD");
        addKeyword(patternMap, "GFCPCCD");
        addKeyword(patternMap, "GFCPCD");
        addKeyword(patternMap, "GFCPD");
        addKeyword(patternMap, "GFCPJD");
        addKeyword(patternMap, "GFCPJPD");
        addKeyword(patternMap, "GFD");
        addKeyword(patternMap, "GFDCCCD");
        addKeyword(patternMap, "GFDCD");
        addKeyword(patternMap, "GFDD");
        addKeyword(patternMap, "GFFCCD");
        addKeyword(patternMap, "GFFCD");
        addKeyword(patternMap, "GFFD");
        addKeyword(patternMap, "GFFPCGCD");
        addKeyword(patternMap, "GFGCD");
        addKeyword(patternMap, "GFGCID");
        addKeyword(patternMap, "GFGD");
        addKeyword(patternMap, "GFGJCD");
        addKeyword(patternMap, "GFICCD");
        addKeyword(patternMap, "GFICD");
        addKeyword(patternMap, "GFID");
        addKeyword(patternMap, "GFIICD");
        addKeyword(patternMap, "GFJCCCD");
        addKeyword(patternMap, "GFJCCD");
        addKeyword(patternMap, "GFJCD");
        addKeyword(patternMap, "GFJCDCD");
        addKeyword(patternMap, "GFJD");
        addKeyword(patternMap, "GFJJCCD");
        addKeyword(patternMap, "GFJJD");
        addKeyword(patternMap, "GFJJJCCD");
        addKeyword(patternMap, "GFJJLJCLCD");
        addKeyword(patternMap, "GFLD");
        addKeyword(patternMap, "GFLPD");
        addKeyword(patternMap, "GFMCD");
        addKeyword(patternMap, "GFPCD");
        addKeyword(patternMap, "GFPD");
        addKeyword(patternMap, "GFPJCD");
        addKeyword(patternMap, "GFPJD");
        addKeyword(patternMap, "GFPJPD");
        addKeyword(patternMap, "GFPPCCCD");
        addKeyword(patternMap, "GFPPD");
        addKeyword(patternMap, "GFWCJCPCCCWCCD");
        addKeyword(patternMap, "GFWGWCD");
        addKeyword(patternMap, "GGCCCCCD");
        addKeyword(patternMap, "GGCCCCD");
        addKeyword(patternMap, "GGCCCD");
        addKeyword(patternMap, "GGCCCICD");
        addKeyword(patternMap, "GGCCCID");
        addKeyword(patternMap, "GGCCCWDWD");
        addKeyword(patternMap, "GGCCD");
        addKeyword(patternMap, "GGCCDCD");
        addKeyword(patternMap, "GGCCDD");
        addKeyword(patternMap, "GGCCGCD");
        addKeyword(patternMap, "GGCCGD");
        addKeyword(patternMap, "GGCCGJD");
        addKeyword(patternMap, "GGCCJCD");
        addKeyword(patternMap, "GGCCJD");
        addKeyword(patternMap, "GGCD");
        addKeyword(patternMap, "GGCDCCCCCD");
        addKeyword(patternMap, "GGCDCCD");
        addKeyword(patternMap, "GGCDCD");
        addKeyword(patternMap, "GGCDD");
        addKeyword(patternMap, "GGCDJD");
        addKeyword(patternMap, "GGCFCCFCPD");
        addKeyword(patternMap, "GGCFD");
        addKeyword(patternMap, "GGCFJD");
        addKeyword(patternMap, "GGCGCCCD");
        addKeyword(patternMap, "GGCGCD");
        addKeyword(patternMap, "GGCGD");
        addKeyword(patternMap, "GGCGGD");
        addKeyword(patternMap, "GGCICLCD");
        addKeyword(patternMap, "GGCID");
        addKeyword(patternMap, "GGCIJCD");
        addKeyword(patternMap, "GGCJCCD");
        addKeyword(patternMap, "GGCJCD");
        addKeyword(patternMap, "GGCJD");
        addKeyword(patternMap, "GGCJDDCD");
        addKeyword(patternMap, "GGCJJCCD");
        addKeyword(patternMap, "GGCJJD");
        addKeyword(patternMap, "GGCJPCICCCD");
        addKeyword(patternMap, "GGCJPD");
        addKeyword(patternMap, "GGCLCD");
        addKeyword(patternMap, "GGCLD");
        addKeyword(patternMap, "GGCMD");
        addKeyword(patternMap, "GGCPCCD");
        addKeyword(patternMap, "GGCPCD");
        addKeyword(patternMap, "GGCPD");
        addKeyword(patternMap, "GGD");
        addKeyword(patternMap, "GGDCCCD");
        addKeyword(patternMap, "GGDCCD");
        addKeyword(patternMap, "GGDCD");
        addKeyword(patternMap, "GGDD");
        addKeyword(patternMap, "GGDDCCD");
        addKeyword(patternMap, "GGDDCD");
        addKeyword(patternMap, "GGDDD");
        addKeyword(patternMap, "GGDFCD");
        addKeyword(patternMap, "GGDFD");
        addKeyword(patternMap, "GGDGD");
        addKeyword(patternMap, "GGDID");
        addKeyword(patternMap, "GGDJCD");
        addKeyword(patternMap, "GGDJD");
        addKeyword(patternMap, "GGDJJD");
        addKeyword(patternMap, "GGDPPJD");
        addKeyword(patternMap, "GGFCCCD");
        addKeyword(patternMap, "GGFCCD");
        addKeyword(patternMap, "GGFCD");
        addKeyword(patternMap, "GGFCDD");
        addKeyword(patternMap, "GGFD");
        addKeyword(patternMap, "GGFDD");
        addKeyword(patternMap, "GGFFCD");
        addKeyword(patternMap, "GGFFD");
        addKeyword(patternMap, "GGFFDCD");
        addKeyword(patternMap, "GGFFDD");
        addKeyword(patternMap, "GGFGD");
        addKeyword(patternMap, "GGFJCCD");
        addKeyword(patternMap, "GGFJD");
        addKeyword(patternMap, "GGFJDD");
        addKeyword(patternMap, "GGFJJD");
        addKeyword(patternMap, "GGFLD");
        addKeyword(patternMap, "GGFPCFPCD");
        addKeyword(patternMap, "GGGCCCCD");
        addKeyword(patternMap, "GGGCCCD");
        addKeyword(patternMap, "GGGCCD");
        addKeyword(patternMap, "GGGCD");
        addKeyword(patternMap, "GGGCDD");
        addKeyword(patternMap, "GGGCGCD");
        addKeyword(patternMap, "GGGCGD");
        addKeyword(patternMap, "GGGCID");
        addKeyword(patternMap, "GGGCJD");
        addKeyword(patternMap, "GGGD");
        addKeyword(patternMap, "GGGDCD");
        addKeyword(patternMap, "GGGDD");
        addKeyword(patternMap, "GGGFD");
        addKeyword(patternMap, "GGGGCD");
        addKeyword(patternMap, "GGGGD");
        addKeyword(patternMap, "GGGGFJD");
        addKeyword(patternMap, "GGGGICD");
        addKeyword(patternMap, "GGGGJD");
        addKeyword(patternMap, "GGGGJPD");
        addKeyword(patternMap, "GGGGLD");
        addKeyword(patternMap, "GGGGPCD");
        addKeyword(patternMap, "GGGGPPD");
        addKeyword(patternMap, "GGGICD");
        addKeyword(patternMap, "GGGID");
        addKeyword(patternMap, "GGGIDID");
        addKeyword(patternMap, "GGGIGCJD");
        addKeyword(patternMap, "GGGIJD");
        addKeyword(patternMap, "GGGJCD");
        addKeyword(patternMap, "GGGJD");
        addKeyword(patternMap, "GGGJJCJD");
        addKeyword(patternMap, "GGGJJD");
        addKeyword(patternMap, "GGGJPCCD");
        addKeyword(patternMap, "GGGLD");
        addKeyword(patternMap, "GGGMD");
        addKeyword(patternMap, "GGGPJD");
        addKeyword(patternMap, "GGGWICWD");
        addKeyword(patternMap, "GGICCCCD");
        addKeyword(patternMap, "GGICCCD");
        addKeyword(patternMap, "GGICCD");
        addKeyword(patternMap, "GGICCGD");
        addKeyword(patternMap, "GGICCLD");
        addKeyword(patternMap, "GGICCPCCD");
        addKeyword(patternMap, "GGICD");
        addKeyword(patternMap, "GGICGCCCD");
        addKeyword(patternMap, "GGICID");
        addKeyword(patternMap, "GGICJD");
        addKeyword(patternMap, "GGID");
        addKeyword(patternMap, "GGIDCD");
        addKeyword(patternMap, "GGIDD");
        addKeyword(patternMap, "GGIFD");
        addKeyword(patternMap, "GGIFJCD");
        addKeyword(patternMap, "GGIFPD");
        addKeyword(patternMap, "GGIGCCD");
        addKeyword(patternMap, "GGIGD");
        addKeyword(patternMap, "GGIICD");
        addKeyword(patternMap, "GGIID");
        addKeyword(patternMap, "GGIIPID");
        addKeyword(patternMap, "GGIJCCD");
        addKeyword(patternMap, "GGIJD");
        addKeyword(patternMap, "GGIPCD");
        addKeyword(patternMap, "GGIPD");
        addKeyword(patternMap, "GGIPDD");
        addKeyword(patternMap, "GGJCCCD");
        addKeyword(patternMap, "GGJCCD");
        addKeyword(patternMap, "GGJCCPCJCCD");
        addKeyword(patternMap, "GGJCD");
        addKeyword(patternMap, "GGJCWDWD");
        addKeyword(patternMap, "GGJD");
        addKeyword(patternMap, "GGJGCCCD");
        addKeyword(patternMap, "GGJGCCD");
        addKeyword(patternMap, "GGJGD");
        addKeyword(patternMap, "GGJJD");
        addKeyword(patternMap, "GGJJPCD");
        addKeyword(patternMap, "GGJLD");
        addKeyword(patternMap, "GGJPD");
        addKeyword(patternMap, "GGJPDD");
        addKeyword(patternMap, "GGKD");
        addKeyword(patternMap, "GGKGD");
        addKeyword(patternMap, "GGLCCCD");
        addKeyword(patternMap, "GGLCD");
        addKeyword(patternMap, "GGLCDD");
        addKeyword(patternMap, "GGLCJD");
        addKeyword(patternMap, "GGLCPD");
        addKeyword(patternMap, "GGLD");
        addKeyword(patternMap, "GGLFD");
        addKeyword(patternMap, "GGLID");
        addKeyword(patternMap, "GGLJD");
        addKeyword(patternMap, "GGLLFD");
        addKeyword(patternMap, "GGLPD");
        addKeyword(patternMap, "GGMCD");
        addKeyword(patternMap, "GGMCDD");
        addKeyword(patternMap, "GGMD");
        addKeyword(patternMap, "GGMJCD");
        addKeyword(patternMap, "GGMLD");
        addKeyword(patternMap, "GGMPCCD");
        addKeyword(patternMap, "GGPCCCD");
        addKeyword(patternMap, "GGPCCD");
        addKeyword(patternMap, "GGPCD");
        addKeyword(patternMap, "GGPCJCD");
        addKeyword(patternMap, "GGPD");
        addKeyword(patternMap, "GGPFD");
        addKeyword(patternMap, "GGPICD");
        addKeyword(patternMap, "GGPJCCCCD");
        addKeyword(patternMap, "GGPJCD");
        addKeyword(patternMap, "GGPJCDD");
        addKeyword(patternMap, "GGPJD");
        addKeyword(patternMap, "GGPLD");
        addKeyword(patternMap, "GGPPCCD");
        addKeyword(patternMap, "GGPPCD");
        addKeyword(patternMap, "GGPPD");
        addKeyword(patternMap, "GGPPJJD");
        addKeyword(patternMap, "GGPPPCD");
        addKeyword(patternMap, "GGWPCGWPJD");
        addKeyword(patternMap, "GICCCCCCD");
        addKeyword(patternMap, "GICCCCCD");
        addKeyword(patternMap, "GICCCCD");
        addKeyword(patternMap, "GICCCD");
        addKeyword(patternMap, "GICCCDD");
        addKeyword(patternMap, "GICCCJCD");
        addKeyword(patternMap, "GICCD");
        addKeyword(patternMap, "GICCDD");
        addKeyword(patternMap, "GICCJD");
        addKeyword(patternMap, "GICCLDD");
        addKeyword(patternMap, "GICCPD");
        addKeyword(patternMap, "GICD");
        addKeyword(patternMap, "GICDCCCCD");
        addKeyword(patternMap, "GICDCCD");
        addKeyword(patternMap, "GICDCD");
        addKeyword(patternMap, "GICDD");
        addKeyword(patternMap, "GICDLPD");
        addKeyword(patternMap, "GICDWCCWD");
        addKeyword(patternMap, "GICGCCCCD");
        addKeyword(patternMap, "GICGCCD");
        addKeyword(patternMap, "GICGCJICD");
        addKeyword(patternMap, "GICGD");
        addKeyword(patternMap, "GICGGD");
        addKeyword(patternMap, "GICGMMD");
        addKeyword(patternMap, "GICGPCJD");
        addKeyword(patternMap, "GICICCD");
        addKeyword(patternMap, "GICICD");
        addKeyword(patternMap, "GICID");
        addKeyword(patternMap, "GICIGD");
        addKeyword(patternMap, "GICIID");
        addKeyword(patternMap, "GICJCCD");
        addKeyword(patternMap, "GICJCD");
        addKeyword(patternMap, "GICJD");
        addKeyword(patternMap, "GICPCCCCD");
        addKeyword(patternMap, "GICPD");
        addKeyword(patternMap, "GICPICD");
        addKeyword(patternMap, "GICPJD");
        addKeyword(patternMap, "GID");
        addKeyword(patternMap, "GIDCCCJCD");
        addKeyword(patternMap, "GIDCCD");
        addKeyword(patternMap, "GIDCD");
        addKeyword(patternMap, "GIDD");
        addKeyword(patternMap, "GIDDD");
        addKeyword(patternMap, "GIDICCD");
        addKeyword(patternMap, "GIDID");
        addKeyword(patternMap, "GIDLPCD");
        addKeyword(patternMap, "GIFCCD");
        addKeyword(patternMap, "GIFD");
        addKeyword(patternMap, "GIFICD");
        addKeyword(patternMap, "GIFWFD");
        addKeyword(patternMap, "GIGCCD");
        addKeyword(patternMap, "GIGCD");
        addKeyword(patternMap, "GIGCGCD");
        addKeyword(patternMap, "GIGCJD");
        addKeyword(patternMap, "GIGCPD");
        addKeyword(patternMap, "GIGD");
        addKeyword(patternMap, "GIGGD");
        addKeyword(patternMap, "GIGICD");
        addKeyword(patternMap, "GIGID");
        addKeyword(patternMap, "GIGJPCD");
        addKeyword(patternMap, "GIICCCCD");
        addKeyword(patternMap, "GIICCD");
        addKeyword(patternMap, "GIICD");
        addKeyword(patternMap, "GIID");
        addKeyword(patternMap, "GIIGD");
        addKeyword(patternMap, "GIIID");
        addKeyword(patternMap, "GIIJCCCD");
        addKeyword(patternMap, "GIIJCD");
        addKeyword(patternMap, "GIJCCCCCD");
        addKeyword(patternMap, "GIJCCCCD");
        addKeyword(patternMap, "GIJCCCD");
        addKeyword(patternMap, "GIJCCD");
        addKeyword(patternMap, "GIJCD");
        addKeyword(patternMap, "GIJCPD");
        addKeyword(patternMap, "GIJD");
        addKeyword(patternMap, "GIJDD");
        addKeyword(patternMap, "GIJID");
        addKeyword(patternMap, "GIJJCCD");
        addKeyword(patternMap, "GIJJCD");
        addKeyword(patternMap, "GIJLD");
        addKeyword(patternMap, "GIJPD");
        addKeyword(patternMap, "GIJPDCD");
        addKeyword(patternMap, "GIKD");
        addKeyword(patternMap, "GILCCCCDD");
        addKeyword(patternMap, "GILCCD");
        addKeyword(patternMap, "GILCD");
        addKeyword(patternMap, "GILD");
        addKeyword(patternMap, "GILID");
        addKeyword(patternMap, "GILPMD");
        addKeyword(patternMap, "GIMCCD");
        addKeyword(patternMap, "GIMCD");
        addKeyword(patternMap, "GIMD");
        addKeyword(patternMap, "GIMJCD");
        addKeyword(patternMap, "GIMJD");
        addKeyword(patternMap, "GIMPCCD");
        addKeyword(patternMap, "GIPCCCCD");
        addKeyword(patternMap, "GIPCCCD");
        addKeyword(patternMap, "GIPCCD");
        addKeyword(patternMap, "GIPCD");
        addKeyword(patternMap, "GIPCMD");
        addKeyword(patternMap, "GIPD");
        addKeyword(patternMap, "GIPDCD");
        addKeyword(patternMap, "GIPDD");
        addKeyword(patternMap, "GIPICD");
        addKeyword(patternMap, "GIPJCCD");
        addKeyword(patternMap, "GIPJCD");
        addKeyword(patternMap, "GIPPCD");
        addKeyword(patternMap, "GIPPD");
        addKeyword(patternMap, "GIWDCCWCD");
        addKeyword(patternMap, "GIWDWD");
        addKeyword(patternMap, "GIWGWCD");
        addKeyword(patternMap, "GJCCCCCD");
        addKeyword(patternMap, "GJCCCCD");
        addKeyword(patternMap, "GJCCCD");
        addKeyword(patternMap, "GJCCCDCDCD");
        addKeyword(patternMap, "GJCCCDD");
        addKeyword(patternMap, "GJCCD");
        addKeyword(patternMap, "GJCCDCD");
        addKeyword(patternMap, "GJCCDD");
        addKeyword(patternMap, "GJCCFD");
        addKeyword(patternMap, "GJCCGJPD");
        addKeyword(patternMap, "GJCCICCD");
        addKeyword(patternMap, "GJCCJCD");
        addKeyword(patternMap, "GJCCJD");
        addKeyword(patternMap, "GJCD");
        addKeyword(patternMap, "GJCDCCD");
        addKeyword(patternMap, "GJCDCJCCD");
        addKeyword(patternMap, "GJCDD");
        addKeyword(patternMap, "GJCDJCD");
        addKeyword(patternMap, "GJCDPD");
        addKeyword(patternMap, "GJCGCD");
        addKeyword(patternMap, "GJCGD");
        addKeyword(patternMap, "GJCGPJCCD");
        addKeyword(patternMap, "GJCICCCD");
        addKeyword(patternMap, "GJCICD");
        addKeyword(patternMap, "GJCID");
        addKeyword(patternMap, "GJCJCCD");
        addKeyword(patternMap, "GJCJCD");
        addKeyword(patternMap, "GJCJD");
        addKeyword(patternMap, "GJCJJCCCCD");
        addKeyword(patternMap, "GJCJJCD");
        addKeyword(patternMap, "GJCJPD");
        addKeyword(patternMap, "GJCJPPCD");
        addKeyword(patternMap, "GJCLD");
        addKeyword(patternMap, "GJCLJCCCD");
        addKeyword(patternMap, "GJCMD");
        addKeyword(patternMap, "GJCPD");
        addKeyword(patternMap, "GJCPJD");
        addKeyword(patternMap, "GJCPPD");
        addKeyword(patternMap, "GJD");
        addKeyword(patternMap, "GJDCCCD");
        addKeyword(patternMap, "GJDCCD");
        addKeyword(patternMap, "GJDCD");
        addKeyword(patternMap, "GJDD");
        addKeyword(patternMap, "GJDICD");
        addKeyword(patternMap, "GJDID");
        addKeyword(patternMap, "GJDLCD");
        addKeyword(patternMap, "GJDPCD");
        addKeyword(patternMap, "GJFCCD");
        addKeyword(patternMap, "GJFCD");
        addKeyword(patternMap, "GJFD");
        addKeyword(patternMap, "GJFFD");
        addKeyword(patternMap, "GJFGD");
        addKeyword(patternMap, "GJFICD");
        addKeyword(patternMap, "GJGCD");
        addKeyword(patternMap, "GJGD");
        addKeyword(patternMap, "GJGPCD");
        addKeyword(patternMap, "GJICCCD");
        addKeyword(patternMap, "GJICCD");
        addKeyword(patternMap, "GJICD");
        addKeyword(patternMap, "GJID");
        addKeyword(patternMap, "GJIID");
        addKeyword(patternMap, "GJJCCCD");
        addKeyword(patternMap, "GJJCCD");
        addKeyword(patternMap, "GJJCCDD");
        addKeyword(patternMap, "GJJCD");
        addKeyword(patternMap, "GJJCJCCCD");
        addKeyword(patternMap, "GJJCJCCD");
        addKeyword(patternMap, "GJJCPCD");
        addKeyword(patternMap, "GJJD");
        addKeyword(patternMap, "GJJDCD");
        addKeyword(patternMap, "GJJDD");
        addKeyword(patternMap, "GJJFCCD");
        addKeyword(patternMap, "GJJFD");
        addKeyword(patternMap, "GJJGD");
        addKeyword(patternMap, "GJJJCD");
        addKeyword(patternMap, "GJJJD");
        addKeyword(patternMap, "GJJJICD");
        addKeyword(patternMap, "GJJJJCCD");
        addKeyword(patternMap, "GJJJJD");
        addKeyword(patternMap, "GJJPCCCD");
        addKeyword(patternMap, "GJJPCCD");
        addKeyword(patternMap, "GJJPCID");
        addKeyword(patternMap, "GJJPPD");
        addKeyword(patternMap, "GJLCCCCD");
        addKeyword(patternMap, "GJLCD");
        addKeyword(patternMap, "GJLCDD");
        addKeyword(patternMap, "GJLD");
        addKeyword(patternMap, "GJMCCD");
        addKeyword(patternMap, "GJMD");
        addKeyword(patternMap, "GJPCCCCD");
        addKeyword(patternMap, "GJPCCCD");
        addKeyword(patternMap, "GJPCCD");
        addKeyword(patternMap, "GJPCD");
        addKeyword(patternMap, "GJPCDD");
        addKeyword(patternMap, "GJPCJCD");
        addKeyword(patternMap, "GJPCLCD");
        addKeyword(patternMap, "GJPCMD");
        addKeyword(patternMap, "GJPD");
        addKeyword(patternMap, "GJPDD");
        addKeyword(patternMap, "GJPGCCD");
        addKeyword(patternMap, "GJPGD");
        addKeyword(patternMap, "GJPICCD");
        addKeyword(patternMap, "GJPICD");
        addKeyword(patternMap, "GJPICDD");
        addKeyword(patternMap, "GJPJCCD");
        addKeyword(patternMap, "GJPJD");
        addKeyword(patternMap, "GJPJPD");
        addKeyword(patternMap, "GJPLCD");
        addKeyword(patternMap, "GJPPJD");
        addKeyword(patternMap, "GKCCCD");
        addKeyword(patternMap, "GKCCD");
        addKeyword(patternMap, "GKCCPD");
        addKeyword(patternMap, "GKCD");
        addKeyword(patternMap, "GKCDCD");
        addKeyword(patternMap, "GKCDD");
        addKeyword(patternMap, "GKCDJCD");
        addKeyword(patternMap, "GKCJCD");
        addKeyword(patternMap, "GKCMD");
        addKeyword(patternMap, "GKD");
        addKeyword(patternMap, "GKDD");
        addKeyword(patternMap, "GKJJD");
        addKeyword(patternMap, "GLCCCCCCD");
        addKeyword(patternMap, "GLCCCCD");
        addKeyword(patternMap, "GLCCCD");
        addKeyword(patternMap, "GLCCD");
        addKeyword(patternMap, "GLCCDD");
        addKeyword(patternMap, "GLCCJCCCD");
        addKeyword(patternMap, "GLCCJCCD");
        addKeyword(patternMap, "GLCD");
        addKeyword(patternMap, "GLCDD");
        addKeyword(patternMap, "GLCDGCCD");
        addKeyword(patternMap, "GLCGCJCD");
        addKeyword(patternMap, "GLCGD");
        addKeyword(patternMap, "GLCGDD");
        addKeyword(patternMap, "GLCJD");
        addKeyword(patternMap, "GLCJJCCCCCD");
        addKeyword(patternMap, "GLCLD");
        addKeyword(patternMap, "GLCMD");
        addKeyword(patternMap, "GLCPCCD");
        addKeyword(patternMap, "GLCPD");
        addKeyword(patternMap, "GLD");
        addKeyword(patternMap, "GLDCD");
        addKeyword(patternMap, "GLDCMD");
        addKeyword(patternMap, "GLDCMDCD");
        addKeyword(patternMap, "GLDCMDD");
        addKeyword(patternMap, "GLDD");
        addKeyword(patternMap, "GLDDCKCD");
        addKeyword(patternMap, "GLFCD");
        addKeyword(patternMap, "GLFCFD");
        addKeyword(patternMap, "GLFGCD");
        addKeyword(patternMap, "GLGCD");
        addKeyword(patternMap, "GLGD");
        addKeyword(patternMap, "GLGPJD");
        addKeyword(patternMap, "GLICCD");
        addKeyword(patternMap, "GLICD");
        addKeyword(patternMap, "GLID");
        addKeyword(patternMap, "GLJCCCD");
        addKeyword(patternMap, "GLJCCD");
        addKeyword(patternMap, "GLJCD");
        addKeyword(patternMap, "GLJCICCD");
        addKeyword(patternMap, "GLJD");
        addKeyword(patternMap, "GLJFCD");
        addKeyword(patternMap, "GLJGD");
        addKeyword(patternMap, "GLJICCD");
        addKeyword(patternMap, "GLJID");
        addKeyword(patternMap, "GLJJD");
        addKeyword(patternMap, "GLJPCCD");
        addKeyword(patternMap, "GLJPCICD");
        addKeyword(patternMap, "GLJPJCCD");
        addKeyword(patternMap, "GLJWGWCD");
        addKeyword(patternMap, "GLLCCCD");
        addKeyword(patternMap, "GLLCID");
        addKeyword(patternMap, "GLPCCCD");
        addKeyword(patternMap, "GLPCCD");
        addKeyword(patternMap, "GLPCD");
        addKeyword(patternMap, "GLPCDD");
        addKeyword(patternMap, "GLPCPCCD");
        addKeyword(patternMap, "GLPD");
        addKeyword(patternMap, "GLPDD");
        addKeyword(patternMap, "GLPGCD");
        addKeyword(patternMap, "GLPJD");
        addKeyword(patternMap, "GLPLJCCCD");
        addKeyword(patternMap, "GLPLJCD");
        addKeyword(patternMap, "GLPPCCCCD");
        addKeyword(patternMap, "GLPPCCD");
        addKeyword(patternMap, "GLPPCD");
        addKeyword(patternMap, "GMCCCCD");
        addKeyword(patternMap, "GMCCCD");
        addKeyword(patternMap, "GMCCD");
        addKeyword(patternMap, "GMCCID");
        addKeyword(patternMap, "GMCD");
        addKeyword(patternMap, "GMCDCCCD");
        addKeyword(patternMap, "GMCDCCD");
        addKeyword(patternMap, "GMCDCD");
        addKeyword(patternMap, "GMCDD");
        addKeyword(patternMap, "GMCDMCD");
        addKeyword(patternMap, "GMCGD");
        addKeyword(patternMap, "GMCJCD");
        addKeyword(patternMap, "GMCMD");
        addKeyword(patternMap, "GMCMJD");
        addKeyword(patternMap, "GMD");
        addKeyword(patternMap, "GMDCD");
        addKeyword(patternMap, "GMDD");
        addKeyword(patternMap, "GMDICD");
        addKeyword(patternMap, "GMDID");
        addKeyword(patternMap, "GMGJCD");
        addKeyword(patternMap, "GMGJJD");
        addKeyword(patternMap, "GMICD");
        addKeyword(patternMap, "GMID");
        addKeyword(patternMap, "GMIPJCCD");
        addKeyword(patternMap, "GMJCCD");
        addKeyword(patternMap, "GMJCD");
        addKeyword(patternMap, "GMJD");
        addKeyword(patternMap, "GMJDD");
        addKeyword(patternMap, "GMJICCCD");
        addKeyword(patternMap, "GMJMJFCD");
        addKeyword(patternMap, "GMJPCD");
        addKeyword(patternMap, "GMJPLCCD");
        addKeyword(patternMap, "GMLD");
        addKeyword(patternMap, "GMLDCD");
        addKeyword(patternMap, "GMLGCD");
        addKeyword(patternMap, "GMLID");
        addKeyword(patternMap, "GMLLD");
        addKeyword(patternMap, "GMMCCCD");
        addKeyword(patternMap, "GMMD");
        addKeyword(patternMap, "GMMGD");
        addKeyword(patternMap, "GMMLCCD");
        addKeyword(patternMap, "GMMPCD");
        addKeyword(patternMap, "GMMPD");
        addKeyword(patternMap, "GMPCCD");
        addKeyword(patternMap, "GMPCD");
        addKeyword(patternMap, "GMPD");
        addKeyword(patternMap, "GMPDCD");
        addKeyword(patternMap, "GMPDD");
        addKeyword(patternMap, "GMPJCD");
        addKeyword(patternMap, "GPCCCCCCD");
        addKeyword(patternMap, "GPCCCCD");
        addKeyword(patternMap, "GPCCCCID");
        addKeyword(patternMap, "GPCCCD");
        addKeyword(patternMap, "GPCCD");
        addKeyword(patternMap, "GPCCDCCD");
        addKeyword(patternMap, "GPCCDD");
        addKeyword(patternMap, "GPCCDDD");
        addKeyword(patternMap, "GPCD");
        addKeyword(patternMap, "GPCDCCD");
        addKeyword(patternMap, "GPCDCD");
        addKeyword(patternMap, "GPCDD");
        addKeyword(patternMap, "GPCFDCCD");
        addKeyword(patternMap, "GPCFDD");
        addKeyword(patternMap, "GPCGD");
        addKeyword(patternMap, "GPCICCD");
        addKeyword(patternMap, "GPCID");
        addKeyword(patternMap, "GPCIJD");
        addKeyword(patternMap, "GPCJCCCD");
        addKeyword(patternMap, "GPCJCCD");
        addKeyword(patternMap, "GPCJCD");
        addKeyword(patternMap, "GPCPID");
        addKeyword(patternMap, "GPCWDWCD");
        addKeyword(patternMap, "GPD");
        addKeyword(patternMap, "GPDCCD");
        addKeyword(patternMap, "GPDCD");
        addKeyword(patternMap, "GPDD");
        addKeyword(patternMap, "GPFCCD");
        addKeyword(patternMap, "GPFCD");
        addKeyword(patternMap, "GPFD");
        addKeyword(patternMap, "GPFFCD");
        addKeyword(patternMap, "GPGCCCD");
        addKeyword(patternMap, "GPGD");
        addKeyword(patternMap, "GPGJCJCCCCD");
        addKeyword(patternMap, "GPGPJD");
        addKeyword(patternMap, "GPICCCCD");
        addKeyword(patternMap, "GPICCCD");
        addKeyword(patternMap, "GPICCD");
        addKeyword(patternMap, "GPICD");
        addKeyword(patternMap, "GPID");
        addKeyword(patternMap, "GPIDCD");
        addKeyword(patternMap, "GPIDD");
        addKeyword(patternMap, "GPJCCCCCD");
        addKeyword(patternMap, "GPJCCCD");
        addKeyword(patternMap, "GPJCCD");
        addKeyword(patternMap, "GPJCD");
        addKeyword(patternMap, "GPJCDD");
        addKeyword(patternMap, "GPJCJCCD");
        addKeyword(patternMap, "GPJD");
        addKeyword(patternMap, "GPJDCCD");
        addKeyword(patternMap, "GPJDCD");
        addKeyword(patternMap, "GPJDD");
        addKeyword(patternMap, "GPJFICD");
        addKeyword(patternMap, "GPJFID");
        addKeyword(patternMap, "GPJGD");
        addKeyword(patternMap, "GPJJCCD");
        addKeyword(patternMap, "GPJJCD");
        addKeyword(patternMap, "GPJLCD");
        addKeyword(patternMap, "GPJWDWD");
        addKeyword(patternMap, "GPLCWCWCWD");
        addKeyword(patternMap, "GPLD");
        addKeyword(patternMap, "GPLJCCD");
        addKeyword(patternMap, "GPMJCGD");
        addKeyword(patternMap, "GPMMD");
        addKeyword(patternMap, "GPMPCCD");
        addKeyword(patternMap, "GPPCCCCD");
        addKeyword(patternMap, "GPPCCCD");
        addKeyword(patternMap, "GPPCCD");
        addKeyword(patternMap, "GPPCD");
        addKeyword(patternMap, "GPPCDCCD");
        addKeyword(patternMap, "GPPCDD");
        addKeyword(patternMap, "GPPCLD");
        addKeyword(patternMap, "GPPD");
        addKeyword(patternMap, "GPPDCD");
        addKeyword(patternMap, "GPPDCDD");
        addKeyword(patternMap, "GPPDD");
        addKeyword(patternMap, "GPPGCD");
        addKeyword(patternMap, "GPPICCD");
        addKeyword(patternMap, "GPPID");
        addKeyword(patternMap, "GPPJCD");
        addKeyword(patternMap, "GPPJD");
        addKeyword(patternMap, "GPPJDD");
        addKeyword(patternMap, "GPPJJCCCCD");
        addKeyword(patternMap, "GPPLD");
        addKeyword(patternMap, "GPPPCCD");
        addKeyword(patternMap, "GPPPCKCCD");
        addKeyword(patternMap, "GPPPPCCD");
        addKeyword(patternMap, "GWCPWD");
        addKeyword(patternMap, "GWCWCCCD");
        addKeyword(patternMap, "GWCWCD");
        addKeyword(patternMap, "GWCWD");
        addKeyword(patternMap, "GWCWPJCD");
        addKeyword(patternMap, "GWD");
        addKeyword(patternMap, "GWFCD");
        addKeyword(patternMap, "GWGCCCD");
        addKeyword(patternMap, "GWGCCD");
        addKeyword(patternMap, "GWGCCWCD");
        addKeyword(patternMap, "GWGCD");
        addKeyword(patternMap, "GWGCWD");
        addKeyword(patternMap, "GWGD");
        addKeyword(patternMap, "GWGID");
        addKeyword(patternMap, "GWGWCCCCD");
        addKeyword(patternMap, "GWGWCCCD");
        addKeyword(patternMap, "GWGWCD");
        addKeyword(patternMap, "GWGWICD");
        addKeyword(patternMap, "GWGWLCD");
        addKeyword(patternMap, "GWICD");
        addKeyword(patternMap, "GWICWD");
        addKeyword(patternMap, "GWIWD");
        addKeyword(patternMap, "GWJWD");
        addKeyword(patternMap, "GWLJWCD");
        addKeyword(patternMap, "GWPD");
        addKeyword(patternMap, "GWPJD");
        addKeyword(patternMap, "ICCCCCCD");
        addKeyword(patternMap, "ICCCCCD");
        addKeyword(patternMap, "ICCCCD");
        addKeyword(patternMap, "ICCCCDD");
        addKeyword(patternMap, "ICCCD");
        addKeyword(patternMap, "ICCD");
        addKeyword(patternMap, "ICCDCCD");
        addKeyword(patternMap, "ICCDCD");
        addKeyword(patternMap, "ICCDD");
        addKeyword(patternMap, "ICCGCCD");
        addKeyword(patternMap, "ICCGCIPD");
        addKeyword(patternMap, "ICCGD");
        addKeyword(patternMap, "ICCJD");
        addKeyword(patternMap, "ICCPD");
        addKeyword(patternMap, "ICCWDWCD");
        addKeyword(patternMap, "ICD");
        addKeyword(patternMap, "ICDD");
        addKeyword(patternMap, "ICDID");
        addKeyword(patternMap, "ICFD");
        addKeyword(patternMap, "ICGCCCD");
        addKeyword(patternMap, "ICGCD");
        addKeyword(patternMap, "ICGFD");
        addKeyword(patternMap, "ICGGCD");
        addKeyword(patternMap, "ICGLCMD");
        addKeyword(patternMap, "ICICD");
        addKeyword(patternMap, "ICID");
        addKeyword(patternMap, "ICIGD");
        addKeyword(patternMap, "ICJCD");
        addKeyword(patternMap, "ICJD");
        addKeyword(patternMap, "ICJJD");
        addKeyword(patternMap, "ICLJCD");
        addKeyword(patternMap, "ICMCCCCD");
        addKeyword(patternMap, "ICMD");
        addKeyword(patternMap, "ICPCD");
        addKeyword(patternMap, "ICPD");
        addKeyword(patternMap, "ICPPD");
        addKeyword(patternMap, "ICWGWCD");
        addKeyword(patternMap, "ICWGWD");
        addKeyword(patternMap, "ICWGWDCD");
        addKeyword(patternMap, "ID");
        addKeyword(patternMap, "IDCCCCD");
        addKeyword(patternMap, "IDCCCD");
        addKeyword(patternMap, "IDCCD");
        addKeyword(patternMap, "IDCCGJID");
        addKeyword(patternMap, "IDCCICD");
        addKeyword(patternMap, "IDCCICDID");
        addKeyword(patternMap, "IDCD");
        addKeyword(patternMap, "IDCDCD");
        addKeyword(patternMap, "IDCDD");
        addKeyword(patternMap, "IDCFCD");
        addKeyword(patternMap, "IDCGD");
        addKeyword(patternMap, "IDCICD");
        addKeyword(patternMap, "IDCID");
        addKeyword(patternMap, "IDCJD");
        addKeyword(patternMap, "IDCPCCCCCCD");
        addKeyword(patternMap, "IDD");
        addKeyword(patternMap, "IDGCCCD");
        addKeyword(patternMap, "IDGCD");
        addKeyword(patternMap, "IDID");
        addKeyword(patternMap, "IDIDD");
        addKeyword(patternMap, "IDJCD");
        addKeyword(patternMap, "IDKCD");
        addKeyword(patternMap, "IDPD");
        addKeyword(patternMap, "IDWCWCCDD");
        addKeyword(patternMap, "IFD");
        addKeyword(patternMap, "IFWGWCD");
        addKeyword(patternMap, "IGCCCD");
        addKeyword(patternMap, "IGCCCDD");
        addKeyword(patternMap, "IGCCD");
        addKeyword(patternMap, "IGCD");
        addKeyword(patternMap, "IGCDCD");
        addKeyword(patternMap, "IGCDD");
        addKeyword(patternMap, "IGCGCCD");
        addKeyword(patternMap, "IGCGCD");
        addKeyword(patternMap, "IGCID");
        addKeyword(patternMap, "IGCJD");
        addKeyword(patternMap, "IGCPD");
        addKeyword(patternMap, "IGCWJWD");
        addKeyword(patternMap, "IGD");
        addKeyword(patternMap, "IGDD");
        addKeyword(patternMap, "IGFCCD");
        addKeyword(patternMap, "IGFCD");
        addKeyword(patternMap, "IGFD");
        addKeyword(patternMap, "IGGCD");
        addKeyword(patternMap, "IGID");
        addKeyword(patternMap, "IGJD");
        addKeyword(patternMap, "IGLCD");
        addKeyword(patternMap, "IGLD");
        addKeyword(patternMap, "IGPCD");
        addKeyword(patternMap, "IGPCDD");
        addKeyword(patternMap, "IICCCD");
        addKeyword(patternMap, "IICCD");
        addKeyword(patternMap, "IICD");
        addKeyword(patternMap, "IICGD");
        addKeyword(patternMap, "IID");
        addKeyword(patternMap, "IIGD");
        addKeyword(patternMap, "IIGJCJCD");
        addKeyword(patternMap, "IIIGCD");
        addKeyword(patternMap, "IIPCD");
        addKeyword(patternMap, "IJCCCCD");
        addKeyword(patternMap, "IJCCCD");
        addKeyword(patternMap, "IJCCD");
        addKeyword(patternMap, "IJCD");
        addKeyword(patternMap, "IJD");
        addKeyword(patternMap, "IJDCCD");
        addKeyword(patternMap, "IJGCD");
        addKeyword(patternMap, "IJGD");
        addKeyword(patternMap, "IJJCD");
        addKeyword(patternMap, "IJJD");
        addKeyword(patternMap, "IJJJCD");
        addKeyword(patternMap, "IJPCDD");
        addKeyword(patternMap, "IJWCFIWGD");
        addKeyword(patternMap, "IJWCFWD");
        addKeyword(patternMap, "IJWCPWGD");
        addKeyword(patternMap, "IKCCCD");
        addKeyword(patternMap, "ILCD");
        addKeyword(patternMap, "ILD");
        addKeyword(patternMap, "ILPCD");
        addKeyword(patternMap, "ILPMD");
        addKeyword(patternMap, "IMCCD");
        addKeyword(patternMap, "IMCD");
        addKeyword(patternMap, "IMD");
        addKeyword(patternMap, "IMPD");
        addKeyword(patternMap, "IPCCCD");
        addKeyword(patternMap, "IPCCD");
        addKeyword(patternMap, "IPCCID");
        addKeyword(patternMap, "IPCCJD");
        addKeyword(patternMap, "IPCD");
        addKeyword(patternMap, "IPCID");
        addKeyword(patternMap, "IPCJD");
        addKeyword(patternMap, "IPCPD");
        addKeyword(patternMap, "IPD");
        addKeyword(patternMap, "IPFCD");
        addKeyword(patternMap, "IPID");
        addKeyword(patternMap, "IPIJD");
        addKeyword(patternMap, "IPJCGD");
        addKeyword(patternMap, "IPJD");
        addKeyword(patternMap, "IPPCD");
        addKeyword(patternMap, "JCCCCCCD");
        addKeyword(patternMap, "JCCCCCD");
        addKeyword(patternMap, "JCCCCD");
        addKeyword(patternMap, "JCCCD");
        addKeyword(patternMap, "JCCCJCD");
        addKeyword(patternMap, "JCCD");
        addKeyword(patternMap, "JCCID");
        addKeyword(patternMap, "JCCJD");
        addKeyword(patternMap, "JCCMCD");
        addKeyword(patternMap, "JCD");
        addKeyword(patternMap, "JCDCCD");
        addKeyword(patternMap, "JCDCD");
        addKeyword(patternMap, "JCDD");
        addKeyword(patternMap, "JCDID");
        addKeyword(patternMap, "JCFCD");
        addKeyword(patternMap, "JCGCCCCD");
        addKeyword(patternMap, "JCGCCCD");
        addKeyword(patternMap, "JCGCCD");
        addKeyword(patternMap, "JCGCD");
        addKeyword(patternMap, "JCGD");
        addKeyword(patternMap, "JCGJGD");
        addKeyword(patternMap, "JCICCCD");
        addKeyword(patternMap, "JCID");
        addKeyword(patternMap, "JCIDD");
        addKeyword(patternMap, "JCJCCCD");
        addKeyword(patternMap, "JCJCCD");
        addKeyword(patternMap, "JCJCD");
        addKeyword(patternMap, "JCJD");
        addKeyword(patternMap, "JCJDD");
        addKeyword(patternMap, "JCJFD");
        addKeyword(patternMap, "JCJJPCD");
        addKeyword(patternMap, "JCJPID");
        addKeyword(patternMap, "JCJWGWD");
        addKeyword(patternMap, "JCLD");
        addKeyword(patternMap, "JCMD");
        addKeyword(patternMap, "JCMPD");
        addKeyword(patternMap, "JCPJCID");
        addKeyword(patternMap, "JCPJJCD");
        addKeyword(patternMap, "JCPPCCCD");
        addKeyword(patternMap, "JD");
        addKeyword(patternMap, "JDCD");
        addKeyword(patternMap, "JDCMD");
        addKeyword(patternMap, "JDD");
        addKeyword(patternMap, "JDGD");
        addKeyword(patternMap, "JDID");
        addKeyword(patternMap, "JDJD");
        addKeyword(patternMap, "JDMD");
        addKeyword(patternMap, "JFCD");
        addKeyword(patternMap, "JFD");
        addKeyword(patternMap, "JGCCCD");
        addKeyword(patternMap, "JGCD");
        addKeyword(patternMap, "JGD");
        addKeyword(patternMap, "JGDCJD");
        addKeyword(patternMap, "JGGD");
        addKeyword(patternMap, "JGPD");
        addKeyword(patternMap, "JICCCD");
        addKeyword(patternMap, "JICD");
        addKeyword(patternMap, "JID");
        addKeyword(patternMap, "JIDD");
        addKeyword(patternMap, "JIID");
        addKeyword(patternMap, "JIJD");
        addKeyword(patternMap, "JILD");
        addKeyword(patternMap, "JJCCCD");
        addKeyword(patternMap, "JJCCD");
        addKeyword(patternMap, "JJCCPGD");
        addKeyword(patternMap, "JJCD");
        addKeyword(patternMap, "JJD");
        addKeyword(patternMap, "JJDCJD");
        addKeyword(patternMap, "JJDD");
        addKeyword(patternMap, "JJGCCD");
        addKeyword(patternMap, "JJGD");
        addKeyword(patternMap, "JJICD");
        addKeyword(patternMap, "JJID");
        addKeyword(patternMap, "JJJCCCD");
        addKeyword(patternMap, "JJJCD");
        addKeyword(patternMap, "JJJCFCCCD");
        addKeyword(patternMap, "JJJD");
        addKeyword(patternMap, "JJJGD");
        addKeyword(patternMap, "JJMCID");
        addKeyword(patternMap, "JJPCD");
        addKeyword(patternMap, "JJPD");
        addKeyword(patternMap, "JJPPJLCD");
        addKeyword(patternMap, "JJWFWCCJJD");
        addKeyword(patternMap, "JJWGWCD");
        addKeyword(patternMap, "JJWGWCDD");
        addKeyword(patternMap, "JKCD");
        addKeyword(patternMap, "JKD");
        addKeyword(patternMap, "JLCCD");
        addKeyword(patternMap, "JLCCDD");
        addKeyword(patternMap, "JLCCJD");
        addKeyword(patternMap, "JLCD");
        addKeyword(patternMap, "JLCDD");
        addKeyword(patternMap, "JLCMD");
        addKeyword(patternMap, "JLCMDD");
        addKeyword(patternMap, "JLD");
        addKeyword(patternMap, "JLDD");
        addKeyword(patternMap, "JLGCJD");
        addKeyword(patternMap, "JLGJCCCJD");
        addKeyword(patternMap, "JLJD");
        addKeyword(patternMap, "JMCD");
        addKeyword(patternMap, "JMD");
        addKeyword(patternMap, "JMJD");
        addKeyword(patternMap, "JMPD");
        addKeyword(patternMap, "JPCCD");
        addKeyword(patternMap, "JPCD");
        addKeyword(patternMap, "JPCMD");
        addKeyword(patternMap, "JPCMDPD");
        addKeyword(patternMap, "JPD");
        addKeyword(patternMap, "JPDCCCD");
        addKeyword(patternMap, "JPDD");
        addKeyword(patternMap, "JPDGCD");
        addKeyword(patternMap, "JPFCCD");
        addKeyword(patternMap, "JPFD");
        addKeyword(patternMap, "JPICD");
        addKeyword(patternMap, "JPID");
        addKeyword(patternMap, "JPIID");
        addKeyword(patternMap, "JPJD");
        addKeyword(patternMap, "JPJJCCCFPCD");
        addKeyword(patternMap, "JPMD");
        addKeyword(patternMap, "JPMDCCD");
        addKeyword(patternMap, "JPMDD");
        addKeyword(patternMap, "JPPJD");
        addKeyword(patternMap, "JPPJLCD");
        addKeyword(patternMap, "KCCCCCD");
        addKeyword(patternMap, "KCCCCD");
        addKeyword(patternMap, "KCCCCDCD");
        addKeyword(patternMap, "KCCCD");
        addKeyword(patternMap, "KCCCDCD");
        addKeyword(patternMap, "KCCCDD");
        addKeyword(patternMap, "KCCCDDCCCD");
        addKeyword(patternMap, "KCCCGD");
        addKeyword(patternMap, "KCCD");
        addKeyword(patternMap, "KCCDCCD");
        addKeyword(patternMap, "KCCDCD");
        addKeyword(patternMap, "KCCJD");
        addKeyword(patternMap, "KCCJDID");
        addKeyword(patternMap, "KCCPD");
        addKeyword(patternMap, "KCD");
        addKeyword(patternMap, "KCDCCCCD");
        addKeyword(patternMap, "KCDCCD");
        addKeyword(patternMap, "KCDCD");
        addKeyword(patternMap, "KCDD");
        addKeyword(patternMap, "KCDICD");
        addKeyword(patternMap, "KCDJD");
        addKeyword(patternMap, "KCGCCCD");
        addKeyword(patternMap, "KCGCCCDD");
        addKeyword(patternMap, "KCGCCD");
        addKeyword(patternMap, "KCGCD");
        addKeyword(patternMap, "KCGD");
        addKeyword(patternMap, "KCGGGD");
        addKeyword(patternMap, "KCICD");
        addKeyword(patternMap, "KCID");
        addKeyword(patternMap, "KCIDCD");
        addKeyword(patternMap, "KCJCD");
        addKeyword(patternMap, "KCJD");
        addKeyword(patternMap, "KCKCD");
        addKeyword(patternMap, "KCMD");
        addKeyword(patternMap, "KCMDCD");
        addKeyword(patternMap, "KCPD");
        addKeyword(patternMap, "KCWGWD");
        addKeyword(patternMap, "KD");
        addKeyword(patternMap, "KDCCCD");
        addKeyword(patternMap, "KDCD");
        addKeyword(patternMap, "KDD");
        addKeyword(patternMap, "KDICD");
        addKeyword(patternMap, "KDLCCPD");
        addKeyword(patternMap, "KFCD");
        addKeyword(patternMap, "KFCDD");
        addKeyword(patternMap, "KFD");
        addKeyword(patternMap, "KFWFD");
        addKeyword(patternMap, "KGCCCD");
        addKeyword(patternMap, "KGCCD");
        addKeyword(patternMap, "KGCD");
        addKeyword(patternMap, "KGCDCCD");
//        addKeyword(patternMap, "KGD");
        addKeyword(patternMap, "KGDD");
        addKeyword(patternMap, "KGGD");
        addKeyword(patternMap, "KGJPD");
        addKeyword(patternMap, "KICCD");
        addKeyword(patternMap, "KICD");
        addKeyword(patternMap, "KICDD");
        addKeyword(patternMap, "KID");
        addKeyword(patternMap, "KIDCCD");
        addKeyword(patternMap, "KIDJCD");
        addKeyword(patternMap, "KIGID");
        addKeyword(patternMap, "KIMCD");
        addKeyword(patternMap, "KIMD");
        addKeyword(patternMap, "KIWGWD");
        addKeyword(patternMap, "KJCCD");
        addKeyword(patternMap, "KJCD");
        addKeyword(patternMap, "KJD");
        addKeyword(patternMap, "KJDD");
        addKeyword(patternMap, "KJICCD");
        addKeyword(patternMap, "KJJD");
        addKeyword(patternMap, "KJJDCD");
        addKeyword(patternMap, "KJJJD");
        addKeyword(patternMap, "KJPD");
        addKeyword(patternMap, "KLCCD");
        addKeyword(patternMap, "KLD");
        addKeyword(patternMap, "KMCCJCCD");
        addKeyword(patternMap, "KMCD");
        addKeyword(patternMap, "KMCDD");
        addKeyword(patternMap, "KMD");
        addKeyword(patternMap, "KMDCD");
        addKeyword(patternMap, "KMDD");
        addKeyword(patternMap, "KMMD");
        addKeyword(patternMap, "KMMMD");
        addKeyword(patternMap, "KPCCCD");
        addKeyword(patternMap, "KPCCD");
        addKeyword(patternMap, "KPCD");
        addKeyword(patternMap, "KPD");
        addKeyword(patternMap, "KPDD");
        addKeyword(patternMap, "LCCCCD");
        addKeyword(patternMap, "LCCCD");
        addKeyword(patternMap, "LCCD");
        addKeyword(patternMap, "LCCDD");
        addKeyword(patternMap, "LCCDJCCD");
        addKeyword(patternMap, "LCCGD");
        addKeyword(patternMap, "LCCGID");
        addKeyword(patternMap, "LCCID");
        addKeyword(patternMap, "LCCPCD");
        addKeyword(patternMap, "LCCWGWD");
        addKeyword(patternMap, "LCD");
        addKeyword(patternMap, "LCDCCD");
        addKeyword(patternMap, "LCDCD");
        addKeyword(patternMap, "LCDCDD");
        addKeyword(patternMap, "LCDCDIGCD");
        addKeyword(patternMap, "LCDD");
        addKeyword(patternMap, "LCDFD");
        addKeyword(patternMap, "LCDGDD");
        addKeyword(patternMap, "LCDGID");
        addKeyword(patternMap, "LCDID");
        addKeyword(patternMap, "LCDLD");
        addKeyword(patternMap, "LCDLDCD");
        addKeyword(patternMap, "LCDLDD");
        addKeyword(patternMap, "LCDMCDD");
        addKeyword(patternMap, "LCDPD");
        addKeyword(patternMap, "LCGD");
        addKeyword(patternMap, "LCGDD");
        addKeyword(patternMap, "LCICCWGWD");
        addKeyword(patternMap, "LCID");
        addKeyword(patternMap, "LCIGD");
        addKeyword(patternMap, "LCJCD");
        addKeyword(patternMap, "LCJD");
        addKeyword(patternMap, "LCLD");
        addKeyword(patternMap, "LCMCCD");
        addKeyword(patternMap, "LCMCDD");
        addKeyword(patternMap, "LCMCID");
        addKeyword(patternMap, "LCMCMD");
        addKeyword(patternMap, "LCMD");
        addKeyword(patternMap, "LCMJCICD");
        addKeyword(patternMap, "LCMJD");
        addKeyword(patternMap, "LCPCJCD");
        addKeyword(patternMap, "LCPD");
        addKeyword(patternMap, "LCPMD");
        addKeyword(patternMap, "LCPPCD");
        addKeyword(patternMap, "LD");
        addKeyword(patternMap, "LDCCD");
        addKeyword(patternMap, "LDCD");
        addKeyword(patternMap, "LDCLCD");
        addKeyword(patternMap, "LDCLCDCD");
        addKeyword(patternMap, "LDCPD");
        addKeyword(patternMap, "LDD");
        addKeyword(patternMap, "LDDD");
        addKeyword(patternMap, "LDLCCCCD");
        addKeyword(patternMap, "LFCD");
        addKeyword(patternMap, "LFCFD");
        addKeyword(patternMap, "LFD");
        addKeyword(patternMap, "LFPPPCCD");
        addKeyword(patternMap, "LGCD");
        addKeyword(patternMap, "LGD");
        addKeyword(patternMap, "LGGCCCD");
        addKeyword(patternMap, "LGGCD");
        addKeyword(patternMap, "LGJCD");
        addKeyword(patternMap, "LGJLCD");
        addKeyword(patternMap, "LGJLD");
        addKeyword(patternMap, "LICCCD");
        addKeyword(patternMap, "LICCD");
        addKeyword(patternMap, "LICD");
        addKeyword(patternMap, "LICLD");
        addKeyword(patternMap, "LID");
        addKeyword(patternMap, "LIGD");
        addKeyword(patternMap, "LIPCCCD");
        addKeyword(patternMap, "LIWGWCCCD");
        addKeyword(patternMap, "LJCCCCD");
        addKeyword(patternMap, "LJCCCCWGWD");
        addKeyword(patternMap, "LJCCCD");
        addKeyword(patternMap, "LJCCD");
        addKeyword(patternMap, "LJCCDCCCD");
        addKeyword(patternMap, "LJCCDCCD");
        addKeyword(patternMap, "LJCCDCD");
        addKeyword(patternMap, "LJCCDID");
        addKeyword(patternMap, "LJCCDJCD");
        addKeyword(patternMap, "LJCD");
        addKeyword(patternMap, "LJCDD");
        addKeyword(patternMap, "LJCGD");
        addKeyword(patternMap, "LJCJJD");
        addKeyword(patternMap, "LJCWCWJWCWJD");
        addKeyword(patternMap, "LJD");
        addKeyword(patternMap, "LJDCCD");
        addKeyword(patternMap, "LJDCD");
        addKeyword(patternMap, "LJDD");
        addKeyword(patternMap, "LJDJPD");
        addKeyword(patternMap, "LJDJPDD");
        addKeyword(patternMap, "LJDJPDID");
        addKeyword(patternMap, "LJDJPMDD");
        addKeyword(patternMap, "LJFJJCLCD");
        addKeyword(patternMap, "LJGD");
        addKeyword(patternMap, "LJID");
        addKeyword(patternMap, "LJJCD");
        addKeyword(patternMap, "LJJD");
        addKeyword(patternMap, "LJLD");
        addKeyword(patternMap, "LJMD");
        addKeyword(patternMap, "LJPCD");
        addKeyword(patternMap, "LKCD");
        addKeyword(patternMap, "LLCD");
        addKeyword(patternMap, "LLD");
        addKeyword(patternMap, "LLPD");
        addKeyword(patternMap, "LMCCFCCD");
        addKeyword(patternMap, "LMCD");
        addKeyword(patternMap, "LMD");
        addKeyword(patternMap, "LMID");
        addKeyword(patternMap, "LPCCCCCD");
        addKeyword(patternMap, "LPCCCD");
        addKeyword(patternMap, "LPCCD");
        addKeyword(patternMap, "LPCD");
        addKeyword(patternMap, "LPCDD");
        addKeyword(patternMap, "LPCFPPD");
        addKeyword(patternMap, "LPCGCCCD");
        addKeyword(patternMap, "LPCGCCD");
        addKeyword(patternMap, "LPCGCCDCCD");
        addKeyword(patternMap, "LPCGD");
        addKeyword(patternMap, "LPCGDDPD");
        addKeyword(patternMap, "LPD");
        addKeyword(patternMap, "LPDD");
        addKeyword(patternMap, "LPDDD");
        addKeyword(patternMap, "LPICD");
        addKeyword(patternMap, "LPID");
        addKeyword(patternMap, "LPJD");
        addKeyword(patternMap, "LPMDCCD");
        addKeyword(patternMap, "LPPJD");
        addKeyword(patternMap, "MCCCD");
        addKeyword(patternMap, "MCCD");
        addKeyword(patternMap, "MCCPD");
        addKeyword(patternMap, "MCD");
        addKeyword(patternMap, "MCDCCD");
        addKeyword(patternMap, "MCDCCDCD");
        addKeyword(patternMap, "MCDCCDD");
        addKeyword(patternMap, "MCDCD");
        addKeyword(patternMap, "MCDCGD");
        addKeyword(patternMap, "MCDD");
        addKeyword(patternMap, "MCDFD");
        addKeyword(patternMap, "MCDFDD");
        addKeyword(patternMap, "MCDLCD");
        addKeyword(patternMap, "MCDPPD");
        addKeyword(patternMap, "MCGCD");
        addKeyword(patternMap, "MCICD");
        addKeyword(patternMap, "MCID");
        addKeyword(patternMap, "MCIDWGWD");
        addKeyword(patternMap, "MCJD");
        addKeyword(patternMap, "MCLD");
        addKeyword(patternMap, "MCPD");
        addKeyword(patternMap, "MD");
        addKeyword(patternMap, "MDD");
        addKeyword(patternMap, "MFD");
        addKeyword(patternMap, "MGD");
        addKeyword(patternMap, "MGJD");
        addKeyword(patternMap, "MGJJD");
        addKeyword(patternMap, "MICCD");
        addKeyword(patternMap, "MICD");
        addKeyword(patternMap, "MID");
        addKeyword(patternMap, "MIDCCD");
        addKeyword(patternMap, "MJCCD");
        addKeyword(patternMap, "MJCD");
        addKeyword(patternMap, "MJD");
        addKeyword(patternMap, "MJDD");
        addKeyword(patternMap, "MLCD");
        addKeyword(patternMap, "MLD");
        addKeyword(patternMap, "MLGD");
        addKeyword(patternMap, "MLGGD");
        addKeyword(patternMap, "MMCCD");
        addKeyword(patternMap, "MMCD");
        addKeyword(patternMap, "MMD");
        addKeyword(patternMap, "MMMD");
        addKeyword(patternMap, "MMPD");
        addKeyword(patternMap, "MPCCD");
        addKeyword(patternMap, "MPCD");
        addKeyword(patternMap, "MPD");
        addKeyword(patternMap, "MPDCD");
        addKeyword(patternMap, "MPJPD");
        addKeyword(patternMap, "MPPD");
        addKeyword(patternMap, "PCCCCCCD");
        addKeyword(patternMap, "PCCCCCD");
        addKeyword(patternMap, "PCCCCD");
        addKeyword(patternMap, "PCCCD");
        addKeyword(patternMap, "PCCCDD");
        addKeyword(patternMap, "PCCD");
        addKeyword(patternMap, "PCCDD");
        addKeyword(patternMap, "PCCGJGD");
        addKeyword(patternMap, "PCCID");
        addKeyword(patternMap, "PCCIDD");
        addKeyword(patternMap, "PCD");
        addKeyword(patternMap, "PCDCD");
        addKeyword(patternMap, "PCDCJCD");
        addKeyword(patternMap, "PCDD");
        addKeyword(patternMap, "PCDFCCCD");
        addKeyword(patternMap, "PCDID");
        addKeyword(patternMap, "PCGCCD");
        addKeyword(patternMap, "PCGCD");
        addKeyword(patternMap, "PCGD");
        addKeyword(patternMap, "PCID");
        addKeyword(patternMap, "PCJCD");
        addKeyword(patternMap, "PCJGD");
        addKeyword(patternMap, "PCPCCD");
        addKeyword(patternMap, "PCPD");
        addKeyword(patternMap, "PD");
        addKeyword(patternMap, "PDCCD");
        addKeyword(patternMap, "PDD");
        addKeyword(patternMap, "PDDD");
        addKeyword(patternMap, "PFCCD");
        addKeyword(patternMap, "PFCDD");
        addKeyword(patternMap, "PFCJCD");
        addKeyword(patternMap, "PFD");
        addKeyword(patternMap, "PFFCD");
        addKeyword(patternMap, "PFPCD");
        addKeyword(patternMap, "PGCD");
        addKeyword(patternMap, "PGCJD");
        addKeyword(patternMap, "PGD");
        addKeyword(patternMap, "PGDCICD");
        addKeyword(patternMap, "PGJD");
        addKeyword(patternMap, "PICCD");
        addKeyword(patternMap, "PICD");
        addKeyword(patternMap, "PICDD");
        addKeyword(patternMap, "PID");
        addKeyword(patternMap, "PIFD");
        addKeyword(patternMap, "PIJCCD");
        addKeyword(patternMap, "PIJD");
        addKeyword(patternMap, "PJCCCDD");
        addKeyword(patternMap, "PJCCD");
        addKeyword(patternMap, "PJCD");
        addKeyword(patternMap, "PJD");
        addKeyword(patternMap, "PJDCD");
        addKeyword(patternMap, "PJDD");
        addKeyword(patternMap, "PJFD");
        addKeyword(patternMap, "PJGD");
        addKeyword(patternMap, "PJICCCPCD");
        addKeyword(patternMap, "PJID");
        addKeyword(patternMap, "PJJD");
        addKeyword(patternMap, "PJJDD");
        addKeyword(patternMap, "PJJPD");
        addKeyword(patternMap, "PJLPCD");
        addKeyword(patternMap, "PJPCD");
        addKeyword(patternMap, "PJPD");
        addKeyword(patternMap, "PLD");
        addKeyword(patternMap, "PLPCD");
        addKeyword(patternMap, "PMJCD");
        addKeyword(patternMap, "PPCCCDCD");
        addKeyword(patternMap, "PPCD");
        addKeyword(patternMap, "PPCJCCD");
        addKeyword(patternMap, "PPD");
        addKeyword(patternMap, "PPDCD");
        addKeyword(patternMap, "PPFCCD");
        addKeyword(patternMap, "PPFCD");
        addKeyword(patternMap, "PPGCID");
        addKeyword(patternMap, "PPGD");
        addKeyword(patternMap, "PPGJCCD");
        addKeyword(patternMap, "PPICCD");
        addKeyword(patternMap, "PPIGD");
        addKeyword(patternMap, "PPJCD");
        addKeyword(patternMap, "PPJD");
        addKeyword(patternMap, "PPJJD");
        addKeyword(patternMap, "PPMD");
        addKeyword(patternMap, "PPPCPD");
        addKeyword(patternMap, "PPPD");
        addKeyword(patternMap, "PPPWGWCCD");
        addKeyword(patternMap, "CCCCDID");
        addKeyword(patternMap, "CCCDFGD");
        addKeyword(patternMap, "CCCDGCD");
        addKeyword(patternMap, "CCCDGDD");
        addKeyword(patternMap, "CCCDWD");
        addKeyword(patternMap, "CCCGCCD");
        addKeyword(patternMap, "CCCGCD");
        addKeyword(patternMap, "CCCWCWD");
        addKeyword(patternMap, "CCCWGWCCD");
        addKeyword(patternMap, "CCCWGWCCDWD");
        addKeyword(patternMap, "CCCWGWD");
        addKeyword(patternMap, "CCDDGCD");
        addKeyword(patternMap, "CCDPCCD");
        addKeyword(patternMap, "CCDWD");
        addKeyword(patternMap, "CCFGCCCCCD");
        addKeyword(patternMap, "CCFGFCCCD");
        addKeyword(patternMap, "CCFPCD");
        addKeyword(patternMap, "CCGDD");
        addKeyword(patternMap, "CCGGCCD");
        addKeyword(patternMap, "CCIDGD");
        addKeyword(patternMap, "CCKD");
        addKeyword(patternMap, "CCMIDGCD");
        addKeyword(patternMap, "CCWD");
        addKeyword(patternMap, "CCWGWCCCD");
        addKeyword(patternMap, "CCWGWCD");
        addKeyword(patternMap, "CCWGWDD");
        addKeyword(patternMap, "CDWGWDGD");
        addKeyword(patternMap, "CFCCGWD");
        addKeyword(patternMap, "CFCD");
        addKeyword(patternMap, "CFCWGWD");
        addKeyword(patternMap, "CFGFGFGFGJID");
        addKeyword(patternMap, "CFJD");
        addKeyword(patternMap, "CFWGWCCDGCD");
        addKeyword(patternMap, "CFWGWCJCD");
        addKeyword(patternMap, "CGCCCCD");
        addKeyword(patternMap, "CGCCID");
        addKeyword(patternMap, "CGCCJCCCD");
        addKeyword(patternMap, "CGCDCCD");
        addKeyword(patternMap, "CGCFCCD");
        addKeyword(patternMap, "CGCGCD");
        addKeyword(patternMap, "CGCID");
        addKeyword(patternMap, "CGFCCD");
        addKeyword(patternMap, "CGFCD");
        addKeyword(patternMap, "CGFDID");
        addKeyword(patternMap, "CGGCICD");
        addKeyword(patternMap, "CGGJPD");
        addKeyword(patternMap, "CGICDGCD");
        addKeyword(patternMap, "CGICDID");
        addKeyword(patternMap, "CGIID");
        addKeyword(patternMap, "CGJCCCD");
        addKeyword(patternMap, "CGJCCD");
        addKeyword(patternMap, "CGJCD");
        addKeyword(patternMap, "CGJCDGD");
        addKeyword(patternMap, "CGJCDWD");
        addKeyword(patternMap, "CGJCJCD");
        addKeyword(patternMap, "CGJDD");
        addKeyword(patternMap, "CGJDDCCD");
        addKeyword(patternMap, "CGJGCD");
        addKeyword(patternMap, "CGJID");
        addKeyword(patternMap, "CGLCCD");
        addKeyword(patternMap, "CGPCCD");
        addKeyword(patternMap, "CGPCD");
        addKeyword(patternMap, "CGPD");
        addKeyword(patternMap, "CGPFCCD");
        addKeyword(patternMap, "CGPICD");
        addKeyword(patternMap, "CGPID");
        addKeyword(patternMap, "CGPJCDD");
        addKeyword(patternMap, "CGPJJJCD");
        addKeyword(patternMap, "CICCDGD");
        addKeyword(patternMap, "CICFJGD");
        addKeyword(patternMap, "CICGFID");
        addKeyword(patternMap, "CIDCD");
        addKeyword(patternMap, "CIDGD");
        addKeyword(patternMap, "CIFID");
        addKeyword(patternMap, "CIGCCD");
        addKeyword(patternMap, "CIGMCD");
        addKeyword(patternMap, "CIICCD");
        addKeyword(patternMap, "CIICD");
        addKeyword(patternMap, "CIJCWGWCD");
        addKeyword(patternMap, "CIJD");
        addKeyword(patternMap, "CIJWD");
        addKeyword(patternMap, "CIPCCD");
        addKeyword(patternMap, "CJCCDFD");
        addKeyword(patternMap, "CJCGD");
        addKeyword(patternMap, "CJCID");
        addKeyword(patternMap, "CJCWCCCD");
        addKeyword(patternMap, "CJCWGWD");
        addKeyword(patternMap, "CJGCCCD");
        addKeyword(patternMap, "CJICD");
        addKeyword(patternMap, "CJIDD");
        addKeyword(patternMap, "CJJCD");
        addKeyword(patternMap, "CJWGCD");
        addKeyword(patternMap, "CJWGWID");
        addKeyword(patternMap, "CPCCDGJD");
        addKeyword(patternMap, "CPCDCCD");
        addKeyword(patternMap, "CPDFCD");
        addKeyword(patternMap, "CPGID");
        addKeyword(patternMap, "CPICD");
        addKeyword(patternMap, "CPIWGWD");
        addKeyword(patternMap, "CPJGD");
        addKeyword(patternMap, "CPPCD");
        addKeyword(patternMap, "CPWGWDGD");
        addKeyword(patternMap, "FCCCCCCCD");
        addKeyword(patternMap, "FCCCCGD");
        addKeyword(patternMap, "FCCCDGD");
        addKeyword(patternMap, "FCCCWGWD");
        addKeyword(patternMap, "FCCDD");
        addKeyword(patternMap, "FCCDFCGD");
        addKeyword(patternMap, "FCCDGD");
        addKeyword(patternMap, "FCCDIPD");
        addKeyword(patternMap, "FCCDWGWD");
        addKeyword(patternMap, "FCCPCD");
        addKeyword(patternMap, "FCCWGWDD");
        addKeyword(patternMap, "FCDGD");
        addKeyword(patternMap, "FCDWD");
        addKeyword(patternMap, "FCDWGD");
        addKeyword(patternMap, "FCFWGWD");
        addKeyword(patternMap, "FCICCD");
        addKeyword(patternMap, "FCICDGD");
        addKeyword(patternMap, "FCIWGWDD");
        addKeyword(patternMap, "FCPCD");
        addKeyword(patternMap, "FCPCPD");
        addKeyword(patternMap, "FCPDGD");
        addKeyword(patternMap, "FCPPGD");
        addKeyword(patternMap, "FCWGWCD");
        addKeyword(patternMap, "FCWGWDD");
        addKeyword(patternMap, "FDDD");
        addKeyword(patternMap, "FDGD");
        addKeyword(patternMap, "FDGJCCD");
        addKeyword(patternMap, "FDWGWD");
        addKeyword(patternMap, "FFCCWGWD");
        addKeyword(patternMap, "FFFFD");
        addKeyword(patternMap, "FFFFFWWFD");
        addKeyword(patternMap, "FFFFWWD");
        addKeyword(patternMap, "FFFWD");
        addKeyword(patternMap, "FFFWWD");
        addKeyword(patternMap, "FFFWWFD");
        addKeyword(patternMap, "FFWWD");
        addKeyword(patternMap, "FGFPCCD");
        addKeyword(patternMap, "FGJWGWD");
        addKeyword(patternMap, "FICCCD");
        addKeyword(patternMap, "FICDGD");
        addKeyword(patternMap, "FICGWD");
        addKeyword(patternMap, "FICJD");
        addKeyword(patternMap, "FIICD");
        addKeyword(patternMap, "FIWGWCDD");
        addKeyword(patternMap, "FIWGWD");
        addKeyword(patternMap, "FIWGWDD");
        addKeyword(patternMap, "FJCCDD");
        addKeyword(patternMap, "FJGPCD");
        addKeyword(patternMap, "FJID");
        addKeyword(patternMap, "FJJGD");
        addKeyword(patternMap, "FMJD");
        addKeyword(patternMap, "FPCCD");
        addKeyword(patternMap, "FPCDD");
        addKeyword(patternMap, "FPDD");
        addKeyword(patternMap, "FPIDGD");
        addKeyword(patternMap, "FPWCWD");
        addKeyword(patternMap, "FWFWFD");
        addKeyword(patternMap, "FWGCD");
        addKeyword(patternMap, "FWGWCCD");
        addKeyword(patternMap, "FWGWCDGCD");
        addKeyword(patternMap, "FWGWCDGD");
        addKeyword(patternMap, "FWGWGD");
        addKeyword(patternMap, "FWJD");
        addKeyword(patternMap, "GCCCCCCDCD");
        addKeyword(patternMap, "GCCCCCDGD");
        addKeyword(patternMap, "GCCCCCID");
        addKeyword(patternMap, "GCCCCCKFD");
        addKeyword(patternMap, "GCCCCDCD");
        addKeyword(patternMap, "GCCCCDGCD");
        addKeyword(patternMap, "GCCCCDGCIJD");
        addKeyword(patternMap, "GCCCCDGDGDDDD");
        addKeyword(patternMap, "GCCCCDWFCCD");
        addKeyword(patternMap, "GCCCCDWGD");
        addKeyword(patternMap, "GCCCCFCCCCD");
        addKeyword(patternMap, "GCCCCID");
        addKeyword(patternMap, "GCCCDCPD");
        addKeyword(patternMap, "GCCCDDGCD");
        addKeyword(patternMap, "GCCCDDGD");
        addKeyword(patternMap, "GCCCDFCD");
        addKeyword(patternMap, "GCCCDGD");
        addKeyword(patternMap, "GCCCDGID");
        addKeyword(patternMap, "GCCCDICD");
        addKeyword(patternMap, "GCCCDMD");
        addKeyword(patternMap, "GCCCDWGCDWFCCD");
        addKeyword(patternMap, "GCCCDWGD");
        addKeyword(patternMap, "GCCCDWGWD");
        addKeyword(patternMap, "GCCCDWID");
        addKeyword(patternMap, "GCCCGPD");
        addKeyword(patternMap, "GCCCIJD");
        addKeyword(patternMap, "GCCCJCCD");
        addKeyword(patternMap, "GCCCJJCD");
        addKeyword(patternMap, "GCCCMCD");
        addKeyword(patternMap, "GCCCWD");
        addKeyword(patternMap, "GCCDCCMD");
        addKeyword(patternMap, "GCCDDWD");
        addKeyword(patternMap, "GCCDFCCD");
        addKeyword(patternMap, "GCCDGCD");
        addKeyword(patternMap, "GCCDGCGD");
        addKeyword(patternMap, "GCCDGDGCD");
        addKeyword(patternMap, "GCCDGJD");
        addKeyword(patternMap, "GCCDPPCD");
        addKeyword(patternMap, "GCCDWD");
        addKeyword(patternMap, "GCCFCCD");
        addKeyword(patternMap, "GCCFID");
        addKeyword(patternMap, "GCCFJCD");
        addKeyword(patternMap, "GCCFWCWCD");
        addKeyword(patternMap, "GCCGDCD");
        addKeyword(patternMap, "GCCGFD");
        addKeyword(patternMap, "GCCGFICD");
        addKeyword(patternMap, "GCCGID");
        addKeyword(patternMap, "GCCGIID");
        addKeyword(patternMap, "GCCICCD");
        addKeyword(patternMap, "GCCICDCD");
        addKeyword(patternMap, "GCCICWDD");
        addKeyword(patternMap, "GCCIDWDCD");
        addKeyword(patternMap, "GCCIID");
        addKeyword(patternMap, "GCCIJD");
        addKeyword(patternMap, "GCCJCDD");
        addKeyword(patternMap, "GCCJCGCD");
        addKeyword(patternMap, "GCCJDD");
        addKeyword(patternMap, "GCCJIDCD");
        addKeyword(patternMap, "GCCKDGD");
        addKeyword(patternMap, "GCCMJCD");
        addKeyword(patternMap, "GCCMJJCD");
        addKeyword(patternMap, "GCCWD");
        addKeyword(patternMap, "GCDCCCDGD");
        addKeyword(patternMap, "GCDCWDWD");
        addKeyword(patternMap, "GCDDDD");
        addKeyword(patternMap, "GCDDJCD");
        addKeyword(patternMap, "GCDFCD");
        addKeyword(patternMap, "GCDFID");
        addKeyword(patternMap, "GCDFJD");
        addKeyword(patternMap, "GCDGCGD");
        addKeyword(patternMap, "GCDGGGCD");
        addKeyword(patternMap, "GCDGIID");
        addKeyword(patternMap, "GCDIID");
        addKeyword(patternMap, "GCDKD");
        addKeyword(patternMap, "GCDMDFD");
        addKeyword(patternMap, "GCDPGD");
        addKeyword(patternMap, "GCDWD");
        addKeyword(patternMap, "GCDWDWD");
        addKeyword(patternMap, "GCFCCCD");
        addKeyword(patternMap, "GCFCCCDGD");
        addKeyword(patternMap, "GCFCDICD");
        addKeyword(patternMap, "GCFCDWGD");
        addKeyword(patternMap, "GCFCIFD");
        addKeyword(patternMap, "GCFCJD");
        addKeyword(patternMap, "GCFDDCID");
        addKeyword(patternMap, "GCFFJD");
        addKeyword(patternMap, "GCFGJPCD");
        addKeyword(patternMap, "GCFICD");
        addKeyword(patternMap, "GCFIDFD");
        addKeyword(patternMap, "GCFJD");
        addKeyword(patternMap, "GCFJDD");
        addKeyword(patternMap, "GCFJPD");
        addKeyword(patternMap, "GCFPCCCD");
        addKeyword(patternMap, "GCFPDD");
        addKeyword(patternMap, "GCFPID");
        addKeyword(patternMap, "GCGCCCCD");
        addKeyword(patternMap, "GCGCCCID");
        addKeyword(patternMap, "GCGCCCIDD");
        addKeyword(patternMap, "GCGCCDD");
        addKeyword(patternMap, "GCGCCDFD");
        addKeyword(patternMap, "GCGCCID");
        addKeyword(patternMap, "GCGCCJCD");
        addKeyword(patternMap, "GCGCCPD");
        addKeyword(patternMap, "GCGCDCCCD");
        addKeyword(patternMap, "GCGCDCD");
        addKeyword(patternMap, "GCGCDCID");
        addKeyword(patternMap, "GCGCDD");
        addKeyword(patternMap, "GCGCFCCD");
        addKeyword(patternMap, "GCGCFCD");
        addKeyword(patternMap, "GCGCFGCD");
        addKeyword(patternMap, "GCGCGCCD");
        addKeyword(patternMap, "GCGCGCD");
        addKeyword(patternMap, "GCGCGCPCCD");
        addKeyword(patternMap, "GCGCGD");
        addKeyword(patternMap, "GCGCGID");
        addKeyword(patternMap, "GCGCGPD");
        addKeyword(patternMap, "GCGCICCCD");
        addKeyword(patternMap, "GCGCICDDFCCCD");
        addKeyword(patternMap, "GCGCIDD");
        addKeyword(patternMap, "GCGCIID");
        addKeyword(patternMap, "GCGCJCCD");
        addKeyword(patternMap, "GCGCJD");
        addKeyword(patternMap, "GCGCJGWD");
        addKeyword(patternMap, "GCGCJJD");
        addKeyword(patternMap, "GCGCLCCD");
        addKeyword(patternMap, "GCGCPCCD");
        addKeyword(patternMap, "GCGCPCCID");
        addKeyword(patternMap, "GCGCPCD");
        addKeyword(patternMap, "GCGCPCJCCD");
        addKeyword(patternMap, "GCGDCCICCD");
        addKeyword(patternMap, "GCGDCD");
        addKeyword(patternMap, "GCGDIMD");
        addKeyword(patternMap, "GCGFCCD");
        addKeyword(patternMap, "GCGFCD");
        addKeyword(patternMap, "GCGFCJD");
        addKeyword(patternMap, "GCGFCMJD");
        addKeyword(patternMap, "GCGFD");
        addKeyword(patternMap, "GCGFDD");
        addKeyword(patternMap, "GCGFFCD");
        addKeyword(patternMap, "GCGFFD");
        addKeyword(patternMap, "GCGFID");
        addKeyword(patternMap, "GCGFIDD");
        addKeyword(patternMap, "GCGFJD");
        addKeyword(patternMap, "GCGGCCD");
        addKeyword(patternMap, "GCGGGJCD");
        addKeyword(patternMap, "GCGGJCID");
        addKeyword(patternMap, "GCGGJCJD");
        addKeyword(patternMap, "GCGICCCD");
        addKeyword(patternMap, "GCGICCD");
        addKeyword(patternMap, "GCGICCJD");
        addKeyword(patternMap, "GCGICDMD");
        addKeyword(patternMap, "GCGICICCD");
        addKeyword(patternMap, "GCGICJCDD");
        addKeyword(patternMap, "GCGICJD");
        addKeyword(patternMap, "GCGICJJD");
        addKeyword(patternMap, "GCGIDCGD");
        addKeyword(patternMap, "GCGIDD");
        addKeyword(patternMap, "GCGIDGD");
        addKeyword(patternMap, "GCGIGCCD");
        addKeyword(patternMap, "GCGIICD");
        addKeyword(patternMap, "GCGIID");
        addKeyword(patternMap, "GCGIMCCD");
        addKeyword(patternMap, "GCGIMJD");
        addKeyword(patternMap, "GCGIPCCD");
        addKeyword(patternMap, "GCGIPD");
        addKeyword(patternMap, "GCGJCCCCDD");
        addKeyword(patternMap, "GCGJCCCD");
        addKeyword(patternMap, "GCGJCCDD");
        addKeyword(patternMap, "GCGJCD");
        addKeyword(patternMap, "GCGJCID");
        addKeyword(patternMap, "GCGJD");
        addKeyword(patternMap, "GCGJDD");
        addKeyword(patternMap, "GCGJGICD");
        addKeyword(patternMap, "GCGJICD");
        addKeyword(patternMap, "GCGJID");
        addKeyword(patternMap, "GCGJIFCD");
        addKeyword(patternMap, "GCGJJCD");
        addKeyword(patternMap, "GCGJPCCD");
        addKeyword(patternMap, "GCGJPCD");
        addKeyword(patternMap, "GCGKCD");
        addKeyword(patternMap, "GCGKD");
        addKeyword(patternMap, "GCGLCDCCD");
        addKeyword(patternMap, "GCGLCJD");
        addKeyword(patternMap, "GCGLGCCD");
        addKeyword(patternMap, "GCGLGPCCID");
        addKeyword(patternMap, "GCGLIPJD");
        addKeyword(patternMap, "GCGLJJID");
        addKeyword(patternMap, "GCGMCD");
        addKeyword(patternMap, "GCGMD");
        addKeyword(patternMap, "GCGPCCCCCD");
        addKeyword(patternMap, "GCGPCCCD");
        addKeyword(patternMap, "GCGPCD");
        addKeyword(patternMap, "GCGPCFCCD");
        addKeyword(patternMap, "GCGPCID");
        addKeyword(patternMap, "GCGPCPD");
        addKeyword(patternMap, "GCGPD");
        addKeyword(patternMap, "GCGPFCD");
        addKeyword(patternMap, "GCGPGCD");
        addKeyword(patternMap, "GCGPIID");
        addKeyword(patternMap, "GCGPJCCD");
        addKeyword(patternMap, "GCGPJCD");
        addKeyword(patternMap, "GCGPJD");
        addKeyword(patternMap, "GCGPJGCD");
        addKeyword(patternMap, "GCGPJID");
        addKeyword(patternMap, "GCGPLICD");
        addKeyword(patternMap, "GCGPLID");
        addKeyword(patternMap, "GCGPPCCD");
        addKeyword(patternMap, "GCGPPCD");
        addKeyword(patternMap, "GCGPPD");
        addKeyword(patternMap, "GCGPPID");
        addKeyword(patternMap, "GCGPPJD");
        addKeyword(patternMap, "GCGWPFCD");
        addKeyword(patternMap, "GCICCCDD");
        addKeyword(patternMap, "GCICCDFD");
        addKeyword(patternMap, "GCICCJD");
        addKeyword(patternMap, "GCICCWDWDCGD");
        addKeyword(patternMap, "GCICDFCD");
        addKeyword(patternMap, "GCICPD");
        addKeyword(patternMap, "GCIDCD");
        addKeyword(patternMap, "GCIDCGD");
        addKeyword(patternMap, "GCIDDGD");
        addKeyword(patternMap, "GCIDPCCD");
        addKeyword(patternMap, "GCIICD");
        addKeyword(patternMap, "GCIJCCD");
        addKeyword(patternMap, "GCIJCCDMD");
        addKeyword(patternMap, "GCIJCID");
        addKeyword(patternMap, "GCIKD");
        addKeyword(patternMap, "GCIPCCD");
        addKeyword(patternMap, "GCIPCPD");
        addKeyword(patternMap, "GCJCCCCCD");
        addKeyword(patternMap, "GCJCCDCD");
        addKeyword(patternMap, "GCJCCDGD");
        addKeyword(patternMap, "GCJCCDMD");
        addKeyword(patternMap, "GCJCCICD");
        addKeyword(patternMap, "GCJCDD");
        addKeyword(patternMap, "GCJCICD");
        addKeyword(patternMap, "GCJCKDD");
        addKeyword(patternMap, "GCJDCDCD");
        addKeyword(patternMap, "GCJDDCD");
        addKeyword(patternMap, "GCJGCD");
        addKeyword(patternMap, "GCJICCCD");
        addKeyword(patternMap, "GCJICGD");
        addKeyword(patternMap, "GCJIDCD");
        addKeyword(patternMap, "GCJIDD");
        addKeyword(patternMap, "GCJJCDD");
        addKeyword(patternMap, "GCJJCJCD");
        addKeyword(patternMap, "GCJJDD");
        addKeyword(patternMap, "GCJMCID");
        addKeyword(patternMap, "GCJPCCCD");
        addKeyword(patternMap, "GCJPCCD");
        addKeyword(patternMap, "GCJPCD");
        addKeyword(patternMap, "GCJPCDMD");
        addKeyword(patternMap, "GCJPID");
        addKeyword(patternMap, "GCJPJD");
        addKeyword(patternMap, "GCJWCPWD");
        addKeyword(patternMap, "GCKCCCD");
        addKeyword(patternMap, "GCKCD");
        addKeyword(patternMap, "GCKDGD");
        addKeyword(patternMap, "GCKGD");
        addKeyword(patternMap, "GCKICD");
        addKeyword(patternMap, "GCKJCCD");
        addKeyword(patternMap, "GCKPD");
        addKeyword(patternMap, "GCLCID");
        addKeyword(patternMap, "GCLGIJCD");
        addKeyword(patternMap, "GCLID");
        addKeyword(patternMap, "GCMCCDFD");
        addKeyword(patternMap, "GCMCCKGD");
        addKeyword(patternMap, "GCMCJCCD");
        addKeyword(patternMap, "GCMCPD");
        addKeyword(patternMap, "GCMDCGCD");
        addKeyword(patternMap, "GCMFCDGD");
        addKeyword(patternMap, "GCMID");
        addKeyword(patternMap, "GCMJCD");
        addKeyword(patternMap, "GCMJCDD");
        addKeyword(patternMap, "GCMJCID");
        addKeyword(patternMap, "GCMJID");
        addKeyword(patternMap, "GCMJPCCCCD");
        addKeyword(patternMap, "GCMKD");
        addKeyword(patternMap, "GCMKGD");
        addKeyword(patternMap, "GCMPCCD");
        addKeyword(patternMap, "GCMPJD");
        addKeyword(patternMap, "GCMPPCCD");
        addKeyword(patternMap, "GCPCCCMD");
        addKeyword(patternMap, "GCPCCDCD");
        addKeyword(patternMap, "GCPCCDMD");
        addKeyword(patternMap, "GCPCCDWD");
        addKeyword(patternMap, "GCPCCWGCWD");
        addKeyword(patternMap, "GCPCDCD");
        addKeyword(patternMap, "GCPCDGD");
        addKeyword(patternMap, "GCPCDWD");
        addKeyword(patternMap, "GCPCICDWGD");
        addKeyword(patternMap, "GCPCIICFD");
        addKeyword(patternMap, "GCPCJCFD");
        addKeyword(patternMap, "GCPCJD");
        addKeyword(patternMap, "GCPDGD");
        addKeyword(patternMap, "GCPGGCD");
        addKeyword(patternMap, "GCPICCCDGD");
        addKeyword(patternMap, "GCPICCD");
        addKeyword(patternMap, "GCPICD");
        addKeyword(patternMap, "GCPICID");
        addKeyword(patternMap, "GCPID");
        addKeyword(patternMap, "GCPIJCCD");
        addKeyword(patternMap, "GCPJCDD");
        addKeyword(patternMap, "GCPJPDD");
        addKeyword(patternMap, "GCPKD");
        addKeyword(patternMap, "GCPMCCD");
        addKeyword(patternMap, "GCPMJCD");
        addKeyword(patternMap, "GCPPCD");
        addKeyword(patternMap, "GCPPID");
        addKeyword(patternMap, "GCPPWCWID");
        addKeyword(patternMap, "GCPWCWCD");
        addKeyword(patternMap, "GCPWDWDCCD");
        addKeyword(patternMap, "GCWDWDCCD");
        addKeyword(patternMap, "GCWGWCCD");
        addKeyword(patternMap, "GCWGWD");
        addKeyword(patternMap, "GCWGWJD");
        addKeyword(patternMap, "GCWJCCD");
        addKeyword(patternMap, "GDCCCCFCD");
        addKeyword(patternMap, "GDCCCFCPD");
        addKeyword(patternMap, "GDCCPCCD");
        addKeyword(patternMap, "GDCDGCD");
        addKeyword(patternMap, "GDCDJD");
        addKeyword(patternMap, "GDCKGCD");
        addKeyword(patternMap, "GDDGCD");
        addKeyword(patternMap, "GDDGD");
        addKeyword(patternMap, "GDDMD");
        addKeyword(patternMap, "GDICCCD");
        addKeyword(patternMap, "GDIPD");
        addKeyword(patternMap, "GDJCICD");
        addKeyword(patternMap, "GDLCCD");
        addKeyword(patternMap, "GFCCCCCCD");
        addKeyword(patternMap, "GFCCCCFD");
        addKeyword(patternMap, "GFCCCDD");
        addKeyword(patternMap, "GFCCCDDD");
        addKeyword(patternMap, "GFCCCDFCD");
        addKeyword(patternMap, "GFCCCDFDD");
        addKeyword(patternMap, "GFCCCDGCD");
        addKeyword(patternMap, "GFCCCDGD");
        addKeyword(patternMap, "GFCCCDID");
        addKeyword(patternMap, "GFCCDCCD");
        addKeyword(patternMap, "GFCCDCD");
        addKeyword(patternMap, "GFCCDCFD");
        addKeyword(patternMap, "GFCCDDD");
        addKeyword(patternMap, "GFCCDFCD");
        addKeyword(patternMap, "GFCCDFDMD");
        addKeyword(patternMap, "GFCCDFFCD");
        addKeyword(patternMap, "GFCCDFFD");
        addKeyword(patternMap, "GFCCDFGD");
        addKeyword(patternMap, "GFCCDGCCD");
        addKeyword(patternMap, "GFCCDGCD");
        addKeyword(patternMap, "GFCCDGD");
        addKeyword(patternMap, "GFCCDGGID");
        addKeyword(patternMap, "GFCCDGICDJICD");
        addKeyword(patternMap, "GFCCDID");
        addKeyword(patternMap, "GFCCDLD");
        addKeyword(patternMap, "GFCCDMD");
        addKeyword(patternMap, "GFCCDWCD");
        addKeyword(patternMap, "GFCCDWD");
        addKeyword(patternMap, "GFCCDWFDD");
        addKeyword(patternMap, "GFCCDWGCD");
        addKeyword(patternMap, "GFCCDWGD");
        addKeyword(patternMap, "GFCCID");
        addKeyword(patternMap, "GFCCJD");
        addKeyword(patternMap, "GFCCPCD");
        addKeyword(patternMap, "GFCDDCCCD");
        addKeyword(patternMap, "GFCDFCCD");
        addKeyword(patternMap, "GFCDFCD");
        addKeyword(patternMap, "GFCDGCD");
        addKeyword(patternMap, "GFCDGD");
        addKeyword(patternMap, "GFCDGDD");
        addKeyword(patternMap, "GFCDGFCD");
        addKeyword(patternMap, "GFCDGGCD");
        addKeyword(patternMap, "GFCDGGD");
        addKeyword(patternMap, "GFCDGPD");
        addKeyword(patternMap, "GFCDID");
        addKeyword(patternMap, "GFCDMIDMD");
        addKeyword(patternMap, "GFCDWCD");
        addKeyword(patternMap, "GFCDWD");
        addKeyword(patternMap, "GFCDWGD");
        addKeyword(patternMap, "GFCFCD");
        addKeyword(patternMap, "GFCGCD");
        addKeyword(patternMap, "GFCGD");
        addKeyword(patternMap, "GFCICD");
        addKeyword(patternMap, "GFCIDCGD");
        addKeyword(patternMap, "GFCIDWD");
        addKeyword(patternMap, "GFCJCCCD");
        addKeyword(patternMap, "GFCJCCD");
        addKeyword(patternMap, "GFCJCCDD");
        addKeyword(patternMap, "GFCJCJD");
        addKeyword(patternMap, "GFCJDD");
        addKeyword(patternMap, "GFCJID");
        addKeyword(patternMap, "GFCKD");
        addKeyword(patternMap, "GFCLCD");
        addKeyword(patternMap, "GFCMCCD");
        addKeyword(patternMap, "GFCMJCDWD");
        addKeyword(patternMap, "GFCPDGD");
        addKeyword(patternMap, "GFCPPCD");
        addKeyword(patternMap, "GFCWCD");
        addKeyword(patternMap, "GFCWCWCD");
        addKeyword(patternMap, "GFCWFWFCCD");
        addKeyword(patternMap, "GFCWGWD");
        addKeyword(patternMap, "GFDCCD");
        addKeyword(patternMap, "GFDCDCDD");
        addKeyword(patternMap, "GFDCDD");
        addKeyword(patternMap, "GFDCDGD");
        addKeyword(patternMap, "GFDCID");
        addKeyword(patternMap, "GFDDCCD");
        addKeyword(patternMap, "GFDDCGD");
        addKeyword(patternMap, "GFDDD");
        addKeyword(patternMap, "GFDDGD");
        addKeyword(patternMap, "GFDDPD");
        addKeyword(patternMap, "GFDGCD");
        addKeyword(patternMap, "GFDGD");
        addKeyword(patternMap, "GFDICD");
        addKeyword(patternMap, "GFDICPCD");
        addKeyword(patternMap, "GFDID");
        addKeyword(patternMap, "GFDJPCD");
        addKeyword(patternMap, "GFDWD");
        addKeyword(patternMap, "GFDWDWD");
        addKeyword(patternMap, "GFFCCCD");
        addKeyword(patternMap, "GFFCJD");
        addKeyword(patternMap, "GFFDD");
        addKeyword(patternMap, "GFFJJDGD");
        addKeyword(patternMap, "GFFPDGD");
        addKeyword(patternMap, "GFGCCCDD");
        addKeyword(patternMap, "GFGCCD");
        addKeyword(patternMap, "GFGCCDGPD");
        addKeyword(patternMap, "GFGFICD");
        addKeyword(patternMap, "GFGMPD");
        addKeyword(patternMap, "GFICCDCD");
        addKeyword(patternMap, "GFICCDD");
        addKeyword(patternMap, "GFICDCD");
        addKeyword(patternMap, "GFICDCJD");
        addKeyword(patternMap, "GFICDD");
        addKeyword(patternMap, "GFICDGD");
        addKeyword(patternMap, "GFICJD");
        addKeyword(patternMap, "GFICKD");
        addKeyword(patternMap, "GFIDD");
        addKeyword(patternMap, "GFIDFGD");
        addKeyword(patternMap, "GFIDGCD");
        addKeyword(patternMap, "GFIDGD");
        addKeyword(patternMap, "GFIDPCPCD");
        addKeyword(patternMap, "GFIGD");
        addKeyword(patternMap, "GFIID");
        addKeyword(patternMap, "GFIIDFCD");
        addKeyword(patternMap, "GFIIGD");
        addKeyword(patternMap, "GFIJCCD");
        addKeyword(patternMap, "GFIJD");
        addKeyword(patternMap, "GFJCCCCD");
        addKeyword(patternMap, "GFJCCDD");
        addKeyword(patternMap, "GFJCDD");
        addKeyword(patternMap, "GFJCDGD");
        addKeyword(patternMap, "GFJCDWD");
        addKeyword(patternMap, "GFJCJD");
        addKeyword(patternMap, "GFJDD");
        addKeyword(patternMap, "GFJDGCD");
        addKeyword(patternMap, "GFJDGFCD");
        addKeyword(patternMap, "GFJDWD");
        addKeyword(patternMap, "GFJDWFICGD");
        addKeyword(patternMap, "GFJFD");
        addKeyword(patternMap, "GFJICD");
        addKeyword(patternMap, "GFJICDGD");
        addKeyword(patternMap, "GFJID");
        addKeyword(patternMap, "GFJJCD");
        addKeyword(patternMap, "GFJJDWGD");
        addKeyword(patternMap, "GFKD");
        addKeyword(patternMap, "GFKDGD");
        addKeyword(patternMap, "GFLCD");
        addKeyword(patternMap, "GFMJCD");
        addKeyword(patternMap, "GFPCCCD");
        addKeyword(patternMap, "GFPCCD");
        addKeyword(patternMap, "GFPCDCD");
        addKeyword(patternMap, "GFPCDD");
        addKeyword(patternMap, "GFPCJD");
        addKeyword(patternMap, "GFPDCD");
        addKeyword(patternMap, "GFPDD");
        addKeyword(patternMap, "GFPDID");
        addKeyword(patternMap, "GFPICD");
        addKeyword(patternMap, "GFPIJD");
        addKeyword(patternMap, "GFPJIDD");
        addKeyword(patternMap, "GFPKD");
        addKeyword(patternMap, "GFPPCCD");
        addKeyword(patternMap, "GFPPCD");
        addKeyword(patternMap, "GFWCWID");
        addKeyword(patternMap, "GFWDWD");
        addKeyword(patternMap, "GFWJD");
        addKeyword(patternMap, "GGCCCCCCD");
        addKeyword(patternMap, "GGCCCCJCD");
        addKeyword(patternMap, "GGCCCDD");
        addKeyword(patternMap, "GGCCCDDD");
        addKeyword(patternMap, "GGCCCDGD");
        addKeyword(patternMap, "GGCCCDWGCD");
        addKeyword(patternMap, "GGCCDCDGD");
        addKeyword(patternMap, "GGCCDFGCD");
        addKeyword(patternMap, "GGCCDGD");
        addKeyword(patternMap, "GGCCDGDCD");
        addKeyword(patternMap, "GGCCDID");
        addKeyword(patternMap, "GGCCDMCD");
        addKeyword(patternMap, "GGCCDWGD");
        addKeyword(patternMap, "GGCCFCD");
        addKeyword(patternMap, "GGCCFD");
        addKeyword(patternMap, "GGCCGCCD");
        addKeyword(patternMap, "GGCCICDD");
        addKeyword(patternMap, "GGCCID");
        addKeyword(patternMap, "GGCCJCCDD");
        addKeyword(patternMap, "GGCCLCD");
        addKeyword(patternMap, "GGCCPCD");
        addKeyword(patternMap, "GGCCPJD");
        addKeyword(patternMap, "GGCDCCDGD");
        addKeyword(patternMap, "GGCDCDD");
        addKeyword(patternMap, "GGCDCDGD");
        addKeyword(patternMap, "GGCDCGD");
        addKeyword(patternMap, "GGCDDCCD");
        addKeyword(patternMap, "GGCDGD");
        addKeyword(patternMap, "GGCDGPGCD");
        addKeyword(patternMap, "GGCDID");
        addKeyword(patternMap, "GGCDMD");
        addKeyword(patternMap, "GGCFCCD");
        addKeyword(patternMap, "GGCFCD");
        addKeyword(patternMap, "GGCFID");
        addKeyword(patternMap, "GGCGCCCCD");
        addKeyword(patternMap, "GGCGCCD");
        addKeyword(patternMap, "GGCGCGCCD");
        addKeyword(patternMap, "GGCGCGCD");
        addKeyword(patternMap, "GGCGCGFCD");
        addKeyword(patternMap, "GGCGDGCD");
        addKeyword(patternMap, "GGCGFD");
        addKeyword(patternMap, "GGCGFID");
        addKeyword(patternMap, "GGCGGCD");
        addKeyword(patternMap, "GGCGGGD");
        addKeyword(patternMap, "GGCGGJD");
        addKeyword(patternMap, "GGCGICCD");
        addKeyword(patternMap, "GGCGIICD");
        addKeyword(patternMap, "GGCGILICD");
        addKeyword(patternMap, "GGCGJID");
        addKeyword(patternMap, "GGCGJIJCD");
        addKeyword(patternMap, "GGCGPCCD");
        addKeyword(patternMap, "GGCGPCD");
        addKeyword(patternMap, "GGCGPJCCD");
        addKeyword(patternMap, "GGCGPJCD");
        addKeyword(patternMap, "GGCGPJD");
        addKeyword(patternMap, "GGCGPPD");
        addKeyword(patternMap, "GGCICCD");
        addKeyword(patternMap, "GGCICCID");
        addKeyword(patternMap, "GGCICD");
        addKeyword(patternMap, "GGCIDD");
        addKeyword(patternMap, "GGCIICD");
        addKeyword(patternMap, "GGCIIJD");
        addKeyword(patternMap, "GGCIPCICCD");
        addKeyword(patternMap, "GGCIPD");
        addKeyword(patternMap, "GGCJCDD");
        addKeyword(patternMap, "GGCJCJD");
        addKeyword(patternMap, "GGCJDD");
        addKeyword(patternMap, "GGCJID");
        addKeyword(patternMap, "GGCKLCD");
        addKeyword(patternMap, "GGCLCCD");
        addKeyword(patternMap, "GGCMCIJD");
        addKeyword(patternMap, "GGCMID");
        addKeyword(patternMap, "GGCPCCCD");
        addKeyword(patternMap, "GGCPCCJCCCWD");
        addKeyword(patternMap, "GGCPCDD");
        addKeyword(patternMap, "GGCPDD");
        addKeyword(patternMap, "GGCPGGCID");
        addKeyword(patternMap, "GGCPICD");
        addKeyword(patternMap, "GGCPICDD");
        addKeyword(patternMap, "GGCPID");
        addKeyword(patternMap, "GGCPJCD");
        addKeyword(patternMap, "GGCPPCCD");
        addKeyword(patternMap, "GGCPPD");
        addKeyword(patternMap, "GGCWDWCCDGCD");
        addKeyword(patternMap, "GGCWGD");
        addKeyword(patternMap, "GGDCDCCD");
        addKeyword(patternMap, "GGDCJD");
        addKeyword(patternMap, "GGDDFD");
        addKeyword(patternMap, "GGDGCCGCD");
        addKeyword(patternMap, "GGDGCDGD");
        addKeyword(patternMap, "GGDLGD");
        addKeyword(patternMap, "GGFCCCCD");
        addKeyword(patternMap, "GGFCDID");
        addKeyword(patternMap, "GGFCFCDD");
        addKeyword(patternMap, "GGFCID");
        addKeyword(patternMap, "GGFCJD");
        addKeyword(patternMap, "GGFCMCCD");
        addKeyword(patternMap, "GGFDCD");
        addKeyword(patternMap, "GGFDDD");
        addKeyword(patternMap, "GGFICD");
        addKeyword(patternMap, "GGFICDD");
        addKeyword(patternMap, "GGFID");
        addKeyword(patternMap, "GGFJCD");
        addKeyword(patternMap, "GGFJID");
        addKeyword(patternMap, "GGFJMD");
        addKeyword(patternMap, "GGFKID");
        addKeyword(patternMap, "GGFMJDD");
        addKeyword(patternMap, "GGFPCD");
        addKeyword(patternMap, "GGFPD");
        addKeyword(patternMap, "GGFWID");
        addKeyword(patternMap, "GGGCCCDGD");
        addKeyword(patternMap, "GGGCCCICD");
        addKeyword(patternMap, "GGGCCDGD");
        addKeyword(patternMap, "GGGCCID");
        addKeyword(patternMap, "GGGCGGD");
        addKeyword(patternMap, "GGGCJCD");
        addKeyword(patternMap, "GGGCPD");
        addKeyword(patternMap, "GGGCPFCPCD");
        addKeyword(patternMap, "GGGCPJD");
        addKeyword(patternMap, "GGGFCCD");
        addKeyword(patternMap, "GGGFCCID");
        addKeyword(patternMap, "GGGFCD");
        addKeyword(patternMap, "GGGFCJD");
        addKeyword(patternMap, "GGGFID");
        addKeyword(patternMap, "GGGGPJD");
        addKeyword(patternMap, "GGGICCD");
        addKeyword(patternMap, "GGGICJD");
        addKeyword(patternMap, "GGGIDGID");
        addKeyword(patternMap, "GGGIICD");
        addKeyword(patternMap, "GGGJCCD");
        addKeyword(patternMap, "GGGJGID");
        addKeyword(patternMap, "GGGKCD");
        addKeyword(patternMap, "GGGKDJD");
        addKeyword(patternMap, "GGGLJCD");
        addKeyword(patternMap, "GGGMCD");
        addKeyword(patternMap, "GGGPCD");
        addKeyword(patternMap, "GGGPFIDWD");
        addKeyword(patternMap, "GGGPIICD");
        addKeyword(patternMap, "GGGPIPD");
        addKeyword(patternMap, "GGGPPID");
        addKeyword(patternMap, "GGICCGCD");
        addKeyword(patternMap, "GGICCID");
        addKeyword(patternMap, "GGICDD");
        addKeyword(patternMap, "GGICFID");
        addKeyword(patternMap, "GGICJCD");
        addKeyword(patternMap, "GGICJDD");
        addKeyword(patternMap, "GGICPCCID");
        addKeyword(patternMap, "GGICPD");
        addKeyword(patternMap, "GGIDID");
        addKeyword(patternMap, "GGIDWGD");
        addKeyword(patternMap, "GGIFCCD");
        addKeyword(patternMap, "GGIFCD");
        addKeyword(patternMap, "GGIFCJD");
        addKeyword(patternMap, "GGIFICD");
        addKeyword(patternMap, "GGIFID");
        addKeyword(patternMap, "GGIFIDDD");
        addKeyword(patternMap, "GGIFJD");
        addKeyword(patternMap, "GGIFMID");
        addKeyword(patternMap, "GGIGPFD");
        addKeyword(patternMap, "GGIICCD");
        addKeyword(patternMap, "GGIJCD");
        addKeyword(patternMap, "GGIJCID");
        addKeyword(patternMap, "GGIJDD");
        addKeyword(patternMap, "GGIJICD");
        addKeyword(patternMap, "GGIPCCD");
        addKeyword(patternMap, "GGIPDCCD");
        addKeyword(patternMap, "GGIPICD");
        addKeyword(patternMap, "GGIPMICD");
        addKeyword(patternMap, "GGJCCCCCD");
        addKeyword(patternMap, "GGJCCCCD");
        addKeyword(patternMap, "GGJCCICD");
        addKeyword(patternMap, "GGJCDD");
        addKeyword(patternMap, "GGJCGCD");
        addKeyword(patternMap, "GGJCICCD");
        addKeyword(patternMap, "GGJCICD");
        addKeyword(patternMap, "GGJGCD");
        addKeyword(patternMap, "GGJGCICD");
        addKeyword(patternMap, "GGJGCLCGCD");
        addKeyword(patternMap, "GGJICCD");
        addKeyword(patternMap, "GGJICJD");
        addKeyword(patternMap, "GGJICPCCD");
        addKeyword(patternMap, "GGJID");
        addKeyword(patternMap, "GGJIID");
        addKeyword(patternMap, "GGJJCD");
        addKeyword(patternMap, "GGJJCDD");
        addKeyword(patternMap, "GGJJCKD");
        addKeyword(patternMap, "GGJJID");
        addKeyword(patternMap, "GGJMID");
        addKeyword(patternMap, "GGJPCCCCD");
        addKeyword(patternMap, "GGJPCCD");
        addKeyword(patternMap, "GGJPCD");
        addKeyword(patternMap, "GGJPCJCD");
        addKeyword(patternMap, "GGJPCJPJCD");
        addKeyword(patternMap, "GGJPID");
        addKeyword(patternMap, "GGJPJD");
        addKeyword(patternMap, "GGKCCCD");
        addKeyword(patternMap, "GGKCD");
        addKeyword(patternMap, "GGKDD");
        addKeyword(patternMap, "GGLCCD");
        addKeyword(patternMap, "GGLCCPJD");
        addKeyword(patternMap, "GGLFCCCD");
        addKeyword(patternMap, "GGLGCJD");
        addKeyword(patternMap, "GGLGFID");
        addKeyword(patternMap, "GGLGPCD");
        addKeyword(patternMap, "GGLJCCD");
        addKeyword(patternMap, "GGLJCID");
        addKeyword(patternMap, "GGMFJD");
        addKeyword(patternMap, "GGMJCDGD");
        addKeyword(patternMap, "GGMPJD");
        addKeyword(patternMap, "GGPCCDD");
        addKeyword(patternMap, "GGPCDD");
        addKeyword(patternMap, "GGPCICD");
        addKeyword(patternMap, "GGPCID");
        addKeyword(patternMap, "GGPFCCD");
        addKeyword(patternMap, "GGPFCD");
        addKeyword(patternMap, "GGPFCID");
        addKeyword(patternMap, "GGPFJD");
        addKeyword(patternMap, "GGPGCD");
        addKeyword(patternMap, "GGPGID");
        addKeyword(patternMap, "GGPICFCD");
        addKeyword(patternMap, "GGPID");
        addKeyword(patternMap, "GGPIDD");
        addKeyword(patternMap, "GGPIID");
        addKeyword(patternMap, "GGPJCCCD");
        addKeyword(patternMap, "GGPJCCD");
        addKeyword(patternMap, "GGPJCCID");
        addKeyword(patternMap, "GGPJCJMD");
        addKeyword(patternMap, "GGPJID");
        addKeyword(patternMap, "GGPJKCCD");
        addKeyword(patternMap, "GGPJPCD");
        addKeyword(patternMap, "GGPPCID");
        addKeyword(patternMap, "GGPPDD");
        addKeyword(patternMap, "GGPPFCCD");
        addKeyword(patternMap, "GGPPICD");
        addKeyword(patternMap, "GGPPJCD");
        addKeyword(patternMap, "GGWCJD");
        addKeyword(patternMap, "GGWGWID");
        addKeyword(patternMap, "GGWIWCCD");
        addKeyword(patternMap, "GICCCCCCCD");
        addKeyword(patternMap, "GICCCDGD");
        addKeyword(patternMap, "GICCDDD");
        addKeyword(patternMap, "GICCDGCD");
        addKeyword(patternMap, "GICCDGD");
        addKeyword(patternMap, "GICCDWD");
        addKeyword(patternMap, "GICCDWGD");
        addKeyword(patternMap, "GICCFCCD");
        addKeyword(patternMap, "GICCICCD");
        addKeyword(patternMap, "GICCICD");
        addKeyword(patternMap, "GICCID");
        addKeyword(patternMap, "GICCJCCD");
        addKeyword(patternMap, "GICDCCCD");
        addKeyword(patternMap, "GICDDWGD");
        addKeyword(patternMap, "GICDGD");
        addKeyword(patternMap, "GICDGJCD");
        addKeyword(patternMap, "GICDID");
        addKeyword(patternMap, "GICDWD");
        addKeyword(patternMap, "GICFD");
        addKeyword(patternMap, "GICFID");
        addKeyword(patternMap, "GICGCD");
        addKeyword(patternMap, "GICICCCCCCCCPD");
        addKeyword(patternMap, "GICICDDGD");
        addKeyword(patternMap, "GICICDFD");
        addKeyword(patternMap, "GICIDGD");
        addKeyword(patternMap, "GICIFD");
        addKeyword(patternMap, "GICIIFID");
        addKeyword(patternMap, "GICJDD");
        addKeyword(patternMap, "GICJDGD");
        addKeyword(patternMap, "GICJJD");
        addKeyword(patternMap, "GICKD");
        addKeyword(patternMap, "GICPCD");
        addKeyword(patternMap, "GICPID");
        addKeyword(patternMap, "GICPIDD");
        addKeyword(patternMap, "GICWCWCWD");
        addKeyword(patternMap, "GIDCDD");
        addKeyword(patternMap, "GIDDCD");
        addKeyword(patternMap, "GIDDGD");
        addKeyword(patternMap, "GIDDWGD");
        addKeyword(patternMap, "GIDFCD");
        addKeyword(patternMap, "GIDGDCD");
        addKeyword(patternMap, "GIDJJD");
        addKeyword(patternMap, "GIFCCCD");
        addKeyword(patternMap, "GIFCD");
        addKeyword(patternMap, "GIFCJD");
        addKeyword(patternMap, "GIFFFWFWD");
        addKeyword(patternMap, "GIFGD");
        addKeyword(patternMap, "GIFICCCD");
        addKeyword(patternMap, "GIFID");
        addKeyword(patternMap, "GIFIDCD");
        addKeyword(patternMap, "GIFJD");
        addKeyword(patternMap, "GIFPD");
        addKeyword(patternMap, "GIFPDCD");
        addKeyword(patternMap, "GIGCCDMD");
        addKeyword(patternMap, "GIGGCD");
        addKeyword(patternMap, "GIGJD");
        addKeyword(patternMap, "GIGMD");
        addKeyword(patternMap, "GIICCCD");
        addKeyword(patternMap, "GIICCDD");
        addKeyword(patternMap, "GIICCDGD");
        addKeyword(patternMap, "GIICCDMCD");
        addKeyword(patternMap, "GIICDD");
        addKeyword(patternMap, "GIICID");
        addKeyword(patternMap, "GIIDFCD");
        addKeyword(patternMap, "GIIDGD");
        addKeyword(patternMap, "GIIDJCD");
        addKeyword(patternMap, "GIIFICD");
        addKeyword(patternMap, "GIIICCD");
        addKeyword(patternMap, "GIIJD");
        addKeyword(patternMap, "GIIPCD");
        addKeyword(patternMap, "GIIPD");
        addKeyword(patternMap, "GIJCCDD");
        addKeyword(patternMap, "GIJCCICD");
        addKeyword(patternMap, "GIJCCJD");
        addKeyword(patternMap, "GIJCDCD");
        addKeyword(patternMap, "GIJCDGD");
        addKeyword(patternMap, "GIJCDWCFD");
        addKeyword(patternMap, "GIJDCD");
        addKeyword(patternMap, "GIJICCD");
        addKeyword(patternMap, "GIJICD");
        addKeyword(patternMap, "GIJICDGD");
        addKeyword(patternMap, "GIJIDD");
        addKeyword(patternMap, "GIJJD");
        addKeyword(patternMap, "GIJJICJD");
        addKeyword(patternMap, "GIJPCD");
        addKeyword(patternMap, "GIJPID");
        addKeyword(patternMap, "GILGCD");
        addKeyword(patternMap, "GIMCID");
        addKeyword(patternMap, "GIMCPD");
        addKeyword(patternMap, "GIPCCCCCD");
        addKeyword(patternMap, "GIPCCCDGD");
        addKeyword(patternMap, "GIPCCDD");
        addKeyword(patternMap, "GIPDCCCCD");
        addKeyword(patternMap, "GIPDGD");
        addKeyword(patternMap, "GIPDWCCD");
        addKeyword(patternMap, "GIPFD");
        addKeyword(patternMap, "GIPID");
        addKeyword(patternMap, "GIPJCDD");
        addKeyword(patternMap, "GIPJD");
        addKeyword(patternMap, "GIWGFWDGD");
        addKeyword(patternMap, "GIWGWDD");
        addKeyword(patternMap, "GJCCCCCDCD");
        addKeyword(patternMap, "GJCCCCCDD");
        addKeyword(patternMap, "GJCCCCDD");
        addKeyword(patternMap, "GJCCCDCD");
        addKeyword(patternMap, "GJCCCDGCD");
        addKeyword(patternMap, "GJCCCDGD");
        addKeyword(patternMap, "GJCCCDLD");
        addKeyword(patternMap, "GJCCCDWD");
        addKeyword(patternMap, "GJCCCPD");
        addKeyword(patternMap, "GJCCDFDD");
        addKeyword(patternMap, "GJCCID");
        addKeyword(patternMap, "GJCCPD");
        addKeyword(patternMap, "GJCCWKWCD");
        addKeyword(patternMap, "GJCDMCCD");
        addKeyword(patternMap, "GJCICCD");
        addKeyword(patternMap, "GJCIWGWCCD");
        addKeyword(patternMap, "GJCJCDID");
        addKeyword(patternMap, "GJCKD");
        addKeyword(patternMap, "GJCLCCCD");
        addKeyword(patternMap, "GJCMIGD");
        addKeyword(patternMap, "GJCMWD");
        addKeyword(patternMap, "GJCPDCCD");
        addKeyword(patternMap, "GJDCDCD");
        addKeyword(patternMap, "GJFCCCD");
        addKeyword(patternMap, "GJFCCDWGCGD");
        addKeyword(patternMap, "GJFCDCD");
        addKeyword(patternMap, "GJFCDD");
        addKeyword(patternMap, "GJFCDWFCD");
        addKeyword(patternMap, "GJFID");
        addKeyword(patternMap, "GJGCCCCD");
        addKeyword(patternMap, "GJGCCCD");
        addKeyword(patternMap, "GJGCCD");
        addKeyword(patternMap, "GJGCCDD");
        addKeyword(patternMap, "GJGCCDID");
        addKeyword(patternMap, "GJGCMJD");
        addKeyword(patternMap, "GJGFJCD");
        addKeyword(patternMap, "GJGJCD");
        addKeyword(patternMap, "GJGJCJCD");
        addKeyword(patternMap, "GJGJCKDGD");
        addKeyword(patternMap, "GJGMCCD");
        addKeyword(patternMap, "GJGPCCCD");
        addKeyword(patternMap, "GJGPD");
        addKeyword(patternMap, "GJICCCCD");
        addKeyword(patternMap, "GJICCDCD");
        addKeyword(patternMap, "GJICDD");
        addKeyword(patternMap, "GJICJD");
        addKeyword(patternMap, "GJIDD");
        addKeyword(patternMap, "GJIDWCCCWD");
        addKeyword(patternMap, "GJIICD");
        addKeyword(patternMap, "GJIIID");
        addKeyword(patternMap, "GJIJCCD");
        addKeyword(patternMap, "GJIJCD");
        addKeyword(patternMap, "GJIJD");
        addKeyword(patternMap, "GJIPD");
        addKeyword(patternMap, "GJJCCDGD");
        addKeyword(patternMap, "GJJCDCCD");
        addKeyword(patternMap, "GJJCDCD");
        addKeyword(patternMap, "GJJCDD");
        addKeyword(patternMap, "GJJCID");
        addKeyword(patternMap, "GJJCPD");
        addKeyword(patternMap, "GJJDDCCD");
        addKeyword(patternMap, "GJJGCCCCD");
        addKeyword(patternMap, "GJJICCCCD");
        addKeyword(patternMap, "GJJICCDCD");
        addKeyword(patternMap, "GJJICD");
        addKeyword(patternMap, "GJJID");
        addKeyword(patternMap, "GJJIPD");
        addKeyword(patternMap, "GJJPD");
        addKeyword(patternMap, "GJKJCD");
        addKeyword(patternMap, "GJKPD");
        addKeyword(patternMap, "GJMCCCCD");
        addKeyword(patternMap, "GJMCCCD");
        addKeyword(patternMap, "GJMCD");
        addKeyword(patternMap, "GJMICD");
        addKeyword(patternMap, "GJMJCCCCD");
        addKeyword(patternMap, "GJMJCD");
        addKeyword(patternMap, "GJMPCDD");
        addKeyword(patternMap, "GJPCCCDGD");
        addKeyword(patternMap, "GJPCCDD");
        addKeyword(patternMap, "GJPCCDGD");
        addKeyword(patternMap, "GJPCCDID");
        addKeyword(patternMap, "GJPCID");
        addKeyword(patternMap, "GJPDCCD");
        addKeyword(patternMap, "GJPDDGD");
        addKeyword(patternMap, "GJPDGD");
        addKeyword(patternMap, "GJPID");
        addKeyword(patternMap, "GJPIDID");
        addKeyword(patternMap, "GJPJCD");
        addKeyword(patternMap, "GJPJMJCD");
        addKeyword(patternMap, "GJPPCCD");
        addKeyword(patternMap, "GJWGWCD");
        addKeyword(patternMap, "GKCCCCD");
        addKeyword(patternMap, "GKCCDCD");
        addKeyword(patternMap, "GKCCDD");
        addKeyword(patternMap, "GKCCDWD");
        addKeyword(patternMap, "GKCDDICD");
        addKeyword(patternMap, "GKCID");
        addKeyword(patternMap, "GKCJDDWD");
        addKeyword(patternMap, "GKCWWD");
        addKeyword(patternMap, "GKDCCD");
        addKeyword(patternMap, "GKDID");
        addKeyword(patternMap, "GKGDGCDD");
        addKeyword(patternMap, "GKGPDD");
        addKeyword(patternMap, "GKICD");
        addKeyword(patternMap, "GKJCCDGCD");
        addKeyword(patternMap, "GKJCCID");
        addKeyword(patternMap, "GKJCD");
        addKeyword(patternMap, "GKJD");
        addKeyword(patternMap, "GKJID");
        addKeyword(patternMap, "GKJIPCD");
        addKeyword(patternMap, "GKPCDFJD");
        addKeyword(patternMap, "GKPCJD");
        addKeyword(patternMap, "GKWD");
        addKeyword(patternMap, "GLCCCCCID");
        addKeyword(patternMap, "GLCCCDD");
        addKeyword(patternMap, "GLCDCGCD");
        addKeyword(patternMap, "GLCICD");
        addKeyword(patternMap, "GLCID");
        addKeyword(patternMap, "GLCJID");
        addKeyword(patternMap, "GLCMCICD");
        addKeyword(patternMap, "GLCPCCDGD");
        addKeyword(patternMap, "GLCWGWDGCD");
        addKeyword(patternMap, "GLFCCD");
        addKeyword(patternMap, "GLFD");
        addKeyword(patternMap, "GLFJJCD");
        addKeyword(patternMap, "GLFKCCCD");
        addKeyword(patternMap, "GLGCCD");
        addKeyword(patternMap, "GLGCDDFCD");
        addKeyword(patternMap, "GLGJCCD");
        addKeyword(patternMap, "GLICCCCD");
        addKeyword(patternMap, "GLICCCD");
        addKeyword(patternMap, "GLICCDD");
        addKeyword(patternMap, "GLIFD");
        addKeyword(patternMap, "GLIID");
        addKeyword(patternMap, "GLIJD");
        addKeyword(patternMap, "GLIWDWD");
        addKeyword(patternMap, "GLJCCPCJD");
        addKeyword(patternMap, "GLJCDD");
        addKeyword(patternMap, "GLJCID");
        addKeyword(patternMap, "GLJDCD");
        addKeyword(patternMap, "GLJGCCD");
        addKeyword(patternMap, "GLJGCDGD");
        addKeyword(patternMap, "GLKCIID");
        addKeyword(patternMap, "GLMCCDD");
        addKeyword(patternMap, "GLMCD");
        addKeyword(patternMap, "GLPCCCCD");
        addKeyword(patternMap, "GLPCCDD");
        addKeyword(patternMap, "GLPCCDDFD");
        addKeyword(patternMap, "GLPICD");
        addKeyword(patternMap, "GLPID");
        addKeyword(patternMap, "GLPJCD");
        addKeyword(patternMap, "GLPPCCDD");
        addKeyword(patternMap, "GLPWIWD");
        addKeyword(patternMap, "GMCCCDD");
        addKeyword(patternMap, "GMCCDCCCD");
        addKeyword(patternMap, "GMCCDCMD");
        addKeyword(patternMap, "GMCCDMD");
        addKeyword(patternMap, "GMCCDWD");
        addKeyword(patternMap, "GMCID");
        addKeyword(patternMap, "GMCIID");
        addKeyword(patternMap, "GMCKCD");
        addKeyword(patternMap, "GMDPDID");
        addKeyword(patternMap, "GMFCCD");
        addKeyword(patternMap, "GMFCD");
        addKeyword(patternMap, "GMFCDCDGD");
        addKeyword(patternMap, "GMFICD");
        addKeyword(patternMap, "GMGCD");
        addKeyword(patternMap, "GMGCDCD");
        addKeyword(patternMap, "GMICID");
        addKeyword(patternMap, "GMIID");
        addKeyword(patternMap, "GMJCCCD");
        addKeyword(patternMap, "GMMCDGDD");
        addKeyword(patternMap, "GMMICCD");
        addKeyword(patternMap, "GMPCCCD");
        addKeyword(patternMap, "GMPDGCD");
        addKeyword(patternMap, "GMPFD");
        addKeyword(patternMap, "GMPICD");
        addKeyword(patternMap, "GMPID");
        addKeyword(patternMap, "GMPMCCCD");
        addKeyword(patternMap, "GPCCCCCD");
        addKeyword(patternMap, "GPCCCCDGD");
        addKeyword(patternMap, "GPCCCDGD");
        addKeyword(patternMap, "GPCCCDLD");
        addKeyword(patternMap, "GPCCCID");
        addKeyword(patternMap, "GPCCCPD");
        addKeyword(patternMap, "GPCCDGD");
        addKeyword(patternMap, "GPCCDWD");
        addKeyword(patternMap, "GPCCGD");
        addKeyword(patternMap, "GPCCICD");
        addKeyword(patternMap, "GPCCID");
        addKeyword(patternMap, "GPCCJD");
        addKeyword(patternMap, "GPCCWCWCD");
        addKeyword(patternMap, "GPCDCJD");
        addKeyword(patternMap, "GPCDDCD");
        addKeyword(patternMap, "GPCDGFCD");
        addKeyword(patternMap, "GPCDIID");
        addKeyword(patternMap, "GPCFCCCDGD");
        addKeyword(patternMap, "GPCFD");
        addKeyword(patternMap, "GPCGCD");
        addKeyword(patternMap, "GPCICD");
        addKeyword(patternMap, "GPCIDD");
        addKeyword(patternMap, "GPCIDWCWD");
        addKeyword(patternMap, "GPCIID");
        addKeyword(patternMap, "GPCIJCD");
        addKeyword(patternMap, "GPCIPD");
        addKeyword(patternMap, "GPCJD");
        addKeyword(patternMap, "GPCKD");
        addKeyword(patternMap, "GPCPCD");
        addKeyword(patternMap, "GPCPCDD");
        addKeyword(patternMap, "GPCPD");
        addKeyword(patternMap, "GPCWWD");
        addKeyword(patternMap, "GPFCCDWD");
        addKeyword(patternMap, "GPFCCWD");
        addKeyword(patternMap, "GPFCDD");
        addKeyword(patternMap, "GPFCWFWD");
        addKeyword(patternMap, "GPFDD");
        addKeyword(patternMap, "GPFICD");
        addKeyword(patternMap, "GPFIGGPCD");
        addKeyword(patternMap, "GPFJCD");
        addKeyword(patternMap, "GPFJD");
        addKeyword(patternMap, "GPFJDCD");
        addKeyword(patternMap, "GPFPCDCD");
        addKeyword(patternMap, "GPFPD");
        addKeyword(patternMap, "GPGCCCCD");
        addKeyword(patternMap, "GPGCCD");
        addKeyword(patternMap, "GPGCD");
        addKeyword(patternMap, "GPGCDWGD");
        addKeyword(patternMap, "GPGCGCD");
        addKeyword(patternMap, "GPGCIICD");
        addKeyword(patternMap, "GPGCPCCD");
        addKeyword(patternMap, "GPGFFCD");
        addKeyword(patternMap, "GPGICCD");
        addKeyword(patternMap, "GPGICD");
        addKeyword(patternMap, "GPGID");
        addKeyword(patternMap, "GPGJCD");
        addKeyword(patternMap, "GPGJD");
        addKeyword(patternMap, "GPGPCGD");
        addKeyword(patternMap, "GPGPDD");
        addKeyword(patternMap, "GPGPGJCCD");
        addKeyword(patternMap, "GPGPICD");
        addKeyword(patternMap, "GPICCCCDGD");
        addKeyword(patternMap, "GPICDD");
        addKeyword(patternMap, "GPICDGD");
        addKeyword(patternMap, "GPICICD");
        addKeyword(patternMap, "GPIDFGD");
        addKeyword(patternMap, "GPIICD");
        addKeyword(patternMap, "GPIICDGD");
        addKeyword(patternMap, "GPIID");
        addKeyword(patternMap, "GPIJCCD");
        addKeyword(patternMap, "GPIJCD");
        addKeyword(patternMap, "GPIJCDD");
        addKeyword(patternMap, "GPIPCCCD");
        addKeyword(patternMap, "GPIPCCD");
        addKeyword(patternMap, "GPJCCCCD");
        addKeyword(patternMap, "GPJCCDD");
        addKeyword(patternMap, "GPJCDCPD");
        addKeyword(patternMap, "GPJCDFD");
        addKeyword(patternMap, "GPJCDGCD");
        addKeyword(patternMap, "GPJCDGD");
        addKeyword(patternMap, "GPJCID");
        addKeyword(patternMap, "GPJCIDD");
        addKeyword(patternMap, "GPJCJCD");
        addKeyword(patternMap, "GPJCPCCD");
        addKeyword(patternMap, "GPJFCCD");
        addKeyword(patternMap, "GPJFIDD");
        addKeyword(patternMap, "GPJICD");
        addKeyword(patternMap, "GPJID");
        addKeyword(patternMap, "GPJPCD");
        addKeyword(patternMap, "GPJPD");
        addKeyword(patternMap, "GPKD");
        addKeyword(patternMap, "GPLCCCCD");
        addKeyword(patternMap, "GPLCCD");
        addKeyword(patternMap, "GPLCD");
        addKeyword(patternMap, "GPLICD");
        addKeyword(patternMap, "GPLID");
        addKeyword(patternMap, "GPMCCCD");
        addKeyword(patternMap, "GPMCCD");
        addKeyword(patternMap, "GPMCD");
        addKeyword(patternMap, "GPMD");
        addKeyword(patternMap, "GPMDJCD");
        addKeyword(patternMap, "GPPCCDD");
        addKeyword(patternMap, "GPPCCDWD");
        addKeyword(patternMap, "GPPCDWCCCD");
        addKeyword(patternMap, "GPPDDD");
        addKeyword(patternMap, "GPPFD");
        addKeyword(patternMap, "GPPGCCCD");
        addKeyword(patternMap, "GPPGD");
        addKeyword(patternMap, "GPPGDGD");
        addKeyword(patternMap, "GPPICD");
        addKeyword(patternMap, "GPPIID");
        addKeyword(patternMap, "GPPIJD");
        addKeyword(patternMap, "GPPJCCD");
        addKeyword(patternMap, "GPPJCDFCD");
        addKeyword(patternMap, "GPPJDCD");
        addKeyword(patternMap, "GPPMJCD");
        addKeyword(patternMap, "GPPPCD");
        addKeyword(patternMap, "GPPPICD");
        addKeyword(patternMap, "GPWCCD");
        addKeyword(patternMap, "GPWGWCDGD");
        addKeyword(patternMap, "GWCCCCD");
        addKeyword(patternMap, "GWCWJD");
        addKeyword(patternMap, "GWGPPD");
        addKeyword(patternMap, "GWGWCCD");
        addKeyword(patternMap, "GWICCD");
        addKeyword(patternMap, "GWJD");
        addKeyword(patternMap, "GWPCPWD");
        addKeyword(patternMap, "ICCCDFPCCFGCCD");
        addKeyword(patternMap, "ICCCDGD");
        addKeyword(patternMap, "ICCCDGJD");
        addKeyword(patternMap, "ICCCID");
        addKeyword(patternMap, "ICCCWGWD");
        addKeyword(patternMap, "ICCCWGWDGD");
        addKeyword(patternMap, "ICCFJCWGFJCCD");
        addKeyword(patternMap, "ICCICCD");
        addKeyword(patternMap, "ICCWGWD");
        addKeyword(patternMap, "ICDCCCCD");
        addKeyword(patternMap, "ICDCDCD");
        addKeyword(patternMap, "ICDGD");
        addKeyword(patternMap, "ICDWGD");
        addKeyword(patternMap, "ICFCD");
        addKeyword(patternMap, "ICFCJCD");
        addKeyword(patternMap, "ICFDID");
        addKeyword(patternMap, "ICGD");
        addKeyword(patternMap, "ICGGD");
        addKeyword(patternMap, "ICICCD");
        addKeyword(patternMap, "ICIDWID");
        addKeyword(patternMap, "ICIWD");
        addKeyword(patternMap, "ICJCCD");
        addKeyword(patternMap, "ICJWGWCCD");
        addKeyword(patternMap, "ICWGWDD");
        addKeyword(patternMap, "IDDGCD");
        addKeyword(patternMap, "IDGD");
        addKeyword(patternMap, "IFCD");
        addKeyword(patternMap, "IFCICCDGD");
        addKeyword(patternMap, "IFGD");
        addKeyword(patternMap, "IFICCD");
        addKeyword(patternMap, "IFIDWGD");
        addKeyword(patternMap, "IFKD");
        addKeyword(patternMap, "IGCCCCDCCD");
        addKeyword(patternMap, "IGFGJCGDD");
        addKeyword(patternMap, "IGGDFCD");
        addKeyword(patternMap, "IGGPCGCD");
        addKeyword(patternMap, "IGICCD");
        addKeyword(patternMap, "IIGCD");
        addKeyword(patternMap, "IIICD");
        addKeyword(patternMap, "IIID");
        addKeyword(patternMap, "IIJD");
        addKeyword(patternMap, "IIWGWCD");
        addKeyword(patternMap, "IIWGWD");
        addKeyword(patternMap, "IJCCDGD");
        addKeyword(patternMap, "IJCCWGWD");
        addKeyword(patternMap, "IJCDCCD");
        addKeyword(patternMap, "IJCDD");
        addKeyword(patternMap, "IJDD");
        addKeyword(patternMap, "IJGCCD");
        addKeyword(patternMap, "IJPCCD");
        addKeyword(patternMap, "IJPCD");
        addKeyword(patternMap, "IKCD");
        addKeyword(patternMap, "IMCCCCD");
        addKeyword(patternMap, "IPCCCCD");
        addKeyword(patternMap, "IPCGD");
        addKeyword(patternMap, "IPFD");
        addKeyword(patternMap, "IPJCD");
        addKeyword(patternMap, "IPPD");
        addKeyword(patternMap, "IPPDCD");
        addKeyword(patternMap, "IPPJCD");
        addKeyword(patternMap, "IPWGWCCD");
        addKeyword(patternMap, "IPWGWCD");
        addKeyword(patternMap, "IWGMFCCDGD");
        addKeyword(patternMap, "IWGWCCD");
        addKeyword(patternMap, "IWGWCD");
        addKeyword(patternMap, "IWGWD");
        addKeyword(patternMap, "IWGWID");
        addKeyword(patternMap, "JCCCWFWD");
        addKeyword(patternMap, "JCCGD");
        addKeyword(patternMap, "JCCPD");
        addKeyword(patternMap, "JCCWGWD");
        addKeyword(patternMap, "JCDCWMWMWCCCD");
        addKeyword(patternMap, "JCDDWD");
        addKeyword(patternMap, "JCGDWCPWD");
        addKeyword(patternMap, "JCIDGD");
        addKeyword(patternMap, "JCIWGWD");
        addKeyword(patternMap, "JCJGCD");
        addKeyword(patternMap, "JCPCD");
        addKeyword(patternMap, "JCWGWCDWD");
        addKeyword(patternMap, "JDGCCD");
        addKeyword(patternMap, "JDWGWCD");
        addKeyword(patternMap, "JFCCD");
        addKeyword(patternMap, "JFCCWGWDD");
        addKeyword(patternMap, "JFID");
        addKeyword(patternMap, "JFJCCD");
        addKeyword(patternMap, "JGCCD");
        addKeyword(patternMap, "JGCCGCD");
        addKeyword(patternMap, "JGCDFCD");
        addKeyword(patternMap, "JGCFCCCD");
        addKeyword(patternMap, "JGFD");
        addKeyword(patternMap, "JGICD");
        addKeyword(patternMap, "JGID");
        addKeyword(patternMap, "JGJDCD");
        addKeyword(patternMap, "JGMCCD");
        addKeyword(patternMap, "JGPCCD");
        addKeyword(patternMap, "JICCD");
        addKeyword(patternMap, "JIGPCD");
        addKeyword(patternMap, "JIICD");
        addKeyword(patternMap, "JIPCD");
        addKeyword(patternMap, "JJCCCDGD");
        addKeyword(patternMap, "JJCCJD");
        addKeyword(patternMap, "JJCGD");
        addKeyword(patternMap, "JJCID");
        addKeyword(patternMap, "JJCWGWCCDFGCD");
        addKeyword(patternMap, "JJCWGWD");
        addKeyword(patternMap, "JJLWGWCD");
        addKeyword(patternMap, "JJPJJD");
        addKeyword(patternMap, "JJPPCD");
        addKeyword(patternMap, "JPCCCCWGWD");
        addKeyword(patternMap, "JPCCCD");
        addKeyword(patternMap, "JPIWGWID");
        addKeyword(patternMap, "JPJJD");
        addKeyword(patternMap, "JPWWD");
        addKeyword(patternMap, "JWWFWCD");
        addKeyword(patternMap, "KCCCCDD");
        addKeyword(patternMap, "KCCDGD");
        addKeyword(patternMap, "KCDGCD");
        addKeyword(patternMap, "KCDGD");
        addKeyword(patternMap, "KCFCD");
        addKeyword(patternMap, "KCICCD");
        addKeyword(patternMap, "KCJCCCDGD");
        addKeyword(patternMap, "KFCCD");
        addKeyword(patternMap, "KGCDCCCD");
        addKeyword(patternMap, "KGCDD");
        addKeyword(patternMap, "KGCDGD");
        addKeyword(patternMap, "KGCGCD");
        addKeyword(patternMap, "KGGCDID");
        addKeyword(patternMap, "KIDJCCD");
        addKeyword(patternMap, "KIICD");
        addKeyword(patternMap, "KJGCD");
        addKeyword(patternMap, "KLPCCD");
        addKeyword(patternMap, "KPFCCD");
        addKeyword(patternMap, "KPGCD");
        addKeyword(patternMap, "KPICD");
        addKeyword(patternMap, "KPKICD");
        addKeyword(patternMap, "LCCCDGCD");
        addKeyword(patternMap, "LCGFCD");
        addKeyword(patternMap, "LCWGWCFDD");
        addKeyword(patternMap, "LCWGWICD");
        addKeyword(patternMap, "LFCCD");
        addKeyword(patternMap, "LFCWGWCD");
        addKeyword(patternMap, "LFJD");
        addKeyword(patternMap, "LGCCCD");
        addKeyword(patternMap, "LGCCD");
        addKeyword(patternMap, "LGCICD");
        addKeyword(patternMap, "LGCPJCD");
        addKeyword(patternMap, "LGFCCD");
        addKeyword(patternMap, "LGFCD");
        addKeyword(patternMap, "LGFD");
        addKeyword(patternMap, "LGFICD");
        addKeyword(patternMap, "LGFID");
        addKeyword(patternMap, "LGFJD");
        addKeyword(patternMap, "LGFPD");
        addKeyword(patternMap, "LGICCDGCD");
        addKeyword(patternMap, "LGICD");
        addKeyword(patternMap, "LGID");
        addKeyword(patternMap, "LGIICD");
        addKeyword(patternMap, "LGJCCD");
        addKeyword(patternMap, "LGJCID");
        addKeyword(patternMap, "LGLIDD");
        addKeyword(patternMap, "LGPCCD");
        addKeyword(patternMap, "LGPCD");
        addKeyword(patternMap, "LGPDDWD");
        addKeyword(patternMap, "LGPJPD");
        addKeyword(patternMap, "LIJD");
        addKeyword(patternMap, "LIWGWD");
        addKeyword(patternMap, "LJFCCD");
        addKeyword(patternMap, "LJFGCD");
        addKeyword(patternMap, "LKGPD");
        addKeyword(patternMap, "LKPJCCD");
        addKeyword(patternMap, "LMPJIPCCD");
        addKeyword(patternMap, "LPCGDGD");
        addKeyword(patternMap, "LPPWCCD");
        addKeyword(patternMap, "MCCID");
        addKeyword(patternMap, "MCCWGWD");
        addKeyword(patternMap, "MCJCCD");
        addKeyword(patternMap, "MCWD");
        addKeyword(patternMap, "MJCWGWD");
        addKeyword(patternMap, "MPCFCD");
        addKeyword(patternMap, "MPCGD");
        addKeyword(patternMap, "PCCGGCCCCD");
        addKeyword(patternMap, "PCCKD");
        addKeyword(patternMap, "PCDDDCCD");
        addKeyword(patternMap, "PCJD");
        addKeyword(patternMap, "PCJJDD");
        addKeyword(patternMap, "PCLGCCD");
        addKeyword(patternMap, "PCWGWCD");
        addKeyword(patternMap, "PCWGWID");
        addKeyword(patternMap, "PCWGWPDWD");
        addKeyword(patternMap, "PFCCCWGWD");
        addKeyword(patternMap, "PFCCJICCD");
        addKeyword(patternMap, "PFCD");
        addKeyword(patternMap, "PFCPCDCD");
        addKeyword(patternMap, "PFCWGWCD");
        addKeyword(patternMap, "PFID");
        addKeyword(patternMap, "PFPID");
        addKeyword(patternMap, "PGCCD");
        addKeyword(patternMap, "PGCCDGD");
        addKeyword(patternMap, "PGCID");
        addKeyword(patternMap, "PGCJCJD");
        addKeyword(patternMap, "PGFCD");
        addKeyword(patternMap, "PGJCCD");
        addKeyword(patternMap, "PGJICD");
        addKeyword(patternMap, "PGPCCCJD");
        addKeyword(patternMap, "PGPCCD");
        addKeyword(patternMap, "PGPD");
        addKeyword(patternMap, "PGPID");
        addKeyword(patternMap, "PIGFCD");
        addKeyword(patternMap, "PIWGWCCD");
        addKeyword(patternMap, "PJCCCD");
        addKeyword(patternMap, "PJCDD");
        addKeyword(patternMap, "PJCWGWDID");
        addKeyword(patternMap, "PJDFFD");
        addKeyword(patternMap, "PLDWGWCDCGD");
        addKeyword(patternMap, "PPCCCDD");
        addKeyword(patternMap, "PPCCD");
        addKeyword(patternMap, "PPCCDGD");
        addKeyword(patternMap, "PPCCGWD");
        addKeyword(patternMap, "PPCCWGWD");
        addKeyword(patternMap, "PPCID");
        addKeyword(patternMap, "PPCPWCCCWCDD");
        addKeyword(patternMap, "PPCWGWD");
        addKeyword(patternMap, "PPDD");
        addKeyword(patternMap, "PPFWGWCD");
        addKeyword(patternMap, "PPICD");
        addKeyword(patternMap, "PPIDD");
        addKeyword(patternMap, "PPLWGWCCD");
        addKeyword(patternMap, "PPWGWCD");
        addKeyword(patternMap, "PPWGWD");
        addKeyword(patternMap, "PWCCCD");
        addKeyword(patternMap, "PWCWCD");
        addKeyword(patternMap, "PWFWCD");
        addKeyword(patternMap, "PWWJWGWD");
        addKeyword(patternMap, "WCCCD");
        addKeyword(patternMap, "WCJWD");
        addKeyword(patternMap, "WFFPCWJD");
        addKeyword(patternMap, "WFPWPWCCD");
        addKeyword(patternMap, "WFWD");
        addKeyword(patternMap, "WGCJDWFCCCD");
        addKeyword(patternMap, "WJCCD");
        addKeyword(patternMap, "WPWJD");
        addKeyword(patternMap, "WWIWWCWD");
        trie.build(patternMap);
    }

    /**
     * 模式匹配
     *
     * @param ntList         确定的标注序列
     * @param vertexList     原始的未加角色标注的序列
     * @param wordNetOptimum 待优化的图
     * @param wordNetAll
     */
    public static void parsePattern(List<NT> ntList, List<Vertex> vertexList, final WordNet wordNetOptimum, final WordNet wordNetAll)
    {
//        ListIterator<Vertex> listIterator = vertexList.listIterator();
        StringBuilder sbPattern = new StringBuilder(ntList.size());
        for (NT nt : ntList)
        {
            sbPattern.append(nt.toString());
        }
        String pattern = sbPattern.toString();
        final Vertex[] wordArray = vertexList.toArray(new Vertex[0]);
        trie.parseText(pattern, new AhoCorasickDoubleArrayTrie.IHit<String>()
        {
            @Override
            public void hit(int begin, int end, String keyword)
            {
                StringBuilder sbName = new StringBuilder();
                for (int i = begin; i < end; ++i)
                {
                    sbName.append(wordArray[i].realWord);
                }
                String name = sbName.toString();
                // 对一些bad case做出调整
                if (isBadCase(name)) return;

                // 正式算它是一个名字
                if (HanLP.Config.DEBUG)
                {
                    System.out.printf("识别出机构名：%s %s\n", name, keyword);
                }
                int offset = 0;
                for (int i = 0; i < begin; ++i)
                {
                    offset += wordArray[i].realWord.length();
                }
                wordNetOptimum.insert(offset, new Vertex(Predefine.TAG_GROUP, name, ATTRIBUTE, WORD_ID), wordNetAll);
            }
        });
    }

    /**
     * 因为任何算法都无法解决100%的问题，总是有一些bad case，这些bad case会以“单词 Z 1”的形式加入词典中<BR>
     * 这个方法返回是否是bad case
     *
     * @param name
     * @return
     */
    static boolean isBadCase(String name)
    {
        EnumItem<NT> nrEnumItem = dictionary.get(name);
        if (nrEnumItem == null) return false;
        return nrEnumItem.containsLabel(NT.Z);
    }
}
