/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.algorithm;

import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.TransformMatrixDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Viterbi {
    public static int[] compute(int[] obs, int[] states, double[] start_p, double[][] trans_p, double[][] emit_p) {
        int _max_states_value = 0;
        for (int s : states) {
            _max_states_value = Math.max(_max_states_value, s);
        }
        double[][] V = new double[obs.length][++_max_states_value];
        int[][] path = new int[_max_states_value][obs.length];
        for (int y : states) {
            V[0][y] = start_p[y] + emit_p[y][obs[0]];
            path[y][0] = y;
        }
        for (int t = 1; t < obs.length; ++t) {
            int[][] newpath = new int[_max_states_value][obs.length];
            for (int y : states) {
                double prob = Double.MAX_VALUE;
                for (int y0 : states) {
                    double nprob = V[t - 1][y0] + trans_p[y0][y] + emit_p[y][obs[t]];
                    if (!(nprob < prob)) continue;
                    prob = nprob;
                    int state = y0;
                    V[t][y] = prob;
                    System.arraycopy(path[state], 0, newpath[y], 0, t);
                    newpath[y][t] = y;
                }
            }
            path = newpath;
        }
        double prob = Double.MAX_VALUE;
        int state = 0;
        for (int y : states) {
            if (!(V[obs.length - 1][y] < prob)) continue;
            prob = V[obs.length - 1][y];
            state = y;
        }
        return path[state];
    }

    public static void compute(List<Vertex> vertexList, TransformMatrixDictionary<Nature> transformMatrixDictionary) {
        int length = vertexList.size() - 1;
        double[][] cost = new double[2][];
        Iterator<Vertex> iterator = vertexList.iterator();
        Vertex start = iterator.next();
        Nature pre = start.attribute.nature[0];
        Vertex item = iterator.next();
        cost[0] = new double[item.attribute.nature.length];
        int j = 0;
        int curIndex = 0;
        for (Nature cur : item.attribute.nature) {
            cost[0][j] = transformMatrixDictionary.transititon_probability[pre.ordinal()][cur.ordinal()] - Math.log(((double)item.attribute.frequency[curIndex] + 1.0E-8) / (double)transformMatrixDictionary.getTotalFrequency(cur));
            ++j;
            ++curIndex;
        }
        Nature[] preTagSet = item.attribute.nature;
        Vertex preItem = item;
        for (int i = 1; i < length; ++i) {
            Nature[] curTagSet;
            int index_i = i & 1;
            int index_i_1 = 1 - index_i;
            Vertex item2 = iterator.next();
            cost[index_i] = new double[item2.attribute.nature.length];
            double perfect_cost_line = Double.MAX_VALUE;
            int k = 0;
            for (Nature cur : curTagSet = item2.attribute.nature) {
                cost[index_i][k] = Double.MAX_VALUE;
                int j2 = 0;
                for (Nature p : preTagSet) {
                    double now = cost[index_i_1][j2] + transformMatrixDictionary.transititon_probability[p.ordinal()][cur.ordinal()] - Math.log(((double)item2.attribute.frequency[k] + 1.0E-8) / (double)transformMatrixDictionary.getTotalFrequency(cur));
                    if (now < cost[index_i][k]) {
                        cost[index_i][k] = now;
                        if (now < perfect_cost_line) {
                            perfect_cost_line = now;
                            pre = p;
                        }
                    }
                    ++j2;
                }
                ++k;
            }
            preItem.confirmNature(pre);
            preTagSet = curTagSet;
            preItem = item2;
        }
    }

    public static <E extends Enum<E>> List<E> computeEnum(List<EnumItem<E>> roleTagList, TransformMatrixDictionary<E> transformMatrixDictionary) {
        int length = roleTagList.size() - 1;
        ArrayList<Enum> tagList = new ArrayList<Enum>(roleTagList.size());
        double[][] cost = new double[2][];
        Iterator<EnumItem<E>> iterator = roleTagList.iterator();
        EnumItem<E> start = iterator.next();
        Enum pre = (Enum)start.labelMap.entrySet().iterator().next().getKey();
        tagList.add(pre);
        EnumItem<Enum> item = iterator.next();
        cost[0] = new double[item.labelMap.size()];
        int j = 0;
        for (Enum cur : item.labelMap.keySet()) {
            cost[0][j] = transformMatrixDictionary.transititon_probability[pre.ordinal()][cur.ordinal()] - Math.log(((double)item.getFrequency(cur) + 1.0E-8) / (double)transformMatrixDictionary.getTotalFrequency(cur));
            ++j;
        }
        Set preTagSet = item.labelMap.keySet();
        for (int i = 1; i < length; ++i) {
            int index_i = i & 1;
            int index_i_1 = 1 - index_i;
            EnumItem<Enum> item2 = iterator.next();
            cost[index_i] = new double[item2.labelMap.size()];
            double perfect_cost_line = Double.MAX_VALUE;
            int k = 0;
            Set curTagSet = item2.labelMap.keySet();
            for (Enum cur : curTagSet) {
                cost[index_i][k] = Double.MAX_VALUE;
                int j2 = 0;
                for (Enum p : preTagSet) {
                    double now = cost[index_i_1][j2] + transformMatrixDictionary.transititon_probability[p.ordinal()][cur.ordinal()] - Math.log(((double)item2.getFrequency(cur) + 1.0E-8) / (double)transformMatrixDictionary.getTotalFrequency(cur));
                    if (now < cost[index_i][k]) {
                        cost[index_i][k] = now;
                        if (now < perfect_cost_line) {
                            perfect_cost_line = now;
                            pre = p;
                        }
                    }
                    ++j2;
                }
                ++k;
            }
            tagList.add(pre);
            preTagSet = curTagSet;
        }
        tagList.add((Enum)tagList.get(0));
        return tagList;
    }

    public static <E extends Enum<E>> List<E> computeEnumSimply(List<EnumItem<E>> roleTagList, TransformMatrixDictionary<E> transformMatrixDictionary) {
        Enum pre;
        int length = roleTagList.size() - 1;
        LinkedList<Enum> tagList = new LinkedList<Enum>();
        Iterator<EnumItem<E>> iterator = roleTagList.iterator();
        EnumItem<E> start = iterator.next();
        Enum perfect_tag = pre = (Enum)start.labelMap.entrySet().iterator().next().getKey();
        tagList.add(pre);
        for (int i = 0; i < length; ++i) {
            double perfect_cost = Double.MAX_VALUE;
            EnumItem<Enum> item = iterator.next();
            for (Enum cur : item.labelMap.keySet()) {
                double now = transformMatrixDictionary.transititon_probability[pre.ordinal()][cur.ordinal()] - Math.log(((double)item.getFrequency(cur) + 1.0E-8) / (double)transformMatrixDictionary.getTotalFrequency(cur));
                if (!(perfect_cost > now)) continue;
                perfect_cost = now;
                perfect_tag = cur;
            }
            pre = perfect_tag;
            tagList.add(pre);
        }
        return tagList;
    }
}

