/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dependency.CoNll;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNllLine;
import com.hankcs.hanlp.corpus.dependency.CoNll.PosTagCompiler;

public class CoNLLWord {
    public int ID;
    public String LEMMA;
    public String CPOSTAG;
    public String POSTAG;
    public CoNLLWord HEAD;
    public String DEPREL;
    public String NAME;
    public static final CoNLLWord ROOT = new CoNLLWord(0, "##\u6838\u5fc3##", "ROOT", "root");
    public static final CoNLLWord NULL = new CoNLLWord(-1, "##\u7a7a\u767d##", "NULL", "null");

    public CoNLLWord(int ID, String LEMMA, String POSTAG) {
        this.ID = ID;
        this.LEMMA = LEMMA;
        this.CPOSTAG = POSTAG.substring(0, 1);
        this.POSTAG = POSTAG;
        this.compile();
    }

    public CoNLLWord(int ID, String LEMMA, String CPOSTAG, String POSTAG) {
        this.ID = ID;
        this.LEMMA = LEMMA;
        this.CPOSTAG = CPOSTAG;
        this.POSTAG = POSTAG;
        this.compile();
    }

    private void compile() {
        this.NAME = PosTagCompiler.compile(this.POSTAG, this.LEMMA);
    }

    public CoNLLWord(CoNllLine line) {
        this.LEMMA = line.value[2];
        this.CPOSTAG = line.value[3];
        this.POSTAG = line.value[4];
        this.DEPREL = line.value[7];
        this.ID = line.id;
        this.compile();
    }

    public CoNLLWord(CoNllLine[] lineArray, int index) {
        this(lineArray[index]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ID).append('\t').append(this.LEMMA).append('\t').append(this.LEMMA).append('\t').append(this.CPOSTAG).append('\t').append(this.POSTAG).append('\t').append('_').append('\t').append(this.HEAD.ID).append('\t').append(this.DEPREL).append('\t').append('_').append('\t').append('_');
        return sb.toString();
    }
}

