/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg;

import com.hankcs.hanlp.algorithm.Viterbi;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CoreDictionaryTransformMatrixDictionary;
import com.hankcs.hanlp.dictionary.other.CharType;
import com.hankcs.hanlp.seg.NShort.Path.AtomNode;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Graph;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class WordBasedGenerativeModelSegment
extends Segment {
    protected static void GenerateWord(List<Vertex> linkedArray, WordNet wordNetOptimum) {
        WordBasedGenerativeModelSegment.fixResultByRule(linkedArray);
        wordNetOptimum.addAll(linkedArray);
    }

    protected static void fixResultByRule(List<Vertex> linkedArray) {
        WordBasedGenerativeModelSegment.mergeContinueNumIntoOne(linkedArray);
        WordBasedGenerativeModelSegment.ChangeDelimiterPOS(linkedArray);
        WordBasedGenerativeModelSegment.SplitMiddleSlashFromDigitalWords(linkedArray);
        WordBasedGenerativeModelSegment.CheckDateElements(linkedArray);
    }

    static void ChangeDelimiterPOS(List<Vertex> linkedArray) {
        for (Vertex vertex : linkedArray) {
            if (!vertex.realWord.equals("\uff0d\uff0d") && !vertex.realWord.equals("\u2014") && !vertex.realWord.equals("-")) continue;
            vertex.confirmNature(Nature.w);
        }
    }

    private static void SplitMiddleSlashFromDigitalWords(List<Vertex> linkedArray) {
        Vertex next;
        if (linkedArray.size() < 2) {
            return;
        }
        ListIterator<Vertex> listIterator = linkedArray.listIterator();
        Vertex current = next = listIterator.next();
        while (listIterator.hasNext()) {
            String[] param;
            next = listIterator.next();
            Nature currentNature = current.getNature();
            if (currentNature == Nature.nx && (next.hasNature(Nature.q) || next.hasNature(Nature.n)) && (param = current.realWord.split("-", 1)).length == 2 && TextUtility.isAllNum(param[0]) && TextUtility.isAllNum(param[1])) {
                current = current.copy();
                current.realWord = param[0];
                current.confirmNature(Nature.m);
                listIterator.previous();
                listIterator.previous();
                listIterator.set(current);
                listIterator.next();
                listIterator.add(Vertex.newPunctuationInstance("-"));
                listIterator.add(Vertex.newNumberInstance(param[1]));
            }
            current = next;
        }
    }

    private static void CheckDateElements(List<Vertex> linkedArray) {
        Vertex next;
        if (linkedArray.size() < 2) {
            return;
        }
        ListIterator<Vertex> listIterator = linkedArray.listIterator();
        Vertex current = next = listIterator.next();
        while (listIterator.hasNext()) {
            next = listIterator.next();
            if (TextUtility.isAllNum(current.realWord) || TextUtility.isAllChineseNum(current.realWord)) {
                String nextWord = next.realWord;
                if (nextWord.length() == 1 && "\u6708\u65e5\u65f6\u5206\u79d2".contains(nextWord) || nextWord.length() == 2 && nextWord.equals("\u6708\u4efd")) {
                    current = Vertex.newTimeInstance(current.realWord + next.realWord);
                    listIterator.previous();
                    listIterator.previous();
                    listIterator.set(current);
                    listIterator.next();
                    listIterator.next();
                    listIterator.remove();
                } else if (nextWord.equals("\u5e74")) {
                    if (TextUtility.isYearTime(current.realWord)) {
                        current = Vertex.newTimeInstance(current.realWord + next.realWord);
                        listIterator.previous();
                        listIterator.previous();
                        listIterator.set(current);
                        listIterator.next();
                        listIterator.next();
                        listIterator.remove();
                    } else {
                        current.confirmNature(Nature.m);
                    }
                } else if (current.realWord.endsWith("\u70b9")) {
                    current.confirmNature(Nature.t, true);
                } else {
                    char[] tmpCharArray = current.realWord.toCharArray();
                    String lastChar = String.valueOf(tmpCharArray[tmpCharArray.length - 1]);
                    if (!"\u2236\u00b7\uff0e\uff0f./".contains(lastChar)) {
                        current.confirmNature(Nature.m, true);
                    } else if (current.realWord.length() > 1) {
                        char last = current.realWord.charAt(current.realWord.length() - 1);
                        current = Vertex.newNumberInstance(current.realWord.substring(0, current.realWord.length() - 1));
                        listIterator.previous();
                        listIterator.previous();
                        listIterator.set(current);
                        listIterator.next();
                        listIterator.add(Vertex.newPunctuationInstance(String.valueOf(last)));
                    }
                }
            }
            current = next;
        }
    }

    protected static List<Term> convert(List<Vertex> vertexList, boolean offsetEnabled) {
        assert (vertexList != null);
        assert (vertexList.size() >= 2) : "\u8fd9\u6761\u8def\u5f84\u4e0d\u5e94\u5f53\u77ed\u4e8e2" + vertexList.toString();
        int length = vertexList.size() - 2;
        ArrayList<Term> resultList = new ArrayList<Term>(length);
        Iterator<Vertex> iterator = vertexList.iterator();
        iterator.next();
        if (offsetEnabled) {
            int offset = 0;
            for (int i = 0; i < length; ++i) {
                Vertex vertex = iterator.next();
                Term term = WordBasedGenerativeModelSegment.convert(vertex);
                term.offset = offset;
                offset += term.length();
                resultList.add(term);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Vertex vertex = iterator.next();
                Term term = WordBasedGenerativeModelSegment.convert(vertex);
                resultList.add(term);
            }
        }
        return resultList;
    }

    protected static List<Term> convert(List<Vertex> vertexList) {
        return WordBasedGenerativeModelSegment.convert(vertexList, false);
    }

    protected static Graph GenerateBiGraph(WordNet wordNet) {
        return wordNet.toGraph();
    }

    private static List<AtomNode> AtomSegment(String sSentence, int start, int end) {
        if (end < start) {
            throw new RuntimeException("start=" + start + " < end=" + end);
        }
        ArrayList<AtomNode> atomSegment = new ArrayList<AtomNode>();
        int pCur = 0;
        StringBuilder sb = new StringBuilder();
        char[] charArray = sSentence.substring(start, end).toCharArray();
        int[] charTypeArray = new int[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            charTypeArray[i] = CharType.get(c);
            if (c == '.' && i < charArray.length - 1 && CharType.get(charArray[i + 1]) == 9) {
                charTypeArray[i] = 9;
                continue;
            }
            if (c == '.' && i < charArray.length - 1 && charArray[i + 1] >= '0' && charArray[i + 1] <= '9') {
                charTypeArray[i] = 5;
                continue;
            }
            if (charTypeArray[i] != 8) continue;
            charTypeArray[i] = 5;
        }
        while (pCur < charArray.length) {
            int nCurType = charTypeArray[pCur];
            if (nCurType == 7 || nCurType == 10 || nCurType == 6 || nCurType == 17) {
                String single = String.valueOf(charArray[pCur]);
                if (single.length() != 0) {
                    atomSegment.add(new AtomNode(single, nCurType));
                }
                ++pCur;
                continue;
            }
            if (pCur < charArray.length - 1 && (nCurType == 5 || nCurType == 9)) {
                sb.delete(0, sb.length());
                sb.append(charArray[pCur]);
                boolean reachEnd = true;
                while (pCur < charArray.length - 1) {
                    int nNextType;
                    if ((nNextType = charTypeArray[++pCur]) == nCurType) {
                        sb.append(charArray[pCur]);
                        continue;
                    }
                    reachEnd = false;
                    break;
                }
                atomSegment.add(new AtomNode(sb.toString(), nCurType));
                if (!reachEnd) continue;
                ++pCur;
                continue;
            }
            atomSegment.add(new AtomNode(charArray[pCur], nCurType));
            ++pCur;
        }
        return atomSegment;
    }

    private static void mergeContinueNumIntoOne(List<Vertex> linkedArray) {
        Vertex next;
        if (linkedArray.size() < 2) {
            return;
        }
        ListIterator<Vertex> listIterator = linkedArray.listIterator();
        Vertex current = next = listIterator.next();
        while (listIterator.hasNext()) {
            next = listIterator.next();
            if ((TextUtility.isAllNum(current.realWord) || TextUtility.isAllChineseNum(current.realWord)) && (TextUtility.isAllNum(next.realWord) || TextUtility.isAllChineseNum(next.realWord))) {
                current = Vertex.newNumberInstance(current.realWord + next.realWord);
                listIterator.previous();
                listIterator.previous();
                listIterator.set(current);
                listIterator.next();
                listIterator.next();
                listIterator.remove();
                continue;
            }
            current = next;
        }
    }

    protected void GenerateWordNet(WordNet wordNetStorage) {
        char[] charArray = wordNetStorage.charArray;
        DoubleArrayTrie.Searcher searcher = CoreDictionary.trie.getSearcher(charArray, 0);
        while (searcher.next()) {
            wordNetStorage.add(searcher.begin + 1, new Vertex(new String(charArray, searcher.begin, searcher.length), (CoreDictionary.Attribute)searcher.value, searcher.index));
        }
        LinkedList<Vertex>[] vertexes = wordNetStorage.getVertexes();
        int i = 1;
        while (i < vertexes.length) {
            if (vertexes[i].isEmpty()) {
                int j;
                for (j = i + 1; j < vertexes.length - 1 && vertexes[j].isEmpty(); ++j) {
                }
                wordNetStorage.add(i, WordBasedGenerativeModelSegment.quickAtomSegment(charArray, i - 1, j - 1));
                i = j;
                continue;
            }
            i += vertexes[i].getLast().realWord.length();
        }
    }

    protected static List<Term> decorateResultForIndexMode(List<Vertex> vertexList, WordNet wordNetAll) {
        LinkedList<Term> termList = new LinkedList<Term>();
        int line = 1;
        ListIterator<Vertex> listIterator = vertexList.listIterator();
        listIterator.next();
        int length = vertexList.size() - 2;
        for (int i = 0; i < length; ++i) {
            Vertex vertex = listIterator.next();
            Term termMain = WordBasedGenerativeModelSegment.convert(vertex);
            termList.add(termMain);
            termMain.offset = line - 1;
            if (vertex.realWord.length() > 2) {
                for (int currentLine = line; currentLine < line + vertex.realWord.length(); ++currentLine) {
                    Iterator<Vertex> iterator = wordNetAll.descendingIterator(currentLine);
                    while (iterator.hasNext()) {
                        Vertex smallVertex = iterator.next();
                        if ((termMain.nature != Nature.mq || !smallVertex.hasNature(Nature.q)) && smallVertex.realWord.length() <= 1 || smallVertex == vertex || currentLine + smallVertex.realWord.length() > line + vertex.realWord.length()) continue;
                        listIterator.add(smallVertex);
                        Term termSub = WordBasedGenerativeModelSegment.convert(smallVertex);
                        termSub.offset = currentLine - 1;
                        termList.add(termSub);
                    }
                }
            }
            line += vertex.realWord.length();
        }
        return termList;
    }

    private static Term convert(Vertex vertex) {
        return new Term(vertex.realWord, vertex.guessNature());
    }

    protected static void speechTagging(List<Vertex> vertexList) {
        Viterbi.compute(vertexList, CoreDictionaryTransformMatrixDictionary.transformMatrixDictionary);
    }
}

