/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.css;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssFile;
import com.itextpdf.tool.xml.css.CssFileProcessor;
import com.itextpdf.tool.xml.css.CssFiles;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.CssInheritanceRules;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.DefaultCssInheritanceRules;
import com.itextpdf.tool.xml.exceptions.CssResolverException;
import com.itextpdf.tool.xml.net.FileRetrieve;
import com.itextpdf.tool.xml.net.FileRetrieveImpl;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.svg.graphic.SVGAttributes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class StyleAttrSvgCSSResolver
implements CSSResolver {
    public static final String STYLE = "style";
    private final CssUtils utils;
    private CssInheritanceRules inherit;
    private final CssFiles cssFiles;
    private FileRetrieve retrieve;
    private Map<String, Integer> attributes;

    public StyleAttrSvgCSSResolver() {
        this((CssFiles)new CssFilesImpl(), CssUtils.getInstance());
    }

    public StyleAttrSvgCSSResolver(CssFiles cssFiles) {
        this(cssFiles, CssUtils.getInstance());
    }

    public StyleAttrSvgCSSResolver(CssFiles cssFiles, CssUtils utils) {
        this(new DefaultCssInheritanceRules(), cssFiles, utils);
    }

    public StyleAttrSvgCSSResolver(CssInheritanceRules rules, CssFiles cssFiles, CssUtils utils) {
        this(rules, cssFiles, utils, new FileRetrieveImpl());
    }

    public StyleAttrSvgCSSResolver(CssInheritanceRules rules, CssFiles cssFiles, CssUtils utils, FileRetrieve fileRetrieve) {
        this.utils = utils;
        this.cssFiles = cssFiles;
        this.inherit = rules;
        this.retrieve = fileRetrieve;
        this.attributes = SVGAttributes.getSVGAttributesList();
    }

    public StyleAttrSvgCSSResolver(CssFiles cssFiles, FileRetrieve r) {
        this(new DefaultCssInheritanceRules(), cssFiles, CssUtils.getInstance(), r);
    }

    public void resolveStyles(Tag t) {
        Map<Object, Object> tagCss = new HashMap();
        if (null != this.cssFiles && this.cssFiles.hasFiles()) {
            tagCss = this.cssFiles.getCSS(t);
        }
        if (null != t.getAttributes() && !t.getAttributes().isEmpty()) {
            for (String key : t.getAttributes().keySet()) {
                String string;
                boolean valid = SVGAttributes.isValidAttribute(key, string = t.getAttributes().get(key), this.attributes);
                if (!valid) continue;
                tagCss.put(key, string);
            }
            String styleAtt = t.getAttributes().get(STYLE);
            if (null != styleAtt && styleAtt.length() > 0) {
                String[] styles;
                for (String s : styles = styleAtt.split(";")) {
                    String value;
                    String key;
                    String[] part = s.split(":", 2);
                    if (part.length != 2 || !SVGAttributes.isValidAttribute(key = part[0].trim(), value = this.utils.stripDoubleSpacesAndTrim(part[1]), this.attributes)) continue;
                    tagCss.put(key, value);
                }
            }
        }
        Map<String, String> css = t.getCSS();
        if (this.mustInherit(t.getName()) && null != t.getParent() && null != t.getParent().getCSS()) {
            if (null != this.inherit) {
                for (Map.Entry<Object, Object> entry : t.getParent().getCSS().entrySet()) {
                    String key = (String)entry.getKey();
                    if ((!tagCss.containsKey(key) || !"inherit".equals(tagCss.get(key))) && !this.canInherite(t, key) || !SVGAttributes.isValidAttribute(key, (String)entry.getValue(), this.attributes)) continue;
                    css.put(key, (String)entry.getValue());
                }
            } else {
                css.putAll(t.getParent().getCSS());
            }
        }
        for (Map.Entry<Object, Object> entry : tagCss.entrySet()) {
            if ("inherit".equalsIgnoreCase((String)entry.getValue())) continue;
            css.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setCssInheritance(CssInheritanceRules cssInheritanceRules) {
        this.inherit = cssInheritanceRules;
    }

    private boolean canInherite(Tag t, String property) {
        if (null != this.inherit) {
            return this.inherit.inheritCssSelector(t, property);
        }
        return true;
    }

    private boolean mustInherit(String tag) {
        if (null != this.inherit) {
            return this.inherit.inheritCssTag(tag);
        }
        return true;
    }

    public void addCss(String content, String charSet, boolean isPersistent) throws CssResolverException {
        CssFileProcessor proc = new CssFileProcessor();
        try {
            this.retrieve.processFromStream(new ByteArrayInputStream(content.getBytes(charSet)), proc);
            CssFile css = proc.getCss();
            css.isPersistent(isPersistent);
            this.cssFiles.add(css);
        }
        catch (UnsupportedEncodingException e) {
            throw new CssResolverException(e);
        }
        catch (IOException e) {
            throw new CssResolverException(e);
        }
    }

    public void addCssFile(String href, boolean isPersistent) throws CssResolverException {
        CssFileProcessor cssFileProcessor = new CssFileProcessor();
        try {
            this.retrieve.processFromHref(href, cssFileProcessor);
        }
        catch (IOException e) {
            throw new CssResolverException(e);
        }
        CssFile css = cssFileProcessor.getCss();
        css.isPersistent(isPersistent);
        this.cssFiles.add(css);
    }

    public void addCss(CssFile file) {
        this.cssFiles.add(file);
    }

    public void addCss(String content, boolean isPersistent) throws CssResolverException {
        CssFileProcessor proc = new CssFileProcessor();
        FileRetrieveImpl retrieve = new FileRetrieveImpl();
        try {
            retrieve.processFromStream(new ByteArrayInputStream(content.getBytes()), proc);
            CssFile css = proc.getCss();
            css.isPersistent(isPersistent);
            this.cssFiles.add(css);
        }
        catch (UnsupportedEncodingException e) {
            throw new CssResolverException(e);
        }
        catch (IOException e) {
            throw new CssResolverException(e);
        }
    }

    public void setCssInheritanceRules(CssInheritanceRules inherit) {
        this.inherit = inherit;
    }

    public void setFileRetrieve(FileRetrieve retrieve) {
        this.retrieve = retrieve;
    }

    public CSSResolver clear() throws CssResolverException {
        this.cssFiles.clear();
        return this;
    }
}

