/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.graphic;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.svg.tags.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGAttributes {
    public static final int TYPE_OTHER = 0;
    public static final int TYPE_COLOR = 1;
    public static final int TYPE_LINE = 2;
    public static final int TYPE_LINE_CAP = 3;
    public static final int TYPE_LINE_JOIN = 4;
    public static final int TYPE_LINE_DASH = 5;
    static final String STROKE = "stroke";
    static final String STROKE_WIDTH = "stroke-width";
    static final String FILL = "fill";
    static final String LINE_CAP = "stroke-linecap";
    static final String LINE_JOIN = "stroke-linejoin";
    static final String FILL_OPACITY = "fill-opacity";
    static final String STROKE_OPACITY = "stroke-opacity";
    static final String FILL_RULE = "fill-rule";
    static final String STROKE_MASTERLIMIT = "stroke-miterlimit";
    static final String STROKE_DASHARRAY = "stroke-dasharray";
    static final String FONT_SIZE = "font-size";
    static final String FONT_FAMILY = "font-family";
    static final String[] LINE_CAP_VALUES = new String[]{"butt", "round", "square"};
    static final String[] LINE_JOIN_VALUES = new String[]{"miter", "round", "bevel"};

    public static Map<String, Integer> getSVGAttributesList() {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        attributes.put(STROKE, 1);
        attributes.put(STROKE_WIDTH, 2);
        attributes.put(FILL, 1);
        attributes.put(LINE_CAP, 3);
        attributes.put(LINE_JOIN, 4);
        attributes.put(STROKE_DASHARRAY, 5);
        attributes.put(FONT_SIZE, 2);
        attributes.put(FONT_FAMILY, 0);
        return attributes;
    }

    public static boolean isValidAttribute(String key, String value, Map<String, Integer> attributes) {
        if (attributes.get(key) != null) {
            switch (attributes.get(key)) {
                case 2: {
                    return SVGAttributes.isValidValueForLine(value);
                }
                case 1: {
                    return SVGAttributes.isValidColor(value);
                }
                case 3: {
                    return SVGAttributes.isValidString(value, LINE_CAP_VALUES);
                }
                case 4: {
                    return SVGAttributes.isValidString(value, LINE_JOIN_VALUES);
                }
                case 5: {
                    return SVGAttributes.isValidDashArray(value);
                }
                case 0: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isValidDashArray(String value) {
        if (value.equalsIgnoreCase("none")) {
            return true;
        }
        List<String> list = TagUtils.splitValueList(value);
        for (String str : list) {
            try {
                int result = Integer.parseInt(str);
                if (result >= 0) continue;
                return false;
            }
            catch (Exception exp) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidString(String value, String[] possibleValues) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < possibleValues.length; ++i) {
            if (!possibleValues[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidColor(String value) {
        if (value == null) {
            return false;
        }
        if (value.equals("none")) {
            return true;
        }
        if (HtmlUtilities.decodeColor((String)value) != null) {
            return true;
        }
        return SVGAttributes.cleanColorString(value) != null;
    }

    public static BaseColor cleanColorString(String name) {
        int[] c = new int[]{0, 0, 0, 255};
        if ((name = name.toLowerCase()).startsWith("rgb(")) {
            StringTokenizer tok = new StringTokenizer(name, "rgb(), \t\r\n\f");
            for (int k = 0; k < 3; ++k) {
                String v = tok.nextToken();
                c[k] = v.endsWith("%") ? (int)Double.parseDouble(v.substring(0, v.length() - 1)) * 255 / 100 : (int)Double.parseDouble(v);
                if (c[k] < 0) {
                    c[k] = 0;
                    continue;
                }
                if (c[k] <= 255) continue;
                c[k] = 255;
            }
            return new BaseColor(c[0], c[1], c[2], c[3]);
        }
        return null;
    }

    public static boolean isValidValueForLine(String value) {
        if (value == null) {
            return false;
        }
        try {
            double result = Double.parseDouble(value);
            if (result >= 0.0) {
                return true;
            }
        }
        catch (Exception exp) {
            return false;
        }
        return false;
    }
}

