/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.tags;

import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.svg.AbstractGraphicProcessor;
import com.itextpdf.tool.xml.svg.graphic.Ellipse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipseTag
extends AbstractGraphicProcessor {
    static final String CX = "cx";
    static final String CY = "cy";
    static final String RX = "rx";
    static final String RY = "ry";

    private float getAttribute(String name, Map<String, String> attributes) {
        float value = 0.0f;
        try {
            value = Integer.parseInt(attributes.get(name));
        }
        catch (Exception e) {
            // empty catch block
        }
        return value;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        Map<String, String> attributes = tag.getAttributes();
        if (attributes != null) {
            float rx = this.getAttribute(RX, attributes);
            float ry = this.getAttribute(RY, attributes);
            if (rx <= 0.0f || ry <= 0.0f) {
                return new ArrayList<Element>(0);
            }
            float cx = this.getAttribute(CX, attributes);
            float cy = this.getAttribute(CY, attributes);
            ArrayList<Element> l = new ArrayList<Element>(1);
            l.add(new Ellipse(cx, cy, rx, ry, tag.getCSS()));
            return l;
        }
        return new ArrayList<Element>(0);
    }

    @Override
    public boolean isElementWithId() {
        return true;
    }
}

