/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.tags;

import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.svg.AbstractGraphicProcessor;
import com.itextpdf.tool.xml.svg.PathBean;
import com.itextpdf.tool.xml.svg.PathItem;
import com.itextpdf.tool.xml.svg.graphic.Path;
import com.itextpdf.tool.xml.svg.tags.TagUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathTag
extends AbstractGraphicProcessor {
    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        ArrayList<Element> elems = new ArrayList<Element>();
        Map<String, String> attributes = tag.getAttributes();
        if (attributes != null) {
            String fullPath = attributes.get("d");
            PathItem.Builder itemBuilder = null;
            PathBean.Builder pathBuilder = new PathBean.Builder();
            List<String> list = this.splitPath(fullPath);
            if (list != null) {
                for (String str : list) {
                    if (str.length() == 1 && Character.isLetter(str.charAt(0))) {
                        if (itemBuilder != null) {
                            pathBuilder.setPathItem(itemBuilder.build());
                        }
                        itemBuilder = new PathItem.Builder();
                        itemBuilder.setType(str.charAt(0));
                        continue;
                    }
                    itemBuilder.addCoordinate(str);
                }
            }
            if (itemBuilder != null) {
                pathBuilder.setPathItem(itemBuilder.build());
            }
            elems.add(new Path(pathBuilder.build(), tag.getCSS()));
            return elems;
        }
        return new ArrayList<Element>(0);
    }

    List<String> splitPath(String path) {
        if (path.trim().length() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(path.charAt(0));
        for (int i = 1; i < path.length(); ++i) {
            if (Character.isLetter(path.charAt(i - 1)) && !Character.isLetter(path.charAt(i)) || !Character.isLetter(path.charAt(i - 1)) && Character.isLetter(path.charAt(i))) {
                buffer.append(' ');
            }
            buffer.append(path.charAt(i));
        }
        return TagUtils.splitValueList(buffer.toString());
    }

    @Override
    public boolean isElementWithId() {
        return true;
    }
}

