/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo;

import com.kennycason.kumo.CollisionMode;
import com.kennycason.kumo.LayeredWordCloud;
import com.kennycason.kumo.WordFrequency;
import com.kennycason.kumo.exception.KumoException;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelLayeredWordCloud
extends LayeredWordCloud {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelLayeredWordCloud.class);
    private final List<Future<?>> executorFutures = new ArrayList();
    private final ExecutorService executorservice;

    public ParallelLayeredWordCloud(int layers, Dimension dimension, CollisionMode collisionMode) {
        super(layers, dimension, collisionMode);
        this.executorservice = Executors.newFixedThreadPool(layers);
    }

    @Override
    public void build(int layer, List<WordFrequency> wordFrequencies) {
        Future<?> completionFuture = this.executorservice.submit(() -> {
            LOGGER.info("Starting to build WordCloud Layer {} in new Thread", (Object)layer);
            super.build(layer, wordFrequencies);
        });
        this.executorFutures.add(completionFuture);
    }

    @Override
    public void writeToFile(String outputFileName) {
        this.writeToFile(outputFileName, true, true);
    }

    public void writeToFile(String outputFileName, boolean blockThread) {
        this.writeToFile(outputFileName, blockThread, true);
    }

    public void writeToFile(String outputFileName, boolean blockThread, boolean shutdownExecutor) {
        if (blockThread) {
            this.waitForFuturesToBlockCurrentThread();
        }
        super.writeToFile(outputFileName);
        if (shutdownExecutor) {
            this.shutdown();
        }
    }

    private void waitForFuturesToBlockCurrentThread() {
        LOGGER.info("Awaiting Termination of Executors");
        for (int i = 0; i < this.executorFutures.size(); ++i) {
            Future<?> future = this.executorFutures.get(i);
            try {
                LOGGER.info("Performing get on Future:" + (i + 1) + "/" + this.executorFutures.size());
                future.get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new KumoException("Error while waiting for Future of Layer " + i, e);
            }
        }
        this.executorFutures.clear();
        LOGGER.info("Termination Complete, Processing to File now");
    }

    public void shutdown() {
        this.executorservice.shutdown();
        try {
            this.executorservice.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new KumoException("Executor awaitTermination was interrupted, consider manual termination", e);
        }
    }
}

