/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo;

import com.kennycason.kumo.CollisionMode;
import com.kennycason.kumo.PolarBlendMode;
import com.kennycason.kumo.Word;
import com.kennycason.kumo.WordCloud;
import com.kennycason.kumo.WordFrequency;
import com.kennycason.kumo.palette.ColorPalette;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class PolarWordCloud
extends WordCloud {
    private static final Random RANDOM = new Random();
    private static final ColorPalette DEFAULT_POSITIVE_COLORS = new ColorPalette(new Color(1826816), new Color(1755394), new Color(1421312), new Color(1217536), new Color(1014272), new Color(744960));
    private static final ColorPalette DEFAULT_NEGATIVE_COLORS = new ColorPalette(new Color(0xF50000), new Color(0xDE0000), new Color(13173250), new Color(11862530), new Color(0x990202), new Color(0x800101));
    private final PolarBlendMode polarBlendMode;
    private ColorPalette colorPalette2;

    public PolarWordCloud(Dimension dimension, CollisionMode collisionMode) {
        this(dimension, collisionMode, PolarBlendMode.EVEN);
        this.colorPalette = DEFAULT_POSITIVE_COLORS;
        this.colorPalette2 = DEFAULT_NEGATIVE_COLORS;
    }

    public PolarWordCloud(Dimension dimension, CollisionMode collisionMode, PolarBlendMode polarBlendMode) {
        super(dimension, collisionMode);
        this.polarBlendMode = polarBlendMode;
        this.colorPalette = DEFAULT_POSITIVE_COLORS;
        this.colorPalette2 = DEFAULT_NEGATIVE_COLORS;
    }

    public void build(List<WordFrequency> wordFrequencies, List<WordFrequency> wordFrequencies2) {
        Collections.sort(wordFrequencies);
        Collections.sort(wordFrequencies2);
        List<Word> words = this.buildWords(wordFrequencies, this.colorPalette);
        List<Word> words2 = this.buildWords(wordFrequencies2, this.colorPalette2);
        Iterator<Word> wordIterator = words.iterator();
        Iterator<Word> wordIterator2 = words2.iterator();
        Point[] poles = this.getRandomPoles();
        Point pole1 = poles[0];
        Point pole2 = poles[1];
        while (wordIterator.hasNext() || wordIterator2.hasNext()) {
            Point startPosition;
            Word word;
            if (wordIterator.hasNext()) {
                word = wordIterator.next();
                startPosition = this.getStartPosition(pole1);
                this.place(word, startPosition);
            }
            if (!wordIterator2.hasNext()) continue;
            word = wordIterator2.next();
            startPosition = this.getStartPosition(pole2);
            this.place(word, startPosition);
        }
        this.drawForegroundToBackground();
    }

    private Point getStartPosition(Point pole) {
        switch (this.polarBlendMode) {
            case BLUR: {
                int blurX = this.dimension.width / 2;
                int blurY = this.dimension.height / 2;
                return new Point(pole.x + -blurX + RANDOM.nextInt(blurX * 2), pole.y + -blurY + RANDOM.nextInt(blurY * 2));
            }
            case EVEN: {
                return pole;
            }
        }
        throw new IllegalArgumentException("PolarBlendMode must not be null");
    }

    private Point[] getRandomPoles() {
        Point[] max = new Point[2];
        double maxDistance = 0.0;
        for (int i = 0; i < 100; ++i) {
            int x = RANDOM.nextInt(this.dimension.width);
            int y = RANDOM.nextInt(this.dimension.height);
            int x2 = RANDOM.nextInt(this.dimension.width);
            int y2 = RANDOM.nextInt(this.dimension.height);
            double distance = Math.sqrt(Math.pow(x - x2, 2.0) + Math.pow(y - y2, 2.0));
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            max[0] = new Point(x, y);
            max[1] = new Point(x2, y2);
        }
        return max;
    }

    public void setColorPalette2(ColorPalette colorPalette2) {
        this.colorPalette2 = colorPalette2;
    }
}

