/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo;

import com.kennycason.kumo.CollisionMode;
import com.kennycason.kumo.Word;
import com.kennycason.kumo.WordFrequency;
import com.kennycason.kumo.bg.Background;
import com.kennycason.kumo.bg.RectangleBackground;
import com.kennycason.kumo.collide.RectanglePixelCollidable;
import com.kennycason.kumo.collide.checkers.CollisionChecker;
import com.kennycason.kumo.collide.checkers.RectangleCollisionChecker;
import com.kennycason.kumo.collide.checkers.RectanglePixelCollisionChecker;
import com.kennycason.kumo.exception.KumoException;
import com.kennycason.kumo.font.FontWeight;
import com.kennycason.kumo.font.KumoFont;
import com.kennycason.kumo.font.scale.FontScalar;
import com.kennycason.kumo.font.scale.LinearFontScalar;
import com.kennycason.kumo.image.AngleGenerator;
import com.kennycason.kumo.image.CollisionRaster;
import com.kennycason.kumo.image.ImageRotation;
import com.kennycason.kumo.padding.Padder;
import com.kennycason.kumo.padding.RectanglePadder;
import com.kennycason.kumo.padding.WordPixelPadder;
import com.kennycason.kumo.palette.ColorPalette;
import com.kennycason.kumo.placement.RTreeWordPlacer;
import com.kennycason.kumo.placement.RectangleWordPlacer;
import com.kennycason.kumo.wordstart.RandomWordStart;
import com.kennycason.kumo.wordstart.WordStartStrategy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordCloud {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordCloud.class);
    protected final Dimension dimension;
    protected final CollisionMode collisionMode;
    protected final CollisionChecker collisionChecker;
    protected final RectanglePixelCollidable backgroundCollidable;
    protected final CollisionRaster collisionRaster;
    protected final BufferedImage bufferedImage;
    protected final Padder padder;
    protected final Set<Word> skipped = new HashSet<Word>();
    protected int padding;
    protected Background background;
    protected Color backgroundColor = Color.BLACK;
    protected FontScalar fontScalar = new LinearFontScalar(10, 40);
    protected KumoFont kumoFont = new KumoFont("Comic Sans MS", FontWeight.BOLD);
    protected AngleGenerator angleGenerator = new AngleGenerator();
    protected RectangleWordPlacer wordPlacer = new RTreeWordPlacer();
    protected ColorPalette colorPalette = new ColorPalette(177906, 3654384, 8178662, 12904434, 0xFFFFFF);
    protected WordStartStrategy wordStartStrategy = new RandomWordStart();

    public WordCloud(Dimension dimension, CollisionMode collisionMode) {
        this.collisionMode = collisionMode;
        this.padder = WordCloud.derivePadder(collisionMode);
        this.collisionChecker = WordCloud.deriveCollisionChecker(collisionMode);
        this.collisionRaster = new CollisionRaster(dimension);
        this.bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        this.backgroundCollidable = new RectanglePixelCollidable(this.collisionRaster, new Point(0, 0));
        this.dimension = dimension;
        this.background = new RectangleBackground(dimension);
    }

    public void build(List<WordFrequency> wordFrequencies) {
        Collections.sort(wordFrequencies);
        this.wordPlacer.reset();
        this.skipped.clear();
        int currentWord = 1;
        for (Word word : this.buildWords(wordFrequencies, this.colorPalette)) {
            Point point;
            boolean placed = this.place(word, point = this.wordStartStrategy.getStartingPoint(this.dimension, word));
            if (placed) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("placed: {} ({}/{})", new Object[]{word.getWord(), currentWord, wordFrequencies.size()});
                }
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("skipped: {} ({}/{})", new Object[]{word.getWord(), currentWord, wordFrequencies.size()});
                }
                this.skipped.add(word);
            }
            ++currentWord;
        }
        this.drawForegroundToBackground();
    }

    public void writeToFile(String outputFileName) {
        String extension = "";
        int i = outputFileName.lastIndexOf(46);
        if (i > 0) {
            extension = outputFileName.substring(i + 1);
        }
        try {
            LOGGER.info("Saving WordCloud to: {}", (Object)outputFileName);
            ImageIO.write((RenderedImage)this.bufferedImage, extension, new File(outputFileName));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void writeToStreamAsPNG(OutputStream outputStream) {
        this.writeToStream("png", outputStream);
    }

    public void writeToStream(String format, OutputStream outputStream) {
        try {
            LOGGER.debug("Writing WordCloud image data to output stream");
            ImageIO.write((RenderedImage)this.bufferedImage, format, outputStream);
            LOGGER.debug("Done writing WordCloud image data to output stream");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KumoException("Could not write wordcloud to outputstream due to an IOException", e);
        }
    }

    protected void drawForegroundToBackground() {
        if (this.backgroundColor == null) {
            return;
        }
        BufferedImage backgroundBufferedImage = new BufferedImage(this.dimension.width, this.dimension.height, this.bufferedImage.getType());
        Graphics graphics = backgroundBufferedImage.getGraphics();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.dimension.width, this.dimension.height);
        graphics.drawImage(this.bufferedImage, 0, 0, null);
        Graphics graphics2 = this.bufferedImage.getGraphics();
        graphics2.drawImage(backgroundBufferedImage, 0, 0, null);
    }

    protected boolean place(Word word, Point start) {
        Graphics graphics = this.bufferedImage.getGraphics();
        int maxRadius = this.dimension.width;
        for (int r = 0; r < maxRadius; r += 2) {
            for (int x = -r; x <= r; ++x) {
                if (start.x + x < 0 || start.x + x >= maxRadius) continue;
                boolean placed = false;
                word.getPosition().x = start.x + x;
                int y1 = (int)Math.sqrt(r * r - x * x);
                if (start.y + y1 >= 0 && start.y + y1 < this.dimension.height) {
                    word.getPosition().y = start.y + y1;
                    placed = this.canPlace(word);
                }
                int y2 = -y1;
                if (!placed && start.y + y2 >= 0 && start.y + y2 < this.dimension.height) {
                    word.getPosition().y = start.y + y2;
                    placed = this.canPlace(word);
                }
                if (!placed) continue;
                this.collisionRaster.mask(word.getCollisionRaster(), word.getPosition());
                graphics.drawImage(word.getBufferedImage(), word.getPosition().x, word.getPosition().y, null);
                return true;
            }
        }
        return false;
    }

    private boolean canPlace(Word word) {
        if (!this.background.isInBounds(word)) {
            return false;
        }
        switch (this.collisionMode) {
            case RECTANGLE: {
                return this.wordPlacer.place(word);
            }
            case PIXEL_PERFECT: {
                return !this.backgroundCollidable.collide(word);
            }
        }
        return false;
    }

    protected List<Word> buildWords(List<WordFrequency> wordFrequencies, ColorPalette colorPalette) {
        int maxFrequency = WordCloud.maxFrequency(wordFrequencies);
        ArrayList<Word> words = new ArrayList<Word>();
        for (WordFrequency wordFrequency : wordFrequencies) {
            if (wordFrequency.getWord().isEmpty()) continue;
            words.add(this.buildWord(wordFrequency, maxFrequency, colorPalette));
        }
        return words;
    }

    private Word buildWord(WordFrequency wordFrequency, int maxFrequency, ColorPalette colorPalette) {
        Graphics graphics = this.bufferedImage.getGraphics();
        int frequency = wordFrequency.getFrequency();
        float fontHeight = this.fontScalar.scale(frequency, 0, maxFrequency);
        Font font = this.kumoFont.getFont().deriveFont(fontHeight);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Word word = new Word(wordFrequency.getWord(), colorPalette.next(), fontMetrics, this.collisionChecker);
        double theta = this.angleGenerator.randomNext();
        if (theta != 0.0) {
            word.setBufferedImage(ImageRotation.rotate(word.getBufferedImage(), theta));
        }
        if (this.padding > 0) {
            this.padder.pad(word, this.padding);
        }
        return word;
    }

    private static int maxFrequency(List<WordFrequency> wordFrequencies) {
        if (wordFrequencies.isEmpty()) {
            return 1;
        }
        return wordFrequencies.get(0).getFrequency();
    }

    private static Padder derivePadder(CollisionMode collisionMode) {
        switch (collisionMode) {
            case PIXEL_PERFECT: {
                return new WordPixelPadder();
            }
            case RECTANGLE: {
                return new RectanglePadder();
            }
        }
        throw new IllegalArgumentException("CollisionMode can not be null");
    }

    private static CollisionChecker deriveCollisionChecker(CollisionMode collisionMode) {
        switch (collisionMode) {
            case PIXEL_PERFECT: {
                return new RectanglePixelCollisionChecker();
            }
            case RECTANGLE: {
                return new RectangleCollisionChecker();
            }
        }
        throw new IllegalArgumentException("CollisionMode can not be null");
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setColorPalette(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void setFontScalar(FontScalar fontScalar) {
        this.fontScalar = fontScalar;
    }

    public void setKumoFont(KumoFont kumoFont) {
        this.kumoFont = kumoFont;
    }

    public void setAngleGenerator(AngleGenerator angleGenerator) {
        this.angleGenerator = angleGenerator;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public Set<Word> getSkipped() {
        return this.skipped;
    }

    public void setWordStartStrategy(WordStartStrategy startscheme) {
        this.wordStartStrategy = startscheme;
    }

    public void setWordPlacer(RectangleWordPlacer wordPlacer) {
        this.wordPlacer = wordPlacer;
    }
}

